/*
 * Decompiled with CFR 0.152.
 */
package org.cts.op.projection;

import java.util.HashMap;
import java.util.Map;
import org.cts.Identifier;
import org.cts.IllegalCoordinateException;
import org.cts.datum.Ellipsoid;
import org.cts.op.NonInvertibleOperationException;
import org.cts.op.projection.Projection;
import org.cts.units.Measure;
import org.cts.units.Unit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LambertConicConformal2SP
extends Projection {
    public static final Identifier LCC2SP = new Identifier("EPSG", "9802", "Lambert Conic Conformal (2SP)", "Lambert secant");
    public static final LambertConicConformal2SP LAMBERT93 = LambertConicConformal2SP.createLCC2SP(Ellipsoid.GRS80, 46.5, 44.0, 49.0, 3.0, 700000.0, 6600000.0);
    protected final double lon0;
    protected final double n;
    protected final double C;
    protected final double xs;
    protected final double ys;

    public LambertConicConformal2SP(Ellipsoid ellipsoid, Map<String, Measure> parameters) {
        super(LCC2SP, ellipsoid, parameters);
        double lat0 = this.getLatitudeOfOrigin();
        double lat1 = parameters.get("standard parallel 1").getSValue();
        double lat2 = parameters.get("standard parallel 2").getSValue();
        this.lon0 = this.getCentralMeridian();
        double x0 = this.getFalseEasting();
        double y0 = this.getFalseNorthing();
        double latIso0 = ellipsoid.isometricLatitude(lat0);
        double latIso1 = ellipsoid.isometricLatitude(lat1);
        double latIso2 = ellipsoid.isometricLatitude(lat2);
        double cos1 = Math.cos(lat1);
        double cos2 = Math.cos(lat2);
        double N1 = ellipsoid.grandeNormale(lat1);
        double N2 = ellipsoid.grandeNormale(lat2);
        this.n = Math.log(N2 * cos2 / (N1 * cos1)) / (latIso1 - latIso2);
        this.C = N1 * cos1 / this.n * Math.exp(this.n * latIso1);
        this.xs = x0;
        this.ys = Math.abs(lat0 - 1.5707963267948966) < 1.0E-12 ? y0 : y0 + this.C * Math.exp(-this.n * latIso0);
    }

    public static LambertConicConformal2SP createLCC2SP(Ellipsoid ellipsoid, double latitude_of_origin, double standard_parallel_1, double standard_parallel_2, double central_meridian, double false_easting, double false_northing) {
        return LambertConicConformal2SP.createLCC2SP(ellipsoid, latitude_of_origin, standard_parallel_1, standard_parallel_2, central_meridian, Unit.DEGREE, false_easting, false_northing, Unit.METER);
    }

    public static LambertConicConformal2SP createLCC2SP(Ellipsoid ellipsoid, double latitude_of_origin, double standard_parallel_1, double standard_parallel_2, double central_meridian, Unit angleUnit, double false_easting, double false_northing, Unit planimetricUnit) {
        HashMap<String, Measure> params = new HashMap<String, Measure>();
        params.put("latitude of origin", new Measure(latitude_of_origin, angleUnit));
        params.put("standard parallel 1", new Measure(standard_parallel_1, angleUnit));
        params.put("standard parallel 2", new Measure(standard_parallel_2, angleUnit));
        params.put("central meridian", new Measure(central_meridian, angleUnit));
        params.put("false easting", new Measure(false_easting, planimetricUnit));
        params.put("false northing", new Measure(false_northing, planimetricUnit));
        return new LambertConicConformal2SP(ellipsoid, params);
    }

    @Override
    public double[] transform(double[] coord) throws IllegalCoordinateException {
        double latIso = this.ellipsoid.isometricLatitude(coord[0]);
        double x = this.xs + this.C * Math.exp(-this.n * latIso) * Math.sin(this.n * (coord[1] - this.lon0));
        double y = this.ys - this.C * Math.exp(-this.n * latIso) * Math.cos(this.n * (coord[1] - this.lon0));
        coord[0] = x;
        coord[1] = y;
        return coord;
    }

    @Override
    public Projection inverse() throws NonInvertibleOperationException {
        return new LambertConicConformal2SP(this.ellipsoid, this.parameters){

            public double[] transform(double[] coord) throws IllegalCoordinateException {
                double lat;
                double x = coord[0];
                double y = coord[1];
                double R = Math.sqrt((x - this.xs) * (x - this.xs) + (y - this.ys) * (y - this.ys));
                double g = Math.atan((x - this.xs) / (this.ys - y));
                double lon = this.lon0 + g / this.n;
                double latIso = -1.0 / this.n * Math.log(Math.abs(R / this.C));
                coord[0] = lat = this.ellipsoid.latitude(latIso);
                coord[1] = lon;
                return coord;
            }

            public Projection inverse() throws NonInvertibleOperationException {
                return LambertConicConformal2SP.this;
            }

            public boolean isDirect() {
                return false;
            }

            public String toString() {
                return LambertConicConformal2SP.this.toString() + " inverse";
            }
        };
    }

    @Override
    public Projection.Surface getSurface() {
        return Projection.Surface.CONICAL;
    }

    @Override
    public Projection.Property getProperty() {
        return Projection.Property.CONFORMAL;
    }

    @Override
    public Projection.Orientation getOrientation() {
        return Projection.Orientation.SECANT;
    }

    @Override
    public String toString() {
        return "Lambert Conic Conformal (2SP) [lat0=" + this.parameters.get("latitude of origin") + ";sp1=" + this.parameters.get("standard parallel 1") + ";sp2=" + this.parameters.get("standard parallel 2") + ";lon0=" + this.parameters.get("central meridian") + ";x0=" + this.parameters.get("false easting") + ";y0=" + this.parameters.get("false northing") + "]";
    }
}

