/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sparql.query;

import java.io.IOException;
import org.eclipse.rdf4j.http.client.SPARQLProtocolSession;
import org.eclipse.rdf4j.http.client.query.AbstractHTTPQuery;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sparql.query.QueryStringUtil;

public class SPARQLBooleanQuery
extends AbstractHTTPQuery
implements BooleanQuery {
    public SPARQLBooleanQuery(SPARQLProtocolSession httpClient, String baseURI, String queryString) {
        super(httpClient, QueryLanguage.SPARQL, queryString, baseURI);
    }

    public boolean evaluate() throws QueryEvaluationException {
        SPARQLProtocolSession client = this.getHttpClient();
        try {
            return client.sendBooleanQuery(this.queryLanguage, this.getQueryString(), this.baseURI, this.dataset, this.getIncludeInferred(), this.getMaxExecutionTime(), this.getBindingsArray());
        }
        catch (IOException | MalformedQueryException | RepositoryException e) {
            throw new QueryEvaluationException(e.getMessage(), e);
        }
    }

    private String getQueryString() {
        return QueryStringUtil.getBooleanQueryString(this.queryString, this.getBindings());
    }
}

