/*
 * Decompiled with CFR 0.152.
 */
package org.coode.owlapi.obo12.parser;

import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

class Modifiers {
    private final Map<String, Set<String>> modifierNameValuesMap = new LinkedHashMap<String, Set<String>>();

    public static Modifiers parseModifiers(String modifiersList) {
        Modifiers modifiers = new Modifiers();
        for (String s : modifiersList.split(",")) {
            String nameValuePair = s.trim();
            String[] split = nameValuePair.split("=");
            if (split.length != 2) continue;
            modifiers.addModifier(split[0], split[1]);
        }
        return modifiers;
    }

    public void addModifier(String name, String value) {
        Set<String> values = this.modifierNameValuesMap.get(name);
        if (values == null) {
            values = new HashSet<String>();
            this.modifierNameValuesMap.put(name, values);
        }
        values.add(value);
    }

    public Set<String> getModifierNames() {
        return this.modifierNameValuesMap.keySet();
    }

    public Set<String> getModifierValues(String modifierName) {
        HashSet<String> valuesToReturn = new HashSet<String>();
        Set<String> values = this.modifierNameValuesMap.get(modifierName);
        if (values != null) {
            valuesToReturn.addAll(values);
        }
        return valuesToReturn;
    }
}

