/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.cache;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.rdf4j.federated.algebra.StatementSource;
import org.eclipse.rdf4j.federated.cache.SourceSelectionCache;
import org.eclipse.rdf4j.federated.endpoint.Endpoint;
import org.eclipse.rdf4j.federated.evaluation.TripleSource;
import org.eclipse.rdf4j.federated.exception.OptimizationException;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.federated.structures.SubQuery;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;

public class CacheUtils {
    private static boolean checkEndpointForResults(SourceSelectionCache cache, Endpoint endpoint, Resource subj, IRI pred, Value obj, QueryInfo queryInfo) throws OptimizationException {
        try {
            TripleSource t = endpoint.getTripleSource();
            boolean hasResults = t.hasStatements(subj, pred, obj, queryInfo, new Resource[0]);
            cache.updateInformation(new SubQuery(subj, pred, obj), endpoint, hasResults);
            return hasResults;
        }
        catch (Exception e) {
            throw new OptimizationException("Error checking results for endpoint " + endpoint.getId() + ": " + e.getMessage(), e);
        }
    }

    public static boolean checkCacheUpdateCache(SourceSelectionCache cache, List<Endpoint> endpoints, Resource subj, IRI pred, Value obj, QueryInfo queryInfo) {
        SubQuery q = new SubQuery(subj, pred, obj);
        for (Endpoint e : endpoints) {
            SourceSelectionCache.StatementSourceAssurance a = cache.getAssurance(q, e);
            if (a == SourceSelectionCache.StatementSourceAssurance.HAS_REMOTE_STATEMENTS) {
                return true;
            }
            if (a != SourceSelectionCache.StatementSourceAssurance.POSSIBLY_HAS_STATEMENTS || !CacheUtils.checkEndpointForResults(cache, e, subj, pred, obj, queryInfo)) continue;
            return true;
        }
        return false;
    }

    public static List<StatementSource> checkCacheForStatementSourcesUpdateCache(SourceSelectionCache cache, List<Endpoint> endpoints, Resource subj, IRI pred, Value obj, QueryInfo queryInfo) {
        SubQuery q = new SubQuery(subj, pred, obj);
        ArrayList<StatementSource> sources = new ArrayList<StatementSource>(endpoints.size());
        for (Endpoint e : endpoints) {
            SourceSelectionCache.StatementSourceAssurance a = cache.getAssurance(q, e);
            if (a == SourceSelectionCache.StatementSourceAssurance.HAS_REMOTE_STATEMENTS) {
                sources.add(new StatementSource(e.getId(), StatementSource.StatementSourceType.REMOTE));
                continue;
            }
            if (a != SourceSelectionCache.StatementSourceAssurance.POSSIBLY_HAS_STATEMENTS || !CacheUtils.checkEndpointForResults(cache, e, subj, pred, obj, queryInfo)) continue;
            sources.add(new StatementSource(e.getId(), StatementSource.StatementSourceType.REMOTE));
        }
        return sources;
    }
}

