/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.ganglia;

import com.bigdata.ganglia.GangliaSlopeEnum;
import com.bigdata.ganglia.IGangliaAttributes;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractMetrics
implements IGangliaAttributes {
    public static final Map<String, String[]> emptyMap = Collections.emptyMap();
    protected final String hostName;
    protected final GangliaSlopeEnum slope;
    protected final int tmax;
    protected final int dmax;

    public static Map<String, String[]> getMap(String group, String title, String description) {
        if (group == null && title == null && description == null) {
            return emptyMap;
        }
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        if (group != null) {
            map.put("GROUP", new String[]{group});
        }
        if (title != null) {
            map.put("TITLE", new String[]{title});
        }
        if (description != null) {
            map.put("DESC", new String[]{description});
        }
        return map;
    }

    static Map<String, String[]> getMap(NV[] a) {
        if (a == null || a.length == 0) {
            return emptyMap;
        }
        HashMap<String, String[]> m = new HashMap<String, String[]>();
        for (NV t : a) {
            if (t == null) {
                throw new IllegalArgumentException();
            }
            m.put(t.name, t.value);
        }
        return m;
    }

    public AbstractMetrics(String hostName, GangliaSlopeEnum slope, int tmax, int dmax) {
        if (hostName == null) {
            throw new IllegalArgumentException();
        }
        if (slope == null) {
            throw new IllegalArgumentException();
        }
        if (tmax < 0) {
            throw new IllegalArgumentException();
        }
        if (dmax < 0) {
            throw new IllegalArgumentException();
        }
        this.hostName = hostName;
        this.slope = slope;
        this.tmax = tmax;
        this.dmax = dmax;
    }

    static class NV {
        public final String name;
        public final String[] value;

        public NV(String name, String[] value) {
            if (name == null || value == null || value.length == 0) {
                throw new IllegalArgumentException();
            }
            this.name = name;
            this.value = value;
        }
    }
}

