/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.jeri.internal.mux;

import com.sun.jini.action.GetIntegerAction;
import com.sun.jini.jeri.internal.mux.Mux;
import com.sun.jini.jeri.internal.mux.Session;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.SocketChannel;
import java.security.AccessController;
import java.util.Collection;
import net.jini.jeri.OutboundRequest;

public class MuxClient
extends Mux {
    private static final int clientInitialInboundRation = (Integer)AccessController.doPrivileged(new GetIntegerAction("com.sun.jini.jeri.connection.mux.client.initialInboundRation", 32768));

    public MuxClient(OutputStream out, InputStream in) throws IOException {
        super(out, in, 0, clientInitialInboundRation, 1024);
    }

    public MuxClient(SocketChannel channel) throws IOException {
        super(channel, 0, clientInitialInboundRation, 1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutboundRequest newRequest() throws IOException {
        Object object = this.muxLock;
        synchronized (object) {
            if (this.muxDown) {
                IOException ioe = new IOException(this.muxDownMessage);
                ioe.initCause(this.muxDownCause);
                throw ioe;
            }
            int sessionID = this.busySessions.nextClearBit(0);
            if (sessionID > 127) {
                throw new IOException("no free sessions");
            }
            Session session = new Session(this, sessionID, 0);
            this.addSession(sessionID, session);
            return session.getOutboundRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int requestsInProgress() throws IOException {
        Object object = this.muxLock;
        synchronized (object) {
            if (this.muxDown) {
                IOException ioe = new IOException(this.muxDownMessage);
                ioe.initCause(this.muxDownCause);
                throw ioe;
            }
            return this.busySessions.cardinality();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(String message) {
        Object object = this.muxLock;
        synchronized (object) {
            this.setDown(message, null);
        }
    }

    protected void populateContext(Collection context) {
    }
}

