/*
 * Decompiled with CFR 0.152.
 */
package com.bigdata.rdf.sail.webapp.client;

import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.LiteralImpl;
import org.openrdf.model.impl.URIImpl;

public class EncodeDecodeValue {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Resource[] EMPTY_RESOURCE_ARRAY = new Resource[0];

    public static Value decodeValue(String s) {
        if (s == null) {
            return null;
        }
        int slen = s.length();
        if (slen == 0) {
            throw new IllegalArgumentException("<Empty String>");
        }
        char ch = s.charAt(0);
        if (ch == '\"' || ch == '\'') {
            int closeQuotePos = s.lastIndexOf(ch);
            if (closeQuotePos == 0) {
                throw new IllegalArgumentException(s);
            }
            String label = s.substring(1, closeQuotePos);
            if (slen == closeQuotePos + 1) {
                return new LiteralImpl(label);
            }
            char ch2 = s.charAt(closeQuotePos + 1);
            if (ch2 == '@') {
                String languageCode = s.substring(closeQuotePos + 2);
                return new LiteralImpl(label, languageCode);
            }
            if (ch2 == '^') {
                if (slen <= closeQuotePos + 2) {
                    throw new IllegalArgumentException(s);
                }
                if (s.charAt(closeQuotePos + 2) != '^') {
                    throw new IllegalArgumentException(s);
                }
                String datatypeStr = s.substring(closeQuotePos + 3);
                URI datatypeURI = EncodeDecodeValue.decodeURI(datatypeStr);
                return new LiteralImpl(label, datatypeURI);
            }
            throw new IllegalArgumentException(s);
        }
        if (ch == '<') {
            if (s.charAt(slen - 1) != '>') {
                throw new IllegalArgumentException(s);
            }
            String uriStr = s.substring(1, slen - 1);
            return new URIImpl(uriStr);
        }
        throw new IllegalArgumentException(s);
    }

    public static Resource decodeResource(String param) {
        Value v = EncodeDecodeValue.decodeValue(param);
        if (v == null || v instanceof Resource) {
            return (Resource)v;
        }
        throw new IllegalArgumentException("Not a Resource: '" + param + "'");
    }

    public static URI decodeURI(String param) {
        Value v = EncodeDecodeValue.decodeValue(param);
        if (v == null || v instanceof URI) {
            return (URI)v;
        }
        throw new IllegalArgumentException("Not an URI: '" + param + "'");
    }

    public static String encodeValue(Value v) {
        if (v == null) {
            return null;
        }
        if (v instanceof BNode) {
            throw new IllegalArgumentException();
        }
        if (v instanceof URI) {
            return "<" + v.stringValue() + ">";
        }
        if (v instanceof Literal) {
            Literal lit = (Literal)v;
            StringBuilder sb = new StringBuilder();
            sb.append("\"");
            sb.append(lit.getLabel());
            sb.append("\"");
            if (lit.getLanguage() != null) {
                sb.append("@");
                sb.append(lit.getLanguage());
            }
            if (lit.getDatatype() != null) {
                sb.append("^^");
                sb.append(EncodeDecodeValue.encodeValue((Value)lit.getDatatype()));
            }
            return sb.toString();
        }
        throw new AssertionError();
    }

    public static Resource[] decodeContexts(String[] strings) {
        if (strings == null) {
            throw new IllegalArgumentException();
        }
        if (strings.length == 0) {
            return EMPTY_RESOURCE_ARRAY;
        }
        Resource[] tmp = new Resource[strings.length];
        for (int i = 0; i < strings.length; ++i) {
            String s = strings[i];
            tmp[i] = s == null || s.length() == 0 ? null : EncodeDecodeValue.decodeResource(s);
        }
        return tmp;
    }

    public static String[] encodeContexts(Resource[] values) {
        if (values == null) {
            throw new IllegalArgumentException();
        }
        if (values.length == 0) {
            return EMPTY_STRING_ARRAY;
        }
        String[] strings = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            Resource val = values[i];
            strings[i] = val == null ? null : EncodeDecodeValue.encodeValue((Value)val);
        }
        return strings;
    }
}

