/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.http.auth;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.List;
import org.apache.jena.atlas.web.HttpException;
import org.apache.jena.http.HttpLib;
import org.apache.jena.http.auth.AuthChallenge;
import org.apache.jena.http.auth.AuthDomain;
import org.apache.jena.http.auth.AuthEnv;
import org.apache.jena.http.auth.AuthRequestModifier;
import org.apache.jena.http.auth.DigestLib;
import org.apache.jena.http.auth.PasswordRecord;

public class AuthLib {
    public static <T> HttpResponse<T> authExecute(HttpClient httpClient, HttpRequest httpRequest, HttpResponse.BodyHandler<T> bodyHandler) {
        HttpResponse<T> httpResponse = HttpLib.executeJDK(httpClient, httpRequest, bodyHandler);
        if (httpResponse.statusCode() != 401) {
            return httpResponse;
        }
        HttpResponse<T> httpResponse2 = AuthLib.handle401(httpClient, httpRequest, bodyHandler, httpResponse);
        return httpResponse2;
    }

    private static AuthChallenge authenticateHeader(HttpResponse<?> httpResponse) {
        List<String> headers = httpResponse.headers().allValues("WWW-Authenticate");
        if (headers.size() == 0) {
            return null;
        }
        AuthChallenge aHeader = null;
        Object result = null;
        block4: for (String headerValue : headers) {
            AuthChallenge aHeader2 = AuthChallenge.parse(headerValue);
            if (aHeader2 == null) {
                AuthEnv.LOG.warn("Bad authentication response - ignored: " + headerValue);
            }
            switch (aHeader2.authScheme) {
                case DIGEST: {
                    return aHeader2;
                }
                case BASIC: {
                    if (aHeader != null) continue block4;
                    aHeader = aHeader2;
                    continue block4;
                }
            }
            AuthEnv.LOG.warn("Unrecogized authentication response - ignored: " + headerValue);
        }
        return aHeader;
    }

    private static <T> HttpResponse<T> handle401(HttpClient httpClient, HttpRequest request, HttpResponse.BodyHandler<T> bodyHandler, HttpResponse<T> httpResponse1) {
        AuthRequestModifier digestAuthModifier;
        AuthChallenge aHeader = AuthLib.authenticateHeader(httpResponse1);
        if (aHeader == null) {
            return httpResponse1;
        }
        AuthDomain domain = new AuthDomain(request.uri());
        PasswordRecord passwordRecord = AuthEnv.get().getUsernamePassword(request.uri());
        if (passwordRecord == null) {
            throw new HttpException(401);
        }
        switch (aHeader.authScheme) {
            case BASIC: {
                digestAuthModifier = AuthLib.basicAuthModifier(passwordRecord.getUsername(), passwordRecord.getPassword());
                break;
            }
            case DIGEST: {
                String requestTarget = HttpLib.requestTarget(request.uri());
                digestAuthModifier = DigestLib.buildDigest(aHeader, passwordRecord.getUsername(), passwordRecord.getPassword(), request.method(), requestTarget);
                break;
            }
            default: {
                throw new HttpException("Not an authentication scheme -- " + aHeader.authScheme);
            }
        }
        String endpointURL = HttpLib.requestTarget(request.uri());
        AuthEnv.get().registerAuthModifier(endpointURL, digestAuthModifier);
        HttpRequest.Builder request2builder = HttpLib.createBuilder(request);
        request2builder = digestAuthModifier.addAuth(request2builder);
        HttpRequest httpRequest2 = request2builder.build();
        HttpResponse<T> httpResponse2 = HttpLib.executeJDK(httpClient, httpRequest2, bodyHandler);
        return httpResponse2;
    }

    static AuthRequestModifier basicAuthModifier(String user, String password) {
        return req -> req.setHeader("Authorization", HttpLib.basicAuth(user, password));
    }

    public static Authenticator authenticator(final String user, final String password) {
        return new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(user, password.toCharArray());
            }
        };
    }

    public static PasswordAuthentication getPasswordAuthentication(Authenticator authenticator) {
        return authenticator.requestPasswordAuthenticationInstance(null, null, -1, null, null, null, null, null);
    }
}

