__version__ = "v1.0"
__copyright__ = "Copyright 2023"
__license__ = "MIT"
__lab__ = "cribbslab"

from resimpy.read.inf.Pseudo import pseudo as seqpseudo
from resimpy.read.umi.Library import library as liblogginger


class design(seqpseudo):

    def __init__(self, *args, **kwargs):
        super(design, self).__init__(*args, **kwargs)
        self.args = args
        self.kwargs = kwargs

    @liblogginger()
    def general(self, lib_fpn='./primer.txt', is_sv=True):
        return ''.join([
            self.kwargs['dna_map'][i] for i in
            self.kwargs['pseudorandom_num']
        ])

    @liblogginger()
    def tsoatdbio(self, lib_fpn='./primer.txt', is_sv=True):
        return 'AAGCAGTGGTATCAACGCAGAGTAC'
        # return 'AAGCAGTGGTATCAACGCAGAGTGAAT'