import json
import sys
import io
import subprocess
from django.test.runner import DiscoverRunner
from .colors import RESET
from .colors import GREEN
from .colors import RED
from .colors import YELLOW
from .colors import BOLD


def print_default(text=''):
    sys.stdout.write(RESET)
    sys.stdout.write(f'  {text}')


def print_ok(lines='', verbose=False):
    sys.stdout.write(GREEN)
    sys.stdout.write(' OK\n')
    sys.stdout.write(RESET)
    if verbose:
        print(lines)


def print_error(lines='', short_error=False):
    sys.stdout.write(RED)
    sys.stdout.write(' ERROR\n')
    if short_error:
        print(lines)
        sys.stdout.write(RESET)
    else:
        sys.stdout.write(RESET)
        print(lines)


def print_warning(lines=''):
    sys.stdout.write(YELLOW)
    sys.stdout.write(' WARNING\n')
    print(lines)
    sys.stdout.write(RESET)


def print_header(text=''):
    sys.stdout.write(RESET)
    sys.stdout.write(BOLD)
    sys.stdout.write(f'\n{text}\n\n')


def print_empty():
    sys.stdout.write('\n')


def shell_run(cmd):
    ps = subprocess.Popen(cmd, shell=True, stdout=subprocess.PIPE, stderr=subprocess.STDOUT)  # nosec
    lines = ps.communicate()[0]
    lines = lines.decode("utf-8")
    return lines


def run_unit_tests(config_file: str, apps: tuple) -> (int, str):
    old_stderr, old_stdout = sys.stderr, sys.stdout
    new_stdout = io.StringIO()
    sys.stdout, sys.stderr = new_stdout, new_stdout
    try:
        with open(config_file) as f:
            test_options = json.loads(f.read())
            apps = apps or tuple(test_options.get('apps', []))
            test_runner = DiscoverRunner(**test_options)
            failures = test_runner.run_tests(apps)
            output = new_stdout.getvalue()
        sys.stderr, sys.stdout = old_stderr, old_stdout
    except Exception as e:
        sys.stderr, sys.stdout = old_stderr, old_stdout
        raise e
    return failures, output


def check_needed(check_variable, variables_passed):
    return check_variable or not variables_passed
