"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3ToStepFunction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const defaults = require("@aws-solutions-constructs/core");
const aws_events_rule_step_function_1 = require("@aws-solutions-constructs/aws-events-rule-step-function");
const core_1 = require("@aws-cdk/core");
const cloudtrail = require("@aws-cdk/aws-cloudtrail");
class S3ToStepFunction extends core_1.Construct {
    /**
     * @param scope - represents the scope for all the resources.
     * @param id - this is a a scope-unique id.
     * @param props - user provided props for the construct.
     * @summary Constructs a new instance of the S3ToStepFunction class.
     * @since 0.9.0
     * @access public
     */
    constructor(scope, id, props) {
        super(scope, id);
        defaults.CheckProps(props);
        let bucket;
        if (props.existingBucketObj && props.bucketProps) {
            throw new Error('Cannot specify both bucket properties and an existing bucket');
        }
        if (!props.existingBucketObj) {
            [this.s3Bucket, this.s3LoggingBucket] = defaults.buildS3Bucket(this, {
                bucketProps: props.bucketProps
            });
            bucket = this.s3Bucket;
        }
        else {
            bucket = props.existingBucketObj;
        }
        if (props.deployCloudTrail === undefined || props.deployCloudTrail) {
            [this.cloudtrailBucket, this.cloudtrailLoggingBucket] = defaults.buildS3Bucket(this, {}, 'CloudTrail');
            this.cloudtrail = new cloudtrail.Trail(this, 'S3EventsTrail', {
                bucket: this.cloudtrailBucket
            });
            this.cloudtrail.addS3EventSelector([{
                    bucket
                }], {
                readWriteType: cloudtrail.ReadWriteType.ALL,
                includeManagementEvents: false
            });
        }
        let _eventRuleProps = {};
        if (props.eventRuleProps) {
            _eventRuleProps = props.eventRuleProps;
        }
        else {
            // By default the CW Events Rule will filter any 's3:PutObject' events for the S3 Bucket
            _eventRuleProps = {
                eventPattern: {
                    source: ['aws.s3'],
                    detailType: ['AWS API Call via CloudTrail'],
                    detail: {
                        eventSource: [
                            "s3.amazonaws.com"
                        ],
                        eventName: [
                            "PutObject"
                        ],
                        requestParameters: {
                            bucketName: [
                                bucket.bucketName
                            ]
                        }
                    }
                }
            };
        }
        const eventsRuleToStepFunction = new aws_events_rule_step_function_1.EventsRuleToStepFunction(this, `${id}-event-rule-step-function-construct`, {
            stateMachineProps: props.stateMachineProps,
            eventRuleProps: _eventRuleProps,
            createCloudWatchAlarms: props.createCloudWatchAlarms,
            logGroupProps: props.logGroupProps
        });
        this.stateMachine = eventsRuleToStepFunction.stateMachine;
        this.stateMachineLogGroup = eventsRuleToStepFunction.stateMachineLogGroup;
        this.cloudwatchAlarms = eventsRuleToStepFunction.cloudwatchAlarms;
    }
}
exports.S3ToStepFunction = S3ToStepFunction;
_a = JSII_RTTI_SYMBOL_1;
S3ToStepFunction[_a] = { fqn: "@aws-solutions-constructs/aws-s3-step-function.S3ToStepFunction", version: "1.103.0" };
//# sourceMappingURL=data:application/json;base64,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