# -*- coding: utf-8 -*-

import unittest
from msiempy.core.utils import dehexify


uri_string = "14%11Local%20ESM%11144115188075855872%110%11T%11T%11T%11T%11T%11T%11T%11T%11TTT%111%110%11T%11306%11%11F%11F%11F%11TTT%11%11syslog%110%11T%11F%1122.22.26.15%11%113%111%11%1215%11ACE-1%11144120685633994752%110%11T%11T%11T%11T%11T%11T%11T%11T%11FTT%110%110%11F%11TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT%1110001000%11ACE-VM4%11F%11F%11TTT%11%11%110%11T%11F%1122.22.26.16%11%114%111%11%1217%11Destination%20IP%20Risk%11144120685667549184%113%11T%11T%11T%11T%11T%11T%11T%11T%11TTT%116%110%11T%11345%11%11F%11F%11F%11TTT%116%11corr%110%11T%11F%1122.22.26.16%11%110%110%11%123%11Rule%20Correlation%11144120685650771968%112%11T%11T%11T%11T%11T%11T%11T%11T%11TTT%116%110%11T%1147%11ace%11F%11F%11F%11TTT%110%11corr%110%11T%11F%1122.22.26.16%11%110%110%11%1217%11Source%20IP%20Risk%11144120685684326400%114%11T%11T%11T%11T%11T%11T%11T%11T%11TTT%116%110%11T%11345%11%11F%11F%11F%11TTT%116%11corr%110%11T%11F%1122.22.26.16%11%110%110%11%1217%11Source%20User%20Risk%11144120685701103616%115%11T%11T%11T%11T%11T%11T%11T%11T%11TTT%116%110%11T%11345%11%11F%11F%11F%11TTT%116%11corr%110%11T%11F%1122.22.26.16%11%110%110%11%1225%11ELS-1%11144121785145622528%110%11T%11T%11T%11T%11T%11T%11T%11T%11TTT%113%110%11F%11TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT%1110000001%11ELS-VM4%11F%11F%11TTT%11%11syslog%110%11T%11F%1122.22.22.66%11%110%110%11%122%11ERC-1%11144117387099111424%110%11T%11T%11T%11T%11T%11T%11T%11T%11TTT%113%110%11F%11TTTTTTTTTTTTTTTTTTTTTTTTTTTTTTTT%1110001000%11ERC-VM4%11F%11F%11TTT%11%11syslog%110%11T%11F%1122.22.26.17%11%119%111%11%123%11app%11144117387182997504%116%11T%11T%11T%11T%11T%11T%11T%11T%11TTT%110%110%11T%1165%11syslog%11F%11F%11F%11TTT%110%11gsyslog%110%11T%11F%1122.22.26.3%11%110%110%11%123%11gw%11144117387166220288%115%11T%11T%11T%11T%11T%11T%11T%11T%11TTT%110%110%11T%1165%11syslog%11F%11F%11F%11TTT%110%11gsyslog%110%11T%11F%1122.22.26.1%11%110%110%11%123%11Mail%11144117387199774720%117%11T%11T%11T%11T%11T%11T%11T%11T%11TTT%110%110%11T%1165%11syslog%11F%11F%11F%11TTT%110%11gsyslog%110%11T%11F%1122.22.26.4%11%110%110%11%123%11monster%11144117388458065920%1180%11T%11T%11T%11T%11T%11T%11T%11T%11TTT%116%110%11T%1143%11wmi%11F%11F%11F%11TTT%110%11wmi%110%11T%11F%1122.22.22.50%11%110%110%11%123%11NS0%11144117387216551936%118%11T%11T%11T%11T%11T%11T%11T%11T%11TTT%110%110%11T%1165%11syslog%11F%11F%11F%11TTT%110%11gsyslog%110%11T%11F%1122.22.26.10%11%110%110%11%123%11NS1%11144117387233329152%119%11T%11T%11T%11T%11T%11T%11T%11T%11TTT%110%110%11T%1165%11syslog%11F%11F%11F%11TTT%110%11gsyslog%110%11T%11F%1122.22.26.12%11%110%110%11%123%11Test-Parent-1%11144117388424511488%1178%11T%11T%11T%11T%11T%11T%11T%11T%11TTT%116%110%11T%1165%11syslog%11F%11F%11F%11TTT%116%11gsyslog%110%11T%11F%1112.0.0.0%11%111%111%11%12254%111%11144117388424511744%7C144117388424577024%110%11F%11F%11F%11F%11F%11F%11F%11F%11TTT%11%11%11F%11%11%11F%11F%11F%11TTT%11%11%110%11F%11F%1112.0.0.0%11%110%110%11%123%11Testbox%11144117388441288704%1179%11T%11T%11T%11T%11T%11T%11T%11T%11TTT%116%110%11T%11166%11syslog%11F%11F%11F%11TTT%110%11gsyslog%110%11T%11F%1122.22.23.17%11%110%110%11%123%11Tool%11144117387149443072%114%11T%11T%11T%11T%11T%11T%11T%11T%11TTT%110%110%11T%1165%11syslog%11F%11F%11F%11TTT%110%11gsyslog%110%11T%11F%1122.22.26.6%11%110%110%11%12"
hex = [
    r"\x1c",
    r"\x11",
    r"\x12",
    r"\x22",
    r"\x23",
    r"\x27",
    r"\x28",
    r"\x29",
    r"\x2b",
    r"\x2d",
    r"\x2e",
    r"\x2f",
    r"\x7c",
]
uri = [
    r"%11",
    r"%12",
    r"%20",
    r"%22",
    r"%23",
    r"%27",
    r"%28",
    r"%29",
    r"%2B",
    r"%2D",
    r"%2E",
    r"%2F",
    r"%7C",
]


class T(unittest.TestCase):
    def test_dehexify_uri(self):
        cleaned_str = dehexify(uri_string)
        for x in uri:
            self.assertNotIn(x, cleaned_str)
