"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnCloudwatch = exports.toJson_CfnCloudwatchProps = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnCloudwatchProps' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnCloudwatchProps(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'ApiKey': obj.apiKey,
        'LogGroupName': obj.logGroupName,
        'Region': obj.region,
        'ExecRole': obj.execRole,
        'HelixUploadUrl': obj.helixUploadUrl,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnCloudwatchProps = toJson_CfnCloudwatchProps;
/* eslint-enable max-len, quote-props */
/**
 * A CloudFormation `FireEye::CloudIntegrations::Cloudwatch`
 *
 * @cloudformationResource FireEye::CloudIntegrations::Cloudwatch
 * @stability external
 * @link http://unknown-url
 */
class CfnCloudwatch extends cdk.CfnResource {
    /**
     * Create a new `FireEye::CloudIntegrations::Cloudwatch`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnCloudwatch.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnCloudwatchProps(props) });
        this.props = props;
        this.attrPrimaryIdentifier = cdk.Token.asString(this.getAtt('primaryIdentifier'));
    }
}
exports.CfnCloudwatch = CfnCloudwatch;
_a = JSII_RTTI_SYMBOL_1;
CfnCloudwatch[_a] = { fqn: "@cdk-cloudformation/fireeye-cloudintegrations-cloudwatch.CfnCloudwatch", version: "1.1.0-alpha.5" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnCloudwatch.CFN_RESOURCE_TYPE_NAME = "FireEye::CloudIntegrations::Cloudwatch";
//# sourceMappingURL=data:application/json;base64,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