import * as cdk from 'aws-cdk-lib';
import * as constructs from 'constructs';
/**
 * This Resource Type will create necessary resources in your AWS account to forward cloudwatch logs to FireEye Helix. Visit FireEye Cloud Integration Portal for more info and to generate a pre-populated CloudFormation Template
 *
 * @schema CfnCloudwatchProps
 */
export interface CfnCloudwatchProps {
    /**
     * Helix API Key
     *
     * @schema CfnCloudwatchProps#ApiKey
     */
    readonly apiKey: string;
    /**
     * CloudWatch LogGroup to monitor
     *
     * @schema CfnCloudwatchProps#LogGroupName
     */
    readonly logGroupName: string;
    /**
     * LogGroup AWS region
     *
     * @schema CfnCloudwatchProps#Region
     */
    readonly region: string;
    /**
     * Lambda Execution role
     *
     * @schema CfnCloudwatchProps#ExecRole
     */
    readonly execRole: string;
    /**
     * Helix API upload URL
     *
     * @schema CfnCloudwatchProps#HelixUploadUrl
     */
    readonly helixUploadUrl: string;
}
/**
 * Converts an object of type 'CfnCloudwatchProps' to JSON representation.
 */
export declare function toJson_CfnCloudwatchProps(obj: CfnCloudwatchProps | undefined): Record<string, any> | undefined;
/**
 * A CloudFormation `FireEye::CloudIntegrations::Cloudwatch`
 *
 * @cloudformationResource FireEye::CloudIntegrations::Cloudwatch
 * @stability external
 * @link http://unknown-url
 */
export declare class CfnCloudwatch extends cdk.CfnResource {
    /**
    * The CloudFormation resource type name for this resource class.
    */
    static readonly CFN_RESOURCE_TYPE_NAME = "FireEye::CloudIntegrations::Cloudwatch";
    /**
     * Resource props.
     */
    readonly props: CfnCloudwatchProps;
    /**
     * Attribute `FireEye::CloudIntegrations::Cloudwatch.primaryIdentifier`
     * @link http://unknown-url
     */
    readonly attrPrimaryIdentifier: string;
    /**
     * Create a new `FireEye::CloudIntegrations::Cloudwatch`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope: constructs.Construct, id: string, props: CfnCloudwatchProps);
}
