<div align="center">
  

<p align="center">
<img src="https://images.squarespace-cdn.com/content/v1/57f6d51c9f74566f55ecf271/6f3943a1-b76d-4674-9df9-87aebd33e517/cebralogo.png?format=2500w" width="95%">
</p>



[📚Documentation](https://cebra.ai/docs/) |
[🛠️ Installation](https://cebra.ai/docs/installation.html) |
[🌎 Home Page](https://www.cebra.ai) |
[🚨 News](https://cebra.ai/docs/index.html) |
[🪲 Reporting Issues](https://github.com/AdaptiveMotorControlLab/CEBRA) 


[![Downloads](https://static.pepy.tech/badge/cebra)](https://pepy.tech/project/cebra)
[![Downloads](https://static.pepy.tech/badge/cebra/month)](https://pepy.tech/project/cebra)
[![PyPI version](https://badge.fury.io/py/cebra.svg)](https://badge.fury.io/py/cebra)
![License: Non-Commerical](https://img.shields.io/badge/License-Non--commerical-lightgrey)
![Codecov](https://img.shields.io/codecov/c/github/AdaptiveMotorControlLab/CEBRA)
[![Twitter Follow](https://img.shields.io/twitter/follow/CEBRAAI.svg?label=CEBRAai&style=social)](https://twitter.com/CEBRAAI)



</div>

# Welcome! 👋

CEBRA is a library for estimating **C**onsistent **E**m**B**eddings of high-dimensional **R**ecordings using **A**uxiliary variables. It contains self-supervised learning algorithms implemented in PyTorch, and has support for a variety of different datasets common in biology and neuroscience.

To receive updates on code releases, please 👀 watch or ⭐️ star this repository!

``cebra`` is a self-supervised method for non-linear clustering that allows for label-informed time series analysis. 
It can jointly use behavioral and neural data in a hypothesis- or discovery-driven manner to produce consistent, high-performance latent spaces. While it is not specific to neural and behavioral data, this is the first domain we used the tool in. This application case is to obtain a consistent representation of latent variables driving activity and behavior, improving decoding accuracy of behavioral variables over standard supervised learning, and obtaining embeddings which are robust to domain shifts.


# Reference 
- 📄 **Preprint**:
  [Learnable latent embeddings for joint behavioral and neural analysis.](https://arxiv.org/abs/2204.00673)
  Steffen Schneider*, Jin Hwa Lee* and Mackenzie Weygandt Mathis
  
 # License
-  CEBRA is released for academic use only (please read the license file). If this license is not appropriate for your application, please contact Prof. Mackenzie W. Mathis (mackenzie@post.harvard.edu) and/or the TTO office at EPFL (tto@epfl.ch) for a commercial use license.
