/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.str;

import java.util.function.IntPredicate;
import net.sf.saxon.expr.sort.EmptyIntIterator;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.z.IntIterator;

public final class EmptyUnicodeString
extends UnicodeString {
    private static final EmptyUnicodeString INSTANCE = new EmptyUnicodeString();

    public static EmptyUnicodeString getInstance() {
        return INSTANCE;
    }

    private EmptyUnicodeString() {
    }

    @Override
    public long length() {
        return 0L;
    }

    @Override
    public int length32() {
        return 0;
    }

    @Override
    public UnicodeString concat(UnicodeString other) {
        return other;
    }

    @Override
    void copy8bit(byte[] target, int offset) {
    }

    @Override
    void copy16bit(char[] target, int offset) {
    }

    @Override
    void copy24bit(byte[] target, int offset) {
    }

    @Override
    public UnicodeString substring(long start, long end) {
        this.checkSubstringBounds(start, end);
        return this;
    }

    @Override
    public int codePointAt(long index) throws IndexOutOfBoundsException {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public long indexOf(int code, long from) {
        return -1L;
    }

    @Override
    public long indexOf(UnicodeString other, long from) {
        return -1L;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public int getWidth() {
        return 0;
    }

    @Override
    public IntIterator codePoints() {
        return EmptyIntIterator.getInstance();
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof UnicodeString) {
            return ((UnicodeString)o).isEmpty();
        }
        return false;
    }

    @Override
    public int compareTo(UnicodeString other) {
        return other.isEmpty() ? 0 : -1;
    }

    public String toString() {
        return "";
    }

    @Override
    public long indexWhere(IntPredicate predicate, long from) {
        return -1L;
    }

    public String details() {
        return "empty string";
    }
}

