/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.GeomKind;
import jetbrains.datalore.plot.base.Stat;
import jetbrains.datalore.plot.base.data.DataFrameUtil;
import jetbrains.datalore.plot.builder.GeomLayer;
import jetbrains.datalore.plot.builder.VarBinding;
import jetbrains.datalore.plot.builder.assemble.GeomLayerBuilder;
import jetbrains.datalore.plot.builder.assemble.GuideOptions;
import jetbrains.datalore.plot.builder.assemble.PlotAssembler;
import jetbrains.datalore.plot.builder.assemble.geom.GeomProvider;
import jetbrains.datalore.plot.builder.interact.GeomInteraction;
import jetbrains.datalore.plot.config.GeomInteractionUtil;
import jetbrains.datalore.plot.config.GeomProtoClientSide;
import jetbrains.datalore.plot.config.GuideConfig;
import jetbrains.datalore.plot.config.LayerConfig;
import jetbrains.datalore.plot.config.Option;
import jetbrains.datalore.plot.config.PlotConfigClientSide;
import jetbrains.datalore.plot.config.PlotConfigUtil;
import jetbrains.datalore.plot.config.ScaleConfig;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J/\u0010\b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u000b0\t2\u0010\u0010\f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r0\u0004H\u0000\u00a2\u0006\u0002\b\u000eJ1\u0010\b\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\n\u0012\u0004\u0012\u00020\u000b0\t2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00010\tH\u0000\u00a2\u0006\u0002\b\u000eJ\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0007\u00a8\u0006\u001a"}, d2={"Ljetbrains/datalore/plot/config/PlotConfigClientSideUtil;", "", "()V", "buildPlotLayers", "", "Ljetbrains/datalore/plot/builder/GeomLayer;", "plotConfig", "Ljetbrains/datalore/plot/config/PlotConfigClientSide;", "createGuideOptionsMap", "", "Ljetbrains/datalore/plot/base/Aes;", "Ljetbrains/datalore/plot/builder/assemble/GuideOptions;", "scaleConfigs", "Ljetbrains/datalore/plot/config/ScaleConfig;", "createGuideOptionsMap$plot_config_portable", "guideOptionsList", "", "createLayerBuilder", "Ljetbrains/datalore/plot/builder/assemble/GeomLayerBuilder;", "layerConfig", "Ljetbrains/datalore/plot/config/LayerConfig;", "geomInteraction", "Ljetbrains/datalore/plot/builder/interact/GeomInteraction;", "createPlotAssembler", "Ljetbrains/datalore/plot/builder/assemble/PlotAssembler;", "config", "plot-config-portable"})
public final class PlotConfigClientSideUtil {
    @NotNull
    public static final PlotConfigClientSideUtil INSTANCE = new PlotConfigClientSideUtil();

    private PlotConfigClientSideUtil() {
    }

    @NotNull
    public final Map<Aes<?>, GuideOptions> createGuideOptionsMap$plot_config_portable(@NotNull List<? extends ScaleConfig<?>> scaleConfigs) {
        Intrinsics.checkNotNullParameter(scaleConfigs, (String)"scaleConfigs");
        HashMap guideOptionsByAes = new HashMap();
        for (ScaleConfig<?> scaleConfig : scaleConfigs) {
            if (!scaleConfig.hasGuideOptions()) continue;
            GuideOptions guideOptions = scaleConfig.getGuideOptions().createGuideOptions();
            Map map2 = guideOptionsByAes;
            Aes<?> aes = scaleConfig.getAes();
            boolean bl = false;
            map2.put(aes, guideOptions);
        }
        return guideOptionsByAes;
    }

    @NotNull
    public final Map<Aes<?>, GuideOptions> createGuideOptionsMap$plot_config_portable(@NotNull Map<String, ? extends Object> guideOptionsList) {
        Intrinsics.checkNotNullParameter(guideOptionsList, (String)"guideOptionsList");
        HashMap guideOptionsByAes = new HashMap();
        Object object = guideOptionsList;
        boolean bl = false;
        Iterator<Map.Entry<String, ? extends Object>> iterator2 = object.entrySet().iterator();
        while (iterator2.hasNext()) {
            Object object2 = object = iterator2.next();
            boolean bl2 = false;
            String key = (String)object2.getKey();
            Object object3 = object;
            boolean bl3 = false;
            Object value = object3.getValue();
            Aes<?> aes = Option.Mapping.INSTANCE.toAes(key);
            Map map2 = guideOptionsByAes;
            GuideOptions guideOptions = GuideConfig.Companion.create(value).createGuideOptions();
            boolean bl4 = false;
            map2.put(aes, guideOptions);
        }
        return guideOptionsByAes;
    }

    @NotNull
    public final PlotAssembler createPlotAssembler(@NotNull PlotConfigClientSide config2) {
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        List<List<GeomLayer>> layersByTile = this.buildPlotLayers(config2);
        PlotAssembler assembler = PlotAssembler.Companion.multiTile(config2.getScaleMap(), layersByTile, config2.getCoordProvider$plot_config_portable(), config2.getTheme$plot_config_portable());
        assembler.setTitle(config2.getTitle());
        assembler.setGuideOptionsMap(config2.getGuideOptionsMap$plot_config_portable());
        assembler.setFacets(config2.getFacets());
        return assembler;
    }

    private final List<List<GeomLayer>> buildPlotLayers(PlotConfigClientSide plotConfig) {
        ArrayList<DataFrame> dataByLayer = new ArrayList<DataFrame>();
        for (LayerConfig layerConfig : plotConfig.getLayerConfigs()) {
            DataFrame layerData = layerConfig.getCombinedData();
            dataByLayer.add(layerData);
        }
        List<List<DataFrame>> layersDataByTile = PlotConfigUtil.INSTANCE.toLayersDataByTile((List<DataFrame>)dataByLayer, plotConfig.getFacets());
        ArrayList<GeomLayerBuilder> layerBuilders = new ArrayList<GeomLayerBuilder>();
        ArrayList layersByTile = new ArrayList();
        for (List<DataFrame> tileDataByLayer : layersDataByTile) {
            boolean bl;
            boolean isMultilayer;
            ArrayList<GeomLayer> panelLayers;
            block9: {
                panelLayers = new ArrayList<GeomLayer>();
                isMultilayer = tileDataByLayer.size() > 1;
                Iterable $this$any$iv = plotConfig.getLayerConfigs();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        LayerConfig it = (LayerConfig)element$iv;
                        boolean bl2 = false;
                        if (!(it.getGeomProto().getGeomKind() == GeomKind.LIVE_MAP)) continue;
                        bl = true;
                        break block9;
                    }
                    bl = false;
                }
            }
            boolean isLiveMap = bl;
            int n = 0;
            int n2 = tileDataByLayer.size() + -1;
            if (n <= n2) {
                do {
                    int layerIndex = n++;
                    boolean element$iv = layerBuilders.size() >= layerIndex;
                    boolean it = false;
                    boolean bl3 = false;
                    bl3 = false;
                    boolean bl4 = false;
                    if (!element$iv) {
                        boolean bl5 = false;
                        String string = "Check failed.";
                        throw (Throwable)new IllegalStateException(string.toString());
                    }
                    if (layerBuilders.size() == layerIndex) {
                        LayerConfig layerConfig = plotConfig.getLayerConfigs().get(layerIndex);
                        GeomInteraction geomInteraction = GeomInteractionUtil.INSTANCE.configGeomTargets$plot_config_portable(layerConfig, plotConfig.getScaleMap(), isMultilayer, isLiveMap, plotConfig.getTheme$plot_config_portable());
                        layerBuilders.add(this.createLayerBuilder(layerConfig, geomInteraction));
                    }
                    DataFrame layerTileData = tileDataByLayer.get(layerIndex);
                    GeomLayer layer = ((GeomLayerBuilder)layerBuilders.get(layerIndex)).build(layerTileData, plotConfig.getScaleMap());
                    panelLayers.add(layer);
                } while (n <= n2);
            }
            layersByTile.add(panelLayers);
        }
        return layersByTile;
    }

    private final GeomLayerBuilder createLayerBuilder(LayerConfig layerConfig, GeomInteraction geomInteraction) {
        GeomProvider geomProvider2 = ((GeomProtoClientSide)layerConfig.getGeomProto()).geomProvider(layerConfig);
        Stat stat = layerConfig.getStat();
        GeomLayerBuilder layerBuilder = new GeomLayerBuilder().stat(stat).geom(geomProvider2).pos(layerConfig.getPosProvider());
        Map<Aes<?>, Object> constantAesMap = layerConfig.getConstantsMap();
        Iterator<VarBinding> iterator2 = constantAesMap.keySet().iterator();
        while (iterator2.hasNext()) {
            Aes<?> aes = iterator2.next();
            Object object = constantAesMap.get(aes);
            Intrinsics.checkNotNull((Object)object);
            layerBuilder.addConstantAes(aes, object);
        }
        if (layerConfig.hasExplicitGrouping()) {
            String string = layerConfig.getExplicitGroupingVarName();
            Intrinsics.checkNotNull((Object)string);
            layerBuilder.groupingVarName(string);
        }
        if ((iterator2 = DataFrameUtil.INSTANCE.variables(layerConfig.getCombinedData()).get("__geo_id__")) != null) {
            Iterator<VarBinding> iterator3 = iterator2;
            boolean bl = false;
            boolean bl2 = false;
            Iterator<VarBinding> it = iterator3;
            boolean bl3 = false;
            layerBuilder.pathIdVarName("__geo_id__");
        }
        List<VarBinding> bindings = layerConfig.getVarBindings();
        for (VarBinding binding : bindings) {
            layerBuilder.addBinding(binding);
        }
        layerBuilder.disableLegend(layerConfig.isLegendDisabled());
        layerBuilder.locatorLookupSpec(geomInteraction.createLookupSpec()).contextualMappingProvider(geomInteraction);
        return layerBuilder;
    }
}

