/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.guide;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.base.values.Color;
import jetbrains.datalore.plot.base.render.svg.SvgComponent;
import jetbrains.datalore.plot.base.render.svg.TextLabel;
import jetbrains.datalore.plot.builder.guide.Orientation;
import jetbrains.datalore.plot.builder.presentation.PlotLabelSpec;
import jetbrains.datalore.plot.builder.theme.AxisTheme;
import jetbrains.datalore.plot.builder.theme.PanelGridTheme;
import jetbrains.datalore.vis.svg.SvgGElement;
import jetbrains.datalore.vis.svg.SvgLineElement;
import jetbrains.datalore.vis.svg.SvgUtils;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 (2\u00020\u0001:\u0004'()*Bg\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u000f\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0011\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0012\u001a\u00020\u0010\u0012\b\b\u0002\u0010\u0013\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0017H\u0014J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J(\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010&\u001a\u00020$H\u0002R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Ljetbrains/datalore/plot/builder/guide/AxisComponent;", "Ljetbrains/datalore/plot/base/render/svg/SvgComponent;", "length", "", "orientation", "Ljetbrains/datalore/plot/builder/guide/Orientation;", "breaksData", "Ljetbrains/datalore/plot/builder/guide/AxisComponent$BreaksData;", "labelAdjustments", "Ljetbrains/datalore/plot/builder/guide/AxisComponent$TickLabelAdjustments;", "gridLineLength", "axisTheme", "Ljetbrains/datalore/plot/builder/theme/AxisTheme;", "gridTheme", "Ljetbrains/datalore/plot/builder/theme/PanelGridTheme;", "useSmallFont", "", "hideAxis", "hideAxisBreaks", "hideGridlines", "(DLjetbrains/datalore/plot/builder/guide/Orientation;Ljetbrains/datalore/plot/builder/guide/AxisComponent$BreaksData;Ljetbrains/datalore/plot/builder/guide/AxisComponent$TickLabelAdjustments;DLjetbrains/datalore/plot/builder/theme/AxisTheme;Ljetbrains/datalore/plot/builder/theme/PanelGridTheme;ZZZZ)V", "tickMarkPadding", "buildAxis", "", "buildComponent", "buildGridLine", "Ljetbrains/datalore/vis/svg/SvgLineElement;", "br", "width", "color", "Ljetbrains/datalore/base/values/Color;", "buildTick", "Ljetbrains/datalore/vis/svg/SvgGElement;", "label", "", "labelOffset", "Ljetbrains/datalore/base/geometry/DoubleVector;", "skipLabel", "tickLabelBaseOffset", "BreaksData", "Companion", "TickLabelAdjustments", "TickLabelsCleaner", "plot-builder-portable"})
public final class AxisComponent
extends SvgComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double length;
    @NotNull
    private final Orientation orientation;
    @NotNull
    private final BreaksData breaksData;
    @NotNull
    private final TickLabelAdjustments labelAdjustments;
    private final double gridLineLength;
    @NotNull
    private final AxisTheme axisTheme;
    @NotNull
    private final PanelGridTheme gridTheme;
    private final boolean useSmallFont;
    private final boolean hideAxis;
    private final boolean hideAxisBreaks;
    private final boolean hideGridlines;
    private final double tickMarkPadding;

    public AxisComponent(double length, @NotNull Orientation orientation, @NotNull BreaksData breaksData, @NotNull TickLabelAdjustments labelAdjustments, double gridLineLength, @NotNull AxisTheme axisTheme, @NotNull PanelGridTheme gridTheme, boolean useSmallFont, boolean hideAxis, boolean hideAxisBreaks, boolean hideGridlines) {
        Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
        Intrinsics.checkNotNullParameter((Object)breaksData, (String)"breaksData");
        Intrinsics.checkNotNullParameter((Object)labelAdjustments, (String)"labelAdjustments");
        Intrinsics.checkNotNullParameter((Object)axisTheme, (String)"axisTheme");
        Intrinsics.checkNotNullParameter((Object)gridTheme, (String)"gridTheme");
        this.length = length;
        this.orientation = orientation;
        this.breaksData = breaksData;
        this.labelAdjustments = labelAdjustments;
        this.gridLineLength = gridLineLength;
        this.axisTheme = axisTheme;
        this.gridTheme = gridTheme;
        this.useSmallFont = useSmallFont;
        this.hideAxis = hideAxis;
        this.hideAxisBreaks = hideAxisBreaks;
        this.hideGridlines = hideGridlines;
        this.tickMarkPadding = 3.0;
    }

    public /* synthetic */ AxisComponent(double d, Orientation orientation, BreaksData breaksData, TickLabelAdjustments tickLabelAdjustments, double d2, AxisTheme axisTheme, PanelGridTheme panelGridTheme, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            tickLabelAdjustments = new TickLabelAdjustments(orientation, null, null, 0.0, null, 30, null);
        }
        if ((n & 0x80) != 0) {
            bl = false;
        }
        if ((n & 0x100) != 0) {
            bl2 = false;
        }
        if ((n & 0x200) != 0) {
            bl3 = false;
        }
        if ((n & 0x400) != 0) {
            bl4 = false;
        }
        this(d, orientation, breaksData, tickLabelAdjustments, d2, axisTheme, panelGridTheme, bl, bl2, bl3, bl4);
    }

    @Override
    protected void buildComponent() {
        this.buildAxis();
    }

    private final void buildAxis() {
        SvgGElement rootElement = this.getRootGroup();
        if (!this.hideAxis) {
            rootElement.addClass("plt-axis");
            if (this.useSmallFont) {
                rootElement.addClass("small-tick-font");
            }
        }
        double l = this.length;
        double x1 = 0.0;
        double y1 = 0.0;
        double x2 = 0.0;
        double y2 = 0.0;
        double start2 = 0.0;
        double end = 0.0;
        Orientation orientation = this.orientation;
        int n = WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()];
        switch (n) {
            case 1: 
            case 2: {
                x1 = x2 = 0.0;
                y1 = start2 = 0.0;
                y2 = end = l;
                break;
            }
            case 3: 
            case 4: {
                x1 = start2 = 0.0;
                x2 = end = l;
                y1 = y2 = 0.0;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (!this.hideGridlines) {
            SvgLineElement elem;
            double br;
            Iterator<Double> iterator2;
            double gridLineMinPos = start2 + (double)6;
            double gridLineMaxPos = end - (double)6;
            if (this.gridTheme.showMinor()) {
                iterator2 = this.breaksData.getMinorBreaks().iterator();
                while (iterator2.hasNext()) {
                    br = ((Number)iterator2.next()).doubleValue();
                    if (!(br >= gridLineMinPos) || !(br <= gridLineMaxPos)) continue;
                    elem = this.buildGridLine(br, this.gridTheme.minorLineWidth(), this.gridTheme.minorLineColor());
                    rootElement.children().add(elem);
                }
            }
            if (this.gridTheme.showMajor()) {
                iterator2 = this.breaksData.getMajorBreaks().iterator();
                while (iterator2.hasNext()) {
                    br = ((Number)iterator2.next()).doubleValue();
                    if (!(br >= gridLineMinPos) || !(br <= gridLineMaxPos)) continue;
                    elem = this.buildGridLine(br, this.gridTheme.majorLineWidth(), this.gridTheme.majorLineColor());
                    rootElement.children().add(elem);
                }
            }
        }
        if (!this.hideAxis) {
            if (!this.hideAxisBreaks && (this.axisTheme.showLabels() || this.axisTheme.showTickMarks())) {
                TickLabelsCleaner labelsCleaner = new TickLabelsCleaner(this.orientation.isHorizontal());
                Iterator<Double> iterator3 = this.breaksData.getMajorBreaks().iterator();
                int n2 = 0;
                while (iterator3.hasNext()) {
                    int i = n2++;
                    double br = ((Number)iterator3.next()).doubleValue();
                    String label = this.breaksData.getMajorLabels().get(i % this.breaksData.getMajorLabels().size());
                    DoubleVector labelOffset = this.tickLabelBaseOffset().add(this.labelAdjustments.additionalOffset(i));
                    SvgGElement group2 = this.buildTick(label, labelOffset, !labelsCleaner.beforeAddLabel(br, this.labelAdjustments.getRotationDegree()), this.axisTheme);
                    Orientation orientation2 = this.orientation;
                    int n3 = WhenMappings.$EnumSwitchMapping$0[orientation2.ordinal()];
                    switch (n3) {
                        case 1: 
                        case 2: {
                            SvgUtils.INSTANCE.transformTranslate(group2, 0.0, br);
                            break;
                        }
                        case 3: 
                        case 4: {
                            SvgUtils.INSTANCE.transformTranslate(group2, br, 0.0);
                        }
                    }
                    rootElement.children().add(group2);
                }
            }
            if (!this.hideAxisBreaks && this.axisTheme.showLine()) {
                SvgLineElement svgLineElement = new SvgLineElement(x1, y1, x2, y2);
                boolean bl = false;
                boolean bl2 = false;
                SvgLineElement $this$buildAxis_u24lambda_u2d0 = svgLineElement;
                boolean bl3 = false;
                $this$buildAxis_u24lambda_u2d0.strokeWidth().set(this.axisTheme.lineWidth());
                $this$buildAxis_u24lambda_u2d0.strokeColor().set(this.axisTheme.lineColor());
                SvgLineElement axisLine = svgLineElement;
                rootElement.children().add(axisLine);
            }
        }
    }

    private final SvgLineElement buildGridLine(double br, double width2, Color color) {
        SvgLineElement svgLineElement;
        Orientation orientation = this.orientation;
        int n = WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()];
        switch (n) {
            case 1: {
                svgLineElement = new SvgLineElement(0.0, 0.0, this.gridLineLength, 0.0);
                break;
            }
            case 2: {
                svgLineElement = new SvgLineElement(0.0, 0.0, -this.gridLineLength, 0.0);
                break;
            }
            case 3: {
                svgLineElement = new SvgLineElement(0.0, 0.0, 0.0, this.gridLineLength);
                break;
            }
            case 4: {
                svgLineElement = new SvgLineElement(0.0, 0.0, 0.0, -this.gridLineLength);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        SvgLineElement elem = svgLineElement;
        elem.strokeColor().set(color);
        elem.strokeWidth().set(width2);
        orientation = this.orientation;
        n = WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()];
        switch (n) {
            case 1: 
            case 2: {
                elem.y1().set(br);
                elem.y2().set(br);
                break;
            }
            case 3: 
            case 4: {
                elem.x1().set(br);
                elem.x2().set(br);
            }
        }
        return elem;
    }

    private final SvgGElement buildTick(String label, DoubleVector labelOffset, boolean skipLabel, AxisTheme axisTheme) {
        SvgLineElement tickMark = null;
        if (axisTheme.showTickMarks()) {
            tickMark = new SvgLineElement();
            tickMark.strokeWidth().set(axisTheme.tickMarkWidth());
            tickMark.strokeColor().set(axisTheme.tickMarkColor());
        }
        TextLabel tickLabel = null;
        if (!skipLabel && axisTheme.showLabels()) {
            tickLabel = new TextLabel(label);
            tickLabel.textColor().set(axisTheme.labelColor());
        }
        double markLength = axisTheme.tickMarkLength();
        Orientation orientation = this.orientation;
        int n = WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()];
        switch (n) {
            case 1: {
                if (tickMark == null) break;
                tickMark.x2().set(-markLength);
                tickMark.y2().set(0.0);
                break;
            }
            case 2: {
                if (tickMark == null) break;
                tickMark.x2().set(markLength);
                tickMark.y2().set(0.0);
                break;
            }
            case 3: {
                if (tickMark == null) break;
                tickMark.x2().set(0.0);
                tickMark.y2().set(-markLength);
                break;
            }
            case 4: {
                if (tickMark == null) break;
                tickMark.x2().set(0.0);
                tickMark.y2().set(markLength);
            }
        }
        SvgGElement g = new SvgGElement();
        if (tickMark != null) {
            g.children().add(tickMark);
        }
        if (tickLabel != null) {
            tickLabel.moveTo(labelOffset.getX(), labelOffset.getY());
            tickLabel.setHorizontalAnchor(this.labelAdjustments.getHorizontalAnchor());
            tickLabel.setVerticalAnchor(this.labelAdjustments.getVerticalAnchor());
            tickLabel.rotate(this.labelAdjustments.getRotationDegree());
            g.children().add(tickLabel.getRootGroup());
        }
        g.addClass("tick");
        return g;
    }

    private final DoubleVector tickLabelBaseOffset() {
        DoubleVector doubleVector;
        double distance = this.axisTheme.tickLabelDistance();
        Orientation orientation = this.orientation;
        int n = WhenMappings.$EnumSwitchMapping$0[orientation.ordinal()];
        switch (n) {
            case 1: {
                doubleVector = new DoubleVector(-distance, 0.0);
                break;
            }
            case 2: {
                doubleVector = new DoubleVector(distance, 0.0);
                break;
            }
            case 3: {
                doubleVector = new DoubleVector(0.0, -distance);
                break;
            }
            case 4: {
                doubleVector = new DoubleVector(0.0, distance);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return doubleVector;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/datalore/plot/builder/guide/AxisComponent$Companion;", "", "()V", "plot-builder-portable"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B3\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\u0010\b\u0002\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\n\u00a8\u0006\r"}, d2={"Ljetbrains/datalore/plot/builder/guide/AxisComponent$BreaksData;", "", "majorBreaks", "", "", "majorLabels", "", "minorBreaks", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getMajorBreaks", "()Ljava/util/List;", "getMajorLabels", "getMinorBreaks", "plot-builder-portable"})
    public static final class BreaksData {
        @NotNull
        private final List<Double> majorBreaks;
        @NotNull
        private final List<String> majorLabels;
        @NotNull
        private final List<Double> minorBreaks;

        /*
         * WARNING - void declaration
         */
        public BreaksData(@NotNull List<Double> majorBreaks, @NotNull List<String> majorLabels, @Nullable List<Double> minorBreaks) {
            List list2;
            Intrinsics.checkNotNullParameter(majorBreaks, (String)"majorBreaks");
            Intrinsics.checkNotNullParameter(majorLabels, (String)"majorLabels");
            this.majorBreaks = majorBreaks;
            this.majorLabels = majorLabels;
            BreaksData breaksData = this;
            List list3 = minorBreaks;
            if (list3 == null) {
                List list4;
                BreaksData breaksData2 = this;
                boolean bl = false;
                boolean bl2 = false;
                BreaksData breaksData3 = breaksData2;
                BreaksData breaksData4 = breaksData;
                boolean bl3 = false;
                if (this.getMajorBreaks().size() <= 1) {
                    list4 = CollectionsKt.emptyList();
                } else {
                    double second;
                    double first2;
                    void $this$fold$iv;
                    Object object = CollectionsKt.zip((Iterable)this.getMajorBreaks().subList(0, this.getMajorBreaks().size() - 1), (Iterable)this.getMajorBreaks().subList(1, this.getMajorBreaks().size()));
                    ArrayList<Double> initial$iv = new ArrayList<Double>();
                    boolean $i$f$fold = false;
                    Object accumulator$iv = initial$iv;
                    for (Object element$iv : $this$fold$iv) {
                        void pair2;
                        Pair pair3 = (Pair)element$iv;
                        ArrayList<Double> l = accumulator$iv;
                        boolean bl4 = false;
                        l.add((((Number)pair2.getSecond()).doubleValue() - ((Number)pair2.getFirst()).doubleValue()) / (double)2 + ((Number)pair2.getFirst()).doubleValue());
                        accumulator$iv = l;
                    }
                    List minorBreaks2 = (List)accumulator$iv;
                    Iterable<Object> $this$reduce$iv = (ArrayList)CollectionsKt.take((Iterable)this.getMajorBreaks(), (int)2);
                    boolean $i$f$reduce = false;
                    Iterator iterator$iv22 = $this$reduce$iv.iterator();
                    if (!iterator$iv22.hasNext()) {
                        throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
                    }
                    accumulator$iv = iterator$iv22.next();
                    while (iterator$iv22.hasNext()) {
                        double d = ((Number)iterator$iv22.next()).doubleValue();
                        first2 = ((Number)accumulator$iv).doubleValue();
                        boolean bl5 = false;
                        accumulator$iv = (double)(second - first2);
                    }
                    $this$reduce$iv = accumulator$iv;
                    $i$f$reduce = false;
                    boolean iterator$iv22 = false;
                    double $this$minorBreaks_u24lambda_u2d5_u24lambda_u2d2 = ((Number)((Object)$this$reduce$iv)).doubleValue();
                    boolean bl6 = false;
                    minorBreaks2.add(0, ((Number)CollectionsKt.first((List)minorBreaks2)).doubleValue() - $this$minorBreaks_u24lambda_u2d5_u24lambda_u2d2);
                    $this$reduce$iv = CollectionsKt.takeLast(this.getMajorBreaks(), (int)2);
                    $i$f$reduce = false;
                    Iterator<Object> iterator$iv = $this$reduce$iv.iterator();
                    if (!iterator$iv.hasNext()) {
                        throw (Throwable)new UnsupportedOperationException("Empty collection can't be reduced.");
                    }
                    accumulator$iv = iterator$iv.next();
                    while (iterator$iv.hasNext()) {
                        second = ((Number)iterator$iv.next()).doubleValue();
                        first2 = ((Number)accumulator$iv).doubleValue();
                        boolean bl7 = false;
                        accumulator$iv = second - first2;
                    }
                    object = accumulator$iv;
                    boolean bl8 = false;
                    boolean bl9 = false;
                    double $this$minorBreaks_u24lambda_u2d5_u24lambda_u2d4 = ((Number)object).doubleValue();
                    boolean bl10 = false;
                    minorBreaks2.add(0, ((Number)CollectionsKt.last((List)minorBreaks2)).doubleValue() + $this$minorBreaks_u24lambda_u2d5_u24lambda_u2d4);
                    list4 = minorBreaks2;
                }
                List list5 = list4;
                breaksData = breaksData4;
                list2 = list5;
            } else {
                list2 = list3;
            }
            breaksData.minorBreaks = list2;
        }

        public /* synthetic */ BreaksData(List list2, List list3, List list4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                list4 = null;
            }
            this(list2, list3, list4);
        }

        @NotNull
        public final List<Double> getMajorBreaks() {
            return this.majorBreaks;
        }

        @NotNull
        public final List<String> getMajorLabels() {
            return this.majorLabels;
        }

        @NotNull
        public final List<Double> getMinorBreaks() {
            return this.minorBreaks;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000b\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0016R\u0016\u0010\n\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0017"}, d2={"Ljetbrains/datalore/plot/builder/guide/AxisComponent$TickLabelAdjustments;", "", "orientation", "Ljetbrains/datalore/plot/builder/guide/Orientation;", "horizontalAnchor", "Ljetbrains/datalore/plot/base/render/svg/TextLabel$HorizontalAnchor;", "verticalAnchor", "Ljetbrains/datalore/plot/base/render/svg/TextLabel$VerticalAnchor;", "rotationDegree", "", "additionalOffsets", "", "Ljetbrains/datalore/base/geometry/DoubleVector;", "(Ljetbrains/datalore/plot/builder/guide/Orientation;Ljetbrains/datalore/plot/base/render/svg/TextLabel$HorizontalAnchor;Ljetbrains/datalore/plot/base/render/svg/TextLabel$VerticalAnchor;DLjava/util/List;)V", "getHorizontalAnchor", "()Ljetbrains/datalore/plot/base/render/svg/TextLabel$HorizontalAnchor;", "getRotationDegree", "()D", "getVerticalAnchor", "()Ljetbrains/datalore/plot/base/render/svg/TextLabel$VerticalAnchor;", "additionalOffset", "tickIndex", "", "plot-builder-portable"})
    public static final class TickLabelAdjustments {
        private final double rotationDegree;
        @Nullable
        private final List<DoubleVector> additionalOffsets;
        @NotNull
        private final TextLabel.HorizontalAnchor horizontalAnchor;
        @NotNull
        private final TextLabel.VerticalAnchor verticalAnchor;

        public TickLabelAdjustments(@NotNull Orientation orientation, @Nullable TextLabel.HorizontalAnchor horizontalAnchor, @Nullable TextLabel.VerticalAnchor verticalAnchor, double rotationDegree, @Nullable List<DoubleVector> additionalOffsets) {
            Enum enum_;
            block13: {
                Enum enum_2;
                block12: {
                    TextLabel.HorizontalAnchor horizontalAnchor2;
                    int n;
                    Orientation orientation2;
                    block11: {
                        block10: {
                            Intrinsics.checkNotNullParameter((Object)((Object)orientation), (String)"orientation");
                            this.rotationDegree = rotationDegree;
                            this.additionalOffsets = additionalOffsets;
                            enum_2 = horizontalAnchor;
                            if (enum_2 != null) break block10;
                            orientation2 = orientation;
                            n = WhenMappings.$EnumSwitchMapping$0[orientation2.ordinal()];
                            switch (n) {
                                case 1: {
                                    horizontalAnchor2 = TextLabel.HorizontalAnchor.RIGHT;
                                    break block11;
                                }
                                case 2: {
                                    horizontalAnchor2 = TextLabel.HorizontalAnchor.LEFT;
                                    break block11;
                                }
                                case 3: 
                                case 4: {
                                    horizontalAnchor2 = TextLabel.HorizontalAnchor.MIDDLE;
                                    break block11;
                                }
                                default: {
                                    throw new NoWhenBranchMatchedException();
                                }
                            }
                        }
                        horizontalAnchor2 = enum_2;
                    }
                    this.horizontalAnchor = horizontalAnchor2;
                    enum_2 = verticalAnchor;
                    if (enum_2 != null) break block12;
                    orientation2 = orientation;
                    n = WhenMappings.$EnumSwitchMapping$0[orientation2.ordinal()];
                    switch (n) {
                        case 1: 
                        case 2: {
                            enum_ = TextLabel.VerticalAnchor.CENTER;
                            break block13;
                        }
                        case 3: {
                            enum_ = TextLabel.VerticalAnchor.BOTTOM;
                            break block13;
                        }
                        case 4: {
                            enum_ = TextLabel.VerticalAnchor.TOP;
                            break block13;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                }
                enum_ = enum_2;
            }
            this.verticalAnchor = enum_;
        }

        public /* synthetic */ TickLabelAdjustments(Orientation orientation, TextLabel.HorizontalAnchor horizontalAnchor, TextLabel.VerticalAnchor verticalAnchor, double d, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                horizontalAnchor = null;
            }
            if ((n & 4) != 0) {
                verticalAnchor = null;
            }
            if ((n & 8) != 0) {
                d = 0.0;
            }
            if ((n & 0x10) != 0) {
                list2 = null;
            }
            this(orientation, horizontalAnchor, verticalAnchor, d, list2);
        }

        public final double getRotationDegree() {
            return this.rotationDegree;
        }

        @NotNull
        public final TextLabel.HorizontalAnchor getHorizontalAnchor() {
            return this.horizontalAnchor;
        }

        @NotNull
        public final TextLabel.VerticalAnchor getVerticalAnchor() {
            return this.verticalAnchor;
        }

        @NotNull
        public final DoubleVector additionalOffset(int tickIndex) {
            List<DoubleVector> list2 = this.additionalOffsets;
            DoubleVector doubleVector = list2 == null ? null : list2.get(tickIndex);
            return doubleVector == null ? DoubleVector.Companion.getZERO() : doubleVector;
        }

        @Metadata(mv={1, 5, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Orientation.values().length];
                nArray[Orientation.LEFT.ordinal()] = 1;
                nArray[Orientation.RIGHT.ordinal()] = 2;
                nArray[Orientation.TOP.ordinal()] = 3;
                nArray[Orientation.BOTTOM.ordinal()] = 4;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\bJ\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\bH\u0002R*\u0010\u0005\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0006j\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0007`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Ljetbrains/datalore/plot/builder/guide/AxisComponent$TickLabelsCleaner;", "", "horizontalAxis", "", "(Z)V", "filledRanges", "Ljava/util/ArrayList;", "Ljetbrains/datalore/base/gcommon/collect/ClosedRange;", "", "Lkotlin/collections/ArrayList;", "getHorizontalAxis", "()Z", "beforeAddLabel", "loc", "rotationDegree", "isHorizontal", "isRelevant", "isVertical", "plot-builder-portable"})
    private static final class TickLabelsCleaner {
        private final boolean horizontalAxis;
        @NotNull
        private final ArrayList<ClosedRange<Double>> filledRanges;

        public TickLabelsCleaner(boolean horizontalAxis) {
            this.horizontalAxis = horizontalAxis;
            this.filledRanges = new ArrayList();
        }

        public final boolean getHorizontalAxis() {
            return this.horizontalAxis;
        }

        public final boolean beforeAddLabel(double loc, double rotationDegree) {
            boolean bl;
            double len;
            block5: {
                if (!this.isRelevant(rotationDegree)) {
                    return true;
                }
                len = PlotLabelSpec.AXIS_TICK.height();
                Iterable $this$any$iv = this.filledRanges;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ClosedRange it = (ClosedRange)element$iv;
                        boolean bl2 = false;
                        if (!(it.contains(loc) || it.contains(loc + len))) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return false;
            }
            this.filledRanges.add(new ClosedRange<Comparable>(Double.valueOf(loc), Double.valueOf(loc + len)));
            return true;
        }

        private final boolean isRelevant(double rotationDegree) {
            return this.horizontalAxis ? this.isVertical(rotationDegree) : this.isHorizontal(rotationDegree);
        }

        private final boolean isHorizontal(double rotationDegree) {
            return rotationDegree % (double)180 == 0.0;
        }

        private final boolean isVertical(double rotationDegree) {
            return rotationDegree / (double)90 % (double)2 == 1.0;
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Orientation.values().length];
            nArray[Orientation.LEFT.ordinal()] = 1;
            nArray[Orientation.RIGHT.ordinal()] = 2;
            nArray[Orientation.TOP.ordinal()] = 3;
            nArray[Orientation.BOTTOM.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

