/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.geometry;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0000J\u000e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0000J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0006\u0010\u000f\u001a\u00020\u0000J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0006\u0010\u0012\u001a\u00020\u0003J\u000e\u0010\u0013\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0000J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0000J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0003J\u0006\u0010\u0017\u001a\u00020\u0000J\u0006\u0010\u0018\u001a\u00020\u0000J\u0006\u0010\u0019\u001a\u00020\u0000J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u0003J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0000J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006 "}, d2={"Ljetbrains/datalore/base/geometry/DoubleVector;", "", "x", "", "y", "(DD)V", "getX", "()D", "getY", "add", "v", "dotProduct", "equals", "", "other", "flip", "hashCode", "", "length", "max", "min", "mul", "value", "negate", "normalize", "orthogonal", "rotate", "phi", "subtract", "toString", "", "Companion", "base-portable"})
public final class DoubleVector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final double x;
    private final double y;
    @NotNull
    private static final DoubleVector ZERO = new DoubleVector(0.0, 0.0);

    public DoubleVector(double x2, double y2) {
        this.x = x2;
        this.y = y2;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    @NotNull
    public final DoubleVector add(@NotNull DoubleVector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new DoubleVector(this.x + v.x, this.y + v.y);
    }

    @NotNull
    public final DoubleVector subtract(@NotNull DoubleVector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return new DoubleVector(this.x - v.x, this.y - v.y);
    }

    @NotNull
    public final DoubleVector max(@NotNull DoubleVector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        double d = this.x;
        double d2 = v.x;
        boolean bl = false;
        double d3 = Math.max(d, d2);
        d = this.y;
        d2 = v.y;
        bl = false;
        return new DoubleVector(d3, Math.max(d, d2));
    }

    @NotNull
    public final DoubleVector min(@NotNull DoubleVector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        double d = this.x;
        double d2 = v.x;
        boolean bl = false;
        double d3 = Math.min(d, d2);
        d = this.y;
        d2 = v.y;
        bl = false;
        return new DoubleVector(d3, Math.min(d, d2));
    }

    @NotNull
    public final DoubleVector mul(double value) {
        return new DoubleVector(this.x * value, this.y * value);
    }

    public final double dotProduct(@NotNull DoubleVector v) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        return this.x * v.x + this.y * v.y;
    }

    @NotNull
    public final DoubleVector negate() {
        return new DoubleVector(-this.x, -this.y);
    }

    @NotNull
    public final DoubleVector orthogonal() {
        return new DoubleVector(-this.y, this.x);
    }

    public final double length() {
        double d = this.x * this.x + this.y * this.y;
        boolean bl = false;
        return Math.sqrt(d);
    }

    @NotNull
    public final DoubleVector normalize() {
        return this.mul(1.0 / this.length());
    }

    @NotNull
    public final DoubleVector rotate(double phi) {
        boolean bl = false;
        bl = false;
        double x2 = this.x * Math.cos(phi) - this.y * Math.sin(phi);
        boolean bl2 = false;
        bl2 = false;
        double y2 = this.x * Math.sin(phi) + this.y * Math.cos(phi);
        return new DoubleVector(x2, y2);
    }

    @NotNull
    public final DoubleVector flip() {
        return new DoubleVector(this.y, this.x);
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof DoubleVector)) {
            return false;
        }
        DoubleVector v = (DoubleVector)other;
        return v.x == this.x && v.y == this.y;
    }

    public int hashCode() {
        return Double.hashCode(this.x) + 31 * Double.hashCode(this.y);
    }

    @NotNull
    public String toString() {
        return "" + '(' + this.x + ", " + this.y + ')';
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ljetbrains/datalore/base/geometry/DoubleVector$Companion;", "", "()V", "ZERO", "Ljetbrains/datalore/base/geometry/DoubleVector;", "getZERO", "()Ljetbrains/datalore/base/geometry/DoubleVector;", "base-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DoubleVector getZERO() {
            return ZERO;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

