/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.dummy;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.testelement.AbstractTestElement;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class DummyElement
implements Serializable {
    private static final long serialVersionUID = 246L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    public static final String IS_SUCCESSFUL = "SUCCESFULL";
    public static final String RESPONSE_CODE = "RESPONSE_CODE";
    public static final String RESPONSE_MESSAGE = "RESPONSE_MESSAGE";
    public static final String RESPONSE_DATA = "RESPONSE_DATA";
    public static final String REQUEST_DATA = "REQUEST_DATA";
    public static final String RESPONSE_TIME = "RESPONSE_TIME";
    public static final String LATENCY = "LATENCY";
    public static final String CONNECT = "CONNECT";
    public static final String IS_WAITING = "WAITING";
    public static final String URL = "URL";
    public static final String RESULT_CLASS = "RESULT_CLASS";
    private AbstractTestElement model;

    public DummyElement(AbstractTestElement model) {
        this.model = model;
    }

    public SampleResult sample() {
        SampleResult res;
        try {
            res = this.createSample();
        }
        catch (ReflectiveOperationException ex) {
            res = new SampleResult();
            log.warn("Failed to create sample of desired type", (Throwable)ex);
        }
        res.setSampleLabel(this.model.getName());
        res.setSamplerData(this.getRequestData());
        res.setResponseCode(this.getResponseCode());
        res.setResponseMessage(this.getResponseMessage());
        res.setSuccessful(this.isSuccessfull());
        res.setDataType("text");
        try {
            res.setResponseData(this.getResponseData().getBytes(res.getDataEncodingWithDefault()));
        }
        catch (UnsupportedEncodingException exc) {
            log.warn("Failed to get response data", (Throwable)exc);
        }
        String url = this.getURL();
        if (!url.isEmpty()) {
            try {
                res.setURL(new URL(url));
            }
            catch (MalformedURLException ex) {
                log.debug("URL is wrong: " + url, (Throwable)ex);
            }
        }
        res.setLatency((long)this.getLatency());
        res.setConnectTime((long)this.getConnectTime());
        return res;
    }

    private SampleResult createSample() throws ReflectiveOperationException {
        Class<?> cls = Class.forName(this.getResultClass());
        SampleResult res = (SampleResult)cls.newInstance();
        if (this.isSimulateWaiting()) {
            res.sampleStart();
            try {
                Thread.sleep(this.getResponseTime());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            res.sampleEnd();
        } else {
            res.setStampAndTime(System.currentTimeMillis(), (long)this.getResponseTime());
        }
        return res;
    }

    public void setSuccessful(boolean selected) {
        this.setProperty(IS_SUCCESSFUL, selected);
    }

    public void setSimulateWaiting(boolean selected) {
        this.setProperty(IS_WAITING, selected);
    }

    public void setResponseCode(String text) {
        this.setProperty(RESPONSE_CODE, text);
    }

    public void setResponseMessage(String text) {
        this.setProperty(RESPONSE_MESSAGE, text);
    }

    public void setResponseData(String text) {
        this.setProperty(RESPONSE_DATA, text);
    }

    public void setRequestData(String text) {
        this.setProperty(REQUEST_DATA, text);
    }

    public void setURL(String text) {
        this.setProperty(URL, text);
    }

    public void setResultClass(String text) {
        this.setProperty(RESULT_CLASS, text);
    }

    public boolean isSuccessfull() {
        return this.getPropertyAsBoolean(IS_SUCCESSFUL);
    }

    public boolean isSimulateWaiting() {
        return this.getPropertyAsBoolean(IS_WAITING);
    }

    public String getResponseCode() {
        return this.getPropertyAsString(RESPONSE_CODE);
    }

    public String getResponseMessage() {
        return this.getPropertyAsString(RESPONSE_MESSAGE);
    }

    public String getResponseData() {
        return this.getPropertyAsString(RESPONSE_DATA);
    }

    public String getRequestData() {
        return this.getPropertyAsString(REQUEST_DATA);
    }

    public String getResultClass() {
        return this.getPropertyAsString(RESULT_CLASS, SampleResult.class.getCanonicalName());
    }

    public String getURL() {
        return this.getPropertyAsString(URL);
    }

    public int getResponseTime() {
        int time = 0;
        try {
            time = Integer.valueOf(this.getPropertyAsString(RESPONSE_TIME));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return time;
    }

    public int getLatency() {
        int time = 0;
        try {
            time = Integer.valueOf(this.getPropertyAsString(LATENCY));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return time;
    }

    public void setResponseTime(String time) {
        this.setProperty(RESPONSE_TIME, time);
    }

    public void setLatency(String time) {
        this.setProperty(LATENCY, time);
    }

    public void setConnectTime(String time) {
        this.setProperty(CONNECT, time);
    }

    public int getConnectTime() {
        int time = 0;
        try {
            time = Integer.valueOf(this.getPropertyAsString(CONNECT));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return time;
    }

    private void setProperty(String key, String val) {
        this.model.setProperty(key, val);
    }

    private void setProperty(String key, boolean val) {
        this.model.setProperty(key, val);
    }

    private String getPropertyAsString(String key) {
        return this.model.getPropertyAsString(key);
    }

    private String getPropertyAsString(String key, String vdefault) {
        return this.model.getPropertyAsString(key, vdefault);
    }

    private boolean getPropertyAsBoolean(String key) {
        return this.model.getPropertyAsBoolean(key);
    }
}

