/*
 * Decompiled with CFR 0.152.
 */
package jodd.props;

import jodd.props.PropsData;

public class PropsEntry {
    protected final String value;
    protected PropsEntry next;
    protected final String key;
    protected final String profile;
    protected final boolean hasMacro;
    protected final PropsData propsData;

    public PropsEntry(String key, String value, String profile, PropsData propsData) {
        this.value = value;
        this.key = key;
        this.profile = profile;
        this.hasMacro = value.contains("${");
        this.propsData = propsData;
    }

    public String getValue() {
        return this.value;
    }

    public String getValue(String ... profiles) {
        if (this.hasMacro) {
            return this.propsData.resolveMacros(this.value, profiles);
        }
        return this.value;
    }

    public String getKey() {
        return this.key;
    }

    public String getProfile() {
        return this.profile;
    }

    public boolean hasMacro() {
        return this.hasMacro;
    }

    public String toString() {
        return "PropsEntry{" + this.key + (this.profile != null ? '<' + this.profile + '>' : "") + '=' + this.value + '}';
    }
}

