/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.statistics;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.impl.CommonsHashMap;
import com.helger.commons.collection.impl.ICommonsMap;
import com.helger.commons.collection.impl.ICommonsSet;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.statistics.IMutableStatisticsHandlerCache;
import com.helger.commons.statistics.IMutableStatisticsHandlerCounter;
import com.helger.commons.statistics.IMutableStatisticsHandlerKeyedCounter;
import com.helger.commons.statistics.IMutableStatisticsHandlerKeyedSize;
import com.helger.commons.statistics.IMutableStatisticsHandlerKeyedTimer;
import com.helger.commons.statistics.IMutableStatisticsHandlerSize;
import com.helger.commons.statistics.IMutableStatisticsHandlerTimer;
import com.helger.commons.statistics.StatisticsHandlerCache;
import com.helger.commons.statistics.StatisticsHandlerCounter;
import com.helger.commons.statistics.StatisticsHandlerKeyedCounter;
import com.helger.commons.statistics.StatisticsHandlerKeyedSize;
import com.helger.commons.statistics.StatisticsHandlerKeyedTimer;
import com.helger.commons.statistics.StatisticsHandlerSize;
import com.helger.commons.statistics.StatisticsHandlerTimer;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class StatisticsManager {
    private static final SimpleReadWriteLock RWL_CACHE = new SimpleReadWriteLock();
    private static final SimpleReadWriteLock RWL_TIMER = new SimpleReadWriteLock();
    private static final SimpleReadWriteLock RWL_KEYED_TIMER = new SimpleReadWriteLock();
    private static final SimpleReadWriteLock RWL_SIZE = new SimpleReadWriteLock();
    private static final SimpleReadWriteLock RWL_KEYED_SIZE = new SimpleReadWriteLock();
    private static final SimpleReadWriteLock RWL_COUNTER = new SimpleReadWriteLock();
    private static final SimpleReadWriteLock RWL_KEYED_COUNTER = new SimpleReadWriteLock();
    private static final ICommonsMap<String, StatisticsHandlerCache> HDL_CACHE = new CommonsHashMap<String, StatisticsHandlerCache>();
    private static final ICommonsMap<String, StatisticsHandlerTimer> HDL_TIMER = new CommonsHashMap<String, StatisticsHandlerTimer>();
    private static final ICommonsMap<String, StatisticsHandlerKeyedTimer> HDL_KEYED_TIMER = new CommonsHashMap<String, StatisticsHandlerKeyedTimer>();
    private static final ICommonsMap<String, StatisticsHandlerSize> HDL_SIZE = new CommonsHashMap<String, StatisticsHandlerSize>();
    private static final ICommonsMap<String, StatisticsHandlerKeyedSize> HDL_KEYED_SIZE = new CommonsHashMap<String, StatisticsHandlerKeyedSize>();
    private static final ICommonsMap<String, StatisticsHandlerCounter> HDL_COUNTER = new CommonsHashMap<String, StatisticsHandlerCounter>();
    private static final ICommonsMap<String, StatisticsHandlerKeyedCounter> HDL_KEYED_COUNTER = new CommonsHashMap<String, StatisticsHandlerKeyedCounter>();
    private static final Logger LOGGER = LoggerFactory.getLogger(StatisticsManager.class);
    private static final StatisticsManager INSTANCE = new StatisticsManager();

    private StatisticsManager() {
    }

    @Nonnull
    public static IMutableStatisticsHandlerCache getCacheHandler(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "Class");
        return StatisticsManager.getCacheHandler(clazz.getName());
    }

    @Nonnull
    public static IMutableStatisticsHandlerCache getCacheHandler(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Name");
        StatisticsHandlerCache statisticsHandlerCache = RWL_CACHE.readLockedGet(() -> (StatisticsHandlerCache)HDL_CACHE.get(string));
        if (statisticsHandlerCache == null) {
            statisticsHandlerCache = RWL_CACHE.writeLockedGet(() -> HDL_CACHE.computeIfAbsent(string, string -> new StatisticsHandlerCache()));
        }
        return statisticsHandlerCache;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllCacheHandler() {
        return RWL_CACHE.readLockedGet(HDL_CACHE::copyOfKeySet);
    }

    @Nonnull
    public static IMutableStatisticsHandlerTimer getTimerHandler(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "Class");
        return StatisticsManager.getTimerHandler(clazz.getName());
    }

    @Nonnull
    public static IMutableStatisticsHandlerTimer getTimerHandler(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Name");
        StatisticsHandlerTimer statisticsHandlerTimer = RWL_TIMER.readLockedGet(() -> (StatisticsHandlerTimer)HDL_TIMER.get(string));
        if (statisticsHandlerTimer == null) {
            statisticsHandlerTimer = RWL_TIMER.writeLockedGet(() -> HDL_TIMER.computeIfAbsent(string, string -> new StatisticsHandlerTimer()));
        }
        return statisticsHandlerTimer;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllTimerHandler() {
        return RWL_TIMER.readLockedGet(HDL_TIMER::copyOfKeySet);
    }

    @Nonnull
    public static IMutableStatisticsHandlerKeyedTimer getKeyedTimerHandler(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "Class");
        return StatisticsManager.getKeyedTimerHandler(clazz.getName());
    }

    @Nonnull
    public static IMutableStatisticsHandlerKeyedTimer getKeyedTimerHandler(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Name");
        StatisticsHandlerKeyedTimer statisticsHandlerKeyedTimer = RWL_KEYED_TIMER.readLockedGet(() -> (StatisticsHandlerKeyedTimer)HDL_KEYED_TIMER.get(string));
        if (statisticsHandlerKeyedTimer == null) {
            statisticsHandlerKeyedTimer = RWL_KEYED_TIMER.writeLockedGet(() -> HDL_KEYED_TIMER.computeIfAbsent(string, string -> new StatisticsHandlerKeyedTimer()));
        }
        return statisticsHandlerKeyedTimer;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllKeyedTimerHandler() {
        return RWL_KEYED_TIMER.readLockedGet(HDL_KEYED_TIMER::copyOfKeySet);
    }

    @Nonnull
    public static IMutableStatisticsHandlerSize getSizeHandler(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "Class");
        return StatisticsManager.getSizeHandler(clazz.getName());
    }

    @Nonnull
    public static IMutableStatisticsHandlerSize getSizeHandler(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Name");
        StatisticsHandlerSize statisticsHandlerSize = RWL_SIZE.readLockedGet(() -> (StatisticsHandlerSize)HDL_SIZE.get(string));
        if (statisticsHandlerSize == null) {
            statisticsHandlerSize = RWL_SIZE.writeLockedGet(() -> HDL_SIZE.computeIfAbsent(string, string -> new StatisticsHandlerSize()));
        }
        return statisticsHandlerSize;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllSizeHandler() {
        return RWL_SIZE.readLockedGet(HDL_SIZE::copyOfKeySet);
    }

    @Nonnull
    public static IMutableStatisticsHandlerKeyedSize getKeyedSizeHandler(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "Class");
        return StatisticsManager.getKeyedSizeHandler(clazz.getName());
    }

    @Nonnull
    public static IMutableStatisticsHandlerKeyedSize getKeyedSizeHandler(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Name");
        StatisticsHandlerKeyedSize statisticsHandlerKeyedSize = RWL_KEYED_SIZE.readLockedGet(() -> (StatisticsHandlerKeyedSize)HDL_KEYED_SIZE.get(string));
        if (statisticsHandlerKeyedSize == null) {
            statisticsHandlerKeyedSize = RWL_KEYED_SIZE.writeLockedGet(() -> HDL_KEYED_SIZE.computeIfAbsent(string, string -> new StatisticsHandlerKeyedSize()));
        }
        return statisticsHandlerKeyedSize;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllKeyedSizeHandler() {
        return RWL_KEYED_SIZE.readLockedGet(HDL_KEYED_SIZE::copyOfKeySet);
    }

    @Nonnull
    public static IMutableStatisticsHandlerCounter getCounterHandler(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "Class");
        return StatisticsManager.getCounterHandler(clazz.getName());
    }

    @Nonnull
    public static IMutableStatisticsHandlerCounter getCounterHandler(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Name");
        StatisticsHandlerCounter statisticsHandlerCounter = RWL_COUNTER.readLockedGet(() -> (StatisticsHandlerCounter)HDL_COUNTER.get(string));
        if (statisticsHandlerCounter == null) {
            statisticsHandlerCounter = RWL_COUNTER.writeLockedGet(() -> HDL_COUNTER.computeIfAbsent(string, string -> new StatisticsHandlerCounter()));
        }
        return statisticsHandlerCounter;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllCounterHandler() {
        return RWL_COUNTER.readLockedGet(HDL_COUNTER::copyOfKeySet);
    }

    @Nonnull
    public static IMutableStatisticsHandlerKeyedCounter getKeyedCounterHandler(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "Class");
        return StatisticsManager.getKeyedCounterHandler(clazz.getName());
    }

    @Nonnull
    public static IMutableStatisticsHandlerKeyedCounter getKeyedCounterHandler(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Name");
        StatisticsHandlerKeyedCounter statisticsHandlerKeyedCounter = RWL_KEYED_COUNTER.readLockedGet(() -> (StatisticsHandlerKeyedCounter)HDL_KEYED_COUNTER.get(string));
        if (statisticsHandlerKeyedCounter == null) {
            statisticsHandlerKeyedCounter = RWL_KEYED_COUNTER.writeLockedGet(() -> HDL_KEYED_COUNTER.computeIfAbsent(string, string -> new StatisticsHandlerKeyedCounter()));
        }
        return statisticsHandlerKeyedCounter;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static ICommonsSet<String> getAllKeyedCounterHandler() {
        return RWL_KEYED_COUNTER.readLockedGet(HDL_KEYED_COUNTER::copyOfKeySet);
    }

    public static void clearCache() {
        RWL_CACHE.writeLocked(HDL_CACHE::clear);
        RWL_TIMER.writeLocked(HDL_TIMER::clear);
        RWL_KEYED_TIMER.writeLocked(HDL_KEYED_TIMER::clear);
        RWL_SIZE.writeLocked(HDL_SIZE::clear);
        RWL_KEYED_SIZE.writeLocked(HDL_KEYED_SIZE::clear);
        RWL_COUNTER.writeLocked(HDL_COUNTER::clear);
        RWL_KEYED_COUNTER.writeLocked(HDL_KEYED_COUNTER::clear);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Cache was cleared: " + StatisticsManager.class.getName());
        }
    }
}

