/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads;

import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.jmeter.engine.StandardJMeterEngine;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.threads.AbstractThreadGroup;
import org.apache.jmeter.threads.JMeterContextService;
import org.apache.jmeter.threads.JMeterThread;
import org.apache.jmeter.threads.JMeterVariables;
import org.apache.jmeter.util.JMeterUtils;

public class JMeterContext {
    private JMeterVariables variables;
    private SampleResult previousResult;
    private Sampler currentSampler;
    private Sampler previousSampler;
    private boolean samplingStarted;
    private StandardJMeterEngine engine;
    private JMeterThread thread;
    private AbstractThreadGroup threadGroup;
    private int threadNum;
    private TestLogicalAction testLogicalAction = TestLogicalAction.CONTINUE;
    private ConcurrentHashMap<String, Object> samplerContext = new ConcurrentHashMap(5);
    private boolean recording;

    JMeterContext() {
        this.clear0();
    }

    public void clear() {
        this.clear0();
    }

    private void clear0() {
        this.variables = null;
        this.previousResult = null;
        this.currentSampler = null;
        this.previousSampler = null;
        this.samplingStarted = false;
        this.threadNum = 0;
        this.thread = null;
        this.recording = false;
        this.samplerContext.clear();
    }

    public JMeterVariables getVariables() {
        return this.variables != null ? this.variables : JMeterContextService.getClientSideVariables();
    }

    public Properties getProperties() {
        return JMeterUtils.getJMeterProperties();
    }

    public void setVariables(JMeterVariables vars) {
        this.variables = vars;
    }

    public SampleResult getPreviousResult() {
        return this.previousResult;
    }

    public void setPreviousResult(SampleResult result) {
        this.previousResult = result;
    }

    public Sampler getCurrentSampler() {
        return this.currentSampler;
    }

    public void setCurrentSampler(Sampler sampler) {
        this.previousSampler = this.currentSampler;
        this.currentSampler = sampler;
    }

    public Sampler getPreviousSampler() {
        return this.previousSampler;
    }

    public int getThreadNum() {
        return this.threadNum;
    }

    public void setThreadNum(int threadNum) {
        this.threadNum = threadNum;
    }

    public JMeterThread getThread() {
        return this.thread;
    }

    public void setThread(JMeterThread thread) {
        this.thread = thread;
    }

    public AbstractThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    public void setThreadGroup(AbstractThreadGroup threadgrp) {
        this.threadGroup = threadgrp;
    }

    public StandardJMeterEngine getEngine() {
        return this.engine;
    }

    public void setEngine(StandardJMeterEngine engine) {
        this.engine = engine;
    }

    public boolean isSamplingStarted() {
        return this.samplingStarted;
    }

    public void setSamplingStarted(boolean b) {
        this.samplingStarted = b;
    }

    public void setTestLogicalAction(TestLogicalAction actionOnExecution) {
        this.testLogicalAction = actionOnExecution;
    }

    public TestLogicalAction getTestLogicalAction() {
        return this.testLogicalAction;
    }

    @Deprecated
    public void setStartNextThreadLoop(boolean restartNextLoop) {
        this.testLogicalAction = restartNextLoop ? TestLogicalAction.START_NEXT_ITERATION_OF_THREAD : TestLogicalAction.CONTINUE;
    }

    @Deprecated
    public boolean isStartNextThreadLoop() {
        return this.testLogicalAction == TestLogicalAction.START_NEXT_ITERATION_OF_THREAD;
    }

    @Deprecated
    public void setRestartNextLoop(boolean restartNextLoop) {
        this.setStartNextThreadLoop(restartNextLoop);
    }

    @Deprecated
    public boolean isRestartNextLoop() {
        return this.isStartNextThreadLoop();
    }

    public void cleanAfterSample() {
        if (this.previousResult != null) {
            this.previousResult.cleanAfterSample();
        }
        this.samplerContext.clear();
    }

    public Map<String, Object> getSamplerContext() {
        return this.samplerContext;
    }

    public void setRecording(boolean recording) {
        this.recording = recording;
    }

    public boolean isRecording() {
        return this.recording;
    }

    public static enum TestLogicalAction {
        CONTINUE,
        START_NEXT_ITERATION_OF_THREAD,
        START_NEXT_ITERATION_OF_CURRENT_LOOP,
        BREAK_CURRENT_LOOP;

    }
}

