/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import net.miginfocom.swing.MigLayout;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.NamePanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.Printable;
import org.apache.jorphan.gui.JFactory;
import org.apiguardian.api.API;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJMeterGuiComponent
extends JPanel
implements JMeterGUIComponent,
Printable {
    private static final long serialVersionUID = 241L;
    private static final Logger log = LoggerFactory.getLogger(AbstractJMeterGuiComponent.class);
    private boolean enabled = true;
    @API(status=API.Status.INTERNAL, since="5.2.0")
    @Deprecated
    protected NamePanel namePanel;
    private final JTextArea commentField = JFactory.tabMovesFocus((JTextArea)new JTextArea());

    protected AbstractJMeterGuiComponent() {
        this.namePanel = new NamePanel();
        this.init();
    }

    @Override
    public void setName(String name) {
        this.namePanel.setName(name);
    }

    public void setComment(String comment) {
        this.commentField.setText(comment);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void setEnabled(boolean enabled) {
        log.debug("Setting enabled: {}", (Object)enabled);
        this.enabled = enabled;
    }

    @Override
    public String getName() {
        NamePanel namePanel = this.getNamePanel();
        if (namePanel != null) {
            return namePanel.getName();
        }
        return "";
    }

    public String getComment() {
        return this.commentField.getText();
    }

    @API(status=API.Status.DEPRECATED, since="5.2.0")
    @Deprecated
    protected NamePanel getNamePanel() {
        return this.namePanel;
    }

    protected Component createTitleLabel() {
        return JFactory.big((JLabel)new JLabel(this.getStaticLabel()));
    }

    @Override
    public void configure(TestElement element) {
        this.setName(element.getName());
        this.enabled = element.isEnabled();
        this.commentField.setText(element.getComment());
    }

    @Override
    public void clearGui() {
        this.initGui();
        this.enabled = true;
    }

    private void initGui() {
        this.setName(this.getStaticLabel());
        this.commentField.setText("");
    }

    private void init() {
        this.initGui();
    }

    protected void configureTestElement(TestElement mc) {
        mc.setName(this.getName());
        mc.setProperty(new StringProperty("TestElement.gui_class", this.getClass().getName()));
        mc.setProperty(new StringProperty("TestElement.test_class", mc.getClass().getName()));
        log.debug("setting element to enabled: {}", (Object)this.enabled);
        mc.setEnabled(this.enabled);
        mc.setComment(this.getComment());
    }

    protected Container makeTitlePanel() {
        JPanel titlePanel = new JPanel((LayoutManager)new MigLayout("fillx, wrap 2, insets 0", "[][fill,grow]"));
        titlePanel.add(this.createTitleLabel(), "span 2");
        JTextField nameField = this.namePanel.getNameField();
        titlePanel.add(JMeterUtils.labelFor(nameField, "name"));
        titlePanel.add(nameField);
        titlePanel.add(JMeterUtils.labelFor(nameField, "testplan_comments"));
        this.commentField.setWrapStyleWord(true);
        this.commentField.setLineWrap(true);
        titlePanel.add(this.commentField);
        return this.wrapTitlePanel(titlePanel);
    }

    @API(status=API.Status.EXPERIMENTAL, since="5.2.0")
    protected Container wrapTitlePanel(Container titlePanel) {
        VerticalPanel vp = new VerticalPanel();
        vp.add(titlePanel);
        return vp;
    }

    protected Border makeBorder() {
        return BorderFactory.createEmptyBorder(10, 10, 5, 10);
    }

    protected JScrollPane makeScrollPane(Component comp) {
        JScrollPane pane = new JScrollPane(comp);
        pane.setPreferredSize(pane.getMinimumSize());
        return pane;
    }

    protected JScrollPane makeScrollPane(Component comp, int verticalPolicy, int horizontalPolicy) {
        JScrollPane pane = new JScrollPane(comp, verticalPolicy, horizontalPolicy);
        pane.setPreferredSize(pane.getMinimumSize());
        return pane;
    }

    @Override
    public String getStaticLabel() {
        return JMeterUtils.getResString(this.getLabelResource());
    }

    @Override
    public String getDocAnchor() {
        String label = JMeterUtils.getResString(this.getLabelResource(), new Locale("", ""));
        return label.replace(' ', '_');
    }

    @Override
    public JComponent getPrintableComponent() {
        return this;
    }
}

