/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.base.typedGeometry;

import java.util.ArrayList;
import java.util.List;
import jetbrains.datalore.base.typedGeometry.FunctionsKt;
import jetbrains.datalore.base.typedGeometry.Vec;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B-\u0012\u001e\u0010\u0004\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ,\u0010\u000b\u001a\u00020\b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u00062\n\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u00062\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J,\u0010\u000f\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006H\u0002J \u0010\u0012\u001a\u00020\b2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00062\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0006H\u0002J.\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u00142\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00062\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006J&\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\u00142\u0012\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00060\u0014J\u001d\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0002\u0010\u0017*\b\u0012\u0004\u0012\u0002H\u00170\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0004\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Ljetbrains/datalore/base/typedGeometry/AdaptiveResampling;", "InT", "OutT", "", "transform", "Lkotlin/Function1;", "Ljetbrains/datalore/base/typedGeometry/Vec;", "epsilon", "", "(Lkotlin/jvm/functions/Function1;D)V", "epsilonSqr", "distance", "p", "l1", "l2", "getSamplePoint", "p1", "p2", "length", "resample", "", "points", "pop", "T", "", "(Ljava/util/List;)Ljava/lang/Object;", "base-portable"})
public final class AdaptiveResampling<InT, OutT> {
    @NotNull
    private final Function1<Vec<InT>, Vec<OutT>> transform;
    private final double epsilonSqr;

    public AdaptiveResampling(@NotNull Function1<? super Vec<InT>, Vec<OutT>> transform2, double epsilon) {
        Intrinsics.checkNotNullParameter(transform2, (String)"transform");
        this.transform = transform2;
        this.epsilonSqr = epsilon * epsilon;
    }

    private final <T> T pop(List<T> $this$pop) {
        T t = $this$pop.get(CollectionsKt.getLastIndex($this$pop));
        boolean bl = false;
        boolean bl2 = false;
        T it = t;
        boolean bl3 = false;
        $this$pop.remove(CollectionsKt.getLastIndex($this$pop));
        return t;
    }

    @NotNull
    public final List<Vec<OutT>> resample(@NotNull List<Vec<InT>> points) {
        Intrinsics.checkNotNullParameter(points, (String)"points");
        ArrayList<Object> result = new ArrayList<Object>(points.size());
        int n = 1;
        int n2 = points.size();
        if (n < n2) {
            do {
                int i = n++;
                List<Vec<InT>> sample = this.resample(points.get(i - 1), points.get(i));
                if (!result.isEmpty()) {
                    this.pop((List)result);
                }
                Iterable $this$forEach$iv = sample;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Vec p = (Vec)element$iv;
                    boolean bl = false;
                    result.add(this.transform.invoke((Object)p));
                }
            } while (n < n2);
        }
        return result;
    }

    @NotNull
    public final List<Vec<InT>> resample(@NotNull Vec<InT> p1, @NotNull Vec<InT> p2) {
        Intrinsics.checkNotNullParameter(p1, (String)"p1");
        Intrinsics.checkNotNullParameter(p2, (String)"p2");
        ArrayList<Vec<Object>> result = new ArrayList<Vec<Object>>();
        ArrayList<Vec<InT>> candidates = new ArrayList<Vec<InT>>();
        result.add(p1);
        candidates.add(p2);
        while (!candidates.isEmpty()) {
            Vec<InT> samplePoint = this.getSamplePoint((Vec)CollectionsKt.last((List)result), (Vec)CollectionsKt.last((List)candidates));
            if (samplePoint == null) {
                result.add((Vec<Object>)this.pop((List)candidates));
                continue;
            }
            candidates.add(samplePoint);
        }
        return result;
    }

    private final Vec<InT> getSamplePoint(Vec<InT> p1, Vec<InT> p2) {
        Vec<InT> pc = FunctionsKt.div(FunctionsKt.plus(p1, p2), 2.0);
        Vec q1 = (Vec)this.transform.invoke(p1);
        Vec q2 = (Vec)this.transform.invoke(p2);
        Vec qc = (Vec)this.transform.invoke(pc);
        double distance = Intrinsics.areEqual((Object)q1, (Object)q2) ? this.length(q1, qc) : this.distance(qc, q1, q2);
        return distance < this.epsilonSqr ? null : pc;
    }

    private final double length(Vec<?> p1, Vec<?> p2) {
        double x2 = p2.getX() - p1.getX();
        double y2 = p2.getY() - p1.getY();
        return x2 * x2 + y2 * y2;
    }

    private final double distance(Vec<?> p, Vec<?> l1, Vec<?> l2) {
        double ortX = l2.getX() - l1.getX();
        double ortY = -(l2.getY() - l1.getY());
        double dot = (p.getX() - l1.getX()) * ortY + (p.getY() - l1.getY()) * ortX;
        double len = ortY * ortY + ortX * ortX;
        return dot * dot / len;
    }
}

