/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.builder.layout;

import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.builder.coord.CoordProvider;
import jetbrains.datalore.plot.builder.layout.PlotLayoutBase;
import jetbrains.datalore.plot.builder.layout.PlotLayoutInfo;
import jetbrains.datalore.plot.builder.layout.TileLayout;
import jetbrains.datalore.plot.builder.layout.TileLayoutInfo;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Ljetbrains/datalore/plot/builder/layout/SingleTilePlotLayout;", "Ljetbrains/datalore/plot/builder/layout/PlotLayoutBase;", "tileLayout", "Ljetbrains/datalore/plot/builder/layout/TileLayout;", "(Ljetbrains/datalore/plot/builder/layout/TileLayout;)V", "doLayout", "Ljetbrains/datalore/plot/builder/layout/PlotLayoutInfo;", "preferredSize", "Ljetbrains/datalore/base/geometry/DoubleVector;", "coordProvider", "Ljetbrains/datalore/plot/builder/coord/CoordProvider;", "plot-builder-portable"})
public final class SingleTilePlotLayout
extends PlotLayoutBase {
    @NotNull
    private final TileLayout tileLayout;

    public SingleTilePlotLayout(@NotNull TileLayout tileLayout) {
        Intrinsics.checkNotNullParameter((Object)tileLayout, (String)"tileLayout");
        this.tileLayout = tileLayout;
        this.setPadding(10.0, 10.0, 0.0, 0.0);
    }

    @Override
    @NotNull
    public PlotLayoutInfo doLayout(@NotNull DoubleVector preferredSize, @NotNull CoordProvider coordProvider) {
        Intrinsics.checkNotNullParameter((Object)preferredSize, (String)"preferredSize");
        Intrinsics.checkNotNullParameter((Object)coordProvider, (String)"coordProvider");
        DoubleVector paddingLeftTop = new DoubleVector(this.getPaddingLeft(), this.getPaddingTop());
        DoubleVector paddingRightBottom = new DoubleVector(this.getPaddingRight(), this.getPaddingBottom());
        DoubleVector tilePreferredSize = preferredSize.subtract(paddingLeftTop).subtract(paddingRightBottom);
        TileLayoutInfo tileInfo = this.tileLayout.doLayout(tilePreferredSize, coordProvider).withOffset(paddingLeftTop);
        DoubleVector plotSize = tileInfo.getBounds().getDimension().add(paddingLeftTop).add(paddingRightBottom);
        return new PlotLayoutInfo(CollectionsKt.listOf((Object)tileInfo), plotSize);
    }
}

