/*
 * Decompiled with CFR 0.152.
 */
package jodd.crypt;

import java.security.AlgorithmParameters;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import jodd.util.Base64;
import jodd.util.StringUtil;

public class PBKDF2Encryptor {
    protected final Cipher ecipher;
    protected final Cipher dcipher;
    protected final int iterationCount;

    public PBKDF2Encryptor(String passPhrase) {
        this(passPhrase, SecureRandom.getSeed(8), 65536, 256);
    }

    public PBKDF2Encryptor(String passPhrase, byte[] salt, int iterationCount, int i1) {
        this.iterationCount = iterationCount;
        try {
            PBEKeySpec keySpec = new PBEKeySpec(passPhrase.toCharArray(), salt, iterationCount, i1);
            SecretKey tmp = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256").generateSecret(keySpec);
            SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), "AES");
            this.ecipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            this.ecipher.init(1, secret);
            AlgorithmParameters params = this.ecipher.getParameters();
            byte[] iv = params.getParameterSpec(IvParameterSpec.class).getIV();
            this.dcipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            this.dcipher.init(2, (Key)secret, new IvParameterSpec(iv));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public String encrypt(String str) {
        try {
            byte[] utf8 = StringUtil.getBytes(str);
            byte[] enc = this.ecipher.doFinal(utf8);
            return Base64.encodeToString(enc);
        }
        catch (Throwable ignore) {
            return null;
        }
    }

    public byte[] encrypt(byte[] input) {
        try {
            return this.ecipher.doFinal(input);
        }
        catch (Throwable ignore) {
            return null;
        }
    }

    public String decrypt(String str) {
        try {
            str = StringUtil.replaceChar(str, ' ', '+');
            byte[] dec = Base64.decode(str);
            byte[] utf8 = this.dcipher.doFinal(dec);
            return new String(utf8, "UTF-8");
        }
        catch (Throwable ignore) {
            return null;
        }
    }

    public byte[] decrypt(byte[] bytes) {
        try {
            return this.dcipher.doFinal(bytes);
        }
        catch (Throwable ignore) {
            return null;
        }
    }
}

