/*
 * Decompiled with CFR 0.152.
 */
package jodd.cache;

import java.io.File;
import jodd.cache.Cache;
import jodd.cache.FileCache;
import jodd.cache.LRUCache;

public class FileLRUCache
extends FileCache {
    public FileLRUCache(int maxSize) {
        this(maxSize, maxSize / 2, 0L);
    }

    public FileLRUCache(int maxSize, int maxFileSize) {
        this(maxSize, maxFileSize, 0L);
    }

    public FileLRUCache(int maxSize, int maxFileSize, long timeout) {
        super(maxSize, maxFileSize, timeout);
    }

    @Override
    protected Cache<File, byte[]> createCache() {
        return new LRUCache<File, byte[]>(0, this.timeout){

            @Override
            public boolean isFull() {
                return FileLRUCache.this.usedSize > FileLRUCache.this.maxSize;
            }

            @Override
            protected boolean isReallyFull(File file) {
                return this.isFull();
            }

            @Override
            protected void onRemove(File key, byte[] cachedObject) {
                FileLRUCache.this.usedSize -= cachedObject.length;
            }
        };
    }
}

