/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.stat;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import jetbrains.datalore.base.gcommon.collect.ClosedRange;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.DataFrame;
import jetbrains.datalore.plot.base.StatContext;
import jetbrains.datalore.plot.base.data.TransformVar;
import jetbrains.datalore.plot.base.stat.BaseStat;
import jetbrains.datalore.plot.base.stat.DensityStatUtil;
import jetbrains.datalore.plot.base.stat.Stats;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u001e2\u00020\u0001:\u0003\u001d\u001e\u001fB7\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ;\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122!\u0010\u0013\u001a\u001d\u0012\u0013\u0012\u00110\u0015\u00a2\u0006\f\b\u0016\u0012\b\b\u0017\u0012\u0004\b\b(\u0018\u0012\u0004\u0012\u00020\u00190\u0014H\u0016J\u0012\u0010\u001a\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001c0\u001bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Ljetbrains/datalore/plot/base/stat/DensityStat;", "Ljetbrains/datalore/plot/base/stat/BaseStat;", "bandWidth", "", "bandWidthMethod", "Ljetbrains/datalore/plot/base/stat/DensityStat$BandWidthMethod;", "adjust", "kernel", "Ljetbrains/datalore/plot/base/stat/DensityStat$Kernel;", "n", "", "fullScalMax", "(Ljava/lang/Double;Ljetbrains/datalore/plot/base/stat/DensityStat$BandWidthMethod;DLjetbrains/datalore/plot/base/stat/DensityStat$Kernel;II)V", "Ljava/lang/Double;", "apply", "Ljetbrains/datalore/plot/base/DataFrame;", "data", "statCtx", "Ljetbrains/datalore/plot/base/StatContext;", "messageConsumer", "Lkotlin/Function1;", "", "Lkotlin/ParameterName;", "name", "s", "", "consumes", "", "Ljetbrains/datalore/plot/base/Aes;", "BandWidthMethod", "Companion", "Kernel", "plot-base-portable"})
public final class DensityStat
extends BaseStat {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Double bandWidth;
    @NotNull
    private final BandWidthMethod bandWidthMethod;
    private final double adjust;
    @NotNull
    private final Kernel kernel;
    private final int n;
    private final int fullScalMax;
    @NotNull
    private static final Kernel DEF_KERNEL = Kernel.GAUSSIAN;
    public static final double DEF_ADJUST = 1.0;
    public static final int DEF_N = 512;
    @NotNull
    private static final BandWidthMethod DEF_BW = BandWidthMethod.NRD0;
    public static final int DEF_FULL_SCAN_MAX = 5000;
    @NotNull
    private static final Map<Aes<?>, DataFrame.Variable> DEF_MAPPING;
    private static final int MAX_N = 1024;

    public DensityStat(@Nullable Double bandWidth, @NotNull BandWidthMethod bandWidthMethod, double adjust, @NotNull Kernel kernel2, int n, int fullScalMax) {
        Intrinsics.checkNotNullParameter((Object)((Object)bandWidthMethod), (String)"bandWidthMethod");
        Intrinsics.checkNotNullParameter((Object)((Object)kernel2), (String)"kernel");
        super(DEF_MAPPING);
        this.bandWidth = bandWidth;
        this.bandWidthMethod = bandWidthMethod;
        this.adjust = adjust;
        this.kernel = kernel2;
        this.n = n;
        this.fullScalMax = fullScalMax;
        boolean bl = this.n <= 1024;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "The input n = " + this.n + "  > 1024 is too large!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @Override
    @NotNull
    public List<Aes<?>> consumes() {
        Object[] objectArray = new Aes[]{Aes.Companion.getX(), Aes.Companion.getWEIGHT()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public DataFrame apply(@NotNull DataFrame data, @NotNull StatContext statCtx, @NotNull Function1<? super String, Unit> messageConsumer) {
        block13: {
            block12: {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                Intrinsics.checkNotNullParameter((Object)statCtx, (String)"statCtx");
                Intrinsics.checkNotNullParameter(messageConsumer, (String)"messageConsumer");
                var4_4 = new Aes[]{Aes.Companion.getX()};
                if (!this.hasRequiredValues(data, var4_4)) {
                    return this.withEmptyStatValues();
                }
                xs = null;
                weights = null;
                if (!data.has(TransformVar.INSTANCE.getWEIGHT())) break block12;
                filtered = SeriesUtil.INSTANCE.filterFinite(data.getNumeric(TransformVar.INSTANCE.getX()), data.getNumeric(TransformVar.INSTANCE.getWEIGHT()));
                xsFiltered = (List)filtered.get(0);
                weightsFiltered = (List)filtered.get(1);
                $this$sortedBy$iv = CollectionsKt.zip((Iterable)xsFiltered, (Iterable)weightsFiltered);
                $i$f$sortedBy = false;
                var12_22 = 0;
                var9_24 = CollectionsKt.unzip((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        boolean bl = false;
                        Pair it = (Pair)a;
                        boolean bl2 = false;
                        Comparable comparable = (Double)it.getFirst();
                        it = (Pair)b;
                        Comparable comparable2 = comparable;
                        bl2 = false;
                        Double d = (Double)it.getFirst();
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)d);
                    }
                }));
                xsSorted = (List)var9_24.component1();
                weightsSorted = (List)var9_24.component2();
                xs = xsSorted;
                weights = weightsSorted;
                break block13;
            }
            $this$filter$iv = CollectionsKt.filterNotNull((Iterable)data.getNumeric(TransformVar.INSTANCE.getX()));
            $i$f$filter = false;
            weightsFiltered = $this$filter$iv;
            destination$iv$iv = (ArrayList<Object>)new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = ((Number)element$iv$iv).doubleValue();
                $i$a$-filter-DensityStat$apply$2 = 0;
                var16_30 = it;
                var18_32 = false;
                var19_34 = var16_30;
                var21_36 = false;
                if (Double.isInfinite(var19_34)) ** GOTO lbl-1000
                var19_34 = var16_30;
                var21_36 = false;
                if (!Double.isNaN(var19_34)) {
                    v0 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v0 = false;
                }
                if (!v0) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            xs = CollectionsKt.sorted((Iterable)destination$iv$iv);
            $this$filter$iv = xs.size();
            $i$f$filter = false;
            $this$filterTo$iv$iv = false;
            destination$iv$iv = new ArrayList<Object>($this$filter$iv);
            $i$f$filterTo = false;
            weightsSorted = 0;
            weightsSorted = 0;
            var12_22 = $this$filter$iv;
            while (weightsSorted < var12_22) {
                it = weightsSorted++;
                var14_37 = false;
                $i$a$-filter-DensityStat$apply$2 = it;
                var22_39 = destination$iv$iv;
                $i$a$-List-DensityStat$apply$3 = false;
                var23_40 = 1.0;
                var22_39.add(var23_40);
            }
            weights = destination$iv$iv;
        }
        if (xs.isEmpty()) {
            return this.withEmptyStatValues();
        }
        $i$f$filter = statCtx.overallXRange();
        rangeX = $i$f$filter == null ? new ClosedRange((Comparable)Double.valueOf(-0.5), (Comparable)Double.valueOf(0.5)) : $i$f$filter;
        statX = DensityStatUtil.INSTANCE.createStepValues((ClosedRange<Double>)rangeX, this.n);
        statDensity = new ArrayList<Double>();
        statCount = new ArrayList<Double>();
        statScaled = new ArrayList<Double>();
        it = this.bandWidth;
        bandWidth = it == null ? DensityStatUtil.INSTANCE.bandWidth(this.bandWidthMethod, xs) : it.doubleValue();
        kernelFun = DensityStatUtil.INSTANCE.kernel(this.kernel);
        v1 = it = xs.size() <= this.fullScalMax;
        if (it) {
            v2 = DensityStatUtil.INSTANCE.densityFunctionFullScan$plot_base_portable(xs, weights, kernelFun, bandWidth, this.adjust);
        } else if (!it) {
            v2 = DensityStatUtil.INSTANCE.densityFunctionFast$plot_base_portable(xs, weights, kernelFun, bandWidth, this.adjust);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        densityFunction = v2;
        nTotal = CollectionsKt.sumOfDouble((Iterable)weights);
        var17_41 = statX.iterator();
        while (var17_41.hasNext()) {
            x = ((Number)var17_41.next()).doubleValue();
            d = ((Number)densityFunction.invoke((Object)x)).doubleValue();
            statCount.add(d);
            statDensity.add(d / nTotal);
        }
        v3 = CollectionsKt.maxOrNull((Iterable)statCount);
        Intrinsics.checkNotNull((Object)v3);
        maxm = v3;
        for (Double d : statCount) {
            statScaled.add(d / maxm);
        }
        return new DataFrame.Builder().putNumeric(Stats.INSTANCE.getX(), statX).putNumeric(Stats.INSTANCE.getDENSITY(), (List<Double>)statDensity).putNumeric(Stats.INSTANCE.getCOUNT(), (List<Double>)statCount).putNumeric(Stats.INSTANCE.getSCALED(), (List<Double>)statScaled).build();
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(Aes.Companion.getX(), (Object)Stats.INSTANCE.getX()), TuplesKt.to(Aes.Companion.getY(), (Object)Stats.INSTANCE.getDENSITY())};
        DEF_MAPPING = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Ljetbrains/datalore/plot/base/stat/DensityStat$Kernel;", "", "(Ljava/lang/String;I)V", "GAUSSIAN", "RECTANGULAR", "TRIANGULAR", "BIWEIGHT", "EPANECHNIKOV", "OPTCOSINE", "COSINE", "plot-base-portable"})
    public static final class Kernel
    extends Enum<Kernel> {
        public static final /* enum */ Kernel GAUSSIAN = new Kernel();
        public static final /* enum */ Kernel RECTANGULAR = new Kernel();
        public static final /* enum */ Kernel TRIANGULAR = new Kernel();
        public static final /* enum */ Kernel BIWEIGHT = new Kernel();
        public static final /* enum */ Kernel EPANECHNIKOV = new Kernel();
        public static final /* enum */ Kernel OPTCOSINE = new Kernel();
        public static final /* enum */ Kernel COSINE = new Kernel();
        private static final /* synthetic */ Kernel[] $VALUES;

        public static Kernel[] values() {
            return (Kernel[])$VALUES.clone();
        }

        public static Kernel valueOf(String value) {
            return Enum.valueOf(Kernel.class, value);
        }

        static {
            $VALUES = kernelArray = new Kernel[]{Kernel.GAUSSIAN, Kernel.RECTANGULAR, Kernel.TRIANGULAR, Kernel.BIWEIGHT, Kernel.EPANECHNIKOV, Kernel.OPTCOSINE, Kernel.COSINE};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Ljetbrains/datalore/plot/base/stat/DensityStat$BandWidthMethod;", "", "(Ljava/lang/String;I)V", "NRD0", "NRD", "plot-base-portable"})
    public static final class BandWidthMethod
    extends Enum<BandWidthMethod> {
        public static final /* enum */ BandWidthMethod NRD0 = new BandWidthMethod();
        public static final /* enum */ BandWidthMethod NRD = new BandWidthMethod();
        private static final /* synthetic */ BandWidthMethod[] $VALUES;

        public static BandWidthMethod[] values() {
            return (BandWidthMethod[])$VALUES.clone();
        }

        public static BandWidthMethod valueOf(String value) {
            return Enum.valueOf(BandWidthMethod.class, value);
        }

        static {
            $VALUES = bandWidthMethodArray = new BandWidthMethod[]{BandWidthMethod.NRD0, BandWidthMethod.NRD};
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Ljetbrains/datalore/plot/base/stat/DensityStat$Companion;", "", "()V", "DEF_ADJUST", "", "DEF_BW", "Ljetbrains/datalore/plot/base/stat/DensityStat$BandWidthMethod;", "getDEF_BW", "()Ljetbrains/datalore/plot/base/stat/DensityStat$BandWidthMethod;", "DEF_FULL_SCAN_MAX", "", "DEF_KERNEL", "Ljetbrains/datalore/plot/base/stat/DensityStat$Kernel;", "getDEF_KERNEL", "()Ljetbrains/datalore/plot/base/stat/DensityStat$Kernel;", "DEF_MAPPING", "", "Ljetbrains/datalore/plot/base/Aes;", "Ljetbrains/datalore/plot/base/DataFrame$Variable;", "DEF_N", "MAX_N", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Kernel getDEF_KERNEL() {
            return DEF_KERNEL;
        }

        @NotNull
        public final BandWidthMethod getDEF_BW() {
            return DEF_BW;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

