/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.pos;

import java.util.HashMap;
import java.util.Map;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.Aes;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.pos.PositionAdjustments;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000b\u00a8\u0006\u0015"}, d2={"Ljetbrains/datalore/plot/base/pos/DodgePos;", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "myGroupCount", "", "myWidth", "", "(Ljetbrains/datalore/plot/base/Aesthetics;ILjava/lang/Double;)V", "myDodgingNeeded", "", "Ljava/lang/Double;", "handlesGroups", "isDodgingNeeded", "translate", "Ljetbrains/datalore/base/geometry/DoubleVector;", "v", "p", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "plot-base-portable"})
public final class DodgePos
implements PositionAdjustment {
    private final int myGroupCount;
    @Nullable
    private final Double myWidth;
    private final boolean myDodgingNeeded;

    public DodgePos(@NotNull Aesthetics aesthetics, int myGroupCount, @Nullable Double myWidth) {
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        this.myGroupCount = myGroupCount;
        this.myWidth = myWidth;
        this.myDodgingNeeded = this.isDodgingNeeded(aesthetics);
    }

    private final boolean isDodgingNeeded(Aesthetics aesthetics) {
        HashMap groupByX = new HashMap();
        int n = 0;
        int n2 = aesthetics.dataPointCount();
        if (n < n2) {
            do {
                int i;
                DataPointAesthetics p;
                if (!(p = aesthetics.dataPointAt(i = n++)).defined(Aes.Companion.getX())) continue;
                Double d = p.x();
                Intrinsics.checkNotNull((Object)d);
                double x = d;
                Integer group = p.group();
                if (groupByX.containsKey(x)) {
                    if (Intrinsics.areEqual(groupByX.get(x), (Object)group)) continue;
                    return true;
                }
                Map map = groupByX;
                Double d2 = x;
                boolean bl = false;
                map.put(d2, group);
            } while (n < n2);
        }
        return false;
    }

    @Override
    @NotNull
    public DoubleVector translate(@NotNull DoubleVector v, @NotNull DataPointAesthetics p, @NotNull GeomContext ctx) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        if (this.myDodgingNeeded) {
            Double width2;
            double dataResolution = ctx.getResolution(Aes.Companion.getX());
            Double d = this.myWidth;
            Double d2 = width2 = d == null ? p.width() : d;
            if (!SeriesUtil.INSTANCE.isFinite(width2)) {
                return v;
            }
            Integer n = p.group();
            Intrinsics.checkNotNull((Object)n);
            int slotIndex = n;
            double median = (double)(this.myGroupCount - 1) / 2.0;
            double d3 = ((double)slotIndex - median) * dataResolution;
            Double d4 = width2;
            Intrinsics.checkNotNull((Object)d4);
            double xOffset = d3 * d4;
            Double d5 = p.x();
            Intrinsics.checkNotNull((Object)d5);
            double xCenter = d5;
            double xScaler = 1.0 / (double)this.myGroupCount;
            double newX = (v.getX() + xOffset - xCenter) * xScaler + xCenter;
            return new DoubleVector(newX, v.getY());
        }
        return v;
    }

    @Override
    public boolean handlesGroups() {
        return PositionAdjustments.Meta.DODGE.handlesGroups();
    }

    @Override
    public boolean isIdentity() {
        return PositionAdjustment.DefaultImpls.isIdentity(this);
    }
}

