/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.datalore.plot.base.geom;

import java.util.List;
import jetbrains.datalore.base.geometry.DoubleRectangle;
import jetbrains.datalore.base.geometry.DoubleVector;
import jetbrains.datalore.plot.base.Aesthetics;
import jetbrains.datalore.plot.base.CoordinateSystem;
import jetbrains.datalore.plot.base.DataPointAesthetics;
import jetbrains.datalore.plot.base.GeomContext;
import jetbrains.datalore.plot.base.PositionAdjustment;
import jetbrains.datalore.plot.base.geom.BarGeom;
import jetbrains.datalore.plot.base.geom.GeomBase;
import jetbrains.datalore.plot.base.geom.util.BarTooltipHelper;
import jetbrains.datalore.plot.base.geom.util.GeomUtil;
import jetbrains.datalore.plot.base.geom.util.RectanglesHelper;
import jetbrains.datalore.plot.base.render.SvgRoot;
import jetbrains.datalore.plot.common.data.SeriesUtil;
import jetbrains.datalore.vis.svg.SvgNode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014\u00a8\u0006\u0010"}, d2={"Ljetbrains/datalore/plot/base/geom/BarGeom;", "Ljetbrains/datalore/plot/base/geom/GeomBase;", "()V", "buildIntern", "", "root", "Ljetbrains/datalore/plot/base/render/SvgRoot;", "aesthetics", "Ljetbrains/datalore/plot/base/Aesthetics;", "pos", "Ljetbrains/datalore/plot/base/PositionAdjustment;", "coord", "Ljetbrains/datalore/plot/base/CoordinateSystem;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "Companion", "plot-base-portable"})
public class BarGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final boolean HANDLES_GROUPS = false;

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)aesthetics, (String)"aesthetics");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        RectanglesHelper helper = new RectanglesHelper(aesthetics, pos, coord, ctx);
        List<SvgNode> rectangles = helper.createRectangles((Function1<? super DataPointAesthetics, DoubleRectangle>)BarGeom.Companion.rectangleByDataPoint(ctx, false));
        CollectionsKt.reverse(rectangles);
        Iterable $this$forEach$iv = rectangles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SvgNode it = (SvgNode)element$iv;
            boolean bl = false;
            root.add(it);
        }
        BarTooltipHelper.collectRectangleTargets$default(BarTooltipHelper.INSTANCE, CollectionsKt.emptyList(), aesthetics, pos, coord, ctx, BarGeom.Companion.rectangleByDataPoint(ctx, true), buildIntern.2.INSTANCE, null, 128, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Ljetbrains/datalore/plot/base/geom/BarGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "rectangleByDataPoint", "Lkotlin/Function1;", "Ljetbrains/datalore/plot/base/DataPointAesthetics;", "Ljetbrains/datalore/base/geometry/DoubleRectangle;", "ctx", "Ljetbrains/datalore/plot/base/GeomContext;", "isHintRect", "plot-base-portable"})
    public static final class Companion {
        private Companion() {
        }

        private final Function1<DataPointAesthetics, DoubleRectangle> rectangleByDataPoint(GeomContext ctx, boolean isHintRect) {
            return (Function1)new Function1<DataPointAesthetics, DoubleRectangle>(isHintRect, ctx){
                final /* synthetic */ boolean $isHintRect;
                final /* synthetic */ GeomContext $ctx;
                {
                    this.$isHintRect = $isHintRect;
                    this.$ctx = $ctx;
                    super(1);
                }

                @Nullable
                public final DoubleRectangle invoke(@NotNull DataPointAesthetics p) {
                    DoubleRectangle doubleRectangle;
                    Intrinsics.checkNotNullParameter((Object)p, (String)"p");
                    Double x = p.x();
                    Double y = p.y();
                    Double w = p.width();
                    if (!SeriesUtil.INSTANCE.allFinite(x, y, w)) {
                        doubleRectangle = null;
                    } else if (this.$isHintRect) {
                        double width2 = GeomUtil.INSTANCE.widthPx(p, this.$ctx, 2.0);
                        Double d = x;
                        Intrinsics.checkNotNull((Object)d);
                        double d2 = d - width2 / (double)2;
                        Double d3 = y;
                        Intrinsics.checkNotNull((Object)d3);
                        DoubleVector origin = new DoubleVector(d2, d3.doubleValue());
                        DoubleVector dimension = new DoubleVector(width2, 0.0);
                        doubleRectangle = new DoubleRectangle(origin, dimension);
                    } else {
                        doubleRectangle = GeomUtil.INSTANCE.rectangleByDataPoint(p, this.$ctx);
                    }
                    return doubleRectangle;
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

