/*
 * Decompiled with CFR 0.152.
 */
package kg.apc.jmeter.threads;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import kg.apc.jmeter.JMeterPluginsUtils;
import kg.apc.jmeter.threads.AbstractSimpleThreadGroup;
import kg.apc.jmeter.threads.UltimateThreadGroupGui;
import org.apache.jmeter.gui.util.PowerTableModel;
import org.apache.jmeter.testelement.TestStateListener;
import org.apache.jmeter.testelement.property.CollectionProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.NullProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.threads.JMeterThread;
import org.apache.jmeter.util.JMeterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UltimateThreadGroup
extends AbstractSimpleThreadGroup
implements Serializable,
TestStateListener {
    private static final Logger log = LoggerFactory.getLogger(UltimateThreadGroup.class);
    public static final String DATA_PROPERTY = "ultimatethreadgroupdata";
    public static final String EXTERNAL_DATA_PROPERTY = "threads_schedule";
    public static final int START_THREADS_CNT_FIELD_NO = 0;
    public static final int INIT_DELAY_FIELD_NO = 1;
    public static final int STARTUP_TIME_FIELD_NO = 2;
    public static final int HOLD_LOAD_FOR_FIELD_NO = 3;
    public static final int SHUTDOWN_TIME_FIELD_NO = 4;
    private PropertyIterator scheduleIT;
    private int threadsToSchedule;
    private CollectionProperty currentRecord;

    @Override
    protected void scheduleThread(JMeterThread thread, long tgStartTime) {
        log.debug("Scheduling thread: " + thread.getThreadName());
        if (this.threadsToSchedule < 1) {
            if (!this.scheduleIT.hasNext()) {
                throw new RuntimeException("Not enough schedule records for thread #" + thread.getThreadName());
            }
            this.currentRecord = (CollectionProperty)this.scheduleIT.next();
            this.threadsToSchedule = this.currentRecord.get(0).getIntValue();
        }
        int numThreads = this.currentRecord.get(0).getIntValue();
        int initialDelay = this.currentRecord.get(1).getIntValue();
        int startRampUp = this.currentRecord.get(2).getIntValue();
        int flightTime = this.currentRecord.get(3).getIntValue();
        int endRampUp = this.currentRecord.get(4).getIntValue();
        long ascentPoint = tgStartTime + (long)(1000 * initialDelay);
        int rampUpDelayForThread = (int)Math.floor((double)(1000 * startRampUp) * (double)this.threadsToSchedule / (double)numThreads);
        long startTime = ascentPoint + (long)rampUpDelayForThread;
        long descentPoint = startTime + (long)(1000 * flightTime) + (long)(1000 * startRampUp) - (long)rampUpDelayForThread;
        thread.setStartTime(startTime);
        thread.setEndTime(descentPoint + (long)((int)Math.floor((double)(1000 * endRampUp) * (double)this.threadsToSchedule / (double)numThreads)));
        thread.setScheduled(true);
        --this.threadsToSchedule;
    }

    public JMeterProperty getData() {
        CollectionProperty overrideProp;
        JMeterProperty brokenProp = this.getProperty(EXTERNAL_DATA_PROPERTY);
        JMeterProperty usualProp = this.getProperty(DATA_PROPERTY);
        if (brokenProp instanceof CollectionProperty) {
            if (usualProp == null || usualProp instanceof NullProperty) {
                log.warn("Copying 'threads_schedule' into 'ultimatethreadgroupdata'");
                JMeterProperty newProp = brokenProp.clone();
                newProp.setName(DATA_PROPERTY);
                this.setProperty(newProp);
            }
            log.warn("Removing property 'threads_schedule' as invalid");
            this.removeProperty(EXTERNAL_DATA_PROPERTY);
        }
        if ((overrideProp = this.getLoadFromExternalProperty()) != null) {
            return overrideProp;
        }
        return this.getProperty(DATA_PROPERTY);
    }

    public void setData(CollectionProperty rows) {
        this.setProperty((JMeterProperty)rows);
    }

    private CollectionProperty getLoadFromExternalProperty() {
        String loadProp = JMeterUtils.getProperty((String)EXTERNAL_DATA_PROPERTY);
        log.debug("Profile prop: " + loadProp);
        if (loadProp != null && loadProp.length() > 0) {
            String[] chunks;
            log.info("GUI threads profile will be ignored");
            PowerTableModel dataModel = new PowerTableModel(UltimateThreadGroupGui.columnIdentifiers, UltimateThreadGroupGui.columnClasses);
            for (String chunk : chunks = loadProp.split("\\)")) {
                try {
                    UltimateThreadGroup.parseChunk(chunk, dataModel);
                }
                catch (RuntimeException e) {
                    log.warn("Wrong  chunk ignored: " + chunk, (Throwable)e);
                }
            }
            log.info("Setting threads profile from property threads_schedule: " + loadProp);
            return JMeterPluginsUtils.tableModelRowsToCollectionProperty((PowerTableModel)dataModel, (String)DATA_PROPERTY);
        }
        return null;
    }

    private static void parseChunk(String chunk, PowerTableModel model) {
        log.debug("Parsing chunk: " + chunk);
        String[] parts = chunk.split("[(,]");
        String loadVar = parts[0].trim();
        if (!loadVar.equalsIgnoreCase("spawn")) {
            throw new RuntimeException("Unknown load type: " + parts[0]);
        }
        Object[] row = new Integer[]{Integer.parseInt(parts[1].trim()), JMeterPluginsUtils.getSecondsForShortString((String)parts[2]), JMeterPluginsUtils.getSecondsForShortString((String)parts[3]), JMeterPluginsUtils.getSecondsForShortString((String)parts[4]), JMeterPluginsUtils.getSecondsForShortString((String)parts[5])};
        model.addRow(row);
    }

    public int getNumThreads() {
        int result = 0;
        JMeterProperty threadValues = this.getData();
        if (!(threadValues instanceof NullProperty)) {
            CollectionProperty columns = (CollectionProperty)threadValues;
            List rows = (List)columns.getObjectValue();
            for (Object row1 : rows) {
                CollectionProperty prop = (CollectionProperty)row1;
                ArrayList row = (ArrayList)prop.getObjectValue();
                result += ((JMeterProperty)row.get(0)).getIntValue();
            }
        }
        return result;
    }

    public void testStarted() {
        JMeterProperty data = this.getData();
        if (!(data instanceof NullProperty)) {
            this.scheduleIT = ((CollectionProperty)data).iterator();
        }
        this.threadsToSchedule = 0;
    }

    public void testStarted(String host) {
        this.testStarted();
    }

    public void testEnded() {
    }

    public void testEnded(String host) {
        this.testEnded();
    }
}

