"""Minecraft items."""

from enum import Enum


__all__ = ['Item']


# pylint: disable=C0302
class Item(Enum):
    """Minecraft items."""

    ACACIA_BARK = 'minecraft:acacia_bark'
    ACACIA_BOAT = 'minecraft:acacia_boat'
    ACACIA_BUTTON = 'minecraft:acacia_button'
    ACACIA_DOOR = 'minecraft:acacia_door'
    ACACIA_FENCE = 'minecraft:acacia_fence'
    ACACIA_FENCE_GATE = 'minecraft:acacia_fence_gate'
    ACACIA_LEAVES = 'minecraft:acacia_leaves'
    ACACIA_LOG = 'minecraft:acacia_log'
    ACACIA_PLANKS = 'minecraft:acacia_planks'
    ACACIA_PRESSURE_PLATE = 'minecraft:acacia_pressure_plate'
    ACACIA_SAPLING = 'minecraft:acacia_sapling'
    ACACIA_SIGN = 'minecraft:acacia_sign'
    ACACIA_SLAB = 'minecraft:acacia_slab'
    ACACIA_STAIRS = 'minecraft:acacia_stairs'
    ACACIA_TRAPDOOR = 'minecraft:acacia_trapdoor'
    ACACIA_WALL_SIGN = 'minecraft:acacia_wall_sign'
    ACACIA_WOOD = 'minecraft:acacia_wood'
    ACTIVATOR_RAIL = 'minecraft:activator_rail'
    AIR = 'minecraft:air'
    ALLIUM = 'minecraft:allium'
    ANCIENT_DEBRIS = 'minecraft:ancient_debris'
    ANDESITE = 'minecraft:andesite'
    ANDESITE_SLAB = 'minecraft:andesite_slab'
    ANDESITE_STAIRS = 'minecraft:andesite_stairs'
    ANDESITE_WALL = 'minecraft:andesite_wall'
    ANVIL = 'minecraft:anvil'
    APPLE = 'minecraft:apple'
    ARMOR_STAND = 'minecraft:armor_stand'
    ARROW = 'minecraft:arrow'
    ATTACHED_MELON_STEM = 'minecraft:attached_melon_stem'
    ATTACHED_PUMPKIN_STEM = 'minecraft:attached_pumpkin_stem'
    AZURE_BLUET = 'minecraft:azure_bluet'
    BAKED_POTATO = 'minecraft:baked_potato'
    BAMBOO = 'minecraft:bamboo'
    BAMBOO_SAPLING = 'minecraft:bamboo_sapling'
    BANNER = 'minecraft:banner'
    BARREL = 'minecraft:barrel'
    BARRIER = 'minecraft:barrier'
    BASALT = 'minecraft:basalt'
    BAT_SPAWN_EGG = 'minecraft:bat_spawn_egg'
    BEACON = 'minecraft:beacon'
    BED = 'minecraft:bed'
    BEDROCK = 'minecraft:bedrock'
    BEEF = 'minecraft:beef'
    BEEHIVE = 'minecraft:beehive'
    BEETROOT = 'minecraft:beetroot'
    BEETROOTS = 'minecraft:beetroots'
    BEETROOT_SEEDS = 'minecraft:beetroot_seeds'
    BEETROOT_SOUP = 'minecraft:beetroot_soup'
    BEE_NEST = 'minecraft:bee_nest'
    BEE_SPAWN_EGG = 'minecraft:bee_spawn_egg'
    BELL = 'minecraft:bell'
    BIRCH_BARK = 'minecraft:birch_bark'
    BIRCH_BOAT = 'minecraft:birch_boat'
    BIRCH_BUTTON = 'minecraft:birch_button'
    BIRCH_DOOR = 'minecraft:birch_door'
    BIRCH_FENCE = 'minecraft:birch_fence'
    BIRCH_FENCE_GATE = 'minecraft:birch_fence_gate'
    BIRCH_LEAVES = 'minecraft:birch_leaves'
    BIRCH_LOG = 'minecraft:birch_log'
    BIRCH_PLANKS = 'minecraft:birch_planks'
    BIRCH_PRESSURE_PLATE = 'minecraft:birch_pressure_plate'
    BIRCH_SAPLING = 'minecraft:birch_sapling'
    BIRCH_SIGN = 'minecraft:birch_sign'
    BIRCH_SLAB = 'minecraft:birch_slab'
    BIRCH_STAIRS = 'minecraft:birch_stairs'
    BIRCH_TRAPDOOR = 'minecraft:birch_trapdoor'
    BIRCH_WALL_SIGN = 'minecraft:birch_wall_sign'
    BIRCH_WOOD = 'minecraft:birch_wood'
    BLACKSTONE = 'minecraft:blackstone'
    BLACKSTONE_SLAB = 'minecraft:blackstone_slab'
    BLACKSTONE_STAIRS = 'minecraft:blackstone_stairs'
    BLACKSTONE_WALL = 'minecraft:blackstone_wall'
    BLACK_BANNER = 'minecraft:black_banner'
    BLACK_BED = 'minecraft:black_bed'
    BLACK_CARPET = 'minecraft:black_carpet'
    BLACK_CONCRETE = 'minecraft:black_concrete'
    BLACK_CONCRETE_POWDER = 'minecraft:black_concrete_powder'
    BLACK_DYE = 'minecraft:black_dye'
    BLACK_GLAZED_TERRACOTTA = 'minecraft:black_glazed_terracotta'
    BLACK_SHULKER_BOX = 'minecraft:black_shulker_box'
    BLACK_STAINED_GLASS = 'minecraft:black_stained_glass'
    BLACK_STAINED_GLASS_PANE = 'minecraft:black_stained_glass_pane'
    BLACK_TERRACOTTA = 'minecraft:black_terracotta'
    BLACK_WALL_BANNER = 'minecraft:black_wall_banner'
    BLACK_WOOL = 'minecraft:black_wool'
    BLAST_FURNACE = 'minecraft:blast_furnace'
    BLAZE_POWDER = 'minecraft:blaze_powder'
    BLAZE_ROD = 'minecraft:blaze_rod'
    BLAZE_SPAWN_EGG = 'minecraft:blaze_spawn_egg'
    BLUE_BANNER = 'minecraft:blue_banner'
    BLUE_BED = 'minecraft:blue_bed'
    BLUE_CARPET = 'minecraft:blue_carpet'
    BLUE_CONCRETE = 'minecraft:blue_concrete'
    BLUE_CONCRETE_POWDER = 'minecraft:blue_concrete_powder'
    BLUE_DYE = 'minecraft:blue_dye'
    BLUE_GLAZED_TERRACOTTA = 'minecraft:blue_glazed_terracotta'
    BLUE_ICE = 'minecraft:blue_ice'
    BLUE_ORCHID = 'minecraft:blue_orchid'
    BLUE_SHULKER_BOX = 'minecraft:blue_shulker_box'
    BLUE_STAINED_GLASS = 'minecraft:blue_stained_glass'
    BLUE_STAINED_GLASS_PANE = 'minecraft:blue_stained_glass_pane'
    BLUE_TERRACOTTA = 'minecraft:blue_terracotta'
    BLUE_WALL_BANNER = 'minecraft:blue_wall_banner'
    BLUE_WOOL = 'minecraft:blue_wool'
    BOAT = 'minecraft:boat'
    BONE = 'minecraft:bone'
    BONE_BLOCK = 'minecraft:bone_block'
    BONE_MEAL = 'minecraft:bone_meal'
    BOOK = 'minecraft:book'
    BOOKSHELF = 'minecraft:bookshelf'
    BOW = 'minecraft:bow'
    BOWL = 'minecraft:bowl'
    BRAIN_CORAL = 'minecraft:brain_coral'
    BRAIN_CORAL_BLOCK = 'minecraft:brain_coral_block'
    BRAIN_CORAL_FAN = 'minecraft:brain_coral_fan'
    BRAIN_CORAL_WALL_FAN = 'minecraft:brain_coral_wall_fan'
    BREAD = 'minecraft:bread'
    BREWING_STAND = 'minecraft:brewing_stand'
    BRICK = 'minecraft:brick'
    BRICKS = 'minecraft:bricks'
    BRICK_BLOCK = 'minecraft:brick_block'
    BRICK_SLAB = 'minecraft:brick_slab'
    BRICK_STAIRS = 'minecraft:brick_stairs'
    BRICK_WALL = 'minecraft:brick_wall'
    BROWN_BANNER = 'minecraft:brown_banner'
    BROWN_BED = 'minecraft:brown_bed'
    BROWN_CARPET = 'minecraft:brown_carpet'
    BROWN_CONCRETE = 'minecraft:brown_concrete'
    BROWN_CONCRETE_POWDER = 'minecraft:brown_concrete_powder'
    BROWN_DYE = 'minecraft:brown_dye'
    BROWN_GLAZED_TERRACOTTA = 'minecraft:brown_glazed_terracotta'
    BROWN_MUSHROOM = 'minecraft:brown_mushroom'
    BROWN_MUSHROOM_BLOCK = 'minecraft:brown_mushroom_block'
    BROWN_SHULKER_BOX = 'minecraft:brown_shulker_box'
    BROWN_STAINED_GLASS = 'minecraft:brown_stained_glass'
    BROWN_STAINED_GLASS_PANE = 'minecraft:brown_stained_glass_pane'
    BROWN_TERRACOTTA = 'minecraft:brown_terracotta'
    BROWN_WALL_BANNER = 'minecraft:brown_wall_banner'
    BROWN_WOOL = 'minecraft:brown_wool'
    BUBBLE_COLUMN = 'minecraft:bubble_column'
    BUBBLE_CORAL = 'minecraft:bubble_coral'
    BUBBLE_CORAL_BLOCK = 'minecraft:bubble_coral_block'
    BUBBLE_CORAL_FAN = 'minecraft:bubble_coral_fan'
    BUBBLE_CORAL_WALL_FAN = 'minecraft:bubble_coral_wall_fan'
    BUCKET = 'minecraft:bucket'
    CACTUS = 'minecraft:cactus'
    CACTUS_GREEN = 'minecraft:cactus_green'
    CAKE = 'minecraft:cake'
    CAMPFIRE = 'minecraft:campfire'
    CARPET = 'minecraft:carpet'
    CARROT = 'minecraft:carrot'
    CARROTS = 'minecraft:carrots'
    CARROT_ON_A_STICK = 'minecraft:carrot_on_a_stick'
    CARTOGRAPHY_TABLE = 'minecraft:cartography_table'
    CARVED_PUMPKIN = 'minecraft:carved_pumpkin'
    CAT_SPAWN_EGG = 'minecraft:cat_spawn_egg'
    CAULDRON = 'minecraft:cauldron'
    CAVE_AIR = 'minecraft:cave_air'
    CAVE_SPIDER_SPAWN_EGG = 'minecraft:cave_spider_spawn_egg'
    CHAIN = 'minecraft:chain'
    CHAINMAIL_BOOTS = 'minecraft:chainmail_boots'
    CHAINMAIL_CHESTPLATE = 'minecraft:chainmail_chestplate'
    CHAINMAIL_HELMET = 'minecraft:chainmail_helmet'
    CHAINMAIL_LEGGINGS = 'minecraft:chainmail_leggings'
    CHAIN_COMMAND_BLOCK = 'minecraft:chain_command_block'
    CHARCOAL = 'minecraft:charcoal'
    CHEST = 'minecraft:chest'
    CHEST_MINECART = 'minecraft:chest_minecart'
    CHICKEN = 'minecraft:chicken'
    CHICKEN_SPAWN_EGG = 'minecraft:chicken_spawn_egg'
    CHIPPED_ANVIL = 'minecraft:chipped_anvil'
    CHISELED_NETHER_BRICKS = 'minecraft:chiseled_nether_bricks'
    CHISELED_POLISHED_BLACKSTONE = 'minecraft:chiseled_polished_blackstone'
    CHISELED_QUARTZ_BLOCK = 'minecraft:chiseled_quartz_block'
    CHISELED_RED_SANDSTONE = 'minecraft:chiseled_red_sandstone'
    CHISELED_SANDSTONE = 'minecraft:chiseled_sandstone'
    CHISELED_STONE_BRICKS = 'minecraft:chiseled_stone_bricks'
    CHORUS_FLOWER = 'minecraft:chorus_flower'
    CHORUS_FRUIT = 'minecraft:chorus_fruit'
    CHORUS_FRUIT_POPPED = 'minecraft:chorus_fruit_popped'
    CHORUS_PLANT = 'minecraft:chorus_plant'
    CLAY = 'minecraft:clay'
    CLAY_BALL = 'minecraft:clay_ball'
    CLOCK = 'minecraft:clock'
    CLOWNFISH_BUCKET = 'minecraft:clownfish_bucket'
    COAL = 'minecraft:coal'
    COAL_BLOCK = 'minecraft:coal_block'
    COAL_ORE = 'minecraft:coal_ore'
    COARSE_DIRT = 'minecraft:coarse_dirt'
    COBBLESTONE = 'minecraft:cobblestone'
    COBBLESTONE_SLAB = 'minecraft:cobblestone_slab'
    COBBLESTONE_STAIRS = 'minecraft:cobblestone_stairs'
    COBBLESTONE_WALL = 'minecraft:cobblestone_wall'
    COBWEB = 'minecraft:cobweb'
    COCOA = 'minecraft:cocoa'
    COCOA_BEANS = 'minecraft:cocoa_beans'
    COD = 'minecraft:cod'
    COD_BUCKET = 'minecraft:cod_bucket'
    COD_SPAWN_EGG = 'minecraft:cod_spawn_egg'
    COMMAND_BLOCK = 'minecraft:command_block'
    COMMAND_BLOCK_MINECART = 'minecraft:command_block_minecart'
    COMPARATOR = 'minecraft:comparator'
    COMPASS = 'minecraft:compass'
    COMPOSTER = 'minecraft:composter'
    CONCRETE = 'minecraft:concrete'
    CONCRETE_POWDER = 'minecraft:concrete_powder'
    CONDUIT = 'minecraft:conduit'
    COOKED_BEEF = 'minecraft:cooked_beef'
    COOKED_CHICKEN = 'minecraft:cooked_chicken'
    COOKED_COD = 'minecraft:cooked_cod'
    COOKED_FISH = 'minecraft:cooked_fish'
    COOKED_MUTTON = 'minecraft:cooked_mutton'
    COOKED_PORKCHOP = 'minecraft:cooked_porkchop'
    COOKED_RABBIT = 'minecraft:cooked_rabbit'
    COOKED_SALMON = 'minecraft:cooked_salmon'
    COOKIE = 'minecraft:cookie'
    CORNFLOWER = 'minecraft:cornflower'
    COW_SPAWN_EGG = 'minecraft:cow_spawn_egg'
    CRACKED_NETHER_BRICKS = 'minecraft:cracked_nether_bricks'
    CRACKED_POLISHED_BLACKSTONE_BRICKS = \
        'minecraft:cracked_polished_blackstone_bricks'
    CRACKED_STONE_BRICKS = 'minecraft:cracked_stone_bricks'
    CRAFTING_TABLE = 'minecraft:crafting_table'
    CREEPER_BANNER_PATTERN = 'minecraft:creeper_banner_pattern'
    CREEPER_HEAD = 'minecraft:creeper_head'
    CREEPER_SPAWN_EGG = 'minecraft:creeper_spawn_egg'
    CREEPER_WALL_HEAD = 'minecraft:creeper_wall_head'
    CRIMSON_BUTTON = 'minecraft:crimson_button'
    CRIMSON_DOOR = 'minecraft:crimson_door'
    CRIMSON_FENCE = 'minecraft:crimson_fence'
    CRIMSON_FENCE_GATE = 'minecraft:crimson_fence_gate'
    CRIMSON_FUNGUS = 'minecraft:crimson_fungus'
    CRIMSON_HYPHAE = 'minecraft:crimson_hyphae'
    CRIMSON_NYLIUM = 'minecraft:crimson_nylium'
    CRIMSON_PLANKS = 'minecraft:crimson_planks'
    CRIMSON_PRESSURE_PLATE = 'minecraft:crimson_pressure_plate'
    CRIMSON_ROOTS = 'minecraft:crimson_roots'
    CRIMSON_SIGN = 'minecraft:crimson_sign'
    CRIMSON_SLAB = 'minecraft:crimson_slab'
    CRIMSON_STAIRS = 'minecraft:crimson_stairs'
    CRIMSON_STEM = 'minecraft:crimson_stem'
    CRIMSON_TRAPDOOR = 'minecraft:crimson_trapdoor'
    CRIMSON_WALL_SIGN = 'minecraft:crimson_wall_sign'
    CROSSBOW = 'minecraft:crossbow'
    CRYING_OBSIDIAN = 'minecraft:crying_obsidian'
    CUT_RED_SANDSTONE = 'minecraft:cut_red_sandstone'
    CUT_RED_SANDSTONE_SLAB = 'minecraft:cut_red_sandstone_slab'
    CUT_SANDSTONE = 'minecraft:cut_sandstone'
    CUT_SANDSTONE_SLAB = 'minecraft:cut_sandstone_slab'
    CYAN_BANNER = 'minecraft:cyan_banner'
    CYAN_BED = 'minecraft:cyan_bed'
    CYAN_CARPET = 'minecraft:cyan_carpet'
    CYAN_CONCRETE = 'minecraft:cyan_concrete'
    CYAN_CONCRETE_POWDER = 'minecraft:cyan_concrete_powder'
    CYAN_DYE = 'minecraft:cyan_dye'
    CYAN_GLAZED_TERRACOTTA = 'minecraft:cyan_glazed_terracotta'
    CYAN_SHULKER_BOX = 'minecraft:cyan_shulker_box'
    CYAN_STAINED_GLASS = 'minecraft:cyan_stained_glass'
    CYAN_STAINED_GLASS_PANE = 'minecraft:cyan_stained_glass_pane'
    CYAN_TERRACOTTA = 'minecraft:cyan_terracotta'
    CYAN_WALL_BANNER = 'minecraft:cyan_wall_banner'
    CYAN_WOOL = 'minecraft:cyan_wool'
    DAMAGED_ANVIL = 'minecraft:damaged_anvil'
    DANDELION = 'minecraft:dandelion'
    DANDELION_YELLOW = 'minecraft:dandelion_yellow'
    DARK_OAK_BARK = 'minecraft:dark_oak_bark'
    DARK_OAK_BOAT = 'minecraft:dark_oak_boat'
    DARK_OAK_BUTTON = 'minecraft:dark_oak_button'
    DARK_OAK_DOOR = 'minecraft:dark_oak_door'
    DARK_OAK_FENCE = 'minecraft:dark_oak_fence'
    DARK_OAK_FENCE_GATE = 'minecraft:dark_oak_fence_gate'
    DARK_OAK_LEAVES = 'minecraft:dark_oak_leaves'
    DARK_OAK_LOG = 'minecraft:dark_oak_log'
    DARK_OAK_PLANKS = 'minecraft:dark_oak_planks'
    DARK_OAK_PRESSURE_PLATE = 'minecraft:dark_oak_pressure_plate'
    DARK_OAK_SAPLING = 'minecraft:dark_oak_sapling'
    DARK_OAK_SIGN = 'minecraft:dark_oak_sign'
    DARK_OAK_SLAB = 'minecraft:dark_oak_slab'
    DARK_OAK_STAIRS = 'minecraft:dark_oak_stairs'
    DARK_OAK_TRAPDOOR = 'minecraft:dark_oak_trapdoor'
    DARK_OAK_WALL_SIGN = 'minecraft:dark_oak_wall_sign'
    DARK_OAK_WOOD = 'minecraft:dark_oak_wood'
    DARK_PRISMARINE = 'minecraft:dark_prismarine'
    DARK_PRISMARINE_SLAB = 'minecraft:dark_prismarine_slab'
    DARK_PRISMARINE_STAIRS = 'minecraft:dark_prismarine_stairs'
    DAYLIGHT_DETECTOR = 'minecraft:daylight_detector'
    DEADBUSH = 'minecraft:deadbush'
    DEAD_BRAIN_CORAL = 'minecraft:dead_brain_coral'
    DEAD_BRAIN_CORAL_BLOCK = 'minecraft:dead_brain_coral_block'
    DEAD_BRAIN_CORAL_FAN = 'minecraft:dead_brain_coral_fan'
    DEAD_BRAIN_CORAL_WALL_FAN = 'minecraft:dead_brain_coral_wall_fan'
    DEAD_BUBBLE_CORAL = 'minecraft:dead_bubble_coral'
    DEAD_BUBBLE_CORAL_BLOCK = 'minecraft:dead_bubble_coral_block'
    DEAD_BUBBLE_CORAL_FAN = 'minecraft:dead_bubble_coral_fan'
    DEAD_BUBBLE_CORAL_WALL_FAN = 'minecraft:dead_bubble_coral_wall_fan'
    DEAD_BUSH = 'minecraft:dead_bush'
    DEAD_FIRE_CORAL = 'minecraft:dead_fire_coral'
    DEAD_FIRE_CORAL_BLOCK = 'minecraft:dead_fire_coral_block'
    DEAD_FIRE_CORAL_FAN = 'minecraft:dead_fire_coral_fan'
    DEAD_FIRE_CORAL_WALL_FAN = 'minecraft:dead_fire_coral_wall_fan'
    DEAD_HORN_CORAL = 'minecraft:dead_horn_coral'
    DEAD_HORN_CORAL_BLOCK = 'minecraft:dead_horn_coral_block'
    DEAD_HORN_CORAL_FAN = 'minecraft:dead_horn_coral_fan'
    DEAD_HORN_CORAL_WALL_FAN = 'minecraft:dead_horn_coral_wall_fan'
    DEAD_TUBE_CORAL = 'minecraft:dead_tube_coral'
    DEAD_TUBE_CORAL_BLOCK = 'minecraft:dead_tube_coral_block'
    DEAD_TUBE_CORAL_FAN = 'minecraft:dead_tube_coral_fan'
    DEAD_TUBE_CORAL_WALL_FAN = 'minecraft:dead_tube_coral_wall_fan'
    DEBUG_STICK = 'minecraft:debug_stick'
    DETECTOR_RAIL = 'minecraft:detector_rail'
    DIAMOND = 'minecraft:diamond'
    DIAMOND_AXE = 'minecraft:diamond_axe'
    DIAMOND_BLOCK = 'minecraft:diamond_block'
    DIAMOND_BOOTS = 'minecraft:diamond_boots'
    DIAMOND_CHESTPLATE = 'minecraft:diamond_chestplate'
    DIAMOND_HELMET = 'minecraft:diamond_helmet'
    DIAMOND_HOE = 'minecraft:diamond_hoe'
    DIAMOND_HORSE_ARMOR = 'minecraft:diamond_horse_armor'
    DIAMOND_LEGGINGS = 'minecraft:diamond_leggings'
    DIAMOND_ORE = 'minecraft:diamond_ore'
    DIAMOND_PICKAXE = 'minecraft:diamond_pickaxe'
    DIAMOND_SHOVEL = 'minecraft:diamond_shovel'
    DIAMOND_SWORD = 'minecraft:diamond_sword'
    DIORITE = 'minecraft:diorite'
    DIORITE_SLAB = 'minecraft:diorite_slab'
    DIORITE_STAIRS = 'minecraft:diorite_stairs'
    DIORITE_WALL = 'minecraft:diorite_wall'
    DIRT = 'minecraft:dirt'
    DISPENSER = 'minecraft:dispenser'
    DOLPHIN_SPAWN_EGG = 'minecraft:dolphin_spawn_egg'
    DONKEY_SPAWN_EGG = 'minecraft:donkey_spawn_egg'
    DOUBLE_PLANT = 'minecraft:double_plant'
    DOUBLE_STONE_SLAB = 'minecraft:double_stone_slab'
    DRAGON_BREATH = 'minecraft:dragon_breath'
    DRAGON_EGG = 'minecraft:dragon_egg'
    DRAGON_HEAD = 'minecraft:dragon_head'
    DRAGON_WALL_HEAD = 'minecraft:dragon_wall_head'
    DRIED_KELP = 'minecraft:dried_kelp'
    DRIED_KELP_BLOCK = 'minecraft:dried_kelp_block'
    DROPPER = 'minecraft:dropper'
    DROWNED_SPAWN_EGG = 'minecraft:drowned_spawn_egg'
    DYE = 'minecraft:dye'
    EGG = 'minecraft:egg'
    ELDER_GUARDIAN_SPAWN_EGG = 'minecraft:elder_guardian_spawn_egg'
    ELYTRA = 'minecraft:elytra'
    EMERALD = 'minecraft:emerald'
    EMERALD_BLOCK = 'minecraft:emerald_block'
    EMERALD_ORE = 'minecraft:emerald_ore'
    ENCHANTED_BOOK = 'minecraft:enchanted_book'
    ENCHANTED_GOLDEN_APPLE = 'minecraft:enchanted_golden_apple'
    ENCHANTING_TABLE = 'minecraft:enchanting_table'
    ENDERMAN_SPAWN_EGG = 'minecraft:enderman_spawn_egg'
    ENDERMITE_SPAWN_EGG = 'minecraft:endermite_spawn_egg'
    ENDER_CHEST = 'minecraft:ender_chest'
    ENDER_EYE = 'minecraft:ender_eye'
    ENDER_PEARL = 'minecraft:ender_pearl'
    END_BRICKS = 'minecraft:end_bricks'
    END_CRYSTAL = 'minecraft:end_crystal'
    END_GATEWAY = 'minecraft:end_gateway'
    END_PORTAL = 'minecraft:end_portal'
    END_PORTAL_FRAME = 'minecraft:end_portal_frame'
    END_ROD = 'minecraft:end_rod'
    END_STONE = 'minecraft:end_stone'
    END_STONE_BRICKS = 'minecraft:end_stone_bricks'
    END_STONE_BRICK_SLAB = 'minecraft:end_stone_brick_slab'
    END_STONE_BRICK_STAIRS = 'minecraft:end_stone_brick_stairs'
    END_STONE_BRICK_WALL = 'minecraft:end_stone_brick_wall'
    EVOKER_SPAWN_EGG = 'minecraft:evoker_spawn_egg'
    EXPERIENCE_BOTTLE = 'minecraft:experience_bottle'
    FARMLAND = 'minecraft:farmland'
    FEATHER = 'minecraft:feather'
    FENCE = 'minecraft:fence'
    FENCE_GATE = 'minecraft:fence_gate'
    FERMENTED_SPIDER_EYE = 'minecraft:fermented_spider_eye'
    FERN = 'minecraft:fern'
    FILLED_MAP = 'minecraft:filled_map'
    FIRE = 'minecraft:fire'
    FIREWORKS = 'minecraft:fireworks'
    FIREWORK_CHARGE = 'minecraft:firework_charge'
    FIREWORK_ROCKET = 'minecraft:firework_rocket'
    FIREWORK_STAR = 'minecraft:firework_star'
    FIRE_CHARGE = 'minecraft:fire_charge'
    FIRE_CORAL = 'minecraft:fire_coral'
    FIRE_CORAL_BLOCK = 'minecraft:fire_coral_block'
    FIRE_CORAL_FAN = 'minecraft:fire_coral_fan'
    FIRE_CORAL_WALL_FAN = 'minecraft:fire_coral_wall_fan'
    FISH = 'minecraft:fish'
    FISHING_ROD = 'minecraft:fishing_rod'
    FLETCHING_TABLE = 'minecraft:fletching_table'
    FLINT = 'minecraft:flint'
    FLINT_AND_STEEL = 'minecraft:flint_and_steel'
    FLOWER_BANNER_PATTERN = 'minecraft:flower_banner_pattern'
    FLOWER_POT = 'minecraft:flower_pot'
    FOX_SPAWN_EGG = 'minecraft:fox_spawn_egg'
    FROSTED_ICE = 'minecraft:frosted_ice'
    FURNACE = 'minecraft:furnace'
    FURNACE_MINECART = 'minecraft:furnace_minecart'
    GHAST_SPAWN_EGG = 'minecraft:ghast_spawn_egg'
    GHAST_TEAR = 'minecraft:ghast_tear'
    GILDED_BLACKSTONE = 'minecraft:gilded_blackstone'
    GLASS = 'minecraft:glass'
    GLASS_BOTTLE = 'minecraft:glass_bottle'
    GLASS_PANE = 'minecraft:glass_pane'
    GLISTERING_MELON_SLICE = 'minecraft:glistering_melon_slice'
    GLOBE_BANNER_PATTERN = 'minecraft:globe_banner_pattern'
    GLOWSTONE = 'minecraft:glowstone'
    GLOWSTONE_DUST = 'minecraft:glowstone_dust'
    GOLDEN_APPLE = 'minecraft:golden_apple'
    GOLDEN_AXE = 'minecraft:golden_axe'
    GOLDEN_BOOTS = 'minecraft:golden_boots'
    GOLDEN_CARROT = 'minecraft:golden_carrot'
    GOLDEN_CHESTPLATE = 'minecraft:golden_chestplate'
    GOLDEN_HELMET = 'minecraft:golden_helmet'
    GOLDEN_HOE = 'minecraft:golden_hoe'
    GOLDEN_HORSE_ARMOR = 'minecraft:golden_horse_armor'
    GOLDEN_LEGGINGS = 'minecraft:golden_leggings'
    GOLDEN_PICKAXE = 'minecraft:golden_pickaxe'
    GOLDEN_RAIL = 'minecraft:golden_rail'
    GOLDEN_SHOVEL = 'minecraft:golden_shovel'
    GOLDEN_SWORD = 'minecraft:golden_sword'
    GOLD_BLOCK = 'minecraft:gold_block'
    GOLD_INGOT = 'minecraft:gold_ingot'
    GOLD_NUGGET = 'minecraft:gold_nugget'
    GOLD_ORE = 'minecraft:gold_ore'
    GRANITE = 'minecraft:granite'
    GRANITE_SLAB = 'minecraft:granite_slab'
    GRANITE_STAIRS = 'minecraft:granite_stairs'
    GRANITE_WALL = 'minecraft:granite_wall'
    GRASS = 'minecraft:grass'
    GRASS_BLOCK = 'minecraft:grass_block'
    GRASS_PATH = 'minecraft:grass_path'
    GRAVEL = 'minecraft:gravel'
    GRAY_BANNER = 'minecraft:gray_banner'
    GRAY_BED = 'minecraft:gray_bed'
    GRAY_CARPET = 'minecraft:gray_carpet'
    GRAY_CONCRETE = 'minecraft:gray_concrete'
    GRAY_CONCRETE_POWDER = 'minecraft:gray_concrete_powder'
    GRAY_DYE = 'minecraft:gray_dye'
    GRAY_GLAZED_TERRACOTTA = 'minecraft:gray_glazed_terracotta'
    GRAY_SHULKER_BOX = 'minecraft:gray_shulker_box'
    GRAY_STAINED_GLASS = 'minecraft:gray_stained_glass'
    GRAY_STAINED_GLASS_PANE = 'minecraft:gray_stained_glass_pane'
    GRAY_TERRACOTTA = 'minecraft:gray_terracotta'
    GRAY_WALL_BANNER = 'minecraft:gray_wall_banner'
    GRAY_WOOL = 'minecraft:gray_wool'
    GREEN_BANNER = 'minecraft:green_banner'
    GREEN_BED = 'minecraft:green_bed'
    GREEN_CARPET = 'minecraft:green_carpet'
    GREEN_CONCRETE = 'minecraft:green_concrete'
    GREEN_CONCRETE_POWDER = 'minecraft:green_concrete_powder'
    GREEN_DYE = 'minecraft:green_dye'
    GREEN_GLAZED_TERRACOTTA = 'minecraft:green_glazed_terracotta'
    GREEN_SHULKER_BOX = 'minecraft:green_shulker_box'
    GREEN_STAINED_GLASS = 'minecraft:green_stained_glass'
    GREEN_STAINED_GLASS_PANE = 'minecraft:green_stained_glass_pane'
    GREEN_TERRACOTTA = 'minecraft:green_terracotta'
    GREEN_WALL_BANNER = 'minecraft:green_wall_banner'
    GREEN_WOOL = 'minecraft:green_wool'
    GRINDSTONE = 'minecraft:grindstone'
    GUARDIAN_SPAWN_EGG = 'minecraft:guardian_spawn_egg'
    GUNPOWDER = 'minecraft:gunpowder'
    HARDENED_CLAY = 'minecraft:hardened_clay'
    HAY_BALE = 'minecraft:hay_bale'
    HAY_BLOCK = 'minecraft:hay_block'
    HEART_OF_THE_SEA = 'minecraft:heart_of_the_sea'
    HEAVY_WEIGHTED_PRESSURE_PLATE = 'minecraft:heavy_weighted_pressure_plate'
    HOGLIN_SPAWN_EGG = 'minecraft:hoglin_spawn_egg'
    HONEYCOMB = 'minecraft:honeycomb'
    HONEYCOMB_BLOCK = 'minecraft:honeycomb_block'
    HONEY_BLOCK = 'minecraft:honey_block'
    HONEY_BOTTLE = 'minecraft:honey_bottle'
    HOPPER = 'minecraft:hopper'
    HOPPER_MINECART = 'minecraft:hopper_minecart'
    HORN_CORAL = 'minecraft:horn_coral'
    HORN_CORAL_BLOCK = 'minecraft:horn_coral_block'
    HORN_CORAL_FAN = 'minecraft:horn_coral_fan'
    HORN_CORAL_WALL_FAN = 'minecraft:horn_coral_wall_fan'
    HORSE_SPAWN_EGG = 'minecraft:horse_spawn_egg'
    HUSK_SPAWN_EGG = 'minecraft:husk_spawn_egg'
    ICE = 'minecraft:ice'
    INFESTED_CHISELED_STONE_BRICKS = 'minecraft:infested_chiseled_stone_bricks'
    INFESTED_COBBLESTONE = 'minecraft:infested_cobblestone'
    INFESTED_CRACKED_STONE_BRICKS = 'minecraft:infested_cracked_stone_bricks'
    INFESTED_MOSSY_STONE_BRICKS = 'minecraft:infested_mossy_stone_bricks'
    INFESTED_STONE = 'minecraft:infested_stone'
    INFESTED_STONE_BRICKS = 'minecraft:infested_stone_bricks'
    INK_SAC = 'minecraft:ink_sac'
    IRON_AXE = 'minecraft:iron_axe'
    IRON_BARS = 'minecraft:iron_bars'
    IRON_BLOCK = 'minecraft:iron_block'
    IRON_BOOTS = 'minecraft:iron_boots'
    IRON_CHESTPLATE = 'minecraft:iron_chestplate'
    IRON_DOOR = 'minecraft:iron_door'
    IRON_HELMET = 'minecraft:iron_helmet'
    IRON_HOE = 'minecraft:iron_hoe'
    IRON_HORSE_ARMOR = 'minecraft:iron_horse_armor'
    IRON_INGOT = 'minecraft:iron_ingot'
    IRON_LEGGINGS = 'minecraft:iron_leggings'
    IRON_NUGGET = 'minecraft:iron_nugget'
    IRON_ORE = 'minecraft:iron_ore'
    IRON_PICKAXE = 'minecraft:iron_pickaxe'
    IRON_SHOVEL = 'minecraft:iron_shovel'
    IRON_SWORD = 'minecraft:iron_sword'
    IRON_TRAPDOOR = 'minecraft:iron_trapdoor'
    ITEM_FRAME = 'minecraft:item_frame'
    JACK_O_LANTERN = 'minecraft:jack_o_lantern'
    JIGSAW = 'minecraft:jigsaw'
    JUKEBOX = 'minecraft:jukebox'
    JUNGLE_BARK = 'minecraft:jungle_bark'
    JUNGLE_BOAT = 'minecraft:jungle_boat'
    JUNGLE_BUTTON = 'minecraft:jungle_button'
    JUNGLE_DOOR = 'minecraft:jungle_door'
    JUNGLE_FENCE = 'minecraft:jungle_fence'
    JUNGLE_FENCE_GATE = 'minecraft:jungle_fence_gate'
    JUNGLE_LEAVES = 'minecraft:jungle_leaves'
    JUNGLE_LOG = 'minecraft:jungle_log'
    JUNGLE_PLANKS = 'minecraft:jungle_planks'
    JUNGLE_PRESSURE_PLATE = 'minecraft:jungle_pressure_plate'
    JUNGLE_SAPLING = 'minecraft:jungle_sapling'
    JUNGLE_SIGN = 'minecraft:jungle_sign'
    JUNGLE_SLAB = 'minecraft:jungle_slab'
    JUNGLE_STAIRS = 'minecraft:jungle_stairs'
    JUNGLE_TRAPDOOR = 'minecraft:jungle_trapdoor'
    JUNGLE_WALL_SIGN = 'minecraft:jungle_wall_sign'
    JUNGLE_WOOD = 'minecraft:jungle_wood'
    KELP = 'minecraft:kelp'
    KELP_PLANT = 'minecraft:kelp_plant'
    KNOWLEDGE_BOOK = 'minecraft:knowledge_book'
    LADDER = 'minecraft:ladder'
    LANTERN = 'minecraft:lantern'
    LAPIS_BLOCK = 'minecraft:lapis_block'
    LAPIS_LAZULI = 'minecraft:lapis_lazuli'
    LAPIS_ORE = 'minecraft:lapis_ore'
    LARGE_FERN = 'minecraft:large_fern'
    LAVA = 'minecraft:lava'
    LAVA_BUCKET = 'minecraft:lava_bucket'
    LEAD = 'minecraft:lead'
    LEATHER = 'minecraft:leather'
    LEATHER_BOOTS = 'minecraft:leather_boots'
    LEATHER_CHESTPLATE = 'minecraft:leather_chestplate'
    LEATHER_HELMET = 'minecraft:leather_helmet'
    LEATHER_HORSE_ARMOR = 'minecraft:leather_horse_armor'
    LEATHER_LEGGINGS = 'minecraft:leather_leggings'
    LEAVES = 'minecraft:leaves'
    LEAVES2 = 'minecraft:leaves2'
    LECTERN = 'minecraft:lectern'
    LEVER = 'minecraft:lever'
    LIGHT_BLUE_BANNER = 'minecraft:light_blue_banner'
    LIGHT_BLUE_BED = 'minecraft:light_blue_bed'
    LIGHT_BLUE_CARPET = 'minecraft:light_blue_carpet'
    LIGHT_BLUE_CONCRETE = 'minecraft:light_blue_concrete'
    LIGHT_BLUE_CONCRETE_POWDER = 'minecraft:light_blue_concrete_powder'
    LIGHT_BLUE_DYE = 'minecraft:light_blue_dye'
    LIGHT_BLUE_GLAZED_TERRACOTTA = 'minecraft:light_blue_glazed_terracotta'
    LIGHT_BLUE_SHULKER_BOX = 'minecraft:light_blue_shulker_box'
    LIGHT_BLUE_STAINED_GLASS = 'minecraft:light_blue_stained_glass'
    LIGHT_BLUE_STAINED_GLASS_PANE = 'minecraft:light_blue_stained_glass_pane'
    LIGHT_BLUE_TERRACOTTA = 'minecraft:light_blue_terracotta'
    LIGHT_BLUE_WALL_BANNER = 'minecraft:light_blue_wall_banner'
    LIGHT_BLUE_WOOL = 'minecraft:light_blue_wool'
    LIGHT_GRAY_BANNER = 'minecraft:light_gray_banner'
    LIGHT_GRAY_BED = 'minecraft:light_gray_bed'
    LIGHT_GRAY_CARPET = 'minecraft:light_gray_carpet'
    LIGHT_GRAY_CONCRETE = 'minecraft:light_gray_concrete'
    LIGHT_GRAY_CONCRETE_POWDER = 'minecraft:light_gray_concrete_powder'
    LIGHT_GRAY_DYE = 'minecraft:light_gray_dye'
    LIGHT_GRAY_GLAZED_TERRACOTTA = 'minecraft:light_gray_glazed_terracotta'
    LIGHT_GRAY_SHULKER_BOX = 'minecraft:light_gray_shulker_box'
    LIGHT_GRAY_STAINED_GLASS = 'minecraft:light_gray_stained_glass'
    LIGHT_GRAY_STAINED_GLASS_PANE = 'minecraft:light_gray_stained_glass_pane'
    LIGHT_GRAY_TERRACOTTA = 'minecraft:light_gray_terracotta'
    LIGHT_GRAY_WALL_BANNER = 'minecraft:light_gray_wall_banner'
    LIGHT_GRAY_WOOL = 'minecraft:light_gray_wool'
    LIGHT_WEIGHTED_PRESSURE_PLATE = 'minecraft:light_weighted_pressure_plate'
    LILAC = 'minecraft:lilac'
    LILY_OF_THE_VALLEY = 'minecraft:lily_of_the_valley'
    LILY_PAD = 'minecraft:lily_pad'
    LIME_BANNER = 'minecraft:lime_banner'
    LIME_BED = 'minecraft:lime_bed'
    LIME_CARPET = 'minecraft:lime_carpet'
    LIME_CONCRETE = 'minecraft:lime_concrete'
    LIME_CONCRETE_POWDER = 'minecraft:lime_concrete_powder'
    LIME_DYE = 'minecraft:lime_dye'
    LIME_GLAZED_TERRACOTTA = 'minecraft:lime_glazed_terracotta'
    LIME_SHULKER_BOX = 'minecraft:lime_shulker_box'
    LIME_STAINED_GLASS = 'minecraft:lime_stained_glass'
    LIME_STAINED_GLASS_PANE = 'minecraft:lime_stained_glass_pane'
    LIME_TERRACOTTA = 'minecraft:lime_terracotta'
    LIME_WALL_BANNER = 'minecraft:lime_wall_banner'
    LIME_WOOL = 'minecraft:lime_wool'
    LINGERING_POTION = 'minecraft:lingering_potion'
    LIT_PUMPKIN = 'minecraft:lit_pumpkin'
    LIT_REDSTONE_TORCH = 'minecraft:lit_redstone_torch'
    LLAMA_SPAWN_EGG = 'minecraft:llama_spawn_egg'
    LODESTONE = 'minecraft:lodestone'
    LOG = 'minecraft:log'
    LOG2 = 'minecraft:log2'
    LOOM = 'minecraft:loom'
    MAGENTA_BANNER = 'minecraft:magenta_banner'
    MAGENTA_BED = 'minecraft:magenta_bed'
    MAGENTA_CARPET = 'minecraft:magenta_carpet'
    MAGENTA_CONCRETE = 'minecraft:magenta_concrete'
    MAGENTA_CONCRETE_POWDER = 'minecraft:magenta_concrete_powder'
    MAGENTA_DYE = 'minecraft:magenta_dye'
    MAGENTA_GLAZED_TERRACOTTA = 'minecraft:magenta_glazed_terracotta'
    MAGENTA_SHULKER_BOX = 'minecraft:magenta_shulker_box'
    MAGENTA_STAINED_GLASS = 'minecraft:magenta_stained_glass'
    MAGENTA_STAINED_GLASS_PANE = 'minecraft:magenta_stained_glass_pane'
    MAGENTA_TERRACOTTA = 'minecraft:magenta_terracotta'
    MAGENTA_WALL_BANNER = 'minecraft:magenta_wall_banner'
    MAGENTA_WOOL = 'minecraft:magenta_wool'
    MAGMA = 'minecraft:magma'
    MAGMA_BLOCK = 'minecraft:magma_block'
    MAGMA_CREAM = 'minecraft:magma_cream'
    MAGMA_CUBE_SPAWN_EGG = 'minecraft:magma_cube_spawn_egg'
    MAP = 'minecraft:map'
    MELON = 'minecraft:melon'
    MELON_BLOCK = 'minecraft:melon_block'
    MELON_SEEDS = 'minecraft:melon_seeds'
    MELON_SLICE = 'minecraft:melon_slice'
    MELON_STEM = 'minecraft:melon_stem'
    MILK_BUCKET = 'minecraft:milk_bucket'
    MINECART = 'minecraft:minecart'
    MOB_SPAWNER = 'minecraft:mob_spawner'
    MOJANG_BANNER_PATTERN = 'minecraft:mojang_banner_pattern'
    MONSTER_EGG = 'minecraft:monster_egg'
    MOOSHROOM_SPAWN_EGG = 'minecraft:mooshroom_spawn_egg'
    MOSSY_COBBLESTONE = 'minecraft:mossy_cobblestone'
    MOSSY_COBBLESTONE_SLAB = 'minecraft:mossy_cobblestone_slab'
    MOSSY_COBBLESTONE_STAIRS = 'minecraft:mossy_cobblestone_stairs'
    MOSSY_COBBLESTONE_WALL = 'minecraft:mossy_cobblestone_wall'
    MOSSY_STONE_BRICKS = 'minecraft:mossy_stone_bricks'
    MOSSY_STONE_BRICK_SLAB = 'minecraft:mossy_stone_brick_slab'
    MOSSY_STONE_BRICK_STAIRS = 'minecraft:mossy_stone_brick_stairs'
    MOSSY_STONE_BRICK_WALL = 'minecraft:mossy_stone_brick_wall'
    MOVING_PISTON = 'minecraft:moving_piston'
    MULE_SPAWN_EGG = 'minecraft:mule_spawn_egg'
    MUSHROOM_STEM = 'minecraft:mushroom_stem'
    MUSHROOM_STEW = 'minecraft:mushroom_stew'
    MUSIC_DISC_11 = 'minecraft:music_disc_11'
    MUSIC_DISC_13 = 'minecraft:music_disc_13'
    MUSIC_DISC_BLOCKS = 'minecraft:music_disc_blocks'
    MUSIC_DISC_CAT = 'minecraft:music_disc_cat'
    MUSIC_DISC_CHIRP = 'minecraft:music_disc_chirp'
    MUSIC_DISC_FAR = 'minecraft:music_disc_far'
    MUSIC_DISC_MALL = 'minecraft:music_disc_mall'
    MUSIC_DISC_MELLOHI = 'minecraft:music_disc_mellohi'
    MUSIC_DISC_PIGSTEP = 'minecraft:music_disc_pigstep'
    MUSIC_DISC_STAL = 'minecraft:music_disc_stal'
    MUSIC_DISC_STRAD = 'minecraft:music_disc_strad'
    MUSIC_DISC_WAIT = 'minecraft:music_disc_wait'
    MUSIC_DISC_WARD = 'minecraft:music_disc_ward'
    MUTTON = 'minecraft:mutton'
    MYCELIUM = 'minecraft:mycelium'
    NAME_TAG = 'minecraft:name_tag'
    NAUTILUS_SHELL = 'minecraft:nautilus_shell'
    NETHERBRICK = 'minecraft:netherbrick'
    NETHERITE_AXE = 'minecraft:netherite_axe'
    NETHERITE_BLOCK = 'minecraft:netherite_block'
    NETHERITE_BOOTS = 'minecraft:netherite_boots'
    NETHERITE_CHESTPLATE = 'minecraft:netherite_chestplate'
    NETHERITE_HELMET = 'minecraft:netherite_helmet'
    NETHERITE_HOE = 'minecraft:netherite_hoe'
    NETHERITE_INGOT = 'minecraft:netherite_ingot'
    NETHERITE_LEGGINGS = 'minecraft:netherite_leggings'
    NETHERITE_PICKAXE = 'minecraft:netherite_pickaxe'
    NETHERITE_SCRAP = 'minecraft:netherite_scrap'
    NETHERITE_SHOVEL = 'minecraft:netherite_shovel'
    NETHERITE_SWORD = 'minecraft:netherite_sword'
    NETHERRACK = 'minecraft:netherrack'
    NETHER_BRICK = 'minecraft:nether_brick'
    NETHER_BRICKS = 'minecraft:nether_bricks'
    NETHER_BRICK_FENCE = 'minecraft:nether_brick_fence'
    NETHER_BRICK_SLAB = 'minecraft:nether_brick_slab'
    NETHER_BRICK_STAIRS = 'minecraft:nether_brick_stairs'
    NETHER_BRICK_WALL = 'minecraft:nether_brick_wall'
    NETHER_GOLD_ORE = 'minecraft:nether_gold_ore'
    NETHER_PORTAL = 'minecraft:nether_portal'
    NETHER_QUARTZ_ORE = 'minecraft:nether_quartz_ore'
    NETHER_SPROUTS = 'minecraft:nether_sprouts'
    NETHER_STAR = 'minecraft:nether_star'
    NETHER_WART = 'minecraft:nether_wart'
    NETHER_WART_BLOCK = 'minecraft:nether_wart_block'
    NOTEBLOCK = 'minecraft:noteblock'
    NOTE_BLOCK = 'minecraft:note_block'
    OAK_BARK = 'minecraft:oak_bark'
    OAK_BOAT = 'minecraft:oak_boat'
    OAK_BUTTON = 'minecraft:oak_button'
    OAK_DOOR = 'minecraft:oak_door'
    OAK_FENCE = 'minecraft:oak_fence'
    OAK_FENCE_GATE = 'minecraft:oak_fence_gate'
    OAK_LEAVES = 'minecraft:oak_leaves'
    OAK_LOG = 'minecraft:oak_log'
    OAK_PLANKS = 'minecraft:oak_planks'
    OAK_PRESSURE_PLATE = 'minecraft:oak_pressure_plate'
    OAK_SAPLING = 'minecraft:oak_sapling'
    OAK_SIGN = 'minecraft:oak_sign'
    OAK_SLAB = 'minecraft:oak_slab'
    OAK_STAIRS = 'minecraft:oak_stairs'
    OAK_TRAPDOOR = 'minecraft:oak_trapdoor'
    OAK_WALL_SIGN = 'minecraft:oak_wall_sign'
    OAK_WOOD = 'minecraft:oak_wood'
    OBSERVER = 'minecraft:observer'
    OBSIDIAN = 'minecraft:obsidian'
    OCELOT_SPAWN_EGG = 'minecraft:ocelot_spawn_egg'
    ORANGE_BANNER = 'minecraft:orange_banner'
    ORANGE_BED = 'minecraft:orange_bed'
    ORANGE_CARPET = 'minecraft:orange_carpet'
    ORANGE_CONCRETE = 'minecraft:orange_concrete'
    ORANGE_CONCRETE_POWDER = 'minecraft:orange_concrete_powder'
    ORANGE_DYE = 'minecraft:orange_dye'
    ORANGE_GLAZED_TERRACOTTA = 'minecraft:orange_glazed_terracotta'
    ORANGE_SHULKER_BOX = 'minecraft:orange_shulker_box'
    ORANGE_STAINED_GLASS = 'minecraft:orange_stained_glass'
    ORANGE_STAINED_GLASS_PANE = 'minecraft:orange_stained_glass_pane'
    ORANGE_TERRACOTTA = 'minecraft:orange_terracotta'
    ORANGE_TULIP = 'minecraft:orange_tulip'
    ORANGE_WALL_BANNER = 'minecraft:orange_wall_banner'
    ORANGE_WOOL = 'minecraft:orange_wool'
    OXEYE_DAISY = 'minecraft:oxeye_daisy'
    PACKED_ICE = 'minecraft:packed_ice'
    PAINTING = 'minecraft:painting'
    PANDA_SPAWN_EGG = 'minecraft:panda_spawn_egg'
    PAPER = 'minecraft:paper'
    PARROT_SPAWN_EGG = 'minecraft:parrot_spawn_egg'
    PEONY = 'minecraft:peony'
    PETRIFIED_OAK_SLAB = 'minecraft:petrified_oak_slab'
    PHANTOM_MEMBRANE = 'minecraft:phantom_membrane'
    PHANTOM_SPAWN_EGG = 'minecraft:phantom_spawn_egg'
    PIGLIN_BANNER_PATTERN = 'minecraft:piglin_banner_pattern'
    PIGLIN_SPAWN_EGG = 'minecraft:piglin_spawn_egg'
    PIG_SPAWN_EGG = 'minecraft:pig_spawn_egg'
    PILLAGER_SPAWN_EGG = 'minecraft:pillager_spawn_egg'
    PINK_BANNER = 'minecraft:pink_banner'
    PINK_BED = 'minecraft:pink_bed'
    PINK_CARPET = 'minecraft:pink_carpet'
    PINK_CONCRETE = 'minecraft:pink_concrete'
    PINK_CONCRETE_POWDER = 'minecraft:pink_concrete_powder'
    PINK_DYE = 'minecraft:pink_dye'
    PINK_GLAZED_TERRACOTTA = 'minecraft:pink_glazed_terracotta'
    PINK_SHULKER_BOX = 'minecraft:pink_shulker_box'
    PINK_STAINED_GLASS = 'minecraft:pink_stained_glass'
    PINK_STAINED_GLASS_PANE = 'minecraft:pink_stained_glass_pane'
    PINK_TERRACOTTA = 'minecraft:pink_terracotta'
    PINK_TULIP = 'minecraft:pink_tulip'
    PINK_WALL_BANNER = 'minecraft:pink_wall_banner'
    PINK_WOOL = 'minecraft:pink_wool'
    PISTON = 'minecraft:piston'
    PISTON_HEAD = 'minecraft:piston_head'
    PLANKS = 'minecraft:planks'
    PLAYER_HEAD = 'minecraft:player_head'
    PLAYER_WALL_HEAD = 'minecraft:player_wall_head'
    PODZOL = 'minecraft:podzol'
    POISONOUS_POTATO = 'minecraft:poisonous_potato'
    POLAR_BEAR_SPAWN_EGG = 'minecraft:polar_bear_spawn_egg'
    POLISHED_ANDESITE = 'minecraft:polished_andesite'
    POLISHED_ANDESITE_SLAB = 'minecraft:polished_andesite_slab'
    POLISHED_ANDESITE_STAIRS = 'minecraft:polished_andesite_stairs'
    POLISHED_BASALT = 'minecraft:polished_basalt'
    POLISHED_BLACKSTONE = 'minecraft:polished_blackstone'
    POLISHED_BLACKSTONE_BRICKS = 'minecraft:polished_blackstone_bricks'
    POLISHED_BLACKSTONE_BRICK_SLAB = 'minecraft:polished_blackstone_brick_slab'
    POLISHED_BLACKSTONE_BRICK_STAIRS = \
        'minecraft:polished_blackstone_brick_stairs'
    POLISHED_BLACKSTONE_BRICK_WALL = 'minecraft:polished_blackstone_brick_wall'
    POLISHED_BLACKSTONE_BUTTON = 'minecraft:polished_blackstone_button'
    POLISHED_BLACKSTONE_PRESSURE_PLATE = \
        'minecraft:polished_blackstone_pressure_plate'
    POLISHED_BLACKSTONE_SLAB = 'minecraft:polished_blackstone_slab'
    POLISHED_BLACKSTONE_STAIRS = 'minecraft:polished_blackstone_stairs'
    POLISHED_BLACKSTONE_WALL = 'minecraft:polished_blackstone_wall'
    POLISHED_DIORITE = 'minecraft:polished_diorite'
    POLISHED_DIORITE_SLAB = 'minecraft:polished_diorite_slab'
    POLISHED_DIORITE_STAIRS = 'minecraft:polished_diorite_stairs'
    POLISHED_GRANITE = 'minecraft:polished_granite'
    POLISHED_GRANITE_SLAB = 'minecraft:polished_granite_slab'
    POLISHED_GRANITE_STAIRS = 'minecraft:polished_granite_stairs'
    POPPED_CHORUS_FRUIT = 'minecraft:popped_chorus_fruit'
    POPPY = 'minecraft:poppy'
    PORKCHOP = 'minecraft:porkchop'
    PORTAL = 'minecraft:portal'
    POTATO = 'minecraft:potato'
    POTATOES = 'minecraft:potatoes'
    POTION = 'minecraft:potion'
    POTTED_ACACIA_SAPLING = 'minecraft:potted_acacia_sapling'
    POTTED_ALLIUM = 'minecraft:potted_allium'
    POTTED_AZURE_BLUET = 'minecraft:potted_azure_bluet'
    POTTED_BAMBOO = 'minecraft:potted_bamboo'
    POTTED_BIRCH_SAPLING = 'minecraft:potted_birch_sapling'
    POTTED_BLUE_ORCHID = 'minecraft:potted_blue_orchid'
    POTTED_BROWN_MUSHROOM = 'minecraft:potted_brown_mushroom'
    POTTED_CACTUS = 'minecraft:potted_cactus'
    POTTED_CORNFLOWER = 'minecraft:potted_cornflower'
    POTTED_CRIMSON_FUNGUS = 'minecraft:potted_crimson_fungus'
    POTTED_CRIMSON_ROOTS = 'minecraft:potted_crimson_roots'
    POTTED_DANDELION = 'minecraft:potted_dandelion'
    POTTED_DARK_OAK_SAPLING = 'minecraft:potted_dark_oak_sapling'
    POTTED_DEAD_BUSH = 'minecraft:potted_dead_bush'
    POTTED_FERN = 'minecraft:potted_fern'
    POTTED_JUNGLE_SAPLING = 'minecraft:potted_jungle_sapling'
    POTTED_LILY_OF_THE_VALLEY = 'minecraft:potted_lily_of_the_valley'
    POTTED_OAK_SAPLING = 'minecraft:potted_oak_sapling'
    POTTED_ORANGE_TULIP = 'minecraft:potted_orange_tulip'
    POTTED_OXEYE_DAISY = 'minecraft:potted_oxeye_daisy'
    POTTED_PINK_TULIP = 'minecraft:potted_pink_tulip'
    POTTED_POPPY = 'minecraft:potted_poppy'
    POTTED_RED_MUSHROOM = 'minecraft:potted_red_mushroom'
    POTTED_RED_TULIP = 'minecraft:potted_red_tulip'
    POTTED_SPRUCE_SAPLING = 'minecraft:potted_spruce_sapling'
    POTTED_WARPED_FUNGUS = 'minecraft:potted_warped_fungus'
    POTTED_WARPED_ROOTS = 'minecraft:potted_warped_roots'
    POTTED_WHITE_TULIP = 'minecraft:potted_white_tulip'
    POTTED_WITHER_ROSE = 'minecraft:potted_wither_rose'
    POWERED_RAIL = 'minecraft:powered_rail'
    PRISMARINE = 'minecraft:prismarine'
    PRISMARINE_BRICKS = 'minecraft:prismarine_bricks'
    PRISMARINE_BRICK_SLAB = 'minecraft:prismarine_brick_slab'
    PRISMARINE_BRICK_STAIRS = 'minecraft:prismarine_brick_stairs'
    PRISMARINE_CRYSTALS = 'minecraft:prismarine_crystals'
    PRISMARINE_SHARD = 'minecraft:prismarine_shard'
    PRISMARINE_SLAB = 'minecraft:prismarine_slab'
    PRISMARINE_STAIRS = 'minecraft:prismarine_stairs'
    PRISMARINE_WALL = 'minecraft:prismarine_wall'
    PUFFERFISH = 'minecraft:pufferfish'
    PUFFERFISH_BUCKET = 'minecraft:pufferfish_bucket'
    PUFFERFISH_SPAWN_EGG = 'minecraft:pufferfish_spawn_egg'
    PUMPKIN = 'minecraft:pumpkin'
    PUMPKIN_PIE = 'minecraft:pumpkin_pie'
    PUMPKIN_SEEDS = 'minecraft:pumpkin_seeds'
    PUMPKIN_STEM = 'minecraft:pumpkin_stem'
    PURPLE_BANNER = 'minecraft:purple_banner'
    PURPLE_BED = 'minecraft:purple_bed'
    PURPLE_CARPET = 'minecraft:purple_carpet'
    PURPLE_CONCRETE = 'minecraft:purple_concrete'
    PURPLE_CONCRETE_POWDER = 'minecraft:purple_concrete_powder'
    PURPLE_DYE = 'minecraft:purple_dye'
    PURPLE_GLAZED_TERRACOTTA = 'minecraft:purple_glazed_terracotta'
    PURPLE_SHULKER_BOX = 'minecraft:purple_shulker_box'
    PURPLE_STAINED_GLASS = 'minecraft:purple_stained_glass'
    PURPLE_STAINED_GLASS_PANE = 'minecraft:purple_stained_glass_pane'
    PURPLE_TERRACOTTA = 'minecraft:purple_terracotta'
    PURPLE_WALL_BANNER = 'minecraft:purple_wall_banner'
    PURPLE_WOOL = 'minecraft:purple_wool'
    PURPUR_BLOCK = 'minecraft:purpur_block'
    PURPUR_PILLAR = 'minecraft:purpur_pillar'
    PURPUR_SLAB = 'minecraft:purpur_slab'
    PURPUR_STAIRS = 'minecraft:purpur_stairs'
    QUARTZ = 'minecraft:quartz'
    QUARTZ_BLOCK = 'minecraft:quartz_block'
    QUARTZ_BRICKS = 'minecraft:quartz_bricks'
    QUARTZ_ORE = 'minecraft:quartz_ore'
    QUARTZ_PILLAR = 'minecraft:quartz_pillar'
    QUARTZ_SLAB = 'minecraft:quartz_slab'
    QUARTZ_STAIRS = 'minecraft:quartz_stairs'
    RABBIT = 'minecraft:rabbit'
    RABBIT_FOOT = 'minecraft:rabbit_foot'
    RABBIT_HIDE = 'minecraft:rabbit_hide'
    RABBIT_SPAWN_EGG = 'minecraft:rabbit_spawn_egg'
    RABBIT_STEW = 'minecraft:rabbit_stew'
    RAIL = 'minecraft:rail'
    RAVAGER_SPAWN_EGG = 'minecraft:ravager_spawn_egg'
    RECORD_11 = 'minecraft:record_11'
    RECORD_13 = 'minecraft:record_13'
    RECORD_BLOCKS = 'minecraft:record_blocks'
    RECORD_CAT = 'minecraft:record_cat'
    RECORD_CHIRP = 'minecraft:record_chirp'
    RECORD_FAR = 'minecraft:record_far'
    RECORD_MALL = 'minecraft:record_mall'
    RECORD_MELLOHI = 'minecraft:record_mellohi'
    RECORD_STAL = 'minecraft:record_stal'
    RECORD_STRAD = 'minecraft:record_strad'
    RECORD_WAIT = 'minecraft:record_wait'
    RECORD_WARD = 'minecraft:record_ward'
    REDSTONE = 'minecraft:redstone'
    REDSTONE_BLOCK = 'minecraft:redstone_block'
    REDSTONE_LAMP = 'minecraft:redstone_lamp'
    REDSTONE_ORE = 'minecraft:redstone_ore'
    REDSTONE_TORCH = 'minecraft:redstone_torch'
    REDSTONE_WALL_TORCH = 'minecraft:redstone_wall_torch'
    REDSTONE_WIRE = 'minecraft:redstone_wire'
    RED_BANNER = 'minecraft:red_banner'
    RED_BED = 'minecraft:red_bed'
    RED_CARPET = 'minecraft:red_carpet'
    RED_CONCRETE = 'minecraft:red_concrete'
    RED_CONCRETE_POWDER = 'minecraft:red_concrete_powder'
    RED_DYE = 'minecraft:red_dye'
    RED_FLOWER = 'minecraft:red_flower'
    RED_GLAZED_TERRACOTTA = 'minecraft:red_glazed_terracotta'
    RED_MUSHROOM = 'minecraft:red_mushroom'
    RED_MUSHROOM_BLOCK = 'minecraft:red_mushroom_block'
    RED_NETHER_BRICK = 'minecraft:red_nether_brick'
    RED_NETHER_BRICKS = 'minecraft:red_nether_bricks'
    RED_NETHER_BRICK_SLAB = 'minecraft:red_nether_brick_slab'
    RED_NETHER_BRICK_STAIRS = 'minecraft:red_nether_brick_stairs'
    RED_NETHER_BRICK_WALL = 'minecraft:red_nether_brick_wall'
    RED_SAND = 'minecraft:red_sand'
    RED_SANDSTONE = 'minecraft:red_sandstone'
    RED_SANDSTONE_SLAB = 'minecraft:red_sandstone_slab'
    RED_SANDSTONE_STAIRS = 'minecraft:red_sandstone_stairs'
    RED_SANDSTONE_WALL = 'minecraft:red_sandstone_wall'
    RED_SHULKER_BOX = 'minecraft:red_shulker_box'
    RED_STAINED_GLASS = 'minecraft:red_stained_glass'
    RED_STAINED_GLASS_PANE = 'minecraft:red_stained_glass_pane'
    RED_TERRACOTTA = 'minecraft:red_terracotta'
    RED_TULIP = 'minecraft:red_tulip'
    RED_WALL_BANNER = 'minecraft:red_wall_banner'
    RED_WOOL = 'minecraft:red_wool'
    REEDS = 'minecraft:reeds'
    REPEATER = 'minecraft:repeater'
    REPEATING_COMMAND_BLOCK = 'minecraft:repeating_command_block'
    RESPAWN_ANCHOR = 'minecraft:respawn_anchor'
    ROSE_BUSH = 'minecraft:rose_bush'
    ROSE_RED = 'minecraft:rose_red'
    ROTTEN_FLESH = 'minecraft:rotten_flesh'
    SADDLE = 'minecraft:saddle'
    SALMON = 'minecraft:salmon'
    SALMON_BUCKET = 'minecraft:salmon_bucket'
    SALMON_SPAWN_EGG = 'minecraft:salmon_spawn_egg'
    SAND = 'minecraft:sand'
    SANDSTONE = 'minecraft:sandstone'
    SANDSTONE_SLAB = 'minecraft:sandstone_slab'
    SANDSTONE_STAIRS = 'minecraft:sandstone_stairs'
    SANDSTONE_WALL = 'minecraft:sandstone_wall'
    SAPLING = 'minecraft:sapling'
    SCAFFOLDING = 'minecraft:scaffolding'
    SCUTE = 'minecraft:scute'
    SEAGRASS = 'minecraft:seagrass'
    SEA_LANTERN = 'minecraft:sea_lantern'
    SEA_PICKLE = 'minecraft:sea_pickle'
    SHEARS = 'minecraft:shears'
    SHEEP_SPAWN_EGG = 'minecraft:sheep_spawn_egg'
    SHIELD = 'minecraft:shield'
    SHROOMLIGHT = 'minecraft:shroomlight'
    SHULKER_BOX = 'minecraft:shulker_box'
    SHULKER_SHELL = 'minecraft:shulker_shell'
    SHULKER_SPAWN_EGG = 'minecraft:shulker_spawn_egg'
    SIGN = 'minecraft:sign'
    SILVERFISH_SPAWN_EGG = 'minecraft:silverfish_spawn_egg'
    SKELETON_HORSE_SPAWN_EGG = 'minecraft:skeleton_horse_spawn_egg'
    SKELETON_SKULL = 'minecraft:skeleton_skull'
    SKELETON_SPAWN_EGG = 'minecraft:skeleton_spawn_egg'
    SKELETON_WALL_SKULL = 'minecraft:skeleton_wall_skull'
    SKULL = 'minecraft:skull'
    SKULL_BANNER_PATTERN = 'minecraft:skull_banner_pattern'
    SLIME = 'minecraft:slime'
    SLIME_BALL = 'minecraft:slime_ball'
    SLIME_BLOCK = 'minecraft:slime_block'
    SLIME_SPAWN_EGG = 'minecraft:slime_spawn_egg'
    SMITHING_TABLE = 'minecraft:smithing_table'
    SMOKER = 'minecraft:smoker'
    SMOOTH_QUARTZ = 'minecraft:smooth_quartz'
    SMOOTH_QUARTZ_SLAB = 'minecraft:smooth_quartz_slab'
    SMOOTH_QUARTZ_STAIRS = 'minecraft:smooth_quartz_stairs'
    SMOOTH_RED_SANDSTONE = 'minecraft:smooth_red_sandstone'
    SMOOTH_RED_SANDSTONE_SLAB = 'minecraft:smooth_red_sandstone_slab'
    SMOOTH_RED_SANDSTONE_STAIRS = 'minecraft:smooth_red_sandstone_stairs'
    SMOOTH_SANDSTONE = 'minecraft:smooth_sandstone'
    SMOOTH_SANDSTONE_SLAB = 'minecraft:smooth_sandstone_slab'
    SMOOTH_SANDSTONE_STAIRS = 'minecraft:smooth_sandstone_stairs'
    SMOOTH_STONE = 'minecraft:smooth_stone'
    SMOOTH_STONE_SLAB = 'minecraft:smooth_stone_slab'
    SNOW = 'minecraft:snow'
    SNOWBALL = 'minecraft:snowball'
    SNOW_BLOCK = 'minecraft:snow_block'
    SNOW_LAYER = 'minecraft:snow_layer'
    SOUL_CAMPFIRE = 'minecraft:soul_campfire'
    SOUL_FIRE = 'minecraft:soul_fire'
    SOUL_LANTERN = 'minecraft:soul_lantern'
    SOUL_SAND = 'minecraft:soul_sand'
    SOUL_SOIL = 'minecraft:soul_soil'
    SOUL_TORCH = 'minecraft:soul_torch'
    SOUL_WALL_TORCH = 'minecraft:soul_wall_torch'
    SPAWNER = 'minecraft:spawner'
    SPAWN_EGG = 'minecraft:spawn_egg'
    SPECKLED_MELON = 'minecraft:speckled_melon'
    SPECTRAL_ARROW = 'minecraft:spectral_arrow'
    SPIDER_EYE = 'minecraft:spider_eye'
    SPIDER_SPAWN_EGG = 'minecraft:spider_spawn_egg'
    SPLASH_POTION = 'minecraft:splash_potion'
    SPONGE = 'minecraft:sponge'
    SPRUCE_BARK = 'minecraft:spruce_bark'
    SPRUCE_BOAT = 'minecraft:spruce_boat'
    SPRUCE_BUTTON = 'minecraft:spruce_button'
    SPRUCE_DOOR = 'minecraft:spruce_door'
    SPRUCE_FENCE = 'minecraft:spruce_fence'
    SPRUCE_FENCE_GATE = 'minecraft:spruce_fence_gate'
    SPRUCE_LEAVES = 'minecraft:spruce_leaves'
    SPRUCE_LOG = 'minecraft:spruce_log'
    SPRUCE_PLANKS = 'minecraft:spruce_planks'
    SPRUCE_PRESSURE_PLATE = 'minecraft:spruce_pressure_plate'
    SPRUCE_SAPLING = 'minecraft:spruce_sapling'
    SPRUCE_SIGN = 'minecraft:spruce_sign'
    SPRUCE_SLAB = 'minecraft:spruce_slab'
    SPRUCE_STAIRS = 'minecraft:spruce_stairs'
    SPRUCE_TRAPDOOR = 'minecraft:spruce_trapdoor'
    SPRUCE_WALL_SIGN = 'minecraft:spruce_wall_sign'
    SPRUCE_WOOD = 'minecraft:spruce_wood'
    SQUID_SPAWN_EGG = 'minecraft:squid_spawn_egg'
    STAINED_GLASS = 'minecraft:stained_glass'
    STAINED_GLASS_PANE = 'minecraft:stained_glass_pane'
    STAINED_HARDENED_CLAY = 'minecraft:stained_hardened_clay'
    STICK = 'minecraft:stick'
    STICKY_PISTON = 'minecraft:sticky_piston'
    STILL_LAVA = 'minecraft:still_lava'
    STILL_WATER = 'minecraft:still_water'
    STONE = 'minecraft:stone'
    STONEBRICK = 'minecraft:stonebrick'
    STONECUTTER = 'minecraft:stonecutter'
    STONE_AXE = 'minecraft:stone_axe'
    STONE_BRICKS = 'minecraft:stone_bricks'
    STONE_BRICK_SLAB = 'minecraft:stone_brick_slab'
    STONE_BRICK_STAIRS = 'minecraft:stone_brick_stairs'
    STONE_BRICK_WALL = 'minecraft:stone_brick_wall'
    STONE_BUTTON = 'minecraft:stone_button'
    STONE_HOE = 'minecraft:stone_hoe'
    STONE_PICKAXE = 'minecraft:stone_pickaxe'
    STONE_PRESSURE_PLATE = 'minecraft:stone_pressure_plate'
    STONE_SHOVEL = 'minecraft:stone_shovel'
    STONE_SLAB = 'minecraft:stone_slab'
    STONE_SLAB2 = 'minecraft:stone_slab2'
    STONE_STAIRS = 'minecraft:stone_stairs'
    STONE_SWORD = 'minecraft:stone_sword'
    STRAY_SPAWN_EGG = 'minecraft:stray_spawn_egg'
    STRIDER_SPAWN_EGG = 'minecraft:strider_spawn_egg'
    STRING = 'minecraft:string'
    STRIPPED_ACACIA_BARK = 'minecraft:stripped_acacia_bark'
    STRIPPED_ACACIA_LOG = 'minecraft:stripped_acacia_log'
    STRIPPED_ACACIA_WOOD = 'minecraft:stripped_acacia_wood'
    STRIPPED_BIRCH_BARK = 'minecraft:stripped_birch_bark'
    STRIPPED_BIRCH_LOG = 'minecraft:stripped_birch_log'
    STRIPPED_BIRCH_WOOD = 'minecraft:stripped_birch_wood'
    STRIPPED_CRIMSON_HYPHAE = 'minecraft:stripped_crimson_hyphae'
    STRIPPED_CRIMSON_STEM = 'minecraft:stripped_crimson_stem'
    STRIPPED_DARK_OAK_BARK = 'minecraft:stripped_dark_oak_bark'
    STRIPPED_DARK_OAK_LOG = 'minecraft:stripped_dark_oak_log'
    STRIPPED_DARK_OAK_WOOD = 'minecraft:stripped_dark_oak_wood'
    STRIPPED_JUNGLE_BARK = 'minecraft:stripped_jungle_bark'
    STRIPPED_JUNGLE_LOG = 'minecraft:stripped_jungle_log'
    STRIPPED_JUNGLE_WOOD = 'minecraft:stripped_jungle_wood'
    STRIPPED_OAK_BARK = 'minecraft:stripped_oak_bark'
    STRIPPED_OAK_LOG = 'minecraft:stripped_oak_log'
    STRIPPED_OAK_WOOD = 'minecraft:stripped_oak_wood'
    STRIPPED_SPRUCE_BARK = 'minecraft:stripped_spruce_bark'
    STRIPPED_SPRUCE_LOG = 'minecraft:stripped_spruce_log'
    STRIPPED_SPRUCE_WOOD = 'minecraft:stripped_spruce_wood'
    STRIPPED_WARPED_HYPHAE = 'minecraft:stripped_warped_hyphae'
    STRIPPED_WARPED_STEM = 'minecraft:stripped_warped_stem'
    STRUCTURE_BLOCK = 'minecraft:structure_block'
    STRUCTURE_VOID = 'minecraft:structure_void'
    SUGAR = 'minecraft:sugar'
    SUGAR_CANE = 'minecraft:sugar_cane'
    SUNFLOWER = 'minecraft:sunflower'
    SUSPICIOUS_STEW = 'minecraft:suspicious_stew'
    SWEET_BERRIES = 'minecraft:sweet_berries'
    SWEET_BERRY_BUSH = 'minecraft:sweet_berry_bush'
    TALLGRASS = 'minecraft:tallgrass'
    TALL_GRASS = 'minecraft:tall_grass'
    TALL_SEAGRASS = 'minecraft:tall_seagrass'
    TARGET = 'minecraft:target'
    TERRACOTTA = 'minecraft:terracotta'
    TIPPED_ARROW = 'minecraft:tipped_arrow'
    TNT = 'minecraft:tnt'
    TNT_MINECART = 'minecraft:tnt_minecart'
    TORCH = 'minecraft:torch'
    TOTEM_OF_UNDYING = 'minecraft:totem_of_undying'
    TRADER_LLAMA_SPAWN_EGG = 'minecraft:trader_llama_spawn_egg'
    TRAPDOOR = 'minecraft:trapdoor'
    TRAPPED_CHEST = 'minecraft:trapped_chest'
    TRIDENT = 'minecraft:trident'
    TRIPWIRE = 'minecraft:tripwire'
    TRIPWIRE_HOOK = 'minecraft:tripwire_hook'
    TROPICAL_FISH = 'minecraft:tropical_fish'
    TROPICAL_FISH_BUCKET = 'minecraft:tropical_fish_bucket'
    TROPICAL_FISH_SPAWN_EGG = 'minecraft:tropical_fish_spawn_egg'
    TUBE_CORAL = 'minecraft:tube_coral'
    TUBE_CORAL_BLOCK = 'minecraft:tube_coral_block'
    TUBE_CORAL_FAN = 'minecraft:tube_coral_fan'
    TUBE_CORAL_WALL_FAN = 'minecraft:tube_coral_wall_fan'
    TURTLE_EGG = 'minecraft:turtle_egg'
    TURTLE_HELMET = 'minecraft:turtle_helmet'
    TURTLE_SPAWN_EGG = 'minecraft:turtle_spawn_egg'
    TWISTING_VINES = 'minecraft:twisting_vines'
    TWISTING_VINES_PLANT = 'minecraft:twisting_vines_plant'
    VEX_SPAWN_EGG = 'minecraft:vex_spawn_egg'
    VILLAGER_SPAWN_EGG = 'minecraft:villager_spawn_egg'
    VINDICATOR_SPAWN_EGG = 'minecraft:vindicator_spawn_egg'
    VINE = 'minecraft:vine'
    VOID_AIR = 'minecraft:void_air'
    WALL_SIGN = 'minecraft:wall_sign'
    WALL_TORCH = 'minecraft:wall_torch'
    WANDERING_TRADER_SPAWN_EGG = 'minecraft:wandering_trader_spawn_egg'
    WARPED_BUTTON = 'minecraft:warped_button'
    WARPED_DOOR = 'minecraft:warped_door'
    WARPED_FENCE = 'minecraft:warped_fence'
    WARPED_FENCE_GATE = 'minecraft:warped_fence_gate'
    WARPED_FUNGUS = 'minecraft:warped_fungus'
    WARPED_FUNGUS_ON_A_STICK = 'minecraft:warped_fungus_on_a_stick'
    WARPED_HYPHAE = 'minecraft:warped_hyphae'
    WARPED_NYLIUM = 'minecraft:warped_nylium'
    WARPED_PLANKS = 'minecraft:warped_planks'
    WARPED_PRESSURE_PLATE = 'minecraft:warped_pressure_plate'
    WARPED_ROOTS = 'minecraft:warped_roots'
    WARPED_SIGN = 'minecraft:warped_sign'
    WARPED_SLAB = 'minecraft:warped_slab'
    WARPED_STAIRS = 'minecraft:warped_stairs'
    WARPED_STEM = 'minecraft:warped_stem'
    WARPED_TRAPDOOR = 'minecraft:warped_trapdoor'
    WARPED_WALL_SIGN = 'minecraft:warped_wall_sign'
    WARPED_WART_BLOCK = 'minecraft:warped_wart_block'
    WATER = 'minecraft:water'
    WATERLILY = 'minecraft:waterlily'
    WATER_BUCKET = 'minecraft:water_bucket'
    WEEPING_VINES = 'minecraft:weeping_vines'
    WEEPING_VINES_PLANT = 'minecraft:weeping_vines_plant'
    WET_SPONGE = 'minecraft:wet_sponge'
    WHEAT = 'minecraft:wheat'
    WHEAT_SEEDS = 'minecraft:wheat_seeds'
    WHITE_BANNER = 'minecraft:white_banner'
    WHITE_BED = 'minecraft:white_bed'
    WHITE_CARPET = 'minecraft:white_carpet'
    WHITE_CONCRETE = 'minecraft:white_concrete'
    WHITE_CONCRETE_POWDER = 'minecraft:white_concrete_powder'
    WHITE_DYE = 'minecraft:white_dye'
    WHITE_GLAZED_TERRACOTTA = 'minecraft:white_glazed_terracotta'
    WHITE_SHULKER_BOX = 'minecraft:white_shulker_box'
    WHITE_STAINED_GLASS = 'minecraft:white_stained_glass'
    WHITE_STAINED_GLASS_PANE = 'minecraft:white_stained_glass_pane'
    WHITE_TERRACOTTA = 'minecraft:white_terracotta'
    WHITE_TULIP = 'minecraft:white_tulip'
    WHITE_WALL_BANNER = 'minecraft:white_wall_banner'
    WHITE_WOOL = 'minecraft:white_wool'
    WITCH_SPAWN_EGG = 'minecraft:witch_spawn_egg'
    WITHER_ROSE = 'minecraft:wither_rose'
    WITHER_SKELETON_SKULL = 'minecraft:wither_skeleton_skull'
    WITHER_SKELETON_SPAWN_EGG = 'minecraft:wither_skeleton_spawn_egg'
    WITHER_SKELETON_WALL_SKULL = 'minecraft:wither_skeleton_wall_skull'
    WOLF_SPAWN_EGG = 'minecraft:wolf_spawn_egg'
    WOODEN_AXE = 'minecraft:wooden_axe'
    WOODEN_BUTTON = 'minecraft:wooden_button'
    WOODEN_DOOR = 'minecraft:wooden_door'
    WOODEN_HOE = 'minecraft:wooden_hoe'
    WOODEN_PICKAXE = 'minecraft:wooden_pickaxe'
    WOODEN_PRESSURE_PLATE = 'minecraft:wooden_pressure_plate'
    WOODEN_SHOVEL = 'minecraft:wooden_shovel'
    WOODEN_SLAB = 'minecraft:wooden_slab'
    WOODEN_SWORD = 'minecraft:wooden_sword'
    WOOL = 'minecraft:wool'
    WRITABLE_BOOK = 'minecraft:writable_book'
    WRITTEN_BOOK = 'minecraft:written_book'
    YELLOW_BANNER = 'minecraft:yellow_banner'
    YELLOW_BED = 'minecraft:yellow_bed'
    YELLOW_CARPET = 'minecraft:yellow_carpet'
    YELLOW_CONCRETE = 'minecraft:yellow_concrete'
    YELLOW_CONCRETE_POWDER = 'minecraft:yellow_concrete_powder'
    YELLOW_DYE = 'minecraft:yellow_dye'
    YELLOW_FLOWER = 'minecraft:yellow_flower'
    YELLOW_GLAZED_TERRACOTTA = 'minecraft:yellow_glazed_terracotta'
    YELLOW_SHULKER_BOX = 'minecraft:yellow_shulker_box'
    YELLOW_STAINED_GLASS = 'minecraft:yellow_stained_glass'
    YELLOW_STAINED_GLASS_PANE = 'minecraft:yellow_stained_glass_pane'
    YELLOW_TERRACOTTA = 'minecraft:yellow_terracotta'
    YELLOW_WALL_BANNER = 'minecraft:yellow_wall_banner'
    YELLOW_WOOL = 'minecraft:yellow_wool'
    ZOGLIN_SPAWN_EGG = 'minecraft:zoglin_spawn_egg'
    ZOMBIE_HEAD = 'minecraft:zombie_head'
    ZOMBIE_HORSE_SPAWN_EGG = 'minecraft:zombie_horse_spawn_egg'
    ZOMBIE_PIGMAN_SPAWN_EGG = 'minecraft:zombie_pigman_spawn_egg'
    ZOMBIE_SPAWN_EGG = 'minecraft:zombie_spawn_egg'
    ZOMBIE_VILLAGER_SPAWN_EGG = 'minecraft:zombie_villager_spawn_egg'
    ZOMBIE_WALL_HEAD = 'minecraft:zombie_wall_head'
    ZOMBIFIED_PIGLIN_SPAWN_EGG = 'minecraft:zombified_piglin_spawn_egg'
