# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/91_expo.ipynb.

# %% auto 0
__all__ = ['EXPO_ONE', 'EXPO_DECA', 'EXPO_HECTO', 'EXPO_KILO', 'EXPO_MEGA', 'EXPO_GIGA', 'EXPO_TERA', 'EXPO_PETA', 'EXPO_EXA',
           'EXPO_ZETTA', 'EXPO_YOTTA', 'EXPO_RONNA', 'EXPO_QUETTA', 'EXPO_DECI', 'EXPO_CENTI', 'EXPO_MILLI',
           'EXPO_MICRO', 'EXPO_NANO', 'EXPO_PICO', 'EXPO_FEMTO', 'EXPO_ATTO', 'EXPO_ZEPTO', 'EXPO_YOCTO', 'EXPO_RONTO',
           'EXPO_QUECTO', 'ExpoInfo', 'Expo']

# %% ../nbs/91_expo.ipynb 4
from enum import Enum
from typing import NamedTuple

# %% ../nbs/91_expo.ipynb 5
from .unit import UNIT_NAMES, UNIT_ABRVS, UNIT_SYMBS

# %% ../nbs/91_expo.ipynb 7
class ExpoInfo(NamedTuple):
    name: str; abrv: str; symb: str; expo: float;

# %% ../nbs/91_expo.ipynb 8
EXPO_ONE    = ExpoInfo(UNIT_NAMES[0], UNIT_ABRVS[0], UNIT_SYMBS[0], 1e0)
EXPO_DECA   = ExpoInfo(UNIT_NAMES[1],  UNIT_ABRVS[1],  UNIT_SYMBS[1],  1e+1)
EXPO_HECTO  = ExpoInfo(UNIT_NAMES[2],  UNIT_ABRVS[2],  UNIT_SYMBS[2],  1e+2)
EXPO_KILO   = ExpoInfo(UNIT_NAMES[3],  UNIT_ABRVS[3],  UNIT_SYMBS[3],  1e+3)
EXPO_MEGA   = ExpoInfo(UNIT_NAMES[4],  UNIT_ABRVS[4],  UNIT_SYMBS[4],  1e+6)
EXPO_GIGA   = ExpoInfo(UNIT_NAMES[5],  UNIT_ABRVS[5],  UNIT_SYMBS[5],  1e+9)
EXPO_TERA   = ExpoInfo(UNIT_NAMES[6],  UNIT_ABRVS[6],  UNIT_SYMBS[6],  1e+12)
EXPO_PETA   = ExpoInfo(UNIT_NAMES[7],  UNIT_ABRVS[7],  UNIT_SYMBS[7],  1e+15)
EXPO_EXA    = ExpoInfo(UNIT_NAMES[8],  UNIT_ABRVS[8],  UNIT_SYMBS[8],  1e+18)
EXPO_ZETTA  = ExpoInfo(UNIT_NAMES[9],  UNIT_ABRVS[9],  UNIT_SYMBS[9],  1e+21)
EXPO_YOTTA  = ExpoInfo(UNIT_NAMES[10], UNIT_ABRVS[10], UNIT_SYMBS[10], 1e+24)
EXPO_RONNA  = ExpoInfo(UNIT_NAMES[11], UNIT_ABRVS[11], UNIT_SYMBS[11], 1e+27)
EXPO_QUETTA = ExpoInfo(UNIT_NAMES[12], UNIT_ABRVS[12], UNIT_SYMBS[12], 1e+30)

EXPO_DECI   = ExpoInfo(UNIT_NAMES[13], UNIT_ABRVS[13], UNIT_SYMBS[13], 1e-1)
EXPO_CENTI  = ExpoInfo(UNIT_NAMES[14], UNIT_ABRVS[14], UNIT_SYMBS[14], 1e-2)
EXPO_MILLI  = ExpoInfo(UNIT_NAMES[15], UNIT_ABRVS[15], UNIT_SYMBS[15], 1e-3)
EXPO_MICRO  = ExpoInfo(UNIT_NAMES[16], UNIT_ABRVS[16], UNIT_SYMBS[16], 1e-6)
EXPO_NANO   = ExpoInfo(UNIT_NAMES[17], UNIT_ABRVS[17], UNIT_SYMBS[17], 1e-9)
EXPO_PICO   = ExpoInfo(UNIT_NAMES[18], UNIT_ABRVS[18], UNIT_SYMBS[18], 1e-12)
EXPO_FEMTO  = ExpoInfo(UNIT_NAMES[19], UNIT_ABRVS[19], UNIT_SYMBS[19], 1e-15)
EXPO_ATTO   = ExpoInfo(UNIT_NAMES[20], UNIT_ABRVS[20], UNIT_SYMBS[20], 1e-18)
EXPO_ZEPTO  = ExpoInfo(UNIT_NAMES[21], UNIT_ABRVS[21], UNIT_SYMBS[21], 1e-21)
EXPO_YOCTO  = ExpoInfo(UNIT_NAMES[22], UNIT_ABRVS[22], UNIT_SYMBS[22], 1e-24)
EXPO_RONTO  = ExpoInfo(UNIT_NAMES[23], UNIT_ABRVS[23], UNIT_SYMBS[23], 1e-27)
EXPO_QUECTO = ExpoInfo(UNIT_NAMES[24], UNIT_ABRVS[24], UNIT_SYMBS[24], 1e-30)

# %% ../nbs/91_expo.ipynb 10
class Expo(Enum):
    ONE    = EXPO_ONE
    DECA   = EXPO_DECA
    HECTO  = EXPO_HECTO
    KILO   = EXPO_KILO
    MEGA   = EXPO_MEGA
    GIGA   = EXPO_GIGA
    TERA   = EXPO_TERA
    PETA   = EXPO_PETA
    EXA    = EXPO_EXA
    ZETTA  = EXPO_ZETTA
    YOTTA  = EXPO_YOTTA
    RONNA  = EXPO_RONNA
    QUETTA = EXPO_QUETTA
    DECI   = EXPO_DECI
    CENTI  = EXPO_CENTI
    MILLI  = EXPO_MILLI
    MICRO  = EXPO_MICRO
    NANO   = EXPO_NANO
    PICO   = EXPO_PICO
    FEMTO  = EXPO_FEMTO
    ATTO   = EXPO_ATTO
    ZEPTO  = EXPO_ZEPTO
    YOCTO  = EXPO_YOCTO
    RONTO  = EXPO_RONTO
    QUECTO = EXPO_QUECTO
