# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/40_biol.ipynb.

# %% auto 0
__all__ = ['OBS', 'VAR', 'OBSM', 'VARM', 'OBSP', 'VARP', 'UNS', 'LAYER', 'LAYERS', 'MITO', 'RIBO', 'CELL', 'CELLS', 'BARCODE',
           'BARCODES', 'GENE', 'GENES', 'N_GENES', 'GENE_ID', 'GENE_IDS', 'GENE_SYMBOL', 'HVG', 'HIGHLY_VARIABLE',
           'COUNTS', 'TOTAL_COUNTS', 'N_GENES_BY_COUNTS', 'LOG1P_TOTAL_COUNTS', 'ENS', 'ENSG', 'ENSEMBL', 'ENSEMBL_ID',
           'DOUBLET', 'DOUBLET_SCORES', 'PREDICTED_DOUBLETS', 'HUMAN', 'MOUSE', 'HUMAN_TF', 'MOUSE_TF',
           'HUMAN_GENE_SYMBOL', 'HUMAN_ENSEMBLE_ID', 'MOUSE_ENSEMBLE_ID', 'PRENORM', 'DETECTED', 'SCALED_NORMALIZED',
           'PCT_COUNTS', 'PCT_COUNTS_MITO', 'PCT_COUNTS_RIBO', 'X', 'X_', 'X_PRENORM', 'X_DETECTED',
           'X_SCALED_NORMALIZED', 'PCA_HVG', 'MAGIC_HVG', 'PHATE_HVG', 'ADATA', 'MATRIX', 'FEATURES', 'SENSITIVITY',
           'FILTERED_MATRIX', 'SEQ', 'SEQRUN', 'SEQRUNS', 'FIRST_SENS', 'UNIQUE_SENS', 'UNIQUE_SENSITIVITY',
           'UNIQUE_SENSITIVITIES', 'AnnPart']

# %% ../nbs/40_biol.ipynb 4
from enum import StrEnum

# %% ../nbs/40_biol.ipynb 5
from nchr import U1
from .args import UNIQUE
from .exps import ID, PCT, SENS, SENSITIVITIES, NORMALIZED, COUNT, TOTAL
from .mthd import MAGIC, PCA, PHATE, LOG1P
from .exts import EXT_H5, EXT_H5AD, EXT_MTX, EXT_TSV

# %% ../nbs/40_biol.ipynb 8
OBS = 'obs'
VAR = 'var'

OBSM = f'{OBS}m'
VARM = f'{VAR}m'

OBSP = f'{OBS}p'
VARP = f'{VAR}p'

UNS = 'uns'

LAYER = 'layer'
LAYERS = f'{LAYER}s'

# %% ../nbs/40_biol.ipynb 10
MITO = 'mito'
RIBO = 'ribo'

# %% ../nbs/40_biol.ipynb 11
CELL = 'cell'
CELLS = f'{CELL}s'

# %% ../nbs/40_biol.ipynb 12
BARCODE = 'barcode'
BARCODES = f'{BARCODE}s'

# %% ../nbs/40_biol.ipynb 14
GENE = 'gene'
GENES = f'{GENE}s'
N_GENES = f'n_{GENES}'

GENE_ID = f'{GENE}{U1}{ID}'
GENE_IDS = f'{GENE_ID}s'
GENE_SYMBOL = f'{GENE}{U1}symbol'

# %% ../nbs/40_biol.ipynb 16
HVG = 'hvg'
HIGHLY_VARIABLE = 'highly_variable'

# %% ../nbs/40_biol.ipynb 18
COUNTS = f'{COUNT}s'
TOTAL_COUNTS = f'{TOTAL}{U1}{COUNTS}'

# %% ../nbs/40_biol.ipynb 20
N_GENES_BY_COUNTS = f'{N_GENES}_by_{COUNTS}'
LOG1P_TOTAL_COUNTS = f'{LOG1P}{U1}{TOTAL_COUNTS}'

# %% ../nbs/40_biol.ipynb 22
ENS = 'ens'
ENSG = f'{ENS}g'
ENSEMBL = 'ensembl'
ENSEMBL_ID = f'{ENSEMBL}{U1}{ID}'

# %% ../nbs/40_biol.ipynb 24
DOUBLET = 'doublet'
DOUBLET_SCORES = f'{DOUBLET}_scores'
PREDICTED_DOUBLETS = f'predicted_{DOUBLET}s'

# %% ../nbs/40_biol.ipynb 26
HUMAN = 'human'
MOUSE = 'mouse'

HUMAN_TF = f'{HUMAN}TFs'
MOUSE_TF = f'{MOUSE}TFs'

HUMAN_GENE_SYMBOL = f'{HUMAN}GeneSymbol'
HUMAN_ENSEMBLE_ID = f'{HUMAN}EnsemblID'
MOUSE_ENSEMBLE_ID = f'{MOUSE}EnsemblID'

PRENORM = 'prenorm'
DETECTED = 'detected'

SCALED_NORMALIZED = f'scaled_{NORMALIZED}'

PCT_COUNTS = f'{PCT}{U1}{COUNTS}'
PCT_COUNTS_MITO = f'{PCT}{U1}{COUNTS}{U1}{MITO}'
PCT_COUNTS_RIBO = f'{PCT}{U1}{COUNTS}{U1}{RIBO}'

# %% ../nbs/40_biol.ipynb 28
X = 'X'
X_ = f'{X}{U1}'

# %% ../nbs/40_biol.ipynb 29
# Layer storing prenormalized counts in adata.layers
X_PRENORM = f'{X_}{PRENORM}'

# Layer storing values where prenormalized counts is at least 0 in adata.layers
X_DETECTED = f'{X_}{DETECTED}'

# Layer storing counts normalized
X_SCALED_NORMALIZED = f'{X_}{SCALED_NORMALIZED}'

# %% ../nbs/40_biol.ipynb 31
PCA_HVG = f'{PCA}{U1}{HVG}'
MAGIC_HVG = f'{MAGIC}{U1}{HVG}'
PHATE_HVG = f'{PHATE}{U1}{HVG}'

# %% ../nbs/40_biol.ipynb 33
ADATA = 'adata'

MATRIX = 'matrix'

FEATURES = 'features'

SENSITIVITY = 'sensitivity'

FILTERED_MATRIX = 'filtered_matrix'

# %% ../nbs/40_biol.ipynb 34
class AnnPart(StrEnum):
    X = X
    OBS = OBS
    OBSM = OBSM
    OBSP = OBSP
    VAR = VAR
    VARM = VARM
    VARP = VARP
    UNS = UNS
    LAYERS = LAYERS

# %% ../nbs/40_biol.ipynb 36
SEQ = 'seq'
SEQRUN = f'{SEQ}run'
SEQRUNS = f'{SEQRUN}s'

# %% ../nbs/40_biol.ipynb 37
FIRST_SENS = f'first{U1}{SENS}'
UNIQUE_SENS = f'{UNIQUE}{U1}{SENS}'
UNIQUE_SENSITIVITY = f'{UNIQUE}{U1}{SENSITIVITY}'
UNIQUE_SENSITIVITIES = f'{UNIQUE}{U1}{SENSITIVITIES}'
