# -*- coding: utf-8 -*-
from typing import TYPE_CHECKING

from .BaseService import BaseServiceStruct

if TYPE_CHECKING:
    from CHRLINE import CHRLINE


class LoginService(object):
    LoginService_REQ_TYPE = 4  # BASE_VAL
    LoginService_RES_TYPE = 4  # BASE_VAL
    LoginService_API_PATH = None  # BASE_VAL

    def __init__(self):
        pass

    def qrCodeLoginForSecure(self):
        """
        AUTO_GENERATED_CODE! DONT_USE_THIS_FUNC!!

        GENERATED BY YinMo0913_DeachSword-DearSakura_v1.0.5.py
        DATETIME: 10/31/2022, 08:17:56
        """
        raise Exception("qrCodeLoginForSecure is not implemented")
        METHOD_NAME = "qrCodeLoginForSecure"
        params = []
        sqrd = self.generateDummyProtocol(
            METHOD_NAME, params, self.LoginService_REQ_TYPE
        )
        return self.postPackDataAndGetUnpackRespData(
            self.LoginService_API_PATH, sqrd, self.LoginService_RES_TYPE
        )

    def qrCodeLoginV2ForSecure(
        self, authSessionId: str, modelName: str, systemName: str, secureCode: str, autoLoginIsRequired: bool = True
    ):
        """
        Qr code login v2 for secure.

        GENERATED BY YinMo0913_DeachSword-DearSakura_v1.0.5.py
        DATETIME: 10/31/2022, 08:17:56
        """
        METHOD_NAME = "qrCodeLoginV2ForSecure"
        params = [
            [11, 1, authSessionId],
            [11, 2, systemName],
            [11, 3, modelName],
            [2, 4, autoLoginIsRequired],
            [11, 5, secureCode],
        ]
        return SecondaryQrCodeLoginServiceStruct.SendRequestByName(
            self, METHOD_NAME, params
        )

    def createQrCodeForSecure(self, qrcode):
        """
        Create qr code for secure.

        GENERATED BY YinMo0913_DeachSword-DearSakura_v1.0.5.py
        DATETIME: 10/31/2022, 08:17:56
        """
        METHOD_NAME = "createQrCodeForSecure"
        params = [[11, 1, qrcode]]
        return SecondaryQrCodeLoginServiceStruct.SendRequestByName(
            self, METHOD_NAME, params
        )


class SecondaryQrCodeLoginServiceStruct(BaseServiceStruct):
    @staticmethod
    def SendRequestByName(client: "CHRLINE", name: str, request: str):
        payload = __class__.BaseRequest(request)
        sqrd = client.generateDummyProtocol(name, payload, 4)
        return client.postPackDataAndGetUnpackRespData(
            "/acct/lgn/sq/v1",
            sqrd,
            4,
            readWith=f"SecondaryQrCodeLoginService.{name}",
        )
