import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProjectEnvironmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * Place to link to for this environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_environment#external_url ProjectEnvironment#external_url}
    */
    readonly externalUrl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_environment#id ProjectEnvironment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the environment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_environment#name ProjectEnvironment#name}
    */
    readonly name: string;
    /**
    * The ID or full path of the project to environment is created for.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_environment#project ProjectEnvironment#project}
    */
    readonly project: string;
    /**
    * Determines whether the environment is attempted to be stopped before the environment is deleted.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/gitlab/r/project_environment#stop_before_destroy ProjectEnvironment#stop_before_destroy}
    */
    readonly stopBeforeDestroy?: boolean | cdktf.IResolvable;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/gitlab/r/project_environment gitlab_project_environment}
*/
export declare class ProjectEnvironment extends cdktf.TerraformResource {
    static readonly tfResourceType = "gitlab_project_environment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/gitlab/r/project_environment gitlab_project_environment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProjectEnvironmentConfig
    */
    constructor(scope: Construct, id: string, config: ProjectEnvironmentConfig);
    get createdAt(): string;
    private _externalUrl?;
    get externalUrl(): string;
    set externalUrl(value: string);
    resetExternalUrl(): void;
    get externalUrlInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    get projectInput(): string | undefined;
    get slug(): string;
    get state(): string;
    private _stopBeforeDestroy?;
    get stopBeforeDestroy(): boolean | cdktf.IResolvable;
    set stopBeforeDestroy(value: boolean | cdktf.IResolvable);
    resetStopBeforeDestroy(): void;
    get stopBeforeDestroyInput(): boolean | cdktf.IResolvable | undefined;
    get updatedAt(): string;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
