# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2018-10-18 00:13
from __future__ import absolute_import, division, print_function, unicode_literals

from django.db import migrations, models
import django.utils.timezone
import model_utils.fields
import opaque_keys.edx.django.models
import six
import time


BATCH_SIZE = 5000


def copy_data(apps, schema_editor):
    """
    Add indexes to completion_aggregator_stalecompletion without locking.

    Copy data into the new stalecompletionnew table in batches, then rename
    both tables, then do a final copy of any new data that came in.
    """
    copy_sql_tmpl = """
        INSERT INTO %(target)s (`created`, `modified`, `username`, `course_key`, `block_key`, `force`, `resolved`)
            SELECT `created`, `modified`, `username`, `course_key`, `block_key`, `force`, `resolved`
                FROM %(source)s
                WHERE id >= %%s AND id < %%s
    """
    StaleCompletion = apps.get_model("completion_aggregator", "StaleCompletion")
    cursor = schema_editor.connection.cursor()
    try:
        initial_max_id = StaleCompletion.objects.order_by('-id')[0].id
    except IndexError:
        initial_max_id = 0
    copy_sql = copy_sql_tmpl % {
        'source': 'completion_aggregator_stalecompletion',
        'target': 'completion_aggregator_stalecompletionnew',
    }
    print()

    for start_id in six.moves.range(0, initial_max_id, BATCH_SIZE):
        end_id = min(start_id + BATCH_SIZE, initial_max_id)
        cursor.execute(copy_sql, [start_id, end_id])
        time.sleep(.1)
        if end_id % 100000 == 0:
            print("Initial copy: Transferred records up to {} at {}".format(end_id, django.utils.timezone.now()))

    cursor.execute(
        """
        RENAME TABLE
            completion_aggregator_stalecompletion TO completion_aggregator_stalecompletionold,
            completion_aggregator_stalecompletionnew TO completion_aggregator_stalecompletion
        """
    )
    cursor.execute(
        """
        SELECT id
            FROM completion_aggregator_stalecompletionold
            ORDER BY -id
            LIMIT 1
        """,
    )
    result = cursor.fetchone()
    if result is None:
        final_max_id = initial_max_id
    else:
        final_max_id = result[0]

    copy_sql = copy_sql_tmpl % {
        'source': 'completion_aggregator_stalecompletionold',
        'target': 'completion_aggregator_stalecompletion',
    }
    for start_id in six.moves.range(initial_max_id, final_max_id, BATCH_SIZE):
        end_id = start_id + BATCH_SIZE
        cursor.execute(copy_sql, [start_id, end_id])
        if end_id - initial_max_id % 100000 == 0:
            print("Secondary copy: Transferred records up to {} by {}".format(end_id, django.utils.timezone.now()))

    print("Final tally: Transferred records up to {} by {}".format(final_max_id, django.utils.timezone.now()))


class Migration(migrations.Migration):

    dependencies = [
        ('completion_aggregator', '0003_stalecompletion'),
    ]

    operations = [
        migrations.SeparateDatabaseAndState(
            database_operations=[
                migrations.RunSQL([("DROP TABLE IF EXISTS completion_aggregator_stalecompletionnew", None)]),
                migrations.CreateModel(
                    name='StaleCompletionNew',
                    fields=[
                        ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                        ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                        ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                        ('username', models.CharField(max_length=255)),
                        ('course_key', opaque_keys.edx.django.models.CourseKeyField(max_length=255)),
                        ('block_key', opaque_keys.edx.django.models.UsageKeyField(blank=True, max_length=255, null=True)),
                        ('force', models.BooleanField(default=False)),
                        ('resolved', models.BooleanField(default=False)),
                    ],
                ),
                migrations.AlterIndexTogether(
                    name='stalecompletionnew',
                    index_together=set([('username', 'course_key', 'created', 'resolved')]),
                ),
                migrations.RunPython(copy_data)
            ],
            state_operations=[
                migrations.AlterIndexTogether(
                    name='stalecompletion',
                    index_together=set([('username', 'course_key', 'created', 'resolved')]),
                )
            ],
        )
    ]
