# -*- coding: utf-8 -*-
# Copyright 2020 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
from .compute import (
    AbandonInstancesInstanceGroupManagerRequest,
    AbandonInstancesRegionInstanceGroupManagerRequest,
    AcceleratorConfig,
    Accelerators,
    AcceleratorType,
    AcceleratorTypeAggregatedList,
    AcceleratorTypeList,
    AcceleratorTypesScopedList,
    AccessConfig,
    AddAccessConfigInstanceRequest,
    AddAssociationFirewallPolicyRequest,
    AddHealthCheckTargetPoolRequest,
    AddInstancesInstanceGroupRequest,
    AddInstanceTargetPoolRequest,
    AddNodesNodeGroupRequest,
    AddPeeringNetworkRequest,
    AddResourcePoliciesDiskRequest,
    AddResourcePoliciesInstanceRequest,
    AddResourcePoliciesRegionDiskRequest,
    Address,
    AddressAggregatedList,
    AddressesScopedList,
    AddressList,
    AddRuleFirewallPolicyRequest,
    AddRuleSecurityPolicyRequest,
    AddSignedUrlKeyBackendBucketRequest,
    AddSignedUrlKeyBackendServiceRequest,
    AdvancedMachineFeatures,
    AggregatedListAcceleratorTypesRequest,
    AggregatedListAddressesRequest,
    AggregatedListAutoscalersRequest,
    AggregatedListBackendServicesRequest,
    AggregatedListDisksRequest,
    AggregatedListDiskTypesRequest,
    AggregatedListForwardingRulesRequest,
    AggregatedListGlobalOperationsRequest,
    AggregatedListHealthChecksRequest,
    AggregatedListInstanceGroupManagersRequest,
    AggregatedListInstanceGroupsRequest,
    AggregatedListInstancesRequest,
    AggregatedListInterconnectAttachmentsRequest,
    AggregatedListMachineTypesRequest,
    AggregatedListNetworkEndpointGroupsRequest,
    AggregatedListNodeGroupsRequest,
    AggregatedListNodeTemplatesRequest,
    AggregatedListNodeTypesRequest,
    AggregatedListPacketMirroringsRequest,
    AggregatedListPublicDelegatedPrefixesRequest,
    AggregatedListRegionCommitmentsRequest,
    AggregatedListReservationsRequest,
    AggregatedListResourcePoliciesRequest,
    AggregatedListRoutersRequest,
    AggregatedListServiceAttachmentsRequest,
    AggregatedListSslCertificatesRequest,
    AggregatedListSubnetworksRequest,
    AggregatedListTargetHttpProxiesRequest,
    AggregatedListTargetHttpsProxiesRequest,
    AggregatedListTargetInstancesRequest,
    AggregatedListTargetPoolsRequest,
    AggregatedListTargetVpnGatewaysRequest,
    AggregatedListUrlMapsRequest,
    AggregatedListVpnGatewaysRequest,
    AggregatedListVpnTunnelsRequest,
    AliasIpRange,
    AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk,
    AllocationSpecificSKUAllocationReservedInstanceProperties,
    AllocationSpecificSKUReservation,
    Allowed,
    ApplyUpdatesToInstancesInstanceGroupManagerRequest,
    ApplyUpdatesToInstancesRegionInstanceGroupManagerRequest,
    AttachDiskInstanceRequest,
    AttachedDisk,
    AttachedDiskInitializeParams,
    AttachNetworkEndpointsGlobalNetworkEndpointGroupRequest,
    AttachNetworkEndpointsNetworkEndpointGroupRequest,
    AuditConfig,
    AuditLogConfig,
    AuthorizationLoggingOptions,
    Autoscaler,
    AutoscalerAggregatedList,
    AutoscalerList,
    AutoscalersScopedList,
    AutoscalerStatusDetails,
    AutoscalingPolicy,
    AutoscalingPolicyCpuUtilization,
    AutoscalingPolicyCustomMetricUtilization,
    AutoscalingPolicyLoadBalancingUtilization,
    AutoscalingPolicyScaleInControl,
    AutoscalingPolicyScalingSchedule,
    Backend,
    BackendBucket,
    BackendBucketCdnPolicy,
    BackendBucketCdnPolicyBypassCacheOnRequestHeader,
    BackendBucketCdnPolicyNegativeCachingPolicy,
    BackendBucketList,
    BackendService,
    BackendServiceAggregatedList,
    BackendServiceCdnPolicy,
    BackendServiceCdnPolicyBypassCacheOnRequestHeader,
    BackendServiceCdnPolicyNegativeCachingPolicy,
    BackendServiceFailoverPolicy,
    BackendServiceGroupHealth,
    BackendServiceIAP,
    BackendServiceList,
    BackendServiceLogConfig,
    BackendServiceReference,
    BackendServicesScopedList,
    Binding,
    BulkInsertInstanceRequest,
    BulkInsertInstanceResource,
    BulkInsertInstanceResourcePerInstanceProperties,
    BulkInsertRegionInstanceRequest,
    CacheInvalidationRule,
    CacheKeyPolicy,
    CircuitBreakers,
    CloneRulesFirewallPolicyRequest,
    Commitment,
    CommitmentAggregatedList,
    CommitmentList,
    CommitmentsScopedList,
    Condition,
    ConfidentialInstanceConfig,
    ConnectionDraining,
    ConsistentHashLoadBalancerSettings,
    ConsistentHashLoadBalancerSettingsHttpCookie,
    CorsPolicy,
    CreateInstancesInstanceGroupManagerRequest,
    CreateInstancesRegionInstanceGroupManagerRequest,
    CreateSnapshotDiskRequest,
    CreateSnapshotRegionDiskRequest,
    CustomerEncryptionKey,
    CustomerEncryptionKeyProtectedDisk,
    Data,
    DeleteAccessConfigInstanceRequest,
    DeleteAddressRequest,
    DeleteAutoscalerRequest,
    DeleteBackendBucketRequest,
    DeleteBackendServiceRequest,
    DeleteDiskRequest,
    DeleteExternalVpnGatewayRequest,
    DeleteFirewallPolicyRequest,
    DeleteFirewallRequest,
    DeleteForwardingRuleRequest,
    DeleteGlobalAddressRequest,
    DeleteGlobalForwardingRuleRequest,
    DeleteGlobalNetworkEndpointGroupRequest,
    DeleteGlobalOperationRequest,
    DeleteGlobalOperationResponse,
    DeleteGlobalOrganizationOperationRequest,
    DeleteGlobalOrganizationOperationResponse,
    DeleteGlobalPublicDelegatedPrefixeRequest,
    DeleteHealthCheckRequest,
    DeleteImageRequest,
    DeleteInstanceGroupManagerRequest,
    DeleteInstanceGroupRequest,
    DeleteInstanceRequest,
    DeleteInstancesInstanceGroupManagerRequest,
    DeleteInstancesRegionInstanceGroupManagerRequest,
    DeleteInstanceTemplateRequest,
    DeleteInterconnectAttachmentRequest,
    DeleteInterconnectRequest,
    DeleteLicenseRequest,
    DeleteNetworkEndpointGroupRequest,
    DeleteNetworkRequest,
    DeleteNodeGroupRequest,
    DeleteNodesNodeGroupRequest,
    DeleteNodeTemplateRequest,
    DeletePacketMirroringRequest,
    DeletePerInstanceConfigsInstanceGroupManagerRequest,
    DeletePerInstanceConfigsRegionInstanceGroupManagerRequest,
    DeletePublicAdvertisedPrefixeRequest,
    DeletePublicDelegatedPrefixeRequest,
    DeleteRegionAutoscalerRequest,
    DeleteRegionBackendServiceRequest,
    DeleteRegionDiskRequest,
    DeleteRegionHealthCheckRequest,
    DeleteRegionHealthCheckServiceRequest,
    DeleteRegionInstanceGroupManagerRequest,
    DeleteRegionNetworkEndpointGroupRequest,
    DeleteRegionNotificationEndpointRequest,
    DeleteRegionOperationRequest,
    DeleteRegionOperationResponse,
    DeleteRegionSslCertificateRequest,
    DeleteRegionTargetHttpProxyRequest,
    DeleteRegionTargetHttpsProxyRequest,
    DeleteRegionUrlMapRequest,
    DeleteReservationRequest,
    DeleteResourcePolicyRequest,
    DeleteRouteRequest,
    DeleteRouterRequest,
    DeleteSecurityPolicyRequest,
    DeleteServiceAttachmentRequest,
    DeleteSignedUrlKeyBackendBucketRequest,
    DeleteSignedUrlKeyBackendServiceRequest,
    DeleteSnapshotRequest,
    DeleteSslCertificateRequest,
    DeleteSslPolicyRequest,
    DeleteSubnetworkRequest,
    DeleteTargetGrpcProxyRequest,
    DeleteTargetHttpProxyRequest,
    DeleteTargetHttpsProxyRequest,
    DeleteTargetInstanceRequest,
    DeleteTargetPoolRequest,
    DeleteTargetSslProxyRequest,
    DeleteTargetTcpProxyRequest,
    DeleteTargetVpnGatewayRequest,
    DeleteUrlMapRequest,
    DeleteVpnGatewayRequest,
    DeleteVpnTunnelRequest,
    DeleteZoneOperationRequest,
    DeleteZoneOperationResponse,
    Denied,
    DeprecateImageRequest,
    DeprecationStatus,
    DetachDiskInstanceRequest,
    DetachNetworkEndpointsGlobalNetworkEndpointGroupRequest,
    DetachNetworkEndpointsNetworkEndpointGroupRequest,
    DisableXpnHostProjectRequest,
    DisableXpnResourceProjectRequest,
    Disk,
    DiskAggregatedList,
    DiskInstantiationConfig,
    DiskList,
    DiskMoveRequest,
    DisksAddResourcePoliciesRequest,
    DisksRemoveResourcePoliciesRequest,
    DisksResizeRequest,
    DisksScopedList,
    DiskType,
    DiskTypeAggregatedList,
    DiskTypeList,
    DiskTypesScopedList,
    DisplayDevice,
    DistributionPolicy,
    DistributionPolicyZoneConfiguration,
    Duration,
    EnableXpnHostProjectRequest,
    EnableXpnResourceProjectRequest,
    Error,
    Errors,
    ExchangedPeeringRoute,
    ExchangedPeeringRoutesList,
    ExpandIpCidrRangeSubnetworkRequest,
    Expr,
    ExternalVpnGateway,
    ExternalVpnGatewayInterface,
    ExternalVpnGatewayList,
    FileContentBuffer,
    Firewall,
    FirewallList,
    FirewallLogConfig,
    FirewallPoliciesListAssociationsResponse,
    FirewallPolicy,
    FirewallPolicyAssociation,
    FirewallPolicyList,
    FirewallPolicyRule,
    FirewallPolicyRuleMatcher,
    FirewallPolicyRuleMatcherLayer4Config,
    FixedOrPercent,
    ForwardingRule,
    ForwardingRuleAggregatedList,
    ForwardingRuleList,
    ForwardingRuleReference,
    ForwardingRuleServiceDirectoryRegistration,
    ForwardingRulesScopedList,
    GetAcceleratorTypeRequest,
    GetAddressRequest,
    GetAssociationFirewallPolicyRequest,
    GetAutoscalerRequest,
    GetBackendBucketRequest,
    GetBackendServiceRequest,
    GetDiagnosticsInterconnectRequest,
    GetDiskRequest,
    GetDiskTypeRequest,
    GetEffectiveFirewallsInstanceRequest,
    GetEffectiveFirewallsNetworkRequest,
    GetExternalVpnGatewayRequest,
    GetFirewallPolicyRequest,
    GetFirewallRequest,
    GetForwardingRuleRequest,
    GetFromFamilyImageRequest,
    GetGlobalAddressRequest,
    GetGlobalForwardingRuleRequest,
    GetGlobalNetworkEndpointGroupRequest,
    GetGlobalOperationRequest,
    GetGlobalOrganizationOperationRequest,
    GetGlobalPublicDelegatedPrefixeRequest,
    GetGuestAttributesInstanceRequest,
    GetHealthBackendServiceRequest,
    GetHealthCheckRequest,
    GetHealthRegionBackendServiceRequest,
    GetHealthTargetPoolRequest,
    GetIamPolicyDiskRequest,
    GetIamPolicyFirewallPolicyRequest,
    GetIamPolicyImageRequest,
    GetIamPolicyInstanceRequest,
    GetIamPolicyInstanceTemplateRequest,
    GetIamPolicyLicenseRequest,
    GetIamPolicyNodeGroupRequest,
    GetIamPolicyNodeTemplateRequest,
    GetIamPolicyRegionDiskRequest,
    GetIamPolicyReservationRequest,
    GetIamPolicyResourcePolicyRequest,
    GetIamPolicyServiceAttachmentRequest,
    GetIamPolicySnapshotRequest,
    GetIamPolicySubnetworkRequest,
    GetImageFamilyViewRequest,
    GetImageRequest,
    GetInstanceGroupManagerRequest,
    GetInstanceGroupRequest,
    GetInstanceRequest,
    GetInstanceTemplateRequest,
    GetInterconnectAttachmentRequest,
    GetInterconnectLocationRequest,
    GetInterconnectRequest,
    GetLicenseCodeRequest,
    GetLicenseRequest,
    GetMachineTypeRequest,
    GetNatMappingInfoRoutersRequest,
    GetNetworkEndpointGroupRequest,
    GetNetworkRequest,
    GetNodeGroupRequest,
    GetNodeTemplateRequest,
    GetNodeTypeRequest,
    GetPacketMirroringRequest,
    GetProjectRequest,
    GetPublicAdvertisedPrefixeRequest,
    GetPublicDelegatedPrefixeRequest,
    GetRegionAutoscalerRequest,
    GetRegionBackendServiceRequest,
    GetRegionCommitmentRequest,
    GetRegionDiskRequest,
    GetRegionDiskTypeRequest,
    GetRegionHealthCheckRequest,
    GetRegionHealthCheckServiceRequest,
    GetRegionInstanceGroupManagerRequest,
    GetRegionInstanceGroupRequest,
    GetRegionNetworkEndpointGroupRequest,
    GetRegionNotificationEndpointRequest,
    GetRegionOperationRequest,
    GetRegionRequest,
    GetRegionSslCertificateRequest,
    GetRegionTargetHttpProxyRequest,
    GetRegionTargetHttpsProxyRequest,
    GetRegionUrlMapRequest,
    GetReservationRequest,
    GetResourcePolicyRequest,
    GetRouteRequest,
    GetRouterRequest,
    GetRouterStatusRouterRequest,
    GetRuleFirewallPolicyRequest,
    GetRuleSecurityPolicyRequest,
    GetScreenshotInstanceRequest,
    GetSecurityPolicyRequest,
    GetSerialPortOutputInstanceRequest,
    GetServiceAttachmentRequest,
    GetShieldedInstanceIdentityInstanceRequest,
    GetSnapshotRequest,
    GetSslCertificateRequest,
    GetSslPolicyRequest,
    GetStatusVpnGatewayRequest,
    GetSubnetworkRequest,
    GetTargetGrpcProxyRequest,
    GetTargetHttpProxyRequest,
    GetTargetHttpsProxyRequest,
    GetTargetInstanceRequest,
    GetTargetPoolRequest,
    GetTargetSslProxyRequest,
    GetTargetTcpProxyRequest,
    GetTargetVpnGatewayRequest,
    GetUrlMapRequest,
    GetVpnGatewayRequest,
    GetVpnTunnelRequest,
    GetXpnHostProjectRequest,
    GetXpnResourcesProjectsRequest,
    GetZoneOperationRequest,
    GetZoneRequest,
    GlobalNetworkEndpointGroupsAttachEndpointsRequest,
    GlobalNetworkEndpointGroupsDetachEndpointsRequest,
    GlobalOrganizationSetPolicyRequest,
    GlobalSetLabelsRequest,
    GlobalSetPolicyRequest,
    GRPCHealthCheck,
    GuestAttributes,
    GuestAttributesEntry,
    GuestAttributesValue,
    GuestOsFeature,
    HealthCheck,
    HealthCheckList,
    HealthCheckLogConfig,
    HealthCheckReference,
    HealthChecksAggregatedList,
    HealthCheckService,
    HealthCheckServiceReference,
    HealthCheckServicesList,
    HealthChecksScopedList,
    HealthStatus,
    HealthStatusForNetworkEndpoint,
    HostRule,
    HTTP2HealthCheck,
    HttpFaultAbort,
    HttpFaultDelay,
    HttpFaultInjection,
    HttpHeaderAction,
    HttpHeaderMatch,
    HttpHeaderOption,
    HTTPHealthCheck,
    HttpQueryParameterMatch,
    HttpRedirectAction,
    HttpRetryPolicy,
    HttpRouteAction,
    HttpRouteRule,
    HttpRouteRuleMatch,
    HTTPSHealthCheck,
    Image,
    ImageFamilyView,
    ImageList,
    InitialStateConfig,
    InsertAddressRequest,
    InsertAutoscalerRequest,
    InsertBackendBucketRequest,
    InsertBackendServiceRequest,
    InsertDiskRequest,
    InsertExternalVpnGatewayRequest,
    InsertFirewallPolicyRequest,
    InsertFirewallRequest,
    InsertForwardingRuleRequest,
    InsertGlobalAddressRequest,
    InsertGlobalForwardingRuleRequest,
    InsertGlobalNetworkEndpointGroupRequest,
    InsertGlobalPublicDelegatedPrefixeRequest,
    InsertHealthCheckRequest,
    InsertImageRequest,
    InsertInstanceGroupManagerRequest,
    InsertInstanceGroupRequest,
    InsertInstanceRequest,
    InsertInstanceTemplateRequest,
    InsertInterconnectAttachmentRequest,
    InsertInterconnectRequest,
    InsertLicenseRequest,
    InsertNetworkEndpointGroupRequest,
    InsertNetworkRequest,
    InsertNodeGroupRequest,
    InsertNodeTemplateRequest,
    InsertPacketMirroringRequest,
    InsertPublicAdvertisedPrefixeRequest,
    InsertPublicDelegatedPrefixeRequest,
    InsertRegionAutoscalerRequest,
    InsertRegionBackendServiceRequest,
    InsertRegionCommitmentRequest,
    InsertRegionDiskRequest,
    InsertRegionHealthCheckRequest,
    InsertRegionHealthCheckServiceRequest,
    InsertRegionInstanceGroupManagerRequest,
    InsertRegionNetworkEndpointGroupRequest,
    InsertRegionNotificationEndpointRequest,
    InsertRegionSslCertificateRequest,
    InsertRegionTargetHttpProxyRequest,
    InsertRegionTargetHttpsProxyRequest,
    InsertRegionUrlMapRequest,
    InsertReservationRequest,
    InsertResourcePolicyRequest,
    InsertRouteRequest,
    InsertRouterRequest,
    InsertSecurityPolicyRequest,
    InsertServiceAttachmentRequest,
    InsertSslCertificateRequest,
    InsertSslPolicyRequest,
    InsertSubnetworkRequest,
    InsertTargetGrpcProxyRequest,
    InsertTargetHttpProxyRequest,
    InsertTargetHttpsProxyRequest,
    InsertTargetInstanceRequest,
    InsertTargetPoolRequest,
    InsertTargetSslProxyRequest,
    InsertTargetTcpProxyRequest,
    InsertTargetVpnGatewayRequest,
    InsertUrlMapRequest,
    InsertVpnGatewayRequest,
    InsertVpnTunnelRequest,
    Instance,
    InstanceAggregatedList,
    InstanceGroup,
    InstanceGroupAggregatedList,
    InstanceGroupList,
    InstanceGroupManager,
    InstanceGroupManagerActionsSummary,
    InstanceGroupManagerAggregatedList,
    InstanceGroupManagerAutoHealingPolicy,
    InstanceGroupManagerList,
    InstanceGroupManagersAbandonInstancesRequest,
    InstanceGroupManagersApplyUpdatesRequest,
    InstanceGroupManagersCreateInstancesRequest,
    InstanceGroupManagersDeleteInstancesRequest,
    InstanceGroupManagersDeletePerInstanceConfigsReq,
    InstanceGroupManagersListErrorsResponse,
    InstanceGroupManagersListManagedInstancesResponse,
    InstanceGroupManagersListPerInstanceConfigsResp,
    InstanceGroupManagersPatchPerInstanceConfigsReq,
    InstanceGroupManagersRecreateInstancesRequest,
    InstanceGroupManagersScopedList,
    InstanceGroupManagersSetInstanceTemplateRequest,
    InstanceGroupManagersSetTargetPoolsRequest,
    InstanceGroupManagerStatus,
    InstanceGroupManagerStatusStateful,
    InstanceGroupManagerStatusStatefulPerInstanceConfigs,
    InstanceGroupManagerStatusVersionTarget,
    InstanceGroupManagersUpdatePerInstanceConfigsReq,
    InstanceGroupManagerUpdatePolicy,
    InstanceGroupManagerVersion,
    InstanceGroupsAddInstancesRequest,
    InstanceGroupsListInstances,
    InstanceGroupsListInstancesRequest,
    InstanceGroupsRemoveInstancesRequest,
    InstanceGroupsScopedList,
    InstanceGroupsSetNamedPortsRequest,
    InstanceList,
    InstanceListReferrers,
    InstanceManagedByIgmError,
    InstanceManagedByIgmErrorInstanceActionDetails,
    InstanceManagedByIgmErrorManagedInstanceError,
    InstanceMoveRequest,
    InstanceProperties,
    InstanceReference,
    InstancesAddResourcePoliciesRequest,
    InstancesGetEffectiveFirewallsResponse,
    InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy,
    InstancesRemoveResourcePoliciesRequest,
    InstancesScopedList,
    InstancesSetLabelsRequest,
    InstancesSetMachineResourcesRequest,
    InstancesSetMachineTypeRequest,
    InstancesSetMinCpuPlatformRequest,
    InstancesSetServiceAccountRequest,
    InstancesStartWithEncryptionKeyRequest,
    InstanceTemplate,
    InstanceTemplateList,
    InstanceWithNamedPorts,
    Int64RangeMatch,
    Interconnect,
    InterconnectAttachment,
    InterconnectAttachmentAggregatedList,
    InterconnectAttachmentList,
    InterconnectAttachmentPartnerMetadata,
    InterconnectAttachmentPrivateInfo,
    InterconnectAttachmentsScopedList,
    InterconnectCircuitInfo,
    InterconnectDiagnostics,
    InterconnectDiagnosticsARPEntry,
    InterconnectDiagnosticsLinkLACPStatus,
    InterconnectDiagnosticsLinkOpticalPower,
    InterconnectDiagnosticsLinkStatus,
    InterconnectList,
    InterconnectLocation,
    InterconnectLocationList,
    InterconnectLocationRegionInfo,
    InterconnectOutageNotification,
    InterconnectsGetDiagnosticsResponse,
    InvalidateCacheUrlMapRequest,
    Items,
    License,
    LicenseCode,
    LicenseCodeLicenseAlias,
    LicenseResourceCommitment,
    LicenseResourceRequirements,
    LicensesListResponse,
    ListAcceleratorTypesRequest,
    ListAddressesRequest,
    ListAssociationsFirewallPolicyRequest,
    ListAutoscalersRequest,
    ListAvailableFeaturesSslPoliciesRequest,
    ListBackendBucketsRequest,
    ListBackendServicesRequest,
    ListDisksRequest,
    ListDiskTypesRequest,
    ListErrorsInstanceGroupManagersRequest,
    ListErrorsRegionInstanceGroupManagersRequest,
    ListExternalVpnGatewaysRequest,
    ListFirewallPoliciesRequest,
    ListFirewallsRequest,
    ListForwardingRulesRequest,
    ListGlobalAddressesRequest,
    ListGlobalForwardingRulesRequest,
    ListGlobalNetworkEndpointGroupsRequest,
    ListGlobalOperationsRequest,
    ListGlobalOrganizationOperationsRequest,
    ListGlobalPublicDelegatedPrefixesRequest,
    ListHealthChecksRequest,
    ListImagesRequest,
    ListInstanceGroupManagersRequest,
    ListInstanceGroupsRequest,
    ListInstancesInstanceGroupsRequest,
    ListInstancesRegionInstanceGroupsRequest,
    ListInstancesRequest,
    ListInstanceTemplatesRequest,
    ListInterconnectAttachmentsRequest,
    ListInterconnectLocationsRequest,
    ListInterconnectsRequest,
    ListLicensesRequest,
    ListMachineTypesRequest,
    ListManagedInstancesInstanceGroupManagersRequest,
    ListManagedInstancesRegionInstanceGroupManagersRequest,
    ListNetworkEndpointGroupsRequest,
    ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest,
    ListNetworkEndpointsNetworkEndpointGroupsRequest,
    ListNetworksRequest,
    ListNodeGroupsRequest,
    ListNodesNodeGroupsRequest,
    ListNodeTemplatesRequest,
    ListNodeTypesRequest,
    ListPacketMirroringsRequest,
    ListPeeringRoutesNetworksRequest,
    ListPerInstanceConfigsInstanceGroupManagersRequest,
    ListPerInstanceConfigsRegionInstanceGroupManagersRequest,
    ListPreconfiguredExpressionSetsSecurityPoliciesRequest,
    ListPublicAdvertisedPrefixesRequest,
    ListPublicDelegatedPrefixesRequest,
    ListReferrersInstancesRequest,
    ListRegionAutoscalersRequest,
    ListRegionBackendServicesRequest,
    ListRegionCommitmentsRequest,
    ListRegionDisksRequest,
    ListRegionDiskTypesRequest,
    ListRegionHealthCheckServicesRequest,
    ListRegionHealthChecksRequest,
    ListRegionInstanceGroupManagersRequest,
    ListRegionInstanceGroupsRequest,
    ListRegionNetworkEndpointGroupsRequest,
    ListRegionNotificationEndpointsRequest,
    ListRegionOperationsRequest,
    ListRegionsRequest,
    ListRegionSslCertificatesRequest,
    ListRegionTargetHttpProxiesRequest,
    ListRegionTargetHttpsProxiesRequest,
    ListRegionUrlMapsRequest,
    ListReservationsRequest,
    ListResourcePoliciesRequest,
    ListRoutersRequest,
    ListRoutesRequest,
    ListSecurityPoliciesRequest,
    ListServiceAttachmentsRequest,
    ListSnapshotsRequest,
    ListSslCertificatesRequest,
    ListSslPoliciesRequest,
    ListSubnetworksRequest,
    ListTargetGrpcProxiesRequest,
    ListTargetHttpProxiesRequest,
    ListTargetHttpsProxiesRequest,
    ListTargetInstancesRequest,
    ListTargetPoolsRequest,
    ListTargetSslProxiesRequest,
    ListTargetTcpProxiesRequest,
    ListTargetVpnGatewaysRequest,
    ListUrlMapsRequest,
    ListUsableSubnetworksRequest,
    ListVpnGatewaysRequest,
    ListVpnTunnelsRequest,
    ListXpnHostsProjectsRequest,
    ListZoneOperationsRequest,
    ListZonesRequest,
    LocalDisk,
    LocationPolicy,
    LocationPolicyLocation,
    LogConfig,
    LogConfigCloudAuditOptions,
    LogConfigCounterOptions,
    LogConfigCounterOptionsCustomField,
    LogConfigDataAccessOptions,
    MachineType,
    MachineTypeAggregatedList,
    MachineTypeList,
    MachineTypesScopedList,
    ManagedInstance,
    ManagedInstanceInstanceHealth,
    ManagedInstanceLastAttempt,
    ManagedInstanceVersion,
    Metadata,
    MetadataFilter,
    MetadataFilterLabelMatch,
    MoveDiskProjectRequest,
    MoveFirewallPolicyRequest,
    MoveInstanceProjectRequest,
    NamedPort,
    Network,
    NetworkEndpoint,
    NetworkEndpointGroup,
    NetworkEndpointGroupAggregatedList,
    NetworkEndpointGroupAppEngine,
    NetworkEndpointGroupCloudFunction,
    NetworkEndpointGroupCloudRun,
    NetworkEndpointGroupList,
    NetworkEndpointGroupsAttachEndpointsRequest,
    NetworkEndpointGroupsDetachEndpointsRequest,
    NetworkEndpointGroupsListEndpointsRequest,
    NetworkEndpointGroupsListNetworkEndpoints,
    NetworkEndpointGroupsScopedList,
    NetworkEndpointWithHealthStatus,
    NetworkInterface,
    NetworkList,
    NetworkPeering,
    NetworkRoutingConfig,
    NetworksAddPeeringRequest,
    NetworksGetEffectiveFirewallsResponse,
    NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy,
    NetworksRemovePeeringRequest,
    NetworksUpdatePeeringRequest,
    NodeGroup,
    NodeGroupAggregatedList,
    NodeGroupAutoscalingPolicy,
    NodeGroupList,
    NodeGroupMaintenanceWindow,
    NodeGroupNode,
    NodeGroupsAddNodesRequest,
    NodeGroupsDeleteNodesRequest,
    NodeGroupsListNodes,
    NodeGroupsScopedList,
    NodeGroupsSetNodeTemplateRequest,
    NodeTemplate,
    NodeTemplateAggregatedList,
    NodeTemplateList,
    NodeTemplateNodeTypeFlexibility,
    NodeTemplatesScopedList,
    NodeType,
    NodeTypeAggregatedList,
    NodeTypeList,
    NodeTypesScopedList,
    NotificationEndpoint,
    NotificationEndpointGrpcSettings,
    NotificationEndpointList,
    Operation,
    OperationAggregatedList,
    OperationList,
    OperationsScopedList,
    OutlierDetection,
    PacketMirroring,
    PacketMirroringAggregatedList,
    PacketMirroringFilter,
    PacketMirroringForwardingRuleInfo,
    PacketMirroringList,
    PacketMirroringMirroredResourceInfo,
    PacketMirroringMirroredResourceInfoInstanceInfo,
    PacketMirroringMirroredResourceInfoSubnetInfo,
    PacketMirroringNetworkInfo,
    PacketMirroringsScopedList,
    PatchAutoscalerRequest,
    PatchBackendBucketRequest,
    PatchBackendServiceRequest,
    PatchFirewallPolicyRequest,
    PatchFirewallRequest,
    PatchForwardingRuleRequest,
    PatchGlobalForwardingRuleRequest,
    PatchGlobalPublicDelegatedPrefixeRequest,
    PatchHealthCheckRequest,
    PatchImageRequest,
    PatchInstanceGroupManagerRequest,
    PatchInterconnectAttachmentRequest,
    PatchInterconnectRequest,
    PatchNetworkRequest,
    PatchNodeGroupRequest,
    PatchPacketMirroringRequest,
    PatchPerInstanceConfigsInstanceGroupManagerRequest,
    PatchPerInstanceConfigsRegionInstanceGroupManagerRequest,
    PatchPublicAdvertisedPrefixeRequest,
    PatchPublicDelegatedPrefixeRequest,
    PatchRegionAutoscalerRequest,
    PatchRegionBackendServiceRequest,
    PatchRegionHealthCheckRequest,
    PatchRegionHealthCheckServiceRequest,
    PatchRegionInstanceGroupManagerRequest,
    PatchRegionUrlMapRequest,
    PatchRouterRequest,
    PatchRuleFirewallPolicyRequest,
    PatchRuleSecurityPolicyRequest,
    PatchSecurityPolicyRequest,
    PatchServiceAttachmentRequest,
    PatchSslPolicyRequest,
    PatchSubnetworkRequest,
    PatchTargetGrpcProxyRequest,
    PatchTargetHttpProxyRequest,
    PatchTargetHttpsProxyRequest,
    PatchUrlMapRequest,
    PathMatcher,
    PathRule,
    PerInstanceConfig,
    Policy,
    PreconfiguredWafSet,
    PreservedState,
    PreservedStatePreservedDisk,
    PreviewRouterRequest,
    Project,
    ProjectsDisableXpnResourceRequest,
    ProjectsEnableXpnResourceRequest,
    ProjectsGetXpnResources,
    ProjectsListXpnHostsRequest,
    ProjectsSetDefaultNetworkTierRequest,
    PublicAdvertisedPrefix,
    PublicAdvertisedPrefixList,
    PublicAdvertisedPrefixPublicDelegatedPrefix,
    PublicDelegatedPrefix,
    PublicDelegatedPrefixAggregatedList,
    PublicDelegatedPrefixesScopedList,
    PublicDelegatedPrefixList,
    PublicDelegatedPrefixPublicDelegatedSubPrefix,
    Quota,
    RawDisk,
    RecreateInstancesInstanceGroupManagerRequest,
    RecreateInstancesRegionInstanceGroupManagerRequest,
    Reference,
    Region,
    RegionAutoscalerList,
    RegionDisksAddResourcePoliciesRequest,
    RegionDisksRemoveResourcePoliciesRequest,
    RegionDisksResizeRequest,
    RegionDiskTypeList,
    RegionInstanceGroupList,
    RegionInstanceGroupManagerDeleteInstanceConfigReq,
    RegionInstanceGroupManagerList,
    RegionInstanceGroupManagerPatchInstanceConfigReq,
    RegionInstanceGroupManagersAbandonInstancesRequest,
    RegionInstanceGroupManagersApplyUpdatesRequest,
    RegionInstanceGroupManagersCreateInstancesRequest,
    RegionInstanceGroupManagersDeleteInstancesRequest,
    RegionInstanceGroupManagersListErrorsResponse,
    RegionInstanceGroupManagersListInstanceConfigsResp,
    RegionInstanceGroupManagersListInstancesResponse,
    RegionInstanceGroupManagersRecreateRequest,
    RegionInstanceGroupManagersSetTargetPoolsRequest,
    RegionInstanceGroupManagersSetTemplateRequest,
    RegionInstanceGroupManagerUpdateInstanceConfigReq,
    RegionInstanceGroupsListInstances,
    RegionInstanceGroupsListInstancesRequest,
    RegionInstanceGroupsSetNamedPortsRequest,
    RegionList,
    RegionSetLabelsRequest,
    RegionSetPolicyRequest,
    RegionTargetHttpsProxiesSetSslCertificatesRequest,
    RegionUrlMapsValidateRequest,
    RemoveAssociationFirewallPolicyRequest,
    RemoveHealthCheckTargetPoolRequest,
    RemoveInstancesInstanceGroupRequest,
    RemoveInstanceTargetPoolRequest,
    RemovePeeringNetworkRequest,
    RemoveResourcePoliciesDiskRequest,
    RemoveResourcePoliciesInstanceRequest,
    RemoveResourcePoliciesRegionDiskRequest,
    RemoveRuleFirewallPolicyRequest,
    RemoveRuleSecurityPolicyRequest,
    RequestMirrorPolicy,
    Reservation,
    ReservationAffinity,
    ReservationAggregatedList,
    ReservationList,
    ReservationsResizeRequest,
    ReservationsScopedList,
    ResetInstanceRequest,
    ResizeDiskRequest,
    ResizeInstanceGroupManagerRequest,
    ResizeRegionDiskRequest,
    ResizeRegionInstanceGroupManagerRequest,
    ResizeReservationRequest,
    ResourceCommitment,
    ResourceGroupReference,
    ResourcePoliciesScopedList,
    ResourcePolicy,
    ResourcePolicyAggregatedList,
    ResourcePolicyDailyCycle,
    ResourcePolicyGroupPlacementPolicy,
    ResourcePolicyHourlyCycle,
    ResourcePolicyInstanceSchedulePolicy,
    ResourcePolicyInstanceSchedulePolicySchedule,
    ResourcePolicyList,
    ResourcePolicyResourceStatus,
    ResourcePolicyResourceStatusInstanceSchedulePolicyStatus,
    ResourcePolicySnapshotSchedulePolicy,
    ResourcePolicySnapshotSchedulePolicyRetentionPolicy,
    ResourcePolicySnapshotSchedulePolicySchedule,
    ResourcePolicySnapshotSchedulePolicySnapshotProperties,
    ResourcePolicyWeeklyCycle,
    ResourcePolicyWeeklyCycleDayOfWeek,
    Route,
    RouteAsPath,
    RouteList,
    Router,
    RouterAdvertisedIpRange,
    RouterAggregatedList,
    RouterBgp,
    RouterBgpPeer,
    RouterBgpPeerBfd,
    RouterInterface,
    RouterList,
    RouterNat,
    RouterNatLogConfig,
    RouterNatRule,
    RouterNatRuleAction,
    RouterNatSubnetworkToNat,
    RoutersPreviewResponse,
    RoutersScopedList,
    RouterStatus,
    RouterStatusBgpPeerStatus,
    RouterStatusNatStatus,
    RouterStatusNatStatusNatRuleStatus,
    RouterStatusResponse,
    Rule,
    ScalingScheduleStatus,
    Scheduling,
    SchedulingNodeAffinity,
    ScratchDisks,
    Screenshot,
    SecurityPoliciesListPreconfiguredExpressionSetsResponse,
    SecurityPoliciesWafConfig,
    SecurityPolicy,
    SecurityPolicyAdaptiveProtectionConfig,
    SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig,
    SecurityPolicyAdvancedOptionsConfig,
    SecurityPolicyList,
    SecurityPolicyReference,
    SecurityPolicyRule,
    SecurityPolicyRuleMatcher,
    SecurityPolicyRuleMatcherConfig,
    SecuritySettings,
    SendDiagnosticInterruptInstanceRequest,
    SendDiagnosticInterruptInstanceResponse,
    SerialPortOutput,
    ServerBinding,
    ServiceAccount,
    ServiceAttachment,
    ServiceAttachmentAggregatedList,
    ServiceAttachmentConnectedEndpoint,
    ServiceAttachmentConsumerProjectLimit,
    ServiceAttachmentList,
    ServiceAttachmentsScopedList,
    SetBackendServiceTargetSslProxyRequest,
    SetBackendServiceTargetTcpProxyRequest,
    SetBackupTargetPoolRequest,
    SetCommonInstanceMetadataProjectRequest,
    SetDefaultNetworkTierProjectRequest,
    SetDeletionProtectionInstanceRequest,
    SetDiskAutoDeleteInstanceRequest,
    SetIamPolicyDiskRequest,
    SetIamPolicyFirewallPolicyRequest,
    SetIamPolicyImageRequest,
    SetIamPolicyInstanceRequest,
    SetIamPolicyInstanceTemplateRequest,
    SetIamPolicyLicenseRequest,
    SetIamPolicyNodeGroupRequest,
    SetIamPolicyNodeTemplateRequest,
    SetIamPolicyRegionDiskRequest,
    SetIamPolicyReservationRequest,
    SetIamPolicyResourcePolicyRequest,
    SetIamPolicyServiceAttachmentRequest,
    SetIamPolicySnapshotRequest,
    SetIamPolicySubnetworkRequest,
    SetInstanceTemplateInstanceGroupManagerRequest,
    SetInstanceTemplateRegionInstanceGroupManagerRequest,
    SetLabelsDiskRequest,
    SetLabelsExternalVpnGatewayRequest,
    SetLabelsForwardingRuleRequest,
    SetLabelsGlobalForwardingRuleRequest,
    SetLabelsImageRequest,
    SetLabelsInstanceRequest,
    SetLabelsRegionDiskRequest,
    SetLabelsSnapshotRequest,
    SetLabelsVpnGatewayRequest,
    SetMachineResourcesInstanceRequest,
    SetMachineTypeInstanceRequest,
    SetMetadataInstanceRequest,
    SetMinCpuPlatformInstanceRequest,
    SetNamedPortsInstanceGroupRequest,
    SetNamedPortsRegionInstanceGroupRequest,
    SetNodeTemplateNodeGroupRequest,
    SetPrivateIpGoogleAccessSubnetworkRequest,
    SetProxyHeaderTargetSslProxyRequest,
    SetProxyHeaderTargetTcpProxyRequest,
    SetQuicOverrideTargetHttpsProxyRequest,
    SetSchedulingInstanceRequest,
    SetSecurityPolicyBackendServiceRequest,
    SetServiceAccountInstanceRequest,
    SetShieldedInstanceIntegrityPolicyInstanceRequest,
    SetSslCertificatesRegionTargetHttpsProxyRequest,
    SetSslCertificatesTargetHttpsProxyRequest,
    SetSslCertificatesTargetSslProxyRequest,
    SetSslPolicyTargetHttpsProxyRequest,
    SetSslPolicyTargetSslProxyRequest,
    SetTagsInstanceRequest,
    SetTargetForwardingRuleRequest,
    SetTargetGlobalForwardingRuleRequest,
    SetTargetPoolsInstanceGroupManagerRequest,
    SetTargetPoolsRegionInstanceGroupManagerRequest,
    SetUrlMapRegionTargetHttpProxyRequest,
    SetUrlMapRegionTargetHttpsProxyRequest,
    SetUrlMapTargetHttpProxyRequest,
    SetUrlMapTargetHttpsProxyRequest,
    SetUsageExportBucketProjectRequest,
    ShieldedInstanceConfig,
    ShieldedInstanceIdentity,
    ShieldedInstanceIdentityEntry,
    ShieldedInstanceIntegrityPolicy,
    SignedUrlKey,
    SimulateMaintenanceEventInstanceRequest,
    Snapshot,
    SnapshotList,
    SourceInstanceParams,
    SslCertificate,
    SslCertificateAggregatedList,
    SslCertificateList,
    SslCertificateManagedSslCertificate,
    SslCertificateSelfManagedSslCertificate,
    SslCertificatesScopedList,
    SSLHealthCheck,
    SslPoliciesList,
    SslPoliciesListAvailableFeaturesResponse,
    SslPolicy,
    SslPolicyReference,
    StartInstanceRequest,
    StartWithEncryptionKeyInstanceRequest,
    StatefulPolicy,
    StatefulPolicyPreservedState,
    StatefulPolicyPreservedStateDiskDevice,
    StopInstanceRequest,
    Subnetwork,
    SubnetworkAggregatedList,
    SubnetworkList,
    SubnetworkLogConfig,
    SubnetworkSecondaryRange,
    SubnetworksExpandIpCidrRangeRequest,
    SubnetworksScopedList,
    SubnetworksSetPrivateIpGoogleAccessRequest,
    Subsetting,
    SwitchToCustomModeNetworkRequest,
    Tags,
    TargetGrpcProxy,
    TargetGrpcProxyList,
    TargetHttpProxiesScopedList,
    TargetHttpProxy,
    TargetHttpProxyAggregatedList,
    TargetHttpProxyList,
    TargetHttpsProxiesScopedList,
    TargetHttpsProxiesSetQuicOverrideRequest,
    TargetHttpsProxiesSetSslCertificatesRequest,
    TargetHttpsProxy,
    TargetHttpsProxyAggregatedList,
    TargetHttpsProxyList,
    TargetInstance,
    TargetInstanceAggregatedList,
    TargetInstanceList,
    TargetInstancesScopedList,
    TargetPool,
    TargetPoolAggregatedList,
    TargetPoolInstanceHealth,
    TargetPoolList,
    TargetPoolsAddHealthCheckRequest,
    TargetPoolsAddInstanceRequest,
    TargetPoolsRemoveHealthCheckRequest,
    TargetPoolsRemoveInstanceRequest,
    TargetPoolsScopedList,
    TargetReference,
    TargetSslProxiesSetBackendServiceRequest,
    TargetSslProxiesSetProxyHeaderRequest,
    TargetSslProxiesSetSslCertificatesRequest,
    TargetSslProxy,
    TargetSslProxyList,
    TargetTcpProxiesSetBackendServiceRequest,
    TargetTcpProxiesSetProxyHeaderRequest,
    TargetTcpProxy,
    TargetTcpProxyList,
    TargetVpnGateway,
    TargetVpnGatewayAggregatedList,
    TargetVpnGatewayList,
    TargetVpnGatewaysScopedList,
    TCPHealthCheck,
    TestFailure,
    TestIamPermissionsDiskRequest,
    TestIamPermissionsExternalVpnGatewayRequest,
    TestIamPermissionsFirewallPolicyRequest,
    TestIamPermissionsImageRequest,
    TestIamPermissionsInstanceRequest,
    TestIamPermissionsInstanceTemplateRequest,
    TestIamPermissionsLicenseCodeRequest,
    TestIamPermissionsLicenseRequest,
    TestIamPermissionsNetworkEndpointGroupRequest,
    TestIamPermissionsNodeGroupRequest,
    TestIamPermissionsNodeTemplateRequest,
    TestIamPermissionsPacketMirroringRequest,
    TestIamPermissionsRegionDiskRequest,
    TestIamPermissionsReservationRequest,
    TestIamPermissionsResourcePolicyRequest,
    TestIamPermissionsServiceAttachmentRequest,
    TestIamPermissionsSnapshotRequest,
    TestIamPermissionsSubnetworkRequest,
    TestIamPermissionsVpnGatewayRequest,
    TestPermissionsRequest,
    TestPermissionsResponse,
    Uint128,
    UpdateAccessConfigInstanceRequest,
    UpdateAutoscalerRequest,
    UpdateBackendBucketRequest,
    UpdateBackendServiceRequest,
    UpdateDisplayDeviceInstanceRequest,
    UpdateFirewallRequest,
    UpdateHealthCheckRequest,
    UpdateInstanceRequest,
    UpdateNetworkInterfaceInstanceRequest,
    UpdatePeeringNetworkRequest,
    UpdatePerInstanceConfigsInstanceGroupManagerRequest,
    UpdatePerInstanceConfigsRegionInstanceGroupManagerRequest,
    UpdateRegionAutoscalerRequest,
    UpdateRegionBackendServiceRequest,
    UpdateRegionHealthCheckRequest,
    UpdateRegionUrlMapRequest,
    UpdateRouterRequest,
    UpdateShieldedInstanceConfigInstanceRequest,
    UpdateUrlMapRequest,
    UrlMap,
    UrlMapList,
    UrlMapReference,
    UrlMapsAggregatedList,
    UrlMapsScopedList,
    UrlMapsValidateRequest,
    UrlMapsValidateResponse,
    UrlMapTest,
    UrlMapTestHeader,
    UrlMapValidationResult,
    UrlRewrite,
    UsableSubnetwork,
    UsableSubnetworksAggregatedList,
    UsableSubnetworkSecondaryRange,
    UsageExportLocation,
    ValidateRegionUrlMapRequest,
    ValidateUrlMapRequest,
    VmEndpointNatMappings,
    VmEndpointNatMappingsInterfaceNatMappings,
    VmEndpointNatMappingsList,
    VpnGateway,
    VpnGatewayAggregatedList,
    VpnGatewayList,
    VpnGatewaysGetStatusResponse,
    VpnGatewaysScopedList,
    VpnGatewayStatus,
    VpnGatewayStatusHighAvailabilityRequirementState,
    VpnGatewayStatusTunnel,
    VpnGatewayStatusVpnConnection,
    VpnGatewayVpnGatewayInterface,
    VpnTunnel,
    VpnTunnelAggregatedList,
    VpnTunnelList,
    VpnTunnelsScopedList,
    WafExpressionSet,
    WafExpressionSetExpression,
    WaitGlobalOperationRequest,
    WaitRegionOperationRequest,
    WaitZoneOperationRequest,
    Warning,
    Warnings,
    WeightedBackendService,
    XpnHostList,
    XpnResourceId,
    Zone,
    ZoneList,
    ZoneSetLabelsRequest,
    ZoneSetPolicyRequest,
)

__all__ = (
    "AbandonInstancesInstanceGroupManagerRequest",
    "AbandonInstancesRegionInstanceGroupManagerRequest",
    "AcceleratorConfig",
    "Accelerators",
    "AcceleratorType",
    "AcceleratorTypeAggregatedList",
    "AcceleratorTypeList",
    "AcceleratorTypesScopedList",
    "AccessConfig",
    "AddAccessConfigInstanceRequest",
    "AddAssociationFirewallPolicyRequest",
    "AddHealthCheckTargetPoolRequest",
    "AddInstancesInstanceGroupRequest",
    "AddInstanceTargetPoolRequest",
    "AddNodesNodeGroupRequest",
    "AddPeeringNetworkRequest",
    "AddResourcePoliciesDiskRequest",
    "AddResourcePoliciesInstanceRequest",
    "AddResourcePoliciesRegionDiskRequest",
    "Address",
    "AddressAggregatedList",
    "AddressesScopedList",
    "AddressList",
    "AddRuleFirewallPolicyRequest",
    "AddRuleSecurityPolicyRequest",
    "AddSignedUrlKeyBackendBucketRequest",
    "AddSignedUrlKeyBackendServiceRequest",
    "AdvancedMachineFeatures",
    "AggregatedListAcceleratorTypesRequest",
    "AggregatedListAddressesRequest",
    "AggregatedListAutoscalersRequest",
    "AggregatedListBackendServicesRequest",
    "AggregatedListDisksRequest",
    "AggregatedListDiskTypesRequest",
    "AggregatedListForwardingRulesRequest",
    "AggregatedListGlobalOperationsRequest",
    "AggregatedListHealthChecksRequest",
    "AggregatedListInstanceGroupManagersRequest",
    "AggregatedListInstanceGroupsRequest",
    "AggregatedListInstancesRequest",
    "AggregatedListInterconnectAttachmentsRequest",
    "AggregatedListMachineTypesRequest",
    "AggregatedListNetworkEndpointGroupsRequest",
    "AggregatedListNodeGroupsRequest",
    "AggregatedListNodeTemplatesRequest",
    "AggregatedListNodeTypesRequest",
    "AggregatedListPacketMirroringsRequest",
    "AggregatedListPublicDelegatedPrefixesRequest",
    "AggregatedListRegionCommitmentsRequest",
    "AggregatedListReservationsRequest",
    "AggregatedListResourcePoliciesRequest",
    "AggregatedListRoutersRequest",
    "AggregatedListServiceAttachmentsRequest",
    "AggregatedListSslCertificatesRequest",
    "AggregatedListSubnetworksRequest",
    "AggregatedListTargetHttpProxiesRequest",
    "AggregatedListTargetHttpsProxiesRequest",
    "AggregatedListTargetInstancesRequest",
    "AggregatedListTargetPoolsRequest",
    "AggregatedListTargetVpnGatewaysRequest",
    "AggregatedListUrlMapsRequest",
    "AggregatedListVpnGatewaysRequest",
    "AggregatedListVpnTunnelsRequest",
    "AliasIpRange",
    "AllocationSpecificSKUAllocationAllocatedInstancePropertiesReservedDisk",
    "AllocationSpecificSKUAllocationReservedInstanceProperties",
    "AllocationSpecificSKUReservation",
    "Allowed",
    "ApplyUpdatesToInstancesInstanceGroupManagerRequest",
    "ApplyUpdatesToInstancesRegionInstanceGroupManagerRequest",
    "AttachDiskInstanceRequest",
    "AttachedDisk",
    "AttachedDiskInitializeParams",
    "AttachNetworkEndpointsGlobalNetworkEndpointGroupRequest",
    "AttachNetworkEndpointsNetworkEndpointGroupRequest",
    "AuditConfig",
    "AuditLogConfig",
    "AuthorizationLoggingOptions",
    "Autoscaler",
    "AutoscalerAggregatedList",
    "AutoscalerList",
    "AutoscalersScopedList",
    "AutoscalerStatusDetails",
    "AutoscalingPolicy",
    "AutoscalingPolicyCpuUtilization",
    "AutoscalingPolicyCustomMetricUtilization",
    "AutoscalingPolicyLoadBalancingUtilization",
    "AutoscalingPolicyScaleInControl",
    "AutoscalingPolicyScalingSchedule",
    "Backend",
    "BackendBucket",
    "BackendBucketCdnPolicy",
    "BackendBucketCdnPolicyBypassCacheOnRequestHeader",
    "BackendBucketCdnPolicyNegativeCachingPolicy",
    "BackendBucketList",
    "BackendService",
    "BackendServiceAggregatedList",
    "BackendServiceCdnPolicy",
    "BackendServiceCdnPolicyBypassCacheOnRequestHeader",
    "BackendServiceCdnPolicyNegativeCachingPolicy",
    "BackendServiceFailoverPolicy",
    "BackendServiceGroupHealth",
    "BackendServiceIAP",
    "BackendServiceList",
    "BackendServiceLogConfig",
    "BackendServiceReference",
    "BackendServicesScopedList",
    "Binding",
    "BulkInsertInstanceRequest",
    "BulkInsertInstanceResource",
    "BulkInsertInstanceResourcePerInstanceProperties",
    "BulkInsertRegionInstanceRequest",
    "CacheInvalidationRule",
    "CacheKeyPolicy",
    "CircuitBreakers",
    "CloneRulesFirewallPolicyRequest",
    "Commitment",
    "CommitmentAggregatedList",
    "CommitmentList",
    "CommitmentsScopedList",
    "Condition",
    "ConfidentialInstanceConfig",
    "ConnectionDraining",
    "ConsistentHashLoadBalancerSettings",
    "ConsistentHashLoadBalancerSettingsHttpCookie",
    "CorsPolicy",
    "CreateInstancesInstanceGroupManagerRequest",
    "CreateInstancesRegionInstanceGroupManagerRequest",
    "CreateSnapshotDiskRequest",
    "CreateSnapshotRegionDiskRequest",
    "CustomerEncryptionKey",
    "CustomerEncryptionKeyProtectedDisk",
    "Data",
    "DeleteAccessConfigInstanceRequest",
    "DeleteAddressRequest",
    "DeleteAutoscalerRequest",
    "DeleteBackendBucketRequest",
    "DeleteBackendServiceRequest",
    "DeleteDiskRequest",
    "DeleteExternalVpnGatewayRequest",
    "DeleteFirewallPolicyRequest",
    "DeleteFirewallRequest",
    "DeleteForwardingRuleRequest",
    "DeleteGlobalAddressRequest",
    "DeleteGlobalForwardingRuleRequest",
    "DeleteGlobalNetworkEndpointGroupRequest",
    "DeleteGlobalOperationRequest",
    "DeleteGlobalOperationResponse",
    "DeleteGlobalOrganizationOperationRequest",
    "DeleteGlobalOrganizationOperationResponse",
    "DeleteGlobalPublicDelegatedPrefixeRequest",
    "DeleteHealthCheckRequest",
    "DeleteImageRequest",
    "DeleteInstanceGroupManagerRequest",
    "DeleteInstanceGroupRequest",
    "DeleteInstanceRequest",
    "DeleteInstancesInstanceGroupManagerRequest",
    "DeleteInstancesRegionInstanceGroupManagerRequest",
    "DeleteInstanceTemplateRequest",
    "DeleteInterconnectAttachmentRequest",
    "DeleteInterconnectRequest",
    "DeleteLicenseRequest",
    "DeleteNetworkEndpointGroupRequest",
    "DeleteNetworkRequest",
    "DeleteNodeGroupRequest",
    "DeleteNodesNodeGroupRequest",
    "DeleteNodeTemplateRequest",
    "DeletePacketMirroringRequest",
    "DeletePerInstanceConfigsInstanceGroupManagerRequest",
    "DeletePerInstanceConfigsRegionInstanceGroupManagerRequest",
    "DeletePublicAdvertisedPrefixeRequest",
    "DeletePublicDelegatedPrefixeRequest",
    "DeleteRegionAutoscalerRequest",
    "DeleteRegionBackendServiceRequest",
    "DeleteRegionDiskRequest",
    "DeleteRegionHealthCheckRequest",
    "DeleteRegionHealthCheckServiceRequest",
    "DeleteRegionInstanceGroupManagerRequest",
    "DeleteRegionNetworkEndpointGroupRequest",
    "DeleteRegionNotificationEndpointRequest",
    "DeleteRegionOperationRequest",
    "DeleteRegionOperationResponse",
    "DeleteRegionSslCertificateRequest",
    "DeleteRegionTargetHttpProxyRequest",
    "DeleteRegionTargetHttpsProxyRequest",
    "DeleteRegionUrlMapRequest",
    "DeleteReservationRequest",
    "DeleteResourcePolicyRequest",
    "DeleteRouteRequest",
    "DeleteRouterRequest",
    "DeleteSecurityPolicyRequest",
    "DeleteServiceAttachmentRequest",
    "DeleteSignedUrlKeyBackendBucketRequest",
    "DeleteSignedUrlKeyBackendServiceRequest",
    "DeleteSnapshotRequest",
    "DeleteSslCertificateRequest",
    "DeleteSslPolicyRequest",
    "DeleteSubnetworkRequest",
    "DeleteTargetGrpcProxyRequest",
    "DeleteTargetHttpProxyRequest",
    "DeleteTargetHttpsProxyRequest",
    "DeleteTargetInstanceRequest",
    "DeleteTargetPoolRequest",
    "DeleteTargetSslProxyRequest",
    "DeleteTargetTcpProxyRequest",
    "DeleteTargetVpnGatewayRequest",
    "DeleteUrlMapRequest",
    "DeleteVpnGatewayRequest",
    "DeleteVpnTunnelRequest",
    "DeleteZoneOperationRequest",
    "DeleteZoneOperationResponse",
    "Denied",
    "DeprecateImageRequest",
    "DeprecationStatus",
    "DetachDiskInstanceRequest",
    "DetachNetworkEndpointsGlobalNetworkEndpointGroupRequest",
    "DetachNetworkEndpointsNetworkEndpointGroupRequest",
    "DisableXpnHostProjectRequest",
    "DisableXpnResourceProjectRequest",
    "Disk",
    "DiskAggregatedList",
    "DiskInstantiationConfig",
    "DiskList",
    "DiskMoveRequest",
    "DisksAddResourcePoliciesRequest",
    "DisksRemoveResourcePoliciesRequest",
    "DisksResizeRequest",
    "DisksScopedList",
    "DiskType",
    "DiskTypeAggregatedList",
    "DiskTypeList",
    "DiskTypesScopedList",
    "DisplayDevice",
    "DistributionPolicy",
    "DistributionPolicyZoneConfiguration",
    "Duration",
    "EnableXpnHostProjectRequest",
    "EnableXpnResourceProjectRequest",
    "Error",
    "Errors",
    "ExchangedPeeringRoute",
    "ExchangedPeeringRoutesList",
    "ExpandIpCidrRangeSubnetworkRequest",
    "Expr",
    "ExternalVpnGateway",
    "ExternalVpnGatewayInterface",
    "ExternalVpnGatewayList",
    "FileContentBuffer",
    "Firewall",
    "FirewallList",
    "FirewallLogConfig",
    "FirewallPoliciesListAssociationsResponse",
    "FirewallPolicy",
    "FirewallPolicyAssociation",
    "FirewallPolicyList",
    "FirewallPolicyRule",
    "FirewallPolicyRuleMatcher",
    "FirewallPolicyRuleMatcherLayer4Config",
    "FixedOrPercent",
    "ForwardingRule",
    "ForwardingRuleAggregatedList",
    "ForwardingRuleList",
    "ForwardingRuleReference",
    "ForwardingRuleServiceDirectoryRegistration",
    "ForwardingRulesScopedList",
    "GetAcceleratorTypeRequest",
    "GetAddressRequest",
    "GetAssociationFirewallPolicyRequest",
    "GetAutoscalerRequest",
    "GetBackendBucketRequest",
    "GetBackendServiceRequest",
    "GetDiagnosticsInterconnectRequest",
    "GetDiskRequest",
    "GetDiskTypeRequest",
    "GetEffectiveFirewallsInstanceRequest",
    "GetEffectiveFirewallsNetworkRequest",
    "GetExternalVpnGatewayRequest",
    "GetFirewallPolicyRequest",
    "GetFirewallRequest",
    "GetForwardingRuleRequest",
    "GetFromFamilyImageRequest",
    "GetGlobalAddressRequest",
    "GetGlobalForwardingRuleRequest",
    "GetGlobalNetworkEndpointGroupRequest",
    "GetGlobalOperationRequest",
    "GetGlobalOrganizationOperationRequest",
    "GetGlobalPublicDelegatedPrefixeRequest",
    "GetGuestAttributesInstanceRequest",
    "GetHealthBackendServiceRequest",
    "GetHealthCheckRequest",
    "GetHealthRegionBackendServiceRequest",
    "GetHealthTargetPoolRequest",
    "GetIamPolicyDiskRequest",
    "GetIamPolicyFirewallPolicyRequest",
    "GetIamPolicyImageRequest",
    "GetIamPolicyInstanceRequest",
    "GetIamPolicyInstanceTemplateRequest",
    "GetIamPolicyLicenseRequest",
    "GetIamPolicyNodeGroupRequest",
    "GetIamPolicyNodeTemplateRequest",
    "GetIamPolicyRegionDiskRequest",
    "GetIamPolicyReservationRequest",
    "GetIamPolicyResourcePolicyRequest",
    "GetIamPolicyServiceAttachmentRequest",
    "GetIamPolicySnapshotRequest",
    "GetIamPolicySubnetworkRequest",
    "GetImageFamilyViewRequest",
    "GetImageRequest",
    "GetInstanceGroupManagerRequest",
    "GetInstanceGroupRequest",
    "GetInstanceRequest",
    "GetInstanceTemplateRequest",
    "GetInterconnectAttachmentRequest",
    "GetInterconnectLocationRequest",
    "GetInterconnectRequest",
    "GetLicenseCodeRequest",
    "GetLicenseRequest",
    "GetMachineTypeRequest",
    "GetNatMappingInfoRoutersRequest",
    "GetNetworkEndpointGroupRequest",
    "GetNetworkRequest",
    "GetNodeGroupRequest",
    "GetNodeTemplateRequest",
    "GetNodeTypeRequest",
    "GetPacketMirroringRequest",
    "GetProjectRequest",
    "GetPublicAdvertisedPrefixeRequest",
    "GetPublicDelegatedPrefixeRequest",
    "GetRegionAutoscalerRequest",
    "GetRegionBackendServiceRequest",
    "GetRegionCommitmentRequest",
    "GetRegionDiskRequest",
    "GetRegionDiskTypeRequest",
    "GetRegionHealthCheckRequest",
    "GetRegionHealthCheckServiceRequest",
    "GetRegionInstanceGroupManagerRequest",
    "GetRegionInstanceGroupRequest",
    "GetRegionNetworkEndpointGroupRequest",
    "GetRegionNotificationEndpointRequest",
    "GetRegionOperationRequest",
    "GetRegionRequest",
    "GetRegionSslCertificateRequest",
    "GetRegionTargetHttpProxyRequest",
    "GetRegionTargetHttpsProxyRequest",
    "GetRegionUrlMapRequest",
    "GetReservationRequest",
    "GetResourcePolicyRequest",
    "GetRouteRequest",
    "GetRouterRequest",
    "GetRouterStatusRouterRequest",
    "GetRuleFirewallPolicyRequest",
    "GetRuleSecurityPolicyRequest",
    "GetScreenshotInstanceRequest",
    "GetSecurityPolicyRequest",
    "GetSerialPortOutputInstanceRequest",
    "GetServiceAttachmentRequest",
    "GetShieldedInstanceIdentityInstanceRequest",
    "GetSnapshotRequest",
    "GetSslCertificateRequest",
    "GetSslPolicyRequest",
    "GetStatusVpnGatewayRequest",
    "GetSubnetworkRequest",
    "GetTargetGrpcProxyRequest",
    "GetTargetHttpProxyRequest",
    "GetTargetHttpsProxyRequest",
    "GetTargetInstanceRequest",
    "GetTargetPoolRequest",
    "GetTargetSslProxyRequest",
    "GetTargetTcpProxyRequest",
    "GetTargetVpnGatewayRequest",
    "GetUrlMapRequest",
    "GetVpnGatewayRequest",
    "GetVpnTunnelRequest",
    "GetXpnHostProjectRequest",
    "GetXpnResourcesProjectsRequest",
    "GetZoneOperationRequest",
    "GetZoneRequest",
    "GlobalNetworkEndpointGroupsAttachEndpointsRequest",
    "GlobalNetworkEndpointGroupsDetachEndpointsRequest",
    "GlobalOrganizationSetPolicyRequest",
    "GlobalSetLabelsRequest",
    "GlobalSetPolicyRequest",
    "GRPCHealthCheck",
    "GuestAttributes",
    "GuestAttributesEntry",
    "GuestAttributesValue",
    "GuestOsFeature",
    "HealthCheck",
    "HealthCheckList",
    "HealthCheckLogConfig",
    "HealthCheckReference",
    "HealthChecksAggregatedList",
    "HealthCheckService",
    "HealthCheckServiceReference",
    "HealthCheckServicesList",
    "HealthChecksScopedList",
    "HealthStatus",
    "HealthStatusForNetworkEndpoint",
    "HostRule",
    "HTTP2HealthCheck",
    "HttpFaultAbort",
    "HttpFaultDelay",
    "HttpFaultInjection",
    "HttpHeaderAction",
    "HttpHeaderMatch",
    "HttpHeaderOption",
    "HTTPHealthCheck",
    "HttpQueryParameterMatch",
    "HttpRedirectAction",
    "HttpRetryPolicy",
    "HttpRouteAction",
    "HttpRouteRule",
    "HttpRouteRuleMatch",
    "HTTPSHealthCheck",
    "Image",
    "ImageFamilyView",
    "ImageList",
    "InitialStateConfig",
    "InsertAddressRequest",
    "InsertAutoscalerRequest",
    "InsertBackendBucketRequest",
    "InsertBackendServiceRequest",
    "InsertDiskRequest",
    "InsertExternalVpnGatewayRequest",
    "InsertFirewallPolicyRequest",
    "InsertFirewallRequest",
    "InsertForwardingRuleRequest",
    "InsertGlobalAddressRequest",
    "InsertGlobalForwardingRuleRequest",
    "InsertGlobalNetworkEndpointGroupRequest",
    "InsertGlobalPublicDelegatedPrefixeRequest",
    "InsertHealthCheckRequest",
    "InsertImageRequest",
    "InsertInstanceGroupManagerRequest",
    "InsertInstanceGroupRequest",
    "InsertInstanceRequest",
    "InsertInstanceTemplateRequest",
    "InsertInterconnectAttachmentRequest",
    "InsertInterconnectRequest",
    "InsertLicenseRequest",
    "InsertNetworkEndpointGroupRequest",
    "InsertNetworkRequest",
    "InsertNodeGroupRequest",
    "InsertNodeTemplateRequest",
    "InsertPacketMirroringRequest",
    "InsertPublicAdvertisedPrefixeRequest",
    "InsertPublicDelegatedPrefixeRequest",
    "InsertRegionAutoscalerRequest",
    "InsertRegionBackendServiceRequest",
    "InsertRegionCommitmentRequest",
    "InsertRegionDiskRequest",
    "InsertRegionHealthCheckRequest",
    "InsertRegionHealthCheckServiceRequest",
    "InsertRegionInstanceGroupManagerRequest",
    "InsertRegionNetworkEndpointGroupRequest",
    "InsertRegionNotificationEndpointRequest",
    "InsertRegionSslCertificateRequest",
    "InsertRegionTargetHttpProxyRequest",
    "InsertRegionTargetHttpsProxyRequest",
    "InsertRegionUrlMapRequest",
    "InsertReservationRequest",
    "InsertResourcePolicyRequest",
    "InsertRouteRequest",
    "InsertRouterRequest",
    "InsertSecurityPolicyRequest",
    "InsertServiceAttachmentRequest",
    "InsertSslCertificateRequest",
    "InsertSslPolicyRequest",
    "InsertSubnetworkRequest",
    "InsertTargetGrpcProxyRequest",
    "InsertTargetHttpProxyRequest",
    "InsertTargetHttpsProxyRequest",
    "InsertTargetInstanceRequest",
    "InsertTargetPoolRequest",
    "InsertTargetSslProxyRequest",
    "InsertTargetTcpProxyRequest",
    "InsertTargetVpnGatewayRequest",
    "InsertUrlMapRequest",
    "InsertVpnGatewayRequest",
    "InsertVpnTunnelRequest",
    "Instance",
    "InstanceAggregatedList",
    "InstanceGroup",
    "InstanceGroupAggregatedList",
    "InstanceGroupList",
    "InstanceGroupManager",
    "InstanceGroupManagerActionsSummary",
    "InstanceGroupManagerAggregatedList",
    "InstanceGroupManagerAutoHealingPolicy",
    "InstanceGroupManagerList",
    "InstanceGroupManagersAbandonInstancesRequest",
    "InstanceGroupManagersApplyUpdatesRequest",
    "InstanceGroupManagersCreateInstancesRequest",
    "InstanceGroupManagersDeleteInstancesRequest",
    "InstanceGroupManagersDeletePerInstanceConfigsReq",
    "InstanceGroupManagersListErrorsResponse",
    "InstanceGroupManagersListManagedInstancesResponse",
    "InstanceGroupManagersListPerInstanceConfigsResp",
    "InstanceGroupManagersPatchPerInstanceConfigsReq",
    "InstanceGroupManagersRecreateInstancesRequest",
    "InstanceGroupManagersScopedList",
    "InstanceGroupManagersSetInstanceTemplateRequest",
    "InstanceGroupManagersSetTargetPoolsRequest",
    "InstanceGroupManagerStatus",
    "InstanceGroupManagerStatusStateful",
    "InstanceGroupManagerStatusStatefulPerInstanceConfigs",
    "InstanceGroupManagerStatusVersionTarget",
    "InstanceGroupManagersUpdatePerInstanceConfigsReq",
    "InstanceGroupManagerUpdatePolicy",
    "InstanceGroupManagerVersion",
    "InstanceGroupsAddInstancesRequest",
    "InstanceGroupsListInstances",
    "InstanceGroupsListInstancesRequest",
    "InstanceGroupsRemoveInstancesRequest",
    "InstanceGroupsScopedList",
    "InstanceGroupsSetNamedPortsRequest",
    "InstanceList",
    "InstanceListReferrers",
    "InstanceManagedByIgmError",
    "InstanceManagedByIgmErrorInstanceActionDetails",
    "InstanceManagedByIgmErrorManagedInstanceError",
    "InstanceMoveRequest",
    "InstanceProperties",
    "InstanceReference",
    "InstancesAddResourcePoliciesRequest",
    "InstancesGetEffectiveFirewallsResponse",
    "InstancesGetEffectiveFirewallsResponseEffectiveFirewallPolicy",
    "InstancesRemoveResourcePoliciesRequest",
    "InstancesScopedList",
    "InstancesSetLabelsRequest",
    "InstancesSetMachineResourcesRequest",
    "InstancesSetMachineTypeRequest",
    "InstancesSetMinCpuPlatformRequest",
    "InstancesSetServiceAccountRequest",
    "InstancesStartWithEncryptionKeyRequest",
    "InstanceTemplate",
    "InstanceTemplateList",
    "InstanceWithNamedPorts",
    "Int64RangeMatch",
    "Interconnect",
    "InterconnectAttachment",
    "InterconnectAttachmentAggregatedList",
    "InterconnectAttachmentList",
    "InterconnectAttachmentPartnerMetadata",
    "InterconnectAttachmentPrivateInfo",
    "InterconnectAttachmentsScopedList",
    "InterconnectCircuitInfo",
    "InterconnectDiagnostics",
    "InterconnectDiagnosticsARPEntry",
    "InterconnectDiagnosticsLinkLACPStatus",
    "InterconnectDiagnosticsLinkOpticalPower",
    "InterconnectDiagnosticsLinkStatus",
    "InterconnectList",
    "InterconnectLocation",
    "InterconnectLocationList",
    "InterconnectLocationRegionInfo",
    "InterconnectOutageNotification",
    "InterconnectsGetDiagnosticsResponse",
    "InvalidateCacheUrlMapRequest",
    "Items",
    "License",
    "LicenseCode",
    "LicenseCodeLicenseAlias",
    "LicenseResourceCommitment",
    "LicenseResourceRequirements",
    "LicensesListResponse",
    "ListAcceleratorTypesRequest",
    "ListAddressesRequest",
    "ListAssociationsFirewallPolicyRequest",
    "ListAutoscalersRequest",
    "ListAvailableFeaturesSslPoliciesRequest",
    "ListBackendBucketsRequest",
    "ListBackendServicesRequest",
    "ListDisksRequest",
    "ListDiskTypesRequest",
    "ListErrorsInstanceGroupManagersRequest",
    "ListErrorsRegionInstanceGroupManagersRequest",
    "ListExternalVpnGatewaysRequest",
    "ListFirewallPoliciesRequest",
    "ListFirewallsRequest",
    "ListForwardingRulesRequest",
    "ListGlobalAddressesRequest",
    "ListGlobalForwardingRulesRequest",
    "ListGlobalNetworkEndpointGroupsRequest",
    "ListGlobalOperationsRequest",
    "ListGlobalOrganizationOperationsRequest",
    "ListGlobalPublicDelegatedPrefixesRequest",
    "ListHealthChecksRequest",
    "ListImagesRequest",
    "ListInstanceGroupManagersRequest",
    "ListInstanceGroupsRequest",
    "ListInstancesInstanceGroupsRequest",
    "ListInstancesRegionInstanceGroupsRequest",
    "ListInstancesRequest",
    "ListInstanceTemplatesRequest",
    "ListInterconnectAttachmentsRequest",
    "ListInterconnectLocationsRequest",
    "ListInterconnectsRequest",
    "ListLicensesRequest",
    "ListMachineTypesRequest",
    "ListManagedInstancesInstanceGroupManagersRequest",
    "ListManagedInstancesRegionInstanceGroupManagersRequest",
    "ListNetworkEndpointGroupsRequest",
    "ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest",
    "ListNetworkEndpointsNetworkEndpointGroupsRequest",
    "ListNetworksRequest",
    "ListNodeGroupsRequest",
    "ListNodesNodeGroupsRequest",
    "ListNodeTemplatesRequest",
    "ListNodeTypesRequest",
    "ListPacketMirroringsRequest",
    "ListPeeringRoutesNetworksRequest",
    "ListPerInstanceConfigsInstanceGroupManagersRequest",
    "ListPerInstanceConfigsRegionInstanceGroupManagersRequest",
    "ListPreconfiguredExpressionSetsSecurityPoliciesRequest",
    "ListPublicAdvertisedPrefixesRequest",
    "ListPublicDelegatedPrefixesRequest",
    "ListReferrersInstancesRequest",
    "ListRegionAutoscalersRequest",
    "ListRegionBackendServicesRequest",
    "ListRegionCommitmentsRequest",
    "ListRegionDisksRequest",
    "ListRegionDiskTypesRequest",
    "ListRegionHealthCheckServicesRequest",
    "ListRegionHealthChecksRequest",
    "ListRegionInstanceGroupManagersRequest",
    "ListRegionInstanceGroupsRequest",
    "ListRegionNetworkEndpointGroupsRequest",
    "ListRegionNotificationEndpointsRequest",
    "ListRegionOperationsRequest",
    "ListRegionsRequest",
    "ListRegionSslCertificatesRequest",
    "ListRegionTargetHttpProxiesRequest",
    "ListRegionTargetHttpsProxiesRequest",
    "ListRegionUrlMapsRequest",
    "ListReservationsRequest",
    "ListResourcePoliciesRequest",
    "ListRoutersRequest",
    "ListRoutesRequest",
    "ListSecurityPoliciesRequest",
    "ListServiceAttachmentsRequest",
    "ListSnapshotsRequest",
    "ListSslCertificatesRequest",
    "ListSslPoliciesRequest",
    "ListSubnetworksRequest",
    "ListTargetGrpcProxiesRequest",
    "ListTargetHttpProxiesRequest",
    "ListTargetHttpsProxiesRequest",
    "ListTargetInstancesRequest",
    "ListTargetPoolsRequest",
    "ListTargetSslProxiesRequest",
    "ListTargetTcpProxiesRequest",
    "ListTargetVpnGatewaysRequest",
    "ListUrlMapsRequest",
    "ListUsableSubnetworksRequest",
    "ListVpnGatewaysRequest",
    "ListVpnTunnelsRequest",
    "ListXpnHostsProjectsRequest",
    "ListZoneOperationsRequest",
    "ListZonesRequest",
    "LocalDisk",
    "LocationPolicy",
    "LocationPolicyLocation",
    "LogConfig",
    "LogConfigCloudAuditOptions",
    "LogConfigCounterOptions",
    "LogConfigCounterOptionsCustomField",
    "LogConfigDataAccessOptions",
    "MachineType",
    "MachineTypeAggregatedList",
    "MachineTypeList",
    "MachineTypesScopedList",
    "ManagedInstance",
    "ManagedInstanceInstanceHealth",
    "ManagedInstanceLastAttempt",
    "ManagedInstanceVersion",
    "Metadata",
    "MetadataFilter",
    "MetadataFilterLabelMatch",
    "MoveDiskProjectRequest",
    "MoveFirewallPolicyRequest",
    "MoveInstanceProjectRequest",
    "NamedPort",
    "Network",
    "NetworkEndpoint",
    "NetworkEndpointGroup",
    "NetworkEndpointGroupAggregatedList",
    "NetworkEndpointGroupAppEngine",
    "NetworkEndpointGroupCloudFunction",
    "NetworkEndpointGroupCloudRun",
    "NetworkEndpointGroupList",
    "NetworkEndpointGroupsAttachEndpointsRequest",
    "NetworkEndpointGroupsDetachEndpointsRequest",
    "NetworkEndpointGroupsListEndpointsRequest",
    "NetworkEndpointGroupsListNetworkEndpoints",
    "NetworkEndpointGroupsScopedList",
    "NetworkEndpointWithHealthStatus",
    "NetworkInterface",
    "NetworkList",
    "NetworkPeering",
    "NetworkRoutingConfig",
    "NetworksAddPeeringRequest",
    "NetworksGetEffectiveFirewallsResponse",
    "NetworksGetEffectiveFirewallsResponseEffectiveFirewallPolicy",
    "NetworksRemovePeeringRequest",
    "NetworksUpdatePeeringRequest",
    "NodeGroup",
    "NodeGroupAggregatedList",
    "NodeGroupAutoscalingPolicy",
    "NodeGroupList",
    "NodeGroupMaintenanceWindow",
    "NodeGroupNode",
    "NodeGroupsAddNodesRequest",
    "NodeGroupsDeleteNodesRequest",
    "NodeGroupsListNodes",
    "NodeGroupsScopedList",
    "NodeGroupsSetNodeTemplateRequest",
    "NodeTemplate",
    "NodeTemplateAggregatedList",
    "NodeTemplateList",
    "NodeTemplateNodeTypeFlexibility",
    "NodeTemplatesScopedList",
    "NodeType",
    "NodeTypeAggregatedList",
    "NodeTypeList",
    "NodeTypesScopedList",
    "NotificationEndpoint",
    "NotificationEndpointGrpcSettings",
    "NotificationEndpointList",
    "Operation",
    "OperationAggregatedList",
    "OperationList",
    "OperationsScopedList",
    "OutlierDetection",
    "PacketMirroring",
    "PacketMirroringAggregatedList",
    "PacketMirroringFilter",
    "PacketMirroringForwardingRuleInfo",
    "PacketMirroringList",
    "PacketMirroringMirroredResourceInfo",
    "PacketMirroringMirroredResourceInfoInstanceInfo",
    "PacketMirroringMirroredResourceInfoSubnetInfo",
    "PacketMirroringNetworkInfo",
    "PacketMirroringsScopedList",
    "PatchAutoscalerRequest",
    "PatchBackendBucketRequest",
    "PatchBackendServiceRequest",
    "PatchFirewallPolicyRequest",
    "PatchFirewallRequest",
    "PatchForwardingRuleRequest",
    "PatchGlobalForwardingRuleRequest",
    "PatchGlobalPublicDelegatedPrefixeRequest",
    "PatchHealthCheckRequest",
    "PatchImageRequest",
    "PatchInstanceGroupManagerRequest",
    "PatchInterconnectAttachmentRequest",
    "PatchInterconnectRequest",
    "PatchNetworkRequest",
    "PatchNodeGroupRequest",
    "PatchPacketMirroringRequest",
    "PatchPerInstanceConfigsInstanceGroupManagerRequest",
    "PatchPerInstanceConfigsRegionInstanceGroupManagerRequest",
    "PatchPublicAdvertisedPrefixeRequest",
    "PatchPublicDelegatedPrefixeRequest",
    "PatchRegionAutoscalerRequest",
    "PatchRegionBackendServiceRequest",
    "PatchRegionHealthCheckRequest",
    "PatchRegionHealthCheckServiceRequest",
    "PatchRegionInstanceGroupManagerRequest",
    "PatchRegionUrlMapRequest",
    "PatchRouterRequest",
    "PatchRuleFirewallPolicyRequest",
    "PatchRuleSecurityPolicyRequest",
    "PatchSecurityPolicyRequest",
    "PatchServiceAttachmentRequest",
    "PatchSslPolicyRequest",
    "PatchSubnetworkRequest",
    "PatchTargetGrpcProxyRequest",
    "PatchTargetHttpProxyRequest",
    "PatchTargetHttpsProxyRequest",
    "PatchUrlMapRequest",
    "PathMatcher",
    "PathRule",
    "PerInstanceConfig",
    "Policy",
    "PreconfiguredWafSet",
    "PreservedState",
    "PreservedStatePreservedDisk",
    "PreviewRouterRequest",
    "Project",
    "ProjectsDisableXpnResourceRequest",
    "ProjectsEnableXpnResourceRequest",
    "ProjectsGetXpnResources",
    "ProjectsListXpnHostsRequest",
    "ProjectsSetDefaultNetworkTierRequest",
    "PublicAdvertisedPrefix",
    "PublicAdvertisedPrefixList",
    "PublicAdvertisedPrefixPublicDelegatedPrefix",
    "PublicDelegatedPrefix",
    "PublicDelegatedPrefixAggregatedList",
    "PublicDelegatedPrefixesScopedList",
    "PublicDelegatedPrefixList",
    "PublicDelegatedPrefixPublicDelegatedSubPrefix",
    "Quota",
    "RawDisk",
    "RecreateInstancesInstanceGroupManagerRequest",
    "RecreateInstancesRegionInstanceGroupManagerRequest",
    "Reference",
    "Region",
    "RegionAutoscalerList",
    "RegionDisksAddResourcePoliciesRequest",
    "RegionDisksRemoveResourcePoliciesRequest",
    "RegionDisksResizeRequest",
    "RegionDiskTypeList",
    "RegionInstanceGroupList",
    "RegionInstanceGroupManagerDeleteInstanceConfigReq",
    "RegionInstanceGroupManagerList",
    "RegionInstanceGroupManagerPatchInstanceConfigReq",
    "RegionInstanceGroupManagersAbandonInstancesRequest",
    "RegionInstanceGroupManagersApplyUpdatesRequest",
    "RegionInstanceGroupManagersCreateInstancesRequest",
    "RegionInstanceGroupManagersDeleteInstancesRequest",
    "RegionInstanceGroupManagersListErrorsResponse",
    "RegionInstanceGroupManagersListInstanceConfigsResp",
    "RegionInstanceGroupManagersListInstancesResponse",
    "RegionInstanceGroupManagersRecreateRequest",
    "RegionInstanceGroupManagersSetTargetPoolsRequest",
    "RegionInstanceGroupManagersSetTemplateRequest",
    "RegionInstanceGroupManagerUpdateInstanceConfigReq",
    "RegionInstanceGroupsListInstances",
    "RegionInstanceGroupsListInstancesRequest",
    "RegionInstanceGroupsSetNamedPortsRequest",
    "RegionList",
    "RegionSetLabelsRequest",
    "RegionSetPolicyRequest",
    "RegionTargetHttpsProxiesSetSslCertificatesRequest",
    "RegionUrlMapsValidateRequest",
    "RemoveAssociationFirewallPolicyRequest",
    "RemoveHealthCheckTargetPoolRequest",
    "RemoveInstancesInstanceGroupRequest",
    "RemoveInstanceTargetPoolRequest",
    "RemovePeeringNetworkRequest",
    "RemoveResourcePoliciesDiskRequest",
    "RemoveResourcePoliciesInstanceRequest",
    "RemoveResourcePoliciesRegionDiskRequest",
    "RemoveRuleFirewallPolicyRequest",
    "RemoveRuleSecurityPolicyRequest",
    "RequestMirrorPolicy",
    "Reservation",
    "ReservationAffinity",
    "ReservationAggregatedList",
    "ReservationList",
    "ReservationsResizeRequest",
    "ReservationsScopedList",
    "ResetInstanceRequest",
    "ResizeDiskRequest",
    "ResizeInstanceGroupManagerRequest",
    "ResizeRegionDiskRequest",
    "ResizeRegionInstanceGroupManagerRequest",
    "ResizeReservationRequest",
    "ResourceCommitment",
    "ResourceGroupReference",
    "ResourcePoliciesScopedList",
    "ResourcePolicy",
    "ResourcePolicyAggregatedList",
    "ResourcePolicyDailyCycle",
    "ResourcePolicyGroupPlacementPolicy",
    "ResourcePolicyHourlyCycle",
    "ResourcePolicyInstanceSchedulePolicy",
    "ResourcePolicyInstanceSchedulePolicySchedule",
    "ResourcePolicyList",
    "ResourcePolicyResourceStatus",
    "ResourcePolicyResourceStatusInstanceSchedulePolicyStatus",
    "ResourcePolicySnapshotSchedulePolicy",
    "ResourcePolicySnapshotSchedulePolicyRetentionPolicy",
    "ResourcePolicySnapshotSchedulePolicySchedule",
    "ResourcePolicySnapshotSchedulePolicySnapshotProperties",
    "ResourcePolicyWeeklyCycle",
    "ResourcePolicyWeeklyCycleDayOfWeek",
    "Route",
    "RouteAsPath",
    "RouteList",
    "Router",
    "RouterAdvertisedIpRange",
    "RouterAggregatedList",
    "RouterBgp",
    "RouterBgpPeer",
    "RouterBgpPeerBfd",
    "RouterInterface",
    "RouterList",
    "RouterNat",
    "RouterNatLogConfig",
    "RouterNatRule",
    "RouterNatRuleAction",
    "RouterNatSubnetworkToNat",
    "RoutersPreviewResponse",
    "RoutersScopedList",
    "RouterStatus",
    "RouterStatusBgpPeerStatus",
    "RouterStatusNatStatus",
    "RouterStatusNatStatusNatRuleStatus",
    "RouterStatusResponse",
    "Rule",
    "ScalingScheduleStatus",
    "Scheduling",
    "SchedulingNodeAffinity",
    "ScratchDisks",
    "Screenshot",
    "SecurityPoliciesListPreconfiguredExpressionSetsResponse",
    "SecurityPoliciesWafConfig",
    "SecurityPolicy",
    "SecurityPolicyAdaptiveProtectionConfig",
    "SecurityPolicyAdaptiveProtectionConfigLayer7DdosDefenseConfig",
    "SecurityPolicyAdvancedOptionsConfig",
    "SecurityPolicyList",
    "SecurityPolicyReference",
    "SecurityPolicyRule",
    "SecurityPolicyRuleMatcher",
    "SecurityPolicyRuleMatcherConfig",
    "SecuritySettings",
    "SendDiagnosticInterruptInstanceRequest",
    "SendDiagnosticInterruptInstanceResponse",
    "SerialPortOutput",
    "ServerBinding",
    "ServiceAccount",
    "ServiceAttachment",
    "ServiceAttachmentAggregatedList",
    "ServiceAttachmentConnectedEndpoint",
    "ServiceAttachmentConsumerProjectLimit",
    "ServiceAttachmentList",
    "ServiceAttachmentsScopedList",
    "SetBackendServiceTargetSslProxyRequest",
    "SetBackendServiceTargetTcpProxyRequest",
    "SetBackupTargetPoolRequest",
    "SetCommonInstanceMetadataProjectRequest",
    "SetDefaultNetworkTierProjectRequest",
    "SetDeletionProtectionInstanceRequest",
    "SetDiskAutoDeleteInstanceRequest",
    "SetIamPolicyDiskRequest",
    "SetIamPolicyFirewallPolicyRequest",
    "SetIamPolicyImageRequest",
    "SetIamPolicyInstanceRequest",
    "SetIamPolicyInstanceTemplateRequest",
    "SetIamPolicyLicenseRequest",
    "SetIamPolicyNodeGroupRequest",
    "SetIamPolicyNodeTemplateRequest",
    "SetIamPolicyRegionDiskRequest",
    "SetIamPolicyReservationRequest",
    "SetIamPolicyResourcePolicyRequest",
    "SetIamPolicyServiceAttachmentRequest",
    "SetIamPolicySnapshotRequest",
    "SetIamPolicySubnetworkRequest",
    "SetInstanceTemplateInstanceGroupManagerRequest",
    "SetInstanceTemplateRegionInstanceGroupManagerRequest",
    "SetLabelsDiskRequest",
    "SetLabelsExternalVpnGatewayRequest",
    "SetLabelsForwardingRuleRequest",
    "SetLabelsGlobalForwardingRuleRequest",
    "SetLabelsImageRequest",
    "SetLabelsInstanceRequest",
    "SetLabelsRegionDiskRequest",
    "SetLabelsSnapshotRequest",
    "SetLabelsVpnGatewayRequest",
    "SetMachineResourcesInstanceRequest",
    "SetMachineTypeInstanceRequest",
    "SetMetadataInstanceRequest",
    "SetMinCpuPlatformInstanceRequest",
    "SetNamedPortsInstanceGroupRequest",
    "SetNamedPortsRegionInstanceGroupRequest",
    "SetNodeTemplateNodeGroupRequest",
    "SetPrivateIpGoogleAccessSubnetworkRequest",
    "SetProxyHeaderTargetSslProxyRequest",
    "SetProxyHeaderTargetTcpProxyRequest",
    "SetQuicOverrideTargetHttpsProxyRequest",
    "SetSchedulingInstanceRequest",
    "SetSecurityPolicyBackendServiceRequest",
    "SetServiceAccountInstanceRequest",
    "SetShieldedInstanceIntegrityPolicyInstanceRequest",
    "SetSslCertificatesRegionTargetHttpsProxyRequest",
    "SetSslCertificatesTargetHttpsProxyRequest",
    "SetSslCertificatesTargetSslProxyRequest",
    "SetSslPolicyTargetHttpsProxyRequest",
    "SetSslPolicyTargetSslProxyRequest",
    "SetTagsInstanceRequest",
    "SetTargetForwardingRuleRequest",
    "SetTargetGlobalForwardingRuleRequest",
    "SetTargetPoolsInstanceGroupManagerRequest",
    "SetTargetPoolsRegionInstanceGroupManagerRequest",
    "SetUrlMapRegionTargetHttpProxyRequest",
    "SetUrlMapRegionTargetHttpsProxyRequest",
    "SetUrlMapTargetHttpProxyRequest",
    "SetUrlMapTargetHttpsProxyRequest",
    "SetUsageExportBucketProjectRequest",
    "ShieldedInstanceConfig",
    "ShieldedInstanceIdentity",
    "ShieldedInstanceIdentityEntry",
    "ShieldedInstanceIntegrityPolicy",
    "SignedUrlKey",
    "SimulateMaintenanceEventInstanceRequest",
    "Snapshot",
    "SnapshotList",
    "SourceInstanceParams",
    "SslCertificate",
    "SslCertificateAggregatedList",
    "SslCertificateList",
    "SslCertificateManagedSslCertificate",
    "SslCertificateSelfManagedSslCertificate",
    "SslCertificatesScopedList",
    "SSLHealthCheck",
    "SslPoliciesList",
    "SslPoliciesListAvailableFeaturesResponse",
    "SslPolicy",
    "SslPolicyReference",
    "StartInstanceRequest",
    "StartWithEncryptionKeyInstanceRequest",
    "StatefulPolicy",
    "StatefulPolicyPreservedState",
    "StatefulPolicyPreservedStateDiskDevice",
    "StopInstanceRequest",
    "Subnetwork",
    "SubnetworkAggregatedList",
    "SubnetworkList",
    "SubnetworkLogConfig",
    "SubnetworkSecondaryRange",
    "SubnetworksExpandIpCidrRangeRequest",
    "SubnetworksScopedList",
    "SubnetworksSetPrivateIpGoogleAccessRequest",
    "Subsetting",
    "SwitchToCustomModeNetworkRequest",
    "Tags",
    "TargetGrpcProxy",
    "TargetGrpcProxyList",
    "TargetHttpProxiesScopedList",
    "TargetHttpProxy",
    "TargetHttpProxyAggregatedList",
    "TargetHttpProxyList",
    "TargetHttpsProxiesScopedList",
    "TargetHttpsProxiesSetQuicOverrideRequest",
    "TargetHttpsProxiesSetSslCertificatesRequest",
    "TargetHttpsProxy",
    "TargetHttpsProxyAggregatedList",
    "TargetHttpsProxyList",
    "TargetInstance",
    "TargetInstanceAggregatedList",
    "TargetInstanceList",
    "TargetInstancesScopedList",
    "TargetPool",
    "TargetPoolAggregatedList",
    "TargetPoolInstanceHealth",
    "TargetPoolList",
    "TargetPoolsAddHealthCheckRequest",
    "TargetPoolsAddInstanceRequest",
    "TargetPoolsRemoveHealthCheckRequest",
    "TargetPoolsRemoveInstanceRequest",
    "TargetPoolsScopedList",
    "TargetReference",
    "TargetSslProxiesSetBackendServiceRequest",
    "TargetSslProxiesSetProxyHeaderRequest",
    "TargetSslProxiesSetSslCertificatesRequest",
    "TargetSslProxy",
    "TargetSslProxyList",
    "TargetTcpProxiesSetBackendServiceRequest",
    "TargetTcpProxiesSetProxyHeaderRequest",
    "TargetTcpProxy",
    "TargetTcpProxyList",
    "TargetVpnGateway",
    "TargetVpnGatewayAggregatedList",
    "TargetVpnGatewayList",
    "TargetVpnGatewaysScopedList",
    "TCPHealthCheck",
    "TestFailure",
    "TestIamPermissionsDiskRequest",
    "TestIamPermissionsExternalVpnGatewayRequest",
    "TestIamPermissionsFirewallPolicyRequest",
    "TestIamPermissionsImageRequest",
    "TestIamPermissionsInstanceRequest",
    "TestIamPermissionsInstanceTemplateRequest",
    "TestIamPermissionsLicenseCodeRequest",
    "TestIamPermissionsLicenseRequest",
    "TestIamPermissionsNetworkEndpointGroupRequest",
    "TestIamPermissionsNodeGroupRequest",
    "TestIamPermissionsNodeTemplateRequest",
    "TestIamPermissionsPacketMirroringRequest",
    "TestIamPermissionsRegionDiskRequest",
    "TestIamPermissionsReservationRequest",
    "TestIamPermissionsResourcePolicyRequest",
    "TestIamPermissionsServiceAttachmentRequest",
    "TestIamPermissionsSnapshotRequest",
    "TestIamPermissionsSubnetworkRequest",
    "TestIamPermissionsVpnGatewayRequest",
    "TestPermissionsRequest",
    "TestPermissionsResponse",
    "Uint128",
    "UpdateAccessConfigInstanceRequest",
    "UpdateAutoscalerRequest",
    "UpdateBackendBucketRequest",
    "UpdateBackendServiceRequest",
    "UpdateDisplayDeviceInstanceRequest",
    "UpdateFirewallRequest",
    "UpdateHealthCheckRequest",
    "UpdateInstanceRequest",
    "UpdateNetworkInterfaceInstanceRequest",
    "UpdatePeeringNetworkRequest",
    "UpdatePerInstanceConfigsInstanceGroupManagerRequest",
    "UpdatePerInstanceConfigsRegionInstanceGroupManagerRequest",
    "UpdateRegionAutoscalerRequest",
    "UpdateRegionBackendServiceRequest",
    "UpdateRegionHealthCheckRequest",
    "UpdateRegionUrlMapRequest",
    "UpdateRouterRequest",
    "UpdateShieldedInstanceConfigInstanceRequest",
    "UpdateUrlMapRequest",
    "UrlMap",
    "UrlMapList",
    "UrlMapReference",
    "UrlMapsAggregatedList",
    "UrlMapsScopedList",
    "UrlMapsValidateRequest",
    "UrlMapsValidateResponse",
    "UrlMapTest",
    "UrlMapTestHeader",
    "UrlMapValidationResult",
    "UrlRewrite",
    "UsableSubnetwork",
    "UsableSubnetworksAggregatedList",
    "UsableSubnetworkSecondaryRange",
    "UsageExportLocation",
    "ValidateRegionUrlMapRequest",
    "ValidateUrlMapRequest",
    "VmEndpointNatMappings",
    "VmEndpointNatMappingsInterfaceNatMappings",
    "VmEndpointNatMappingsList",
    "VpnGateway",
    "VpnGatewayAggregatedList",
    "VpnGatewayList",
    "VpnGatewaysGetStatusResponse",
    "VpnGatewaysScopedList",
    "VpnGatewayStatus",
    "VpnGatewayStatusHighAvailabilityRequirementState",
    "VpnGatewayStatusTunnel",
    "VpnGatewayStatusVpnConnection",
    "VpnGatewayVpnGatewayInterface",
    "VpnTunnel",
    "VpnTunnelAggregatedList",
    "VpnTunnelList",
    "VpnTunnelsScopedList",
    "WafExpressionSet",
    "WafExpressionSetExpression",
    "WaitGlobalOperationRequest",
    "WaitRegionOperationRequest",
    "WaitZoneOperationRequest",
    "Warning",
    "Warnings",
    "WeightedBackendService",
    "XpnHostList",
    "XpnResourceId",
    "Zone",
    "ZoneList",
    "ZoneSetLabelsRequest",
    "ZoneSetPolicyRequest",
)
