# codat-files

<!-- Start SDK Installation -->
## SDK Installation

```bash
pip install codat-files
```
<!-- End SDK Installation -->

## SDK Example Usage
<!-- Start SDK Example Usage -->
```python
import codat
from codat.models import operations, shared

s = codat.Codat()
s.config_security(
    security=shared.Security(
        api_key="YOUR_API_KEY_HERE",
    )
)
   
req = operations.DownloadFilesRequest(
    security=operations.DownloadFilesSecurity(
        api_key="YOUR_API_KEY_HERE",
    ),
    path_params=operations.DownloadFilesPathParams(
        company_id="unde",
    ),
    query_params=operations.DownloadFilesQueryParams(
        date_="2022-07-28T14:41:43.209Z",
    ),
)
    
res = s.files.download_files(req)

if res.status_code == 200:
    # handle response
```
<!-- End SDK Example Usage -->

<!-- Start SDK Available Operations -->
## SDK Available Operations


### files

* `download_files` - Download all files for a company
* `list_files` - List all files uploaded by a company
* `upload_files` - Upload files for a company
<!-- End SDK Available Operations -->

### SDK Generated by [Speakeasy](https://docs.speakeasyapi.dev/docs/using-speakeasy/client-sdks)
