import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::IoTWireless::Destination`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-destination.html
 */
export interface CfnDestinationProps {
    /**
     * `AWS::IoTWireless::Destination.Expression`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-destination.html#cfn-iotwireless-destination-expression
     */
    readonly expression: string;
    /**
     * `AWS::IoTWireless::Destination.ExpressionType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-destination.html#cfn-iotwireless-destination-expressiontype
     */
    readonly expressionType: string;
    /**
     * `AWS::IoTWireless::Destination.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-destination.html#cfn-iotwireless-destination-name
     */
    readonly name: string;
    /**
     * `AWS::IoTWireless::Destination.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-destination.html#cfn-iotwireless-destination-rolearn
     */
    readonly roleArn: string;
    /**
     * `AWS::IoTWireless::Destination.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-destination.html#cfn-iotwireless-destination-description
     */
    readonly description?: string;
    /**
     * `AWS::IoTWireless::Destination.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-destination.html#cfn-iotwireless-destination-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoTWireless::Destination`.
 *
 * @external
 * @cloudformationResource AWS::IoTWireless::Destination
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-destination.html
 */
export declare class CfnDestination extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTWireless::Destination";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDestination;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::IoTWireless::Destination.Expression`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-destination.html#cfn-iotwireless-destination-expression
     */
    expression: string;
    /**
     * `AWS::IoTWireless::Destination.ExpressionType`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-destination.html#cfn-iotwireless-destination-expressiontype
     */
    expressionType: string;
    /**
     * `AWS::IoTWireless::Destination.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-destination.html#cfn-iotwireless-destination-name
     */
    name: string;
    /**
     * `AWS::IoTWireless::Destination.RoleArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-destination.html#cfn-iotwireless-destination-rolearn
     */
    roleArn: string;
    /**
     * `AWS::IoTWireless::Destination.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-destination.html#cfn-iotwireless-destination-description
     */
    description: string | undefined;
    /**
     * `AWS::IoTWireless::Destination.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-destination.html#cfn-iotwireless-destination-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoTWireless::Destination`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDestinationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::IoTWireless::DeviceProfile`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-deviceprofile.html
 */
export interface CfnDeviceProfileProps {
    /**
     * `AWS::IoTWireless::DeviceProfile.LoRaWAN`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-deviceprofile.html#cfn-iotwireless-deviceprofile-lorawan
     */
    readonly loRaWan?: CfnDeviceProfile.LoRaWANDeviceProfileProperty | cdk.IResolvable;
    /**
     * `AWS::IoTWireless::DeviceProfile.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-deviceprofile.html#cfn-iotwireless-deviceprofile-name
     */
    readonly name?: string;
    /**
     * `AWS::IoTWireless::DeviceProfile.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-deviceprofile.html#cfn-iotwireless-deviceprofile-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoTWireless::DeviceProfile`.
 *
 * @external
 * @cloudformationResource AWS::IoTWireless::DeviceProfile
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-deviceprofile.html
 */
export declare class CfnDeviceProfile extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTWireless::DeviceProfile";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnDeviceProfile;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::IoTWireless::DeviceProfile.LoRaWAN`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-deviceprofile.html#cfn-iotwireless-deviceprofile-lorawan
     */
    loRaWan: CfnDeviceProfile.LoRaWANDeviceProfileProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTWireless::DeviceProfile.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-deviceprofile.html#cfn-iotwireless-deviceprofile-name
     */
    name: string | undefined;
    /**
     * `AWS::IoTWireless::DeviceProfile.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-deviceprofile.html#cfn-iotwireless-deviceprofile-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoTWireless::DeviceProfile`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnDeviceProfileProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::IoTWireless::DeviceProfile`.
 *
 * @external
 * @cloudformationResource AWS::IoTWireless::DeviceProfile
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-deviceprofile.html
 */
export declare namespace CfnDeviceProfile {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html
     */
    interface LoRaWANDeviceProfileProperty {
        /**
         * `CfnDeviceProfile.LoRaWANDeviceProfileProperty.ClassBTimeout`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-classbtimeout
         */
        readonly classBTimeout?: number;
        /**
         * `CfnDeviceProfile.LoRaWANDeviceProfileProperty.ClassCTimeout`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-classctimeout
         */
        readonly classCTimeout?: number;
        /**
         * `CfnDeviceProfile.LoRaWANDeviceProfileProperty.MacVersion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-macversion
         */
        readonly macVersion?: string;
        /**
         * `CfnDeviceProfile.LoRaWANDeviceProfileProperty.MaxDutyCycle`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-maxdutycycle
         */
        readonly maxDutyCycle?: number;
        /**
         * `CfnDeviceProfile.LoRaWANDeviceProfileProperty.MaxEirp`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-maxeirp
         */
        readonly maxEirp?: number;
        /**
         * `CfnDeviceProfile.LoRaWANDeviceProfileProperty.PingSlotDr`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-pingslotdr
         */
        readonly pingSlotDr?: number;
        /**
         * `CfnDeviceProfile.LoRaWANDeviceProfileProperty.PingSlotFreq`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-pingslotfreq
         */
        readonly pingSlotFreq?: number;
        /**
         * `CfnDeviceProfile.LoRaWANDeviceProfileProperty.PingSlotPeriod`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-pingslotperiod
         */
        readonly pingSlotPeriod?: number;
        /**
         * `CfnDeviceProfile.LoRaWANDeviceProfileProperty.RegParamsRevision`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-regparamsrevision
         */
        readonly regParamsRevision?: string;
        /**
         * `CfnDeviceProfile.LoRaWANDeviceProfileProperty.RfRegion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-rfregion
         */
        readonly rfRegion?: string;
        /**
         * `CfnDeviceProfile.LoRaWANDeviceProfileProperty.Supports32BitFCnt`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-supports32bitfcnt
         */
        readonly supports32BitFCnt?: boolean | cdk.IResolvable;
        /**
         * `CfnDeviceProfile.LoRaWANDeviceProfileProperty.SupportsClassB`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-supportsclassb
         */
        readonly supportsClassB?: boolean | cdk.IResolvable;
        /**
         * `CfnDeviceProfile.LoRaWANDeviceProfileProperty.SupportsClassC`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-supportsclassc
         */
        readonly supportsClassC?: boolean | cdk.IResolvable;
        /**
         * `CfnDeviceProfile.LoRaWANDeviceProfileProperty.SupportsJoin`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-deviceprofile-lorawandeviceprofile.html#cfn-iotwireless-deviceprofile-lorawandeviceprofile-supportsjoin
         */
        readonly supportsJoin?: boolean | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::IoTWireless::ServiceProfile`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-serviceprofile.html
 */
export interface CfnServiceProfileProps {
    /**
     * `AWS::IoTWireless::ServiceProfile.LoRaWAN`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-serviceprofile.html#cfn-iotwireless-serviceprofile-lorawan
     */
    readonly loRaWan?: CfnServiceProfile.LoRaWANServiceProfileProperty | cdk.IResolvable;
    /**
     * `AWS::IoTWireless::ServiceProfile.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-serviceprofile.html#cfn-iotwireless-serviceprofile-name
     */
    readonly name?: string;
    /**
     * `AWS::IoTWireless::ServiceProfile.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-serviceprofile.html#cfn-iotwireless-serviceprofile-tags
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::IoTWireless::ServiceProfile`.
 *
 * @external
 * @cloudformationResource AWS::IoTWireless::ServiceProfile
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-serviceprofile.html
 */
export declare class CfnServiceProfile extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTWireless::ServiceProfile";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnServiceProfile;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute ChannelMask
     */
    readonly attrChannelMask: string;
    /**
     * @external
     * @cloudformationAttribute DevStatusReqFreq
     */
    readonly attrDevStatusReqFreq: number;
    /**
     * @external
     * @cloudformationAttribute DlBucketSize
     */
    readonly attrDlBucketSize: number;
    /**
     * @external
     * @cloudformationAttribute DlRate
     */
    readonly attrDlRate: number;
    /**
     * @external
     * @cloudformationAttribute DlRatePolicy
     */
    readonly attrDlRatePolicy: string;
    /**
     * @external
     * @cloudformationAttribute DrMax
     */
    readonly attrDrMax: number;
    /**
     * @external
     * @cloudformationAttribute DrMin
     */
    readonly attrDrMin: number;
    /**
     * @external
     * @cloudformationAttribute HrAllowed
     */
    readonly attrHrAllowed: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @external
     * @cloudformationAttribute LoRaWANResponse
     */
    readonly attrLoRaWanResponse: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute MinGwDiversity
     */
    readonly attrMinGwDiversity: number;
    /**
     * @external
     * @cloudformationAttribute NwkGeoLoc
     */
    readonly attrNwkGeoLoc: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute PrAllowed
     */
    readonly attrPrAllowed: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute RaAllowed
     */
    readonly attrRaAllowed: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute ReportDevStatusBattery
     */
    readonly attrReportDevStatusBattery: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute ReportDevStatusMargin
     */
    readonly attrReportDevStatusMargin: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute TargetPer
     */
    readonly attrTargetPer: number;
    /**
     * @external
     * @cloudformationAttribute UlBucketSize
     */
    readonly attrUlBucketSize: number;
    /**
     * @external
     * @cloudformationAttribute UlRate
     */
    readonly attrUlRate: number;
    /**
     * @external
     * @cloudformationAttribute UlRatePolicy
     */
    readonly attrUlRatePolicy: string;
    /**
     * `AWS::IoTWireless::ServiceProfile.LoRaWAN`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-serviceprofile.html#cfn-iotwireless-serviceprofile-lorawan
     */
    loRaWan: CfnServiceProfile.LoRaWANServiceProfileProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTWireless::ServiceProfile.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-serviceprofile.html#cfn-iotwireless-serviceprofile-name
     */
    name: string | undefined;
    /**
     * `AWS::IoTWireless::ServiceProfile.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-serviceprofile.html#cfn-iotwireless-serviceprofile-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::IoTWireless::ServiceProfile`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnServiceProfileProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::IoTWireless::ServiceProfile`.
 *
 * @external
 * @cloudformationResource AWS::IoTWireless::ServiceProfile
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-serviceprofile.html
 */
export declare namespace CfnServiceProfile {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html
     */
    interface LoRaWANServiceProfileProperty {
        /**
         * `CfnServiceProfile.LoRaWANServiceProfileProperty.AddGwMetadata`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-addgwmetadata
         */
        readonly addGwMetadata?: boolean | cdk.IResolvable;
        /**
         * `CfnServiceProfile.LoRaWANServiceProfileProperty.ChannelMask`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-channelmask
         */
        readonly channelMask?: string;
        /**
         * `CfnServiceProfile.LoRaWANServiceProfileProperty.DevStatusReqFreq`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-devstatusreqfreq
         */
        readonly devStatusReqFreq?: number;
        /**
         * `CfnServiceProfile.LoRaWANServiceProfileProperty.DlBucketSize`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-dlbucketsize
         */
        readonly dlBucketSize?: number;
        /**
         * `CfnServiceProfile.LoRaWANServiceProfileProperty.DlRate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-dlrate
         */
        readonly dlRate?: number;
        /**
         * `CfnServiceProfile.LoRaWANServiceProfileProperty.DlRatePolicy`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-dlratepolicy
         */
        readonly dlRatePolicy?: string;
        /**
         * `CfnServiceProfile.LoRaWANServiceProfileProperty.DrMax`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-drmax
         */
        readonly drMax?: number;
        /**
         * `CfnServiceProfile.LoRaWANServiceProfileProperty.DrMin`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-drmin
         */
        readonly drMin?: number;
        /**
         * `CfnServiceProfile.LoRaWANServiceProfileProperty.HrAllowed`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-hrallowed
         */
        readonly hrAllowed?: boolean | cdk.IResolvable;
        /**
         * `CfnServiceProfile.LoRaWANServiceProfileProperty.MinGwDiversity`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-mingwdiversity
         */
        readonly minGwDiversity?: number;
        /**
         * `CfnServiceProfile.LoRaWANServiceProfileProperty.NwkGeoLoc`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-nwkgeoloc
         */
        readonly nwkGeoLoc?: boolean | cdk.IResolvable;
        /**
         * `CfnServiceProfile.LoRaWANServiceProfileProperty.PrAllowed`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-prallowed
         */
        readonly prAllowed?: boolean | cdk.IResolvable;
        /**
         * `CfnServiceProfile.LoRaWANServiceProfileProperty.RaAllowed`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-raallowed
         */
        readonly raAllowed?: boolean | cdk.IResolvable;
        /**
         * `CfnServiceProfile.LoRaWANServiceProfileProperty.ReportDevStatusBattery`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-reportdevstatusbattery
         */
        readonly reportDevStatusBattery?: boolean | cdk.IResolvable;
        /**
         * `CfnServiceProfile.LoRaWANServiceProfileProperty.ReportDevStatusMargin`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-reportdevstatusmargin
         */
        readonly reportDevStatusMargin?: boolean | cdk.IResolvable;
        /**
         * `CfnServiceProfile.LoRaWANServiceProfileProperty.TargetPer`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-targetper
         */
        readonly targetPer?: number;
        /**
         * `CfnServiceProfile.LoRaWANServiceProfileProperty.UlBucketSize`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-ulbucketsize
         */
        readonly ulBucketSize?: number;
        /**
         * `CfnServiceProfile.LoRaWANServiceProfileProperty.UlRate`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-ulrate
         */
        readonly ulRate?: number;
        /**
         * `CfnServiceProfile.LoRaWANServiceProfileProperty.UlRatePolicy`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-serviceprofile-lorawanserviceprofile.html#cfn-iotwireless-serviceprofile-lorawanserviceprofile-ulratepolicy
         */
        readonly ulRatePolicy?: string;
    }
}
/**
 * Properties for defining a `AWS::IoTWireless::WirelessDevice`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html
 */
export interface CfnWirelessDeviceProps {
    /**
     * `AWS::IoTWireless::WirelessDevice.DestinationName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-destinationname
     */
    readonly destinationName: string;
    /**
     * `AWS::IoTWireless::WirelessDevice.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-type
     */
    readonly type: string;
    /**
     * `AWS::IoTWireless::WirelessDevice.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-description
     */
    readonly description?: string;
    /**
     * `AWS::IoTWireless::WirelessDevice.LastUplinkReceivedAt`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-lastuplinkreceivedat
     */
    readonly lastUplinkReceivedAt?: string;
    /**
     * `AWS::IoTWireless::WirelessDevice.LoRaWAN`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-lorawan
     */
    readonly loRaWan?: CfnWirelessDevice.LoRaWANDeviceProperty | cdk.IResolvable;
    /**
     * `AWS::IoTWireless::WirelessDevice.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-name
     */
    readonly name?: string;
    /**
     * `AWS::IoTWireless::WirelessDevice.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::IoTWireless::WirelessDevice.ThingArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-thingarn
     */
    readonly thingArn?: string;
}
/**
 * A CloudFormation `AWS::IoTWireless::WirelessDevice`.
 *
 * @external
 * @cloudformationResource AWS::IoTWireless::WirelessDevice
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html
 */
export declare class CfnWirelessDevice extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTWireless::WirelessDevice";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnWirelessDevice;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @external
     * @cloudformationAttribute ThingName
     */
    readonly attrThingName: string;
    /**
     * `AWS::IoTWireless::WirelessDevice.DestinationName`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-destinationname
     */
    destinationName: string;
    /**
     * `AWS::IoTWireless::WirelessDevice.Type`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-type
     */
    type: string;
    /**
     * `AWS::IoTWireless::WirelessDevice.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-description
     */
    description: string | undefined;
    /**
     * `AWS::IoTWireless::WirelessDevice.LastUplinkReceivedAt`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-lastuplinkreceivedat
     */
    lastUplinkReceivedAt: string | undefined;
    /**
     * `AWS::IoTWireless::WirelessDevice.LoRaWAN`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-lorawan
     */
    loRaWan: CfnWirelessDevice.LoRaWANDeviceProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::IoTWireless::WirelessDevice.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-name
     */
    name: string | undefined;
    /**
     * `AWS::IoTWireless::WirelessDevice.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::IoTWireless::WirelessDevice.ThingArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html#cfn-iotwireless-wirelessdevice-thingarn
     */
    thingArn: string | undefined;
    /**
     * Create a new `AWS::IoTWireless::WirelessDevice`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnWirelessDeviceProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::IoTWireless::WirelessDevice`.
 *
 * @external
 * @cloudformationResource AWS::IoTWireless::WirelessDevice
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html
 */
export declare namespace CfnWirelessDevice {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-abpv10x.html
     */
    interface AbpV10xProperty {
        /**
         * `CfnWirelessDevice.AbpV10xProperty.DevAddr`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-abpv10x.html#cfn-iotwireless-wirelessdevice-abpv10x-devaddr
         */
        readonly devAddr: string;
        /**
         * `CfnWirelessDevice.AbpV10xProperty.SessionKeys`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-abpv10x.html#cfn-iotwireless-wirelessdevice-abpv10x-sessionkeys
         */
        readonly sessionKeys: CfnWirelessDevice.SessionKeysAbpV10xProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTWireless::WirelessDevice`.
 *
 * @external
 * @cloudformationResource AWS::IoTWireless::WirelessDevice
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html
 */
export declare namespace CfnWirelessDevice {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-abpv11.html
     */
    interface AbpV11Property {
        /**
         * `CfnWirelessDevice.AbpV11Property.DevAddr`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-abpv11.html#cfn-iotwireless-wirelessdevice-abpv11-devaddr
         */
        readonly devAddr: string;
        /**
         * `CfnWirelessDevice.AbpV11Property.SessionKeys`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-abpv11.html#cfn-iotwireless-wirelessdevice-abpv11-sessionkeys
         */
        readonly sessionKeys: CfnWirelessDevice.SessionKeysAbpV11Property | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::IoTWireless::WirelessDevice`.
 *
 * @external
 * @cloudformationResource AWS::IoTWireless::WirelessDevice
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html
 */
export declare namespace CfnWirelessDevice {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-lorawandevice.html
     */
    interface LoRaWANDeviceProperty {
        /**
         * `CfnWirelessDevice.LoRaWANDeviceProperty.AbpV10x`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-lorawandevice.html#cfn-iotwireless-wirelessdevice-lorawandevice-abpv10x
         */
        readonly abpV10X?: CfnWirelessDevice.AbpV10xProperty | cdk.IResolvable;
        /**
         * `CfnWirelessDevice.LoRaWANDeviceProperty.AbpV11`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-lorawandevice.html#cfn-iotwireless-wirelessdevice-lorawandevice-abpv11
         */
        readonly abpV11?: CfnWirelessDevice.AbpV11Property | cdk.IResolvable;
        /**
         * `CfnWirelessDevice.LoRaWANDeviceProperty.DevEui`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-lorawandevice.html#cfn-iotwireless-wirelessdevice-lorawandevice-deveui
         */
        readonly devEui?: string;
        /**
         * `CfnWirelessDevice.LoRaWANDeviceProperty.DeviceProfileId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-lorawandevice.html#cfn-iotwireless-wirelessdevice-lorawandevice-deviceprofileid
         */
        readonly deviceProfileId?: string;
        /**
         * `CfnWirelessDevice.LoRaWANDeviceProperty.OtaaV10x`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-lorawandevice.html#cfn-iotwireless-wirelessdevice-lorawandevice-otaav10x
         */
        readonly otaaV10X?: CfnWirelessDevice.OtaaV10xProperty | cdk.IResolvable;
        /**
         * `CfnWirelessDevice.LoRaWANDeviceProperty.OtaaV11`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-lorawandevice.html#cfn-iotwireless-wirelessdevice-lorawandevice-otaav11
         */
        readonly otaaV11?: CfnWirelessDevice.OtaaV11Property | cdk.IResolvable;
        /**
         * `CfnWirelessDevice.LoRaWANDeviceProperty.ServiceProfileId`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-lorawandevice.html#cfn-iotwireless-wirelessdevice-lorawandevice-serviceprofileid
         */
        readonly serviceProfileId?: string;
    }
}
/**
 * A CloudFormation `AWS::IoTWireless::WirelessDevice`.
 *
 * @external
 * @cloudformationResource AWS::IoTWireless::WirelessDevice
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html
 */
export declare namespace CfnWirelessDevice {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-otaav10x.html
     */
    interface OtaaV10xProperty {
        /**
         * `CfnWirelessDevice.OtaaV10xProperty.AppEui`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-otaav10x.html#cfn-iotwireless-wirelessdevice-otaav10x-appeui
         */
        readonly appEui: string;
        /**
         * `CfnWirelessDevice.OtaaV10xProperty.AppKey`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-otaav10x.html#cfn-iotwireless-wirelessdevice-otaav10x-appkey
         */
        readonly appKey: string;
    }
}
/**
 * A CloudFormation `AWS::IoTWireless::WirelessDevice`.
 *
 * @external
 * @cloudformationResource AWS::IoTWireless::WirelessDevice
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html
 */
export declare namespace CfnWirelessDevice {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-otaav11.html
     */
    interface OtaaV11Property {
        /**
         * `CfnWirelessDevice.OtaaV11Property.AppKey`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-otaav11.html#cfn-iotwireless-wirelessdevice-otaav11-appkey
         */
        readonly appKey: string;
        /**
         * `CfnWirelessDevice.OtaaV11Property.JoinEui`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-otaav11.html#cfn-iotwireless-wirelessdevice-otaav11-joineui
         */
        readonly joinEui: string;
        /**
         * `CfnWirelessDevice.OtaaV11Property.NwkKey`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-otaav11.html#cfn-iotwireless-wirelessdevice-otaav11-nwkkey
         */
        readonly nwkKey: string;
    }
}
/**
 * A CloudFormation `AWS::IoTWireless::WirelessDevice`.
 *
 * @external
 * @cloudformationResource AWS::IoTWireless::WirelessDevice
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html
 */
export declare namespace CfnWirelessDevice {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-sessionkeysabpv10x.html
     */
    interface SessionKeysAbpV10xProperty {
        /**
         * `CfnWirelessDevice.SessionKeysAbpV10xProperty.AppSKey`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-sessionkeysabpv10x.html#cfn-iotwireless-wirelessdevice-sessionkeysabpv10x-appskey
         */
        readonly appSKey: string;
        /**
         * `CfnWirelessDevice.SessionKeysAbpV10xProperty.NwkSKey`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-sessionkeysabpv10x.html#cfn-iotwireless-wirelessdevice-sessionkeysabpv10x-nwkskey
         */
        readonly nwkSKey: string;
    }
}
/**
 * A CloudFormation `AWS::IoTWireless::WirelessDevice`.
 *
 * @external
 * @cloudformationResource AWS::IoTWireless::WirelessDevice
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessdevice.html
 */
export declare namespace CfnWirelessDevice {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-sessionkeysabpv11.html
     */
    interface SessionKeysAbpV11Property {
        /**
         * `CfnWirelessDevice.SessionKeysAbpV11Property.AppSKey`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-sessionkeysabpv11.html#cfn-iotwireless-wirelessdevice-sessionkeysabpv11-appskey
         */
        readonly appSKey: string;
        /**
         * `CfnWirelessDevice.SessionKeysAbpV11Property.FNwkSIntKey`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-sessionkeysabpv11.html#cfn-iotwireless-wirelessdevice-sessionkeysabpv11-fnwksintkey
         */
        readonly fNwkSIntKey: string;
        /**
         * `CfnWirelessDevice.SessionKeysAbpV11Property.NwkSEncKey`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-sessionkeysabpv11.html#cfn-iotwireless-wirelessdevice-sessionkeysabpv11-nwksenckey
         */
        readonly nwkSEncKey: string;
        /**
         * `CfnWirelessDevice.SessionKeysAbpV11Property.SNwkSIntKey`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessdevice-sessionkeysabpv11.html#cfn-iotwireless-wirelessdevice-sessionkeysabpv11-snwksintkey
         */
        readonly sNwkSIntKey: string;
    }
}
/**
 * Properties for defining a `AWS::IoTWireless::WirelessGateway`.
 *
 * @external
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessgateway.html
 */
export interface CfnWirelessGatewayProps {
    /**
     * `AWS::IoTWireless::WirelessGateway.LoRaWAN`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessgateway.html#cfn-iotwireless-wirelessgateway-lorawan
     */
    readonly loRaWan: CfnWirelessGateway.LoRaWANGatewayProperty | cdk.IResolvable;
    /**
     * `AWS::IoTWireless::WirelessGateway.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessgateway.html#cfn-iotwireless-wirelessgateway-description
     */
    readonly description?: string;
    /**
     * `AWS::IoTWireless::WirelessGateway.LastUplinkReceivedAt`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessgateway.html#cfn-iotwireless-wirelessgateway-lastuplinkreceivedat
     */
    readonly lastUplinkReceivedAt?: string;
    /**
     * `AWS::IoTWireless::WirelessGateway.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessgateway.html#cfn-iotwireless-wirelessgateway-name
     */
    readonly name?: string;
    /**
     * `AWS::IoTWireless::WirelessGateway.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessgateway.html#cfn-iotwireless-wirelessgateway-tags
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::IoTWireless::WirelessGateway.ThingArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessgateway.html#cfn-iotwireless-wirelessgateway-thingarn
     */
    readonly thingArn?: string;
}
/**
 * A CloudFormation `AWS::IoTWireless::WirelessGateway`.
 *
 * @external
 * @cloudformationResource AWS::IoTWireless::WirelessGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessgateway.html
 */
export declare class CfnWirelessGateway extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::IoTWireless::WirelessGateway";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnWirelessGateway;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * @external
     * @cloudformationAttribute ThingName
     */
    readonly attrThingName: string;
    /**
     * `AWS::IoTWireless::WirelessGateway.LoRaWAN`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessgateway.html#cfn-iotwireless-wirelessgateway-lorawan
     */
    loRaWan: CfnWirelessGateway.LoRaWANGatewayProperty | cdk.IResolvable;
    /**
     * `AWS::IoTWireless::WirelessGateway.Description`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessgateway.html#cfn-iotwireless-wirelessgateway-description
     */
    description: string | undefined;
    /**
     * `AWS::IoTWireless::WirelessGateway.LastUplinkReceivedAt`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessgateway.html#cfn-iotwireless-wirelessgateway-lastuplinkreceivedat
     */
    lastUplinkReceivedAt: string | undefined;
    /**
     * `AWS::IoTWireless::WirelessGateway.Name`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessgateway.html#cfn-iotwireless-wirelessgateway-name
     */
    name: string | undefined;
    /**
     * `AWS::IoTWireless::WirelessGateway.Tags`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessgateway.html#cfn-iotwireless-wirelessgateway-tags
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::IoTWireless::WirelessGateway.ThingArn`.
     *
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessgateway.html#cfn-iotwireless-wirelessgateway-thingarn
     */
    thingArn: string | undefined;
    /**
     * Create a new `AWS::IoTWireless::WirelessGateway`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnWirelessGatewayProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::IoTWireless::WirelessGateway`.
 *
 * @external
 * @cloudformationResource AWS::IoTWireless::WirelessGateway
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-iotwireless-wirelessgateway.html
 */
export declare namespace CfnWirelessGateway {
    /**
     * @external
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessgateway-lorawangateway.html
     */
    interface LoRaWANGatewayProperty {
        /**
         * `CfnWirelessGateway.LoRaWANGatewayProperty.GatewayEui`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessgateway-lorawangateway.html#cfn-iotwireless-wirelessgateway-lorawangateway-gatewayeui
         */
        readonly gatewayEui: string;
        /**
         * `CfnWirelessGateway.LoRaWANGatewayProperty.RfRegion`.
         *
         * @external
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-iotwireless-wirelessgateway-lorawangateway.html#cfn-iotwireless-wirelessgateway-lorawangateway-rfregion
         */
        readonly rfRegion: string;
    }
}
