"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackupBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_s3_1 = require("@aws-cdk/aws-s3");
const core_1 = require("@aws-cdk/core");
class BackupBucket extends aws_s3_1.Bucket {
    constructor(scope, id, props) {
        const { retentionPeriod = core_1.Duration.days(35), ...rest } = props || {};
        super(scope, id, {
            lifecycleRules: [
                {
                    expiration: retentionPeriod,
                },
            ],
            encryption: aws_s3_1.BucketEncryption.S3_MANAGED,
            publicReadAccess: false,
            blockPublicAccess: aws_s3_1.BlockPublicAccess.BLOCK_ALL,
            removalPolicy: core_1.RemovalPolicy.RETAIN,
            ...rest,
        });
    }
}
exports.BackupBucket = BackupBucket;
_a = JSII_RTTI_SYMBOL_1;
BackupBucket[_a] = { fqn: "@cloudcomponents/cdk-codecommit-backup.BackupBucket", version: "1.36.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYmFja3VwLWJ1Y2tldC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9iYWNrdXAtYnVja2V0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNENBQTJGO0FBQzNGLHdDQUFtRTtBQU1uRSxNQUFhLFlBQWEsU0FBUSxlQUFNO0lBQ3RDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBeUI7UUFDakUsTUFBTSxFQUFFLGVBQWUsR0FBRyxlQUFRLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxFQUFFLEdBQUcsSUFBSSxFQUFFLEdBQUcsS0FBSyxJQUFJLEVBQUUsQ0FBQztRQUVyRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRTtZQUNmLGNBQWMsRUFBRTtnQkFDZDtvQkFDRSxVQUFVLEVBQUUsZUFBZTtpQkFDNUI7YUFDRjtZQUNELFVBQVUsRUFBRSx5QkFBZ0IsQ0FBQyxVQUFVO1lBQ3ZDLGdCQUFnQixFQUFFLEtBQUs7WUFDdkIsaUJBQWlCLEVBQUUsMEJBQWlCLENBQUMsU0FBUztZQUM5QyxhQUFhLEVBQUUsb0JBQWEsQ0FBQyxNQUFNO1lBQ25DLEdBQUcsSUFBSTtTQUNSLENBQUMsQ0FBQztJQUNMLENBQUM7O0FBaEJILG9DQWlCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEJ1Y2tldCwgQnVja2V0UHJvcHMsIEJ1Y2tldEVuY3J5cHRpb24sIEJsb2NrUHVibGljQWNjZXNzIH0gZnJvbSAnQGF3cy1jZGsvYXdzLXMzJztcbmltcG9ydCB7IENvbnN0cnVjdCwgUmVtb3ZhbFBvbGljeSwgRHVyYXRpb24gfSBmcm9tICdAYXdzLWNkay9jb3JlJztcblxuZXhwb3J0IGludGVyZmFjZSBCYWNrdXBCdWNrZXRQcm9wcyBleHRlbmRzIEJ1Y2tldFByb3BzIHtcbiAgcmVhZG9ubHkgcmV0ZW50aW9uUGVyaW9kPzogRHVyYXRpb247XG59XG5cbmV4cG9ydCBjbGFzcyBCYWNrdXBCdWNrZXQgZXh0ZW5kcyBCdWNrZXQge1xuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wcz86IEJhY2t1cEJ1Y2tldFByb3BzKSB7XG4gICAgY29uc3QgeyByZXRlbnRpb25QZXJpb2QgPSBEdXJhdGlvbi5kYXlzKDM1KSwgLi4ucmVzdCB9ID0gcHJvcHMgfHwge307XG5cbiAgICBzdXBlcihzY29wZSwgaWQsIHtcbiAgICAgIGxpZmVjeWNsZVJ1bGVzOiBbXG4gICAgICAgIHtcbiAgICAgICAgICBleHBpcmF0aW9uOiByZXRlbnRpb25QZXJpb2QsXG4gICAgICAgIH0sXG4gICAgICBdLFxuICAgICAgZW5jcnlwdGlvbjogQnVja2V0RW5jcnlwdGlvbi5TM19NQU5BR0VELFxuICAgICAgcHVibGljUmVhZEFjY2VzczogZmFsc2UsXG4gICAgICBibG9ja1B1YmxpY0FjY2VzczogQmxvY2tQdWJsaWNBY2Nlc3MuQkxPQ0tfQUxMLFxuICAgICAgcmVtb3ZhbFBvbGljeTogUmVtb3ZhbFBvbGljeS5SRVRBSU4sXG4gICAgICAuLi5yZXN0LFxuICAgIH0pO1xuICB9XG59XG4iXX0=