"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.VirtualBorderRouter = exports.VirtualBorderRouterProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const vpc_generated_1 = require("./vpc.generated");
Object.defineProperty(exports, "VirtualBorderRouterProperty", { enumerable: true, get: function () { return vpc_generated_1.RosVirtualBorderRouter; } });
/**
 * A ROS resource type:  `ALIYUN::VPC::VirtualBorderRouter`
 */
class VirtualBorderRouter extends ros.Resource {
    /**
     * Create a new `ALIYUN::VPC::VirtualBorderRouter`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosVirtualBorderRouter = new vpc_generated_1.RosVirtualBorderRouter(this, id, {
            peerGatewayIp: props.peerGatewayIp,
            localGatewayIp: props.localGatewayIp,
            description: props.description,
            circuitCode: props.circuitCode,
            physicalConnectionId: props.physicalConnectionId,
            peeringSubnetMask: props.peeringSubnetMask,
            vlanId: props.vlanId,
            name: props.name,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosVirtualBorderRouter;
        this.attrName = rosVirtualBorderRouter.attrName;
        this.attrRouteTableId = rosVirtualBorderRouter.attrRouteTableId;
        this.attrVbrId = rosVirtualBorderRouter.attrVbrId;
        this.attrVlanInterfaceId = rosVirtualBorderRouter.attrVlanInterfaceId;
    }
}
exports.VirtualBorderRouter = VirtualBorderRouter;
//# sourceMappingURL=data:application/json;base64,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