"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.NatIp = exports.NatIpProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const vpc_generated_1 = require("./vpc.generated");
Object.defineProperty(exports, "NatIpProperty", { enumerable: true, get: function () { return vpc_generated_1.RosNatIp; } });
/**
 * A ROS resource type:  `ALIYUN::VPC::NatIp`
 */
class NatIp extends ros.Resource {
    /**
     * Create a new `ALIYUN::VPC::NatIp`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosNatIp = new vpc_generated_1.RosNatIp(this, id, {
            natIp: props.natIp,
            natIpCidr: props.natIpCidr,
            natIpCidrId: props.natIpCidrId,
            natIpDescription: props.natIpDescription,
            natIpName: props.natIpName,
            natGatewayId: props.natGatewayId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosNatIp;
        this.attrNatIp = rosNatIp.attrNatIp;
        this.attrNatIpId = rosNatIp.attrNatIpId;
    }
}
exports.NatIp = NatIp;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmF0aXAuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJuYXRpcC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw4Q0FBOEM7QUFDOUMsbURBQTJDO0FBRXRCLDhGQUZaLHdCQUFRLE9BRWlCO0FBOENsQzs7R0FFRztBQUNILE1BQWEsS0FBTSxTQUFRLEdBQUcsQ0FBQyxRQUFRO0lBaUJuQzs7Ozs7O09BTUc7SUFDSCxZQUFZLEtBQW9CLEVBQUUsRUFBVSxFQUFFLEtBQWlCLEVBQUUsbUNBQTJDLElBQUk7UUFDNUcsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLFFBQVEsR0FBRyxJQUFJLHdCQUFRLENBQUMsSUFBSSxFQUFFLEVBQUUsRUFBRztZQUNyQyxLQUFLLEVBQUUsS0FBSyxDQUFDLEtBQUs7WUFDbEIsU0FBUyxFQUFFLEtBQUssQ0FBQyxTQUFTO1lBQzFCLFdBQVcsRUFBRSxLQUFLLENBQUMsV0FBVztZQUM5QixnQkFBZ0IsRUFBRSxLQUFLLENBQUMsZ0JBQWdCO1lBQ3hDLFNBQVMsRUFBRSxLQUFLLENBQUMsU0FBUztZQUMxQixZQUFZLEVBQUUsS0FBSyxDQUFDLFlBQVk7U0FDbkMsRUFBRSxnQ0FBZ0MsSUFBSSxJQUFJLENBQUMsS0FBSyxDQUFDLGdDQUFnQyxDQUFDLENBQUM7UUFDcEYsSUFBSSxDQUFDLFFBQVEsR0FBRyxRQUFRLENBQUM7UUFDekIsSUFBSSxDQUFDLFNBQVMsR0FBRyxRQUFRLENBQUMsU0FBUyxDQUFDO1FBQ3BDLElBQUksQ0FBQyxXQUFXLEdBQUcsUUFBUSxDQUFDLFdBQVcsQ0FBQztJQUM1QyxDQUFDO0NBQ0o7QUF2Q0Qsc0JBdUNDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgcm9zIGZyb20gJ0BhbGljbG91ZC9yb3MtY2RrLWNvcmUnO1xuaW1wb3J0IHsgUm9zTmF0SXAgfSBmcm9tICcuL3ZwYy5nZW5lcmF0ZWQnO1xuLy8gR2VuZXJhdGVkIGZyb20gdGhlIEFsaUNsb3VkIFJPUyBSZXNvdXJjZSBTcGVjaWZpY2F0aW9uXG5leHBvcnQgeyBSb3NOYXRJcCBhcyBOYXRJcFByb3BlcnR5IH07XG5cbi8qKlxuICogUHJvcGVydGllcyBmb3IgZGVmaW5pbmcgYSBgQUxJWVVOOjpWUEM6Ok5hdElwYFxuICovXG5leHBvcnQgaW50ZXJmYWNlIE5hdElwUHJvcHMge1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgbmF0R2F0ZXdheUlkOiBUaGUgSUQgb2YgdGhlIFZpcnR1YWwgUHJpdmF0ZSBDbG91ZCAoVlBDKSBOQVQgZ2F0ZXdheSBmb3Igd2hpY2ggeW91IHdhbnQgdG8gY3JlYXRlXG4gICAgICogdGhlIE5BVCBJUCBhZGRyZXNzLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IG5hdEdhdGV3YXlJZDogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xuXG4gICAgLyoqXG4gICAgICogUHJvcGVydHkgbmF0SXBDaWRyOiBUaGUgQ0lEUiBibG9jayB0byB3aGljaCB0aGUgTkFUIElQIGFkZHJlc3MgYmVsb25ncy5cbiAgICAgKi9cbiAgICByZWFkb25seSBuYXRJcENpZHI6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IG5hdElwRGVzY3JpcHRpb246IFRoZSBkZXNjcmlwdGlvbiBvZiB0aGUgTkFUIElQIGFkZHJlc3MuXG4gICAgICogVGhlIGRlc2NyaXB0aW9uIG11c3QgYmUgMiB0byAyNTYgY2hhcmFjdGVycyBpbiBsZW5ndGguIEl0IG11c3Qgc3RhcnQgd2l0aCBhIGxldHRlclxuICAgICAqIGJ1dCBjYW5ub3Qgc3RhcnQgd2l0aCBodHRwOi8vIG9yIGh0dHBzOi8vLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IG5hdElwRGVzY3JpcHRpb246IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IG5hdElwTmFtZTogVGhlIG5hbWUgb2YgdGhlIE5BVCBJUCBhZGRyZXNzLlxuICAgICAqIFRoZSBuYW1lIG11c3QgYmUgMiB0byAxMjggY2hhcmFjdGVycyBpbiBsZW5ndGgsIGFuZCBjYW4gY29udGFpbiBsZXR0ZXJzLCBkaWdpdHMsIHBlcmlvZHNcbiAgICAgKiAoLiksIHVuZGVyc2NvcmVzIChfKSwgYW5kIGh5cGhlbnMgKC0pLiBJdCBtdXN0IHN0YXJ0IHdpdGggYSBsZXR0ZXIuIEl0IGNhbm5vdCBzdGFydFxuICAgICAqIHdpdGggaHR0cDovLyBvciBodHRwczovLy5cbiAgICAgKi9cbiAgICByZWFkb25seSBuYXRJcE5hbWU6IHN0cmluZyB8IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIFByb3BlcnR5IG5hdElwOiBUaGUgTkFUIElQIGFkZHJlc3MgdGhhdCB5b3Ugd2FudCB0byBjcmVhdGUuXG4gICAgICogSWYgeW91IGRvIG5vdCBzcGVjaWZ5IGFuIElQIGFkZHJlc3MsIHRoZSBzeXN0ZW0gc2VsZWN0cyBhIHJhbmRvbSBJUCBhZGRyZXNzIGZyb20gdGhlXG4gICAgICogc3BlY2lmaWVkIENJRFIgYmxvY2suXG4gICAgICovXG4gICAgcmVhZG9ubHkgbmF0SXA/OiBzdHJpbmcgfCByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBQcm9wZXJ0eSBuYXRJcENpZHJJZDogVGhlIElEIG9mIHRoZSBDSURSIGJsb2NrIHRvIHdoaWNoIHRoZSBOQVQgSVAgYWRkcmVzcyBiZWxvbmdzLlxuICAgICAqL1xuICAgIHJlYWRvbmx5IG5hdElwQ2lkcklkPzogc3RyaW5nIHwgcm9zLklSZXNvbHZhYmxlO1xufVxuXG4vKipcbiAqIEEgUk9TIHJlc291cmNlIHR5cGU6ICBgQUxJWVVOOjpWUEM6Ok5hdElwYFxuICovXG5leHBvcnQgY2xhc3MgTmF0SXAgZXh0ZW5kcyByb3MuUmVzb3VyY2Uge1xuXG4gICAgLyoqXG4gICAgICogQSBmYWN0b3J5IG1ldGhvZCB0aGF0IGNyZWF0ZXMgYSBuZXcgaW5zdGFuY2Ugb2YgdGhpcyBjbGFzcyBmcm9tIGFuIG9iamVjdFxuICAgICAqIGNvbnRhaW5pbmcgdGhlIHByb3BlcnRpZXMgb2YgdGhpcyBST1MgcmVzb3VyY2UsIHdoaWNoIHdpbGwgYmUgYXNzaWduZWQgdG8gUk9TIHJlc291cmNlLlxuICAgICAqL1xuXG4gICAgLyoqXG4gICAgICogQXR0cmlidXRlIE5hdElwOiBOQVQgSVAgYWRkcmVzcy5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ck5hdElwOiByb3MuSVJlc29sdmFibGU7XG5cbiAgICAvKipcbiAgICAgKiBBdHRyaWJ1dGUgTmF0SXBJZDogVGhlIElEIG9mIHRoZSBOQVQgSVAgYWRkcmVzcy5cbiAgICAgKi9cbiAgICBwdWJsaWMgcmVhZG9ubHkgYXR0ck5hdElwSWQ6IHJvcy5JUmVzb2x2YWJsZTtcblxuICAgIC8qKlxuICAgICAqIENyZWF0ZSBhIG5ldyBgQUxJWVVOOjpWUEM6Ok5hdElwYC5cbiAgICAgKlxuICAgICAqIFBhcmFtIHNjb3BlIC0gc2NvcGUgaW4gd2hpY2ggdGhpcyByZXNvdXJjZSBpcyBkZWZpbmVkXG4gICAgICogUGFyYW0gaWQgICAgLSBzY29wZWQgaWQgb2YgdGhlIHJlc291cmNlXG4gICAgICogUGFyYW0gcHJvcHMgLSByZXNvdXJjZSBwcm9wZXJ0aWVzXG4gICAgICovXG4gICAgY29uc3RydWN0b3Ioc2NvcGU6IHJvcy5Db25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBOYXRJcFByb3BzLCBlbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludDpib29sZWFuID0gdHJ1ZSkge1xuICAgICAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgICAgIGNvbnN0IHJvc05hdElwID0gbmV3IFJvc05hdElwKHRoaXMsIGlkLCAge1xuICAgICAgICAgICAgbmF0SXA6IHByb3BzLm5hdElwLFxuICAgICAgICAgICAgbmF0SXBDaWRyOiBwcm9wcy5uYXRJcENpZHIsXG4gICAgICAgICAgICBuYXRJcENpZHJJZDogcHJvcHMubmF0SXBDaWRySWQsXG4gICAgICAgICAgICBuYXRJcERlc2NyaXB0aW9uOiBwcm9wcy5uYXRJcERlc2NyaXB0aW9uLFxuICAgICAgICAgICAgbmF0SXBOYW1lOiBwcm9wcy5uYXRJcE5hbWUsXG4gICAgICAgICAgICBuYXRHYXRld2F5SWQ6IHByb3BzLm5hdEdhdGV3YXlJZCxcbiAgICAgICAgfSwgZW5hYmxlUmVzb3VyY2VQcm9wZXJ0eUNvbnN0cmFpbnQgJiYgdGhpcy5zdGFjay5lbmFibGVSZXNvdXJjZVByb3BlcnR5Q29uc3RyYWludCk7XG4gICAgICAgIHRoaXMucmVzb3VyY2UgPSByb3NOYXRJcDtcbiAgICAgICAgdGhpcy5hdHRyTmF0SXAgPSByb3NOYXRJcC5hdHRyTmF0SXA7XG4gICAgICAgIHRoaXMuYXR0ck5hdElwSWQgPSByb3NOYXRJcC5hdHRyTmF0SXBJZDtcbiAgICB9XG59XG4iXX0=