#!/usr/bin/env python
# coding:utf-8
"""银联卡bin表
作者：dengqingyong
邮箱：yu12377@163.com
时间：2019-11-05 17:30
"""


__all__ = ["bank_list", "bank_bin_list"]


bank_list = [
    {"key": "ABC", "name": "中国农业银行"},
    {"key": "KMRCU", "name": "昆明农村信用联合社"},
    {"key": "CEB", "name": "中国光大银行"},
    {"key": "CITIC", "name": "中信银行"},
    {"key": "SHBANK", "name": "上海银行"},
    {"key": "SPDB", "name": "上海浦东发展银行"},
    {"key": "CMBC", "name": "中国民生银行"},
    {"key": "SPABANK", "name": "平安银行"},
    {"key": "CMB", "name": "招商银行"},
    {"key": "ICBC", "name": "中国工商银行"},
    {"key": "COMM", "name": "交通银行"},
    {"key": "GDB", "name": "广东发展银行"},
    {"key": "BOC", "name": "中国银行"},
    {"key": "BJBANK", "name": "北京银行"},
    {"key": "CCB", "name": "中国建设银行"},
    {"key": "CIB", "name": "兴业银行"},
    {"key": "SCBHK", "name": "渣打银行(香港)"},
    {"key": "JSBANK", "name": "江苏银行"},
    {"key": "NBBANK", "name": "宁波银行"},
    {"key": "HXBANK", "name": "华夏银行"},
    {"key": "SJBANK", "name": "盛京银行"},
    {"key": "WXCCB", "name": "无锡市商业银行"},
    {"key": "HZCB", "name": "杭州银行"},
    {"key": "GCB", "name": "广州银行"},
    {"key": "HSBANK", "name": "徽商银行"},
    {"key": "SXCB", "name": "绍兴银行"},
    {"key": "CSRCB", "name": "常熟农村商业银行"},
    {"key": "TCCB", "name": "天津银行"},
    {"key": "FJHXBC", "name": "福建海峡银行"},
    {"key": "PSBC", "name": "中国邮政储蓄银行"},
    {"key": "CYS", "name": "中国银盛"},
    {"key": "BJRCB", "name": "北京农村商业银行"},
    {"key": "NBYZ", "name": "鄞州银行"},
    {"key": "CEP", "name": "中银通商务支付有限公司"},
    {"key": "MTBANK", "name": "浙江民泰商业银行"},
    {"key": "CSCB", "name": "长沙银行"},
    {"key": "XTB", "name": "邢台银行"},
    {"key": "DYCCB", "name": "东营市商业银行"},
    {"key": "XJRCU", "name": "新疆农村信用社"},
    {"key": "PLCCB", "name": "平凉市商业银行"},
    {"key": "HURCB", "name": "湖北省农村信用社"},
    {"key": "SRBANK", "name": "上饶银行"},
    {"key": "DBSCN", "name": "星展银行"},
    {"key": "DBS", "name": "星展银行"},
    {"key": "YNRCC", "name": "云南省农村信用社"},
    {"key": "GDRCC", "name": "广东省农村信用社联合社"},
    {"key": "CZBANK", "name": "浙商银行"},
    {"key": "HBRCU", "name": "河北省农村信用社"},
    {"key": "LNRCC", "name": "辽宁省农村信用社"},
    {"key": "CZCB", "name": "浙江稠州商业银行"},
    {"key": "KLB", "name": "昆仑银行"},
    {"key": "SCRCU", "name": "四川省农村信用社"},
    {"key": "ZYB", "name": "中原银行"},
    {"key": "BOHN", "name": "海南省农村信用社"},
    {"key": "DAQINGB", "name": "龙江银行"},
    {"key": "TLBANK", "name": "铁岭银行"},
    {"key": "NCB", "name": "南昌银行"},
    {"key": "CYBC", "name": "集友银行"},
    {"key": "CAB", "name": "宝鸡商行"},
    {"key": "FJNX", "name": "福建省农村信用社联合社"},
    {"key": "LSZRCB", "name": "凉山州商业银行"},
    {"key": "ZJNX", "name": "浙江省农村信用社联合社"},
    {"key": "JRCB", "name": "江苏江阴农村商业银行"},
    {"key": "XHRCB", "name": "新会农商银行"},
    {"key": "SLRCB", "name": "双流诚民村镇银行"},
    {"key": "WOORI", "name": "友利银行(中国)"},
    {"key": "GSRCU", "name": "甘肃省农村信用"},
    {"key": "CITI", "name": "花旗银行(中国)"},
    {"key": "AEON", "name": "AEON银行"},
    {"key": "QHRC", "name": "青海农村信用社"},
    {"key": "ZGCCB", "name": "自贡市商业银行"},
    {"key": "BOP", "name": "平顶山银行"},
    {"key": "BOSH", "name": "新韩银行(中国)"},
    {"key": "TJBHB", "name": "天津滨海农村商业银行"},
    {"key": "BOCY", "name": "朝阳银行"},
    {"key": "OCBC", "name": "华侨银行（中国）"},
    {"key": "LSCCB", "name": "乐山市商业银行"},
    {"key": "CHB", "name": "创兴银行有限公司"},
    {"key": "PZBANK", "name": "盘锦市商业银行"},
    {"key": "SNCCB", "name": "遂宁市商业银行"},
    {"key": "BDCBANK", "name": "保定银行"},
    {"key": "URB", "name": "联合村镇银行"},
    {"key": "JNBANK", "name": "济宁银行"},
    {"key": "HANABANK", "name": "韩亚银行"},
    {"key": "NCBANK", "name": "宁波通商银行"},
    {"key": "JSB", "name": "晋商银行"},
    {"key": "HBC", "name": "湖北银行"},
    {"key": "JZBANK", "name": "晋中市商业银行"},
    {"key": "HLJRCU", "name": "黑龙江省农村信用社"},
    {"key": "BNU", "name": "大西洋银行"},
    {"key": "DZCBANK", "name": "达州银行"},
    {"key": "CSC", "name": "CSC借记卡"},
    {"key": "QHDBANK", "name": "秦皇岛银行"},
    {"key": "HSBK", "name": "衡水银行"},
    {"key": "BOSZ", "name": "苏州银行"},
    {"key": "LZYH", "name": "兰州银行"},
    {"key": "HSBC", "name": "汇丰银行(中国)"},
    {"key": "QDCCB", "name": "青岛银行"},
    {"key": "BCDMMA", "name": "澳门商业银行"},
    {"key": "CRCBANK", "name": "重庆农村商业银行"},
    {"key": "NJCB", "name": "南京银行"},
    {"key": "XFRCB", "name": "咸丰常农商村镇银行"},
    {"key": "ESRCB", "name": "恩施农村商业银行"},
    {"key": "KORLABANK", "name": "库尔勒市商业银行"},
    {"key": "JSRCU", "name": "江苏省农村信用联合社"},
    {"key": "BOCZ", "name": "沧州银行"},
    {"key": "BOHAIB", "name": "渤海银行"},
    {"key": "YQCCB", "name": "阳泉银行"},
    {"key": "YBCCB", "name": "宜宾市商业银行"},
    {"key": "HDHMCB", "name": "惠东惠民村镇银行"},
    {"key": "GXHMVB", "name": "长春高新惠民村镇银行"},
    {"key": "FMBANK", "name": "吉林丰满惠民村镇银行"},
    {"key": "SXRCU", "name": "山西省农村信用社"},
    {"key": "CABANK", "name": "长安银行"},
    {"key": "WHB", "name": "永亨银行"},
    {"key": "YACCB", "name": "雅安市商业银行"},
    {"key": "XLBANK", "name": "中山小榄村镇银行"},
    {"key": "LANGFB", "name": "廊坊银行"},
    {"key": "NDHB", "name": "宁波东海银行"},
    {"key": "ERB", "name": "龙岗鼎业村镇银行"},
    {"key": "WHBANK", "name": "乌海银行"},
    {"key": "YZBANK", "name": "银座银行"},
    {"key": "XHCZYH", "name": "新华村镇银行"},
    {"key": "BOCFCB", "name": "中银富登村镇银行"},
    {"key": "WHRCB", "name": "武汉农村商业银行"},
    {"key": "NMGNXS", "name": "内蒙古农村信用社"},
    {"key": "CZRCB", "name": "常州农村信用联社"},
    {"key": "HRXJB", "name": "华融湘江银行"},
    {"key": "QLCZYH", "name": "齐鲁村镇银行"},
    {"key": "NYCB", "name": "南阳村镇银行"},
    {"key": "LZCCB", "name": "柳州银行"},
    {"key": "ZJKCCB", "name": "张家口市商业银行"},
    {"key": "FDB", "name": "富滇银行"},
    {"key": "NXBANK", "name": "宁夏银行"},
    {"key": "BOD", "name": "东莞银行"},
    {"key": "GLBANK", "name": "桂林银行"},
    {"key": "ZYCBANK", "name": "遵义市商业银行"},
    {"key": "GHB", "name": "广东华兴银行"},
    {"key": "ZJTLCB", "name": "浙江泰隆商业银行"},
    {"key": "RXCB", "name": "榆次融信村镇银行"},
    {"key": "CDCB", "name": "成都银行"},
    {"key": "QJCCB", "name": "曲靖市商业银行"},
    {"key": "CDRCB", "name": "成都农商银行"},
    {"key": "HNRCC", "name": "湖南省农村信用社"},
    {"key": "SDRCU", "name": "山东省农村信用社"},
    {"key": "GRCB", "name": "广州农商银行"},
    {"key": "ARCU", "name": "安徽省农村信用社"},
    {"key": "JLRCU", "name": "吉林农信"},
    {"key": "GYCB", "name": "贵阳市商业银行"},
    {"key": "SXRCCU", "name": "陕西信合"},
    {"key": "HRBANK", "name": "哈尔滨银行"},
    {"key": "HNRCU", "name": "河南省农村信用"},
    {"key": "GZRCU", "name": "贵州省农村信用社"},
    {"key": "XMBANK", "name": "厦门银行"},
    {"key": "SDEB", "name": "顺德农商银行"},
    {"key": "H3CB", "name": "内蒙古银行"},
    {"key": "NYBANK", "name": "广东南粤银行"},
    {"key": "SCB", "name": "渣打银行"},
    {"key": "URMQCCB", "name": "乌鲁木齐市商业银行"},
    {"key": "CCQTGB", "name": "重庆三峡银行"},
    {"key": "BSB", "name": "包商银行"},
    {"key": "WZCB", "name": "温州银行"},
    {"key": "FXCB", "name": "阜新银行"},
    {"key": "SRCB", "name": "深圳农村商业银行"},
    {"key": "JXBANK", "name": "嘉兴银行"},
    {"key": "CQBANK", "name": "重庆银行"},
    {"key": "XABANK", "name": "西安银行"},
    {"key": "JJBANK", "name": "九江银行"},
    {"key": "TSBANK", "name": "唐山银行"},
    {"key": "JLBANK", "name": "吉林银行"},
    {"key": "HKBEA", "name": "东亚银行"},
    {"key": "NHB", "name": "南海农村信用联社"},
    {"key": "DSB", "name": "大新银行"},
    {"key": "HZCCB", "name": "湖州市商业银行"},
    {"key": "BOQH", "name": "青海银行"},
    {"key": "TZCB", "name": "台州银行"},
    {"key": "HKB", "name": "汉口银行"},
    {"key": "DRCBCL", "name": "东莞农村商业银行"},
    {"key": "TRCB", "name": "天津农商银行"},
    {"key": "ZRCBANK", "name": "张家港农村商业银行"},
    {"key": "BGB", "name": "广西北部湾银行"},
    {"key": "JZCBANK", "name": "焦作市商业银行"},
    {"key": "PZHCCB", "name": "攀枝花市商业银行"},
    {"key": "LSBC", "name": "临商银行"},
    {"key": "RBOZ", "name": "珠海华润银行"},
    {"key": "MYBANK", "name": "绵阳市商业银行"},
    {"key": "BOQZ", "name": "泉州银行"},
    {"key": "BEAHK", "name": "东亚银行有限公司"},
    {"key": "HSB", "name": "恒生银行"},
    {"key": "QLBANK", "name": "齐鲁银行"},
    {"key": "DLB", "name": "大连银行"},
    {"key": "EGBANK", "name": "恒丰银行"},
    {"key": "WLB", "name": "永隆银行"},
    {"key": "BANKWF", "name": "潍坊银行"},
    {"key": "LUZBANK", "name": "泸州市商业银行"},
    {"key": "DTCCB", "name": "大同银行"},
    {"key": "YCCB", "name": "宜昌市商业银行"},
    {"key": "HLDB", "name": "葫芦岛市商业银行"},
    {"key": "LYCB", "name": "辽阳市商业银行"},
    {"key": "BOYK", "name": "营口银行"},
    {"key": "WHCCB", "name": "威海市商业银行"},
    {"key": "ASCB", "name": "鞍山银行"},
    {"key": "BODD", "name": "丹东银行"},
    {"key": "BOL", "name": "洛阳银行"},
    {"key": "ZZBANK", "name": "郑州银行"},
    {"key": "LSB", "name": "临商银行"},
    {"key": "FSCB", "name": "抚顺银行"},
    {"key": "KSRB", "name": "昆山农村商业银行"},
    {"key": "JHBANK", "name": "金华银行"},
    {"key": "SHRCB", "name": "上海农村商业银行"},
    {"key": "WJRCB", "name": "吴江农商银行"},
    {"key": "BHB", "name": "河北银行"},
    {"key": "QHDCCB", "name": "秦皇岛市商业银行"},
    {"key": "JINCHB", "name": "晋城银行"},
    {"key": "TFB", "name": "大丰银行有限公司"},
    {"key": "DYCB", "name": "德阳商业银行"},
    {"key": "WRCB", "name": "无锡农村商业银行"},
    {"key": "JXRCU", "name": "江西省农村信用"},
    {"key": "WHBMA", "name": "澳门永亨银行"},
    {"key": "RZB", "name": "日照银行"},
    {"key": "LSBANK", "name": "莱商银行"},
    {"key": "TCRCB", "name": "江苏太仓农村商业银行"},
    {"key": "CJCCB", "name": "苏州长江商业银行"},
    {"key": "YTBANK", "name": "烟台银行"},
    {"key": "CGNB", "name": "南充市商业银行"},
    {"key": "SLH", "name": "湖南农村信用社联合社"},
    {"key": "BOCD", "name": "承德银行"},
    {"key": "DZBANK", "name": "德州银行"},
    {"key": "SZSBK", "name": "石嘴山银行"},
    {"key": "NXRCU", "name": "宁夏黄河农村商业银行"},
    {"key": "HDBANK", "name": "邯郸银行"},
    {"key": "CZCCB", "name": "长治市商业银行"},
    {"key": "GZB", "name": "赣州银行"},
    {"key": "TACCB", "name": "泰安市商业银行"},
    {"key": "QDRCB", "name": "青岛农村商业银行"},
    {"key": "ORBANK", "name": "鄂尔多斯银行"},
    {"key": "YXCCB", "name": "玉溪市商业银行"},
    {"key": "BOJZ", "name": "锦州银行"},
    {"key": "GXRCU", "name": "广西省农村信用"},
    {"key": "GSBANK", "name": "甘肃银行"},
    {"key": "YDNSCZYH", "name": "尧都农商村镇银行"},
    {"key": "COMMHK", "name": "交通银行香港分行"},
    {"key": "WLBHK", "name": "永隆银行"},
    {"key": "YDRCB", "name": "尧都农商行"},
    {"key": "CDB", "name": "国家开发银行"},
    {"key": "ZBCB", "name": "齐商银行"},
    {"key": "XMCCB", "name": "厦门市商业银行"},
    {"key": "NTCCB", "name": "南通商业银行"},
    {"key": "ZJCCB", "name": "镇江市商业银行"},
    {"key": "KSRCB", "name": "昆山农信社"},
    {"key": "ZHCCB", "name": "珠海华润银行股份有限公司"},
    {"key": "FSCCB", "name": "抚顺银行股份有限公司"},
    {"key": "HLDCCB", "name": "葫芦岛市商业银行"},
    {"key": "ZZCCB", "name": "郑州商业银行"},
    {"key": "RZCCB", "name": "日照银行"},
    {"key": "YCCCB", "name": "盐城商行"},
]
bank_bin_list = [
    {"bin": "103", "bank": "ABC", "type": "DC", "length": "19", "name": "中国农业银行"},
    {
        "bin": "18572",
        "bank": "KMRCU",
        "type": "DC",
        "length": "18",
        "name": "昆明农村信用联合社",
    },
    {"bin": "303", "bank": "CEB", "type": "DC", "length": "16", "name": "中国光大银行"},
    {"bin": "356390", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "356391", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "356392", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "356827", "bank": "SHBANK", "type": "CC", "length": "16", "name": "上海银行"},
    {"bin": "356828", "bank": "SHBANK", "type": "CC", "length": "16", "name": "上海银行"},
    {"bin": "356829", "bank": "SHBANK", "type": "CC", "length": "16", "name": "上海银行"},
    {"bin": "356830", "bank": "SHBANK", "type": "CC", "length": "16", "name": "上海银行"},
    {"bin": "356837", "bank": "CEB", "type": "CC", "length": "16", "name": "中国光大银行"},
    {"bin": "356838", "bank": "CEB", "type": "CC", "length": "16", "name": "中国光大银行"},
    {"bin": "356839", "bank": "CEB", "type": "CC", "length": "16", "name": "中国光大银行"},
    {"bin": "356840", "bank": "CEB", "type": "CC", "length": "16", "name": "中国光大银行"},
    {"bin": "356841", "bank": "CEB", "type": "CC", "length": "16", "name": "中国光大银行"},
    {"bin": "356850", "bank": "SPDB", "type": "CC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "356851", "bank": "SPDB", "type": "CC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "356852", "bank": "SPDB", "type": "CC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "356856", "bank": "CMBC", "type": "CC", "length": "16", "name": "中国民生银行"},
    {"bin": "356857", "bank": "CMBC", "type": "CC", "length": "16", "name": "中国民生银行"},
    {"bin": "356858", "bank": "CMBC", "type": "CC", "length": "16", "name": "中国民生银行"},
    {"bin": "356859", "bank": "CMBC", "type": "CC", "length": "16", "name": "中国民生银行"},
    {"bin": "356868", "bank": "SPABANK", "type": "CC", "length": "16", "name": "平安银行"},
    {"bin": "356869", "bank": "SPABANK", "type": "CC", "length": "16", "name": "平安银行"},
    {"bin": "356889", "bank": "CMB", "type": "CC", "length": "16", "name": "招商银行"},
    {"bin": "370247", "bank": "ICBC", "type": "CC", "length": "15", "name": "中国工商银行"},
    {"bin": "376966", "bank": "CITIC", "type": "CC", "length": "15", "name": "中信银行"},
    {"bin": "376968", "bank": "CITIC", "type": "CC", "length": "15", "name": "中信银行"},
    {"bin": "376969", "bank": "CITIC", "type": "CC", "length": "15", "name": "中信银行"},
    {"bin": "400360", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "402673", "bank": "SHBANK", "type": "CC", "length": "16", "name": "上海银行"},
    {"bin": "402674", "bank": "SHBANK", "type": "CC", "length": "16", "name": "上海银行"},
    {"bin": "403361", "bank": "ABC", "type": "CC", "length": "16", "name": "中国农业银行"},
    {"bin": "403391", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "403392", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "403393", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "404117", "bank": "ABC", "type": "CC", "length": "16", "name": "中国农业银行"},
    {"bin": "404118", "bank": "ABC", "type": "CC", "length": "16", "name": "中国农业银行"},
    {"bin": "404119", "bank": "ABC", "type": "CC", "length": "16", "name": "中国农业银行"},
    {"bin": "404120", "bank": "ABC", "type": "CC", "length": "16", "name": "中国农业银行"},
    {"bin": "404121", "bank": "ABC", "type": "CC", "length": "16", "name": "中国农业银行"},
    {"bin": "404157", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "404158", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "404159", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "404171", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "404172", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "404173", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "404174", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "404738", "bank": "SPDB", "type": "CC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "404739", "bank": "SPDB", "type": "CC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "405512", "bank": "COMM", "type": "DC", "length": "17", "name": "交通银行"},
    {"bin": "406252", "bank": "CEB", "type": "CC", "length": "16", "name": "中国光大银行"},
    {"bin": "406254", "bank": "CEB", "type": "CC", "length": "16", "name": "中国光大银行"},
    {"bin": "406365", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "406366", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "407405", "bank": "CMBC", "type": "CC", "length": "16", "name": "中国民生银行"},
    {"bin": "409666", "bank": "BOC", "type": "CC", "length": "16", "name": "中国银行"},
    {"bin": "410062", "bank": "CMB", "type": "DC", "length": "16", "name": "招商银行"},
    {"bin": "412962", "bank": "SPABANK", "type": "DC", "length": "16", "name": "平安银行"},
    {"bin": "412963", "bank": "SPABANK", "type": "DC", "length": "16", "name": "平安银行"},
    {"bin": "415599", "bank": "CMBC", "type": "DC", "length": "16", "name": "中国民生银行"},
    {"bin": "415752", "bank": "SPABANK", "type": "DC", "length": "16", "name": "平安银行"},
    {"bin": "415753", "bank": "SPABANK", "type": "DC", "length": "16", "name": "平安银行"},
    {"bin": "421317", "bank": "BJBANK", "type": "DC", "length": "16", "name": "北京银行"},
    {"bin": "421349", "bank": "CCB", "type": "DC", "length": "16", "name": "中国建设银行"},
    {"bin": "421393", "bank": "CMBC", "type": "DC", "length": "16", "name": "中国民生银行"},
    {"bin": "421865", "bank": "CMBC", "type": "DC", "length": "16", "name": "中国民生银行"},
    {"bin": "421869", "bank": "CMBC", "type": "CC", "length": "16", "name": "中国民生银行"},
    {"bin": "421870", "bank": "CMBC", "type": "CC", "length": "16", "name": "中国民生银行"},
    {"bin": "421871", "bank": "CMBC", "type": "CC", "length": "16", "name": "中国民生银行"},
    {"bin": "422160", "bank": "BJBANK", "type": "DC", "length": "16", "name": "北京银行"},
    {"bin": "422161", "bank": "BJBANK", "type": "DC", "length": "16", "name": "北京银行"},
    {"bin": "425862", "bank": "CEB", "type": "CC", "length": "16", "name": "中国光大银行"},
    {"bin": "427020", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "427030", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "427570", "bank": "CMBC", "type": "DC", "length": "16", "name": "中国民生银行"},
    {"bin": "427571", "bank": "CMBC", "type": "DC", "length": "16", "name": "中国民生银行"},
    {"bin": "428911", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "433666", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "433667", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "433668", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "433669", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "433670", "bank": "CITIC", "type": "DC", "length": "16", "name": "中信银行"},
    {"bin": "433671", "bank": "CITIC", "type": "DC", "length": "16", "name": "中信银行"},
    {"bin": "433680", "bank": "CITIC", "type": "DC", "length": "16", "name": "中信银行"},
    {"bin": "434061", "bank": "CCB", "type": "DC", "length": "16", "name": "中国建设银行"},
    {"bin": "434062", "bank": "CCB", "type": "DC", "length": "16", "name": "中国建设银行"},
    {"bin": "435744", "bank": "SPABANK", "type": "CC", "length": "16", "name": "平安银行"},
    {"bin": "435745", "bank": "SPABANK", "type": "CC", "length": "16", "name": "平安银行"},
    {"bin": "436742", "bank": "CCB", "type": "DC", "length": "19", "name": "中国建设银行"},
    {"bin": "436745", "bank": "CCB", "type": "CC", "length": "16", "name": "中国建设银行"},
    {"bin": "436748", "bank": "CCB", "type": "CC", "length": "16", "name": "中国建设银行"},
    {"bin": "436768", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "436769", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "436770", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "436771", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "438088", "bank": "BOC", "type": "CC", "length": "16", "name": "中国银行"},
    {"bin": "438588", "bank": "CIB", "type": "DC", "length": "18", "name": "兴业银行"},
    {"bin": "438589", "bank": "CIB", "type": "DC", "length": "18", "name": "兴业银行"},
    {"bin": "438600", "bank": "SHBANK", "type": "DC", "length": "16", "name": "上海银行"},
    {"bin": "439188", "bank": "CMB", "type": "CC", "length": "16", "name": "招商银行"},
    {"bin": "439225", "bank": "CMB", "type": "CC", "length": "16", "name": "招商银行"},
    {"bin": "439226", "bank": "CMB", "type": "CC", "length": "16", "name": "招商银行"},
    {"bin": "439227", "bank": "CMB", "type": "CC", "length": "16", "name": "招商银行"},
    {"bin": "442729", "bank": "CITIC", "type": "DC", "length": "16", "name": "中信银行"},
    {"bin": "442730", "bank": "CITIC", "type": "DC", "length": "16", "name": "中信银行"},
    {"bin": "451289", "bank": "CIB", "type": "CC", "length": "16", "name": "兴业银行"},
    {"bin": "451290", "bank": "CIB", "type": "CC", "length": "16", "name": "兴业银行"},
    {"bin": "451810", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "451811", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "453242", "bank": "CCB", "type": "DC", "length": "16", "name": "中国建设银行"},
    {"bin": "456351", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "456418", "bank": "SPDB", "type": "CC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "45806", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "458123", "bank": "COMM", "type": "CC", "length": "16", "name": "交通银行"},
    {"bin": "458124", "bank": "COMM", "type": "CC", "length": "16", "name": "交通银行"},
    {"bin": "461982", "bank": "CIB", "type": "CC", "length": "16", "name": "兴业银行"},
    {"bin": "463758", "bank": "ABC", "type": "CC", "length": "16", "name": "中国农业银行"},
    {"bin": "464580", "bank": "CMBC", "type": "CC", "length": "16", "name": "中国民生银行"},
    {"bin": "464581", "bank": "CMBC", "type": "CC", "length": "16", "name": "中国民生银行"},
    {"bin": "468203", "bank": "CMB", "type": "DC", "length": "16", "name": "招商银行"},
    {"bin": "472067", "bank": "CMBC", "type": "DC", "length": "16", "name": "中国民生银行"},
    {"bin": "472068", "bank": "CMBC", "type": "DC", "length": "16", "name": "中国民生银行"},
    {"bin": "481699", "bank": "CEB", "type": "CC", "length": "16", "name": "中国光大银行"},
    {"bin": "483536", "bank": "SPABANK", "type": "CC", "length": "16", "name": "平安银行"},
    {"bin": "486466", "bank": "SHBANK", "type": "CC", "length": "16", "name": "上海银行"},
    {"bin": "486493", "bank": "CIB", "type": "CC", "length": "16", "name": "兴业银行"},
    {"bin": "486494", "bank": "CIB", "type": "CC", "length": "16", "name": "兴业银行"},
    {
        "bin": "486495",
        "bank": "SCBHK",
        "type": "CC",
        "length": "16",
        "name": "渣打银行(香港)",
    },
    {"bin": "486497", "bank": "CEB", "type": "CC", "length": "16", "name": "中国光大银行"},
    {"bin": "486861", "bank": "CIB", "type": "CC", "length": "16", "name": "兴业银行"},
    {"bin": "487013", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "489592", "bank": "CCB", "type": "CC", "length": "16", "name": "中国建设银行"},
    {"bin": "49102", "bank": "ABC", "type": "SCC", "length": "16", "name": "中国农业银行"},
    {"bin": "491031", "bank": "CCB", "type": "DC", "length": "16", "name": "中国建设银行"},
    {"bin": "491032", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "491033", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "491034", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "491035", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "491036", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "491037", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "491038", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "493427", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "498451", "bank": "SPDB", "type": "CC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "504923", "bank": "JSBANK", "type": "DC", "length": "16", "name": "江苏银行"},
    {"bin": "512425", "bank": "CMB", "type": "DC", "length": "16", "name": "招商银行"},
    {"bin": "512431", "bank": "NBBANK", "type": "CC", "length": "16", "name": "宁波银行"},
    {"bin": "512466", "bank": "CMBC", "type": "CC", "length": "16", "name": "中国民生银行"},
    {"bin": "514027", "bank": "ABC", "type": "CC", "length": "16", "name": "中国农业银行"},
    {"bin": "514906", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "515672", "bank": "SPDB", "type": "CC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "517636", "bank": "CMBC", "type": "CC", "length": "16", "name": "中国民生银行"},
    {"bin": "517650", "bank": "SPDB", "type": "CC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "518212", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "518364", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "518476", "bank": "BOC", "type": "CC", "length": "16", "name": "中国银行"},
    {"bin": "518710", "bank": "CMB", "type": "CC", "length": "16", "name": "招商银行"},
    {"bin": "518718", "bank": "CMB", "type": "CC", "length": "16", "name": "招商银行"},
    {"bin": "519412", "bank": "ABC", "type": "CC", "length": "16", "name": "中国农业银行"},
    {"bin": "519413", "bank": "ABC", "type": "CC", "length": "16", "name": "中国农业银行"},
    {"bin": "519498", "bank": "SHBANK", "type": "CC", "length": "16", "name": "上海银行"},
    {"bin": "520082", "bank": "ABC", "type": "CC", "length": "16", "name": "中国农业银行"},
    {"bin": "520083", "bank": "ABC", "type": "CC", "length": "16", "name": "中国农业银行"},
    {"bin": "520108", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "520131", "bank": "SHBANK", "type": "CC", "length": "16", "name": "上海银行"},
    {"bin": "520152", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "520169", "bank": "COMM", "type": "CC", "length": "16", "name": "交通银行"},
    {"bin": "520194", "bank": "NBBANK", "type": "CC", "length": "16", "name": "宁波银行"},
    {"bin": "520382", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "522001", "bank": "BJBANK", "type": "CC", "length": "16", "name": "北京银行"},
    {"bin": "523036", "bank": "CIB", "type": "CC", "length": "16", "name": "兴业银行"},
    {"bin": "523952", "bank": "CMBC", "type": "CC", "length": "16", "name": "中国民生银行"},
    {"bin": "523959", "bank": "HXBANK", "type": "CC", "length": "16", "name": "华夏银行"},
    {"bin": "524011", "bank": "CMB", "type": "DC", "length": "16", "name": "招商银行"},
    {"bin": "524031", "bank": "SHBANK", "type": "CC", "length": "16", "name": "上海银行"},
    {"bin": "524047", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "524070", "bank": "CIB", "type": "CC", "length": "16", "name": "兴业银行"},
    {"bin": "524090", "bank": "CEB", "type": "CC", "length": "16", "name": "中国光大银行"},
    {"bin": "524091", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "524094", "bank": "CCB", "type": "DC", "length": "16", "name": "中国建设银行"},
    {"bin": "525746", "bank": "BOC", "type": "CC", "length": "16", "name": "中国银行"},
    {"bin": "525998", "bank": "SPDB", "type": "CC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "526410", "bank": "CCB", "type": "DC", "length": "16", "name": "中国建设银行"},
    {"bin": "526855", "bank": "SPABANK", "type": "CC", "length": "16", "name": "平安银行"},
    {"bin": "527414", "bank": "CIB", "type": "CC", "length": "16", "name": "兴业银行"},
    {"bin": "528020", "bank": "SPABANK", "type": "CC", "length": "16", "name": "平安银行"},
    {"bin": "528057", "bank": "CIB", "type": "CC", "length": "16", "name": "兴业银行"},
    {"bin": "528708", "bank": "HXBANK", "type": "CC", "length": "16", "name": "华夏银行"},
    {"bin": "528709", "bank": "HXBANK", "type": "CC", "length": "16", "name": "华夏银行"},
    {"bin": "528856", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "528931", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "528948", "bank": "CMBC", "type": "CC", "length": "16", "name": "中国民生银行"},
    {"bin": "530970", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "530984", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "530985", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "530986", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "530987", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "530988", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "530989", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "530990", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "531659", "bank": "SPABANK", "type": "CC", "length": "16", "name": "平安银行"},
    {"bin": "531693", "bank": "CCB", "type": "CC", "length": "16", "name": "中国建设银行"},
    {"bin": "532421", "bank": "CCB", "type": "DC", "length": "16", "name": "中国建设银行"},
    {"bin": "532422", "bank": "CCB", "type": "DC", "length": "16", "name": "中国建设银行"},
    {"bin": "532423", "bank": "CCB", "type": "DC", "length": "16", "name": "中国建设银行"},
    {"bin": "532424", "bank": "CCB", "type": "DC", "length": "16", "name": "中国建设银行"},
    {"bin": "532425", "bank": "CCB", "type": "DC", "length": "16", "name": "中国建设银行"},
    {"bin": "532426", "bank": "CCB", "type": "DC", "length": "16", "name": "中国建设银行"},
    {"bin": "532427", "bank": "CCB", "type": "DC", "length": "16", "name": "中国建设银行"},
    {"bin": "532428", "bank": "CCB", "type": "DC", "length": "16", "name": "中国建设银行"},
    {"bin": "532429", "bank": "CCB", "type": "DC", "length": "16", "name": "中国建设银行"},
    {"bin": "532458", "bank": "CCB", "type": "CC", "length": "16", "name": "中国建设银行"},
    {"bin": "53591", "bank": "ABC", "type": "SCC", "length": "16", "name": "中国农业银行"},
    {"bin": "539867", "bank": "HXBANK", "type": "CC", "length": "16", "name": "华夏银行"},
    {"bin": "539868", "bank": "HXBANK", "type": "CC", "length": "16", "name": "华夏银行"},
    {"bin": "541709", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "541710", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "543159", "bank": "CEB", "type": "CC", "length": "16", "name": "中国光大银行"},
    {"bin": "545217", "bank": "CMBC", "type": "CC", "length": "16", "name": "中国民生银行"},
    {"bin": "545392", "bank": "CMBC", "type": "CC", "length": "16", "name": "中国民生银行"},
    {"bin": "545393", "bank": "CMBC", "type": "CC", "length": "16", "name": "中国民生银行"},
    {"bin": "545431", "bank": "CMBC", "type": "CC", "length": "16", "name": "中国民生银行"},
    {"bin": "545447", "bank": "CMBC", "type": "CC", "length": "16", "name": "中国民生银行"},
    {"bin": "548478", "bank": "ABC", "type": "CC", "length": "16", "name": "中国农业银行"},
    {"bin": "548738", "bank": "CIB", "type": "CC", "length": "16", "name": "兴业银行"},
    {"bin": "548838", "bank": "SHBANK", "type": "CC", "length": "16", "name": "上海银行"},
    {"bin": "548844", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "549633", "bank": "CIB", "type": "CC", "length": "16", "name": "兴业银行"},
    {"bin": "550213", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "552245", "bank": "CCB", "type": "DC", "length": "16", "name": "中国建设银行"},
    {"bin": "552288", "bank": "CMBC", "type": "CC", "length": "16", "name": "中国民生银行"},
    {"bin": "552398", "bank": "CIB", "type": "CC", "length": "16", "name": "兴业银行"},
    {"bin": "552599", "bank": "ABC", "type": "CC", "length": "16", "name": "中国农业银行"},
    {"bin": "552794", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "553161", "bank": "CMBC", "type": "CC", "length": "16", "name": "中国民生银行"},
    {"bin": "556610", "bank": "CMBC", "type": "CC", "length": "16", "name": "中国民生银行"},
    {"bin": "556617", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "558730", "bank": "ABC", "type": "CC", "length": "16", "name": "中国农业银行"},
    {"bin": "558894", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "558916", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "566666", "bank": "SJBANK", "type": "DC", "length": "16", "name": "盛京银行"},
    {"bin": "601382", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "601427", "bank": "ABC", "type": "DC", "length": "19", "name": "中国农业银行"},
    {"bin": "601428", "bank": "COMM", "type": "DC", "length": "17", "name": "交通银行"},
    {"bin": "602907", "bank": "SPABANK", "type": "DC", "length": "16", "name": "平安银行"},
    {"bin": "602969", "bank": "BJBANK", "type": "DC", "length": "16", "name": "北京银行"},
    {"bin": "603265", "bank": "JSBANK", "type": "DC", "length": "16", "name": "江苏银行"},
    {
        "bin": "60326500",
        "bank": "WXCCB",
        "type": "DC",
        "length": "16",
        "name": "无锡市商业银行",
    },
    {"bin": "603367", "bank": "HZCB", "type": "DC", "length": "18", "name": "杭州银行"},
    {"bin": "603445", "bank": "GCB", "type": "DC", "length": "19", "name": "广州银行"},
    {"bin": "603506", "bank": "JSBANK", "type": "DC", "length": "19", "name": "江苏银行"},
    {"bin": "603601", "bank": "HSBANK", "type": "DC", "length": "17", "name": "徽商银行"},
    {"bin": "603602", "bank": "SXCB", "type": "DC", "length": "18", "name": "绍兴银行"},
    {
        "bin": "603694",
        "bank": "CSRCB",
        "type": "DC",
        "length": "19",
        "name": "常熟农村商业银行",
    },
    {"bin": "609120", "bank": "TCCB", "type": "DC", "length": "18", "name": "天津银行"},
    {"bin": "620010", "bank": "SPABANK", "type": "PC", "length": "16", "name": "平安银行"},
    {"bin": "620013", "bank": "COMM", "type": "DC", "length": "16", "name": "交通银行"},
    {"bin": "620019", "bank": "BOC", "type": "PC", "length": "16", "name": "中国银行"},
    {"bin": "620021", "bank": "COMM", "type": "PC", "length": "19", "name": "交通银行"},
    {"bin": "620040", "bank": "BOC", "type": "PC", "length": "19", "name": "中国银行"},
    {"bin": "620043", "bank": "FJHXBC", "type": "DC", "length": "18", "name": "福建海峡银行"},
    {"bin": "620048", "bank": "BOC", "type": "DC", "length": "16", "name": "中国银行"},
    {"bin": "620058", "bank": "ICBC", "type": "DC", "length": "19", "name": "中国工商银行"},
    {"bin": "620059", "bank": "ABC", "type": "DC", "length": "19", "name": "中国农业银行"},
    {"bin": "620060", "bank": "CCB", "type": "DC", "length": "19", "name": "中国建设银行"},
    {"bin": "620061", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "620062", "bank": "PSBC", "type": "DC", "length": "19", "name": "中国邮政储蓄银行"},
    {"bin": "620070", "bank": "CYS", "type": "DC", "length": "16", "name": "中国银盛"},
    {"bin": "620082", "bank": "CITIC", "type": "DC", "length": "16", "name": "中信银行"},
    {"bin": "620085", "bank": "CEB", "type": "DC", "length": "16", "name": "中国光大银行"},
    {
        "bin": "620088",
        "bank": "BJRCB",
        "type": "DC",
        "length": "19",
        "name": "北京农村商业银行",
    },
    {"bin": "620500", "bank": "NBYZ", "type": "DC", "length": "16", "name": "鄞州银行"},
    {"bin": "620501", "bank": "ABC", "type": "DC", "length": "19", "name": "中国农业银行"},
    {
        "bin": "620515",
        "bank": "CEP",
        "type": "PC",
        "length": "16",
        "name": "中银通商务支付有限公司",
    },
    {
        "bin": "620517",
        "bank": "MTBANK",
        "type": "DC",
        "length": "19",
        "name": "浙江民泰商业银行",
    },
    {"bin": "620518", "bank": "CEB", "type": "DC", "length": "16", "name": "中国光大银行"},
    {"bin": "620519", "bank": "CSCB", "type": "DC", "length": "19", "name": "长沙银行"},
    {"bin": "620522", "bank": "SHBANK", "type": "DC", "length": "18", "name": "上海银行"},
    {"bin": "620527", "bank": "CITIC", "type": "DC", "length": "19", "name": "中信银行"},
    {"bin": "620528", "bank": "XTB", "type": "DC", "length": "19", "name": "邢台银行"},
    {"bin": "620530", "bank": "SPDB", "type": "DC", "length": "19", "name": "上海浦东发展银行"},
    {"bin": "621004", "bank": "DYCCB", "type": "DC", "length": "18", "name": "东营市商业银行"},
    {"bin": "621005", "bank": "SHBANK", "type": "DC", "length": "18", "name": "上海银行"},
    {"bin": "621008", "bank": "XJRCU", "type": "DC", "length": "16", "name": "新疆农村信用社"},
    {"bin": "621010", "bank": "PLCCB", "type": "DC", "length": "16", "name": "平凉市商业银行"},
    {
        "bin": "621013",
        "bank": "HURCB",
        "type": "DC",
        "length": "16",
        "name": "湖北省农村信用社",
    },
    {"bin": "621014", "bank": "SRBANK", "type": "DC", "length": "16", "name": "上饶银行"},
    {"bin": "621015", "bank": "DBSCN", "type": "DC", "length": "19", "name": "星展银行"},
    {"bin": "621016", "bank": "DBS", "type": "DC", "length": "19", "name": "星展银行"},
    {
        "bin": "621017",
        "bank": "YNRCC",
        "type": "DC",
        "length": "19",
        "name": "云南省农村信用社",
    },
    {
        "bin": "621018",
        "bank": "GDRCC",
        "type": "DC",
        "length": "19",
        "name": "广东省农村信用社联合社",
    },
    {"bin": "621019", "bank": "CZBANK", "type": "DC", "length": "19", "name": "浙商银行"},
    {
        "bin": "621021",
        "bank": "HBRCU",
        "type": "DC",
        "length": "19",
        "name": "河北省农村信用社",
    },
    {"bin": "621024", "bank": "NBYZ", "type": "DC", "length": "16", "name": "鄞州银行"},
    {
        "bin": "621026",
        "bank": "LNRCC",
        "type": "DC",
        "length": "19",
        "name": "辽宁省农村信用社",
    },
    {"bin": "621028", "bank": "CZCB", "type": "DC", "length": "16", "name": "浙江稠州商业银行"},
    {"bin": "621029", "bank": "KLB", "type": "DC", "length": "19", "name": "昆仑银行"},
    {"bin": "621030", "bank": "BJBANK", "type": "DC", "length": "16", "name": "北京银行"},
    {
        "bin": "621033",
        "bank": "SCRCU",
        "type": "DC",
        "length": "19",
        "name": "四川省农村信用社",
    },
    {"bin": "621034", "bank": "SHBANK", "type": "DC", "length": "16", "name": "上海银行"},
    {"bin": "621035", "bank": "ZYB", "type": "DC", "length": "19", "name": "中原银行"},
    {"bin": "621036", "bank": "BOHN", "type": "DC", "length": "19", "name": "海南省农村信用社"},
    {"bin": "621037", "bank": "DAQINGB", "type": "DC", "length": "19", "name": "龙江银行"},
    {"bin": "621038", "bank": "TLBANK", "type": "DC", "length": "19", "name": "铁岭银行"},
    {"bin": "621041", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "621042", "bank": "NCB", "type": "DC", "length": "19", "name": "南昌银行"},
    {"bin": "621043", "bank": "CYBC", "type": "DC", "length": "19", "name": "集友银行"},
    {"bin": "621044", "bank": "CAB", "type": "DC", "length": "19", "name": "宝鸡商行"},
    {"bin": "621050", "bank": "SHBANK", "type": "DC", "length": "18", "name": "上海银行"},
    {
        "bin": "621053",
        "bank": "FJNX",
        "type": "DC",
        "length": "19",
        "name": "福建省农村信用社联合社",
    },
    {"bin": "621056801", "bank": "COMM", "type": "DC", "length": "19", "name": "交通银行"},
    {"bin": "621056802", "bank": "COMM", "type": "DC", "length": "19", "name": "交通银行"},
    {"bin": "621056803", "bank": "COMM", "type": "DC", "length": "19", "name": "交通银行"},
    {"bin": "621056805", "bank": "COMM", "type": "DC", "length": "19", "name": "交通银行"},
    {
        "bin": "621057",
        "bank": "LSZRCB",
        "type": "DC",
        "length": "19",
        "name": "凉山州商业银行",
    },
    {
        "bin": "621058",
        "bank": "ZJNX",
        "type": "DC",
        "length": "19",
        "name": "浙江省农村信用社联合社",
    },
    {
        "bin": "621059",
        "bank": "JRCB",
        "type": "DC",
        "length": "16",
        "name": "江苏江阴农村商业银行",
    },
    {
        "bin": "62105900",
        "bank": "XHRCB",
        "type": "DC",
        "length": "16",
        "name": "新会农商银行",
    },
    {
        "bin": "62105901",
        "bank": "SLRCB",
        "type": "DC",
        "length": "16",
        "name": "双流诚民村镇银行",
    },
    {
        "bin": "621060",
        "bank": "WOORI",
        "type": "DC",
        "length": "19",
        "name": "友利银行(中国)",
    },
    {"bin": "621061", "bank": "GSRCU", "type": "DC", "length": "19", "name": "甘肃省农村信用"},
    {"bin": "621062", "bank": "CITI", "type": "DC", "length": "16", "name": "花旗银行(中国)"},
    {"bin": "621063", "bank": "CITI", "type": "DC", "length": "16", "name": "花旗银行(中国)"},
    {"bin": "621064", "bank": "AEON", "type": "DC", "length": "16", "name": "AEON银行"},
    {"bin": "621065", "bank": "QHRC", "type": "DC", "length": "16", "name": "青海农村信用社"},
    {
        "bin": "621066",
        "bank": "BJRCB",
        "type": "DC",
        "length": "19",
        "name": "北京农村商业银行",
    },
    {
        "bin": "621067",
        "bank": "BJRCB",
        "type": "DC",
        "length": "19",
        "name": "北京农村商业银行",
    },
    {
        "bin": "621068",
        "bank": "BJRCB",
        "type": "DC",
        "length": "19",
        "name": "北京农村商业银行",
    },
    {"bin": "621069", "bank": "COMM", "type": "DC", "length": "19", "name": "交通银行"},
    {"bin": "621070", "bank": "ZGCCB", "type": "DC", "length": "19", "name": "自贡市商业银行"},
    {"bin": "621071", "bank": "BOP", "type": "DC", "length": "19", "name": "平顶山银行"},
    {"bin": "621072", "bank": "BOSH", "type": "DC", "length": "19", "name": "新韩银行(中国)"},
    {
        "bin": "621073",
        "bank": "TJBHB",
        "type": "DC",
        "length": "19",
        "name": "天津滨海农村商业银行",
    },
    {"bin": "621074", "bank": "BOCY", "type": "DC", "length": "19", "name": "朝阳银行"},
    {"bin": "621075", "bank": "ZYB", "type": "DC", "length": "19", "name": "中原银行"},
    {"bin": "621076", "bank": "JSBANK", "type": "DC", "length": "19", "name": "江苏银行"},
    {"bin": "621077", "bank": "OCBC", "type": "DC", "length": "16", "name": "华侨银行（中国）"},
    {"bin": "621080", "bank": "CCB", "type": "DC", "length": "16", "name": "中国建设银行"},
    {"bin": "621081", "bank": "CCB", "type": "DC", "length": "19", "name": "中国建设银行"},
    {"bin": "621082", "bank": "CCB", "type": "DC", "length": "16", "name": "中国建设银行"},
    {"bin": "621083", "bank": "CCB", "type": "DC", "length": "16", "name": "中国建设银行"},
    {"bin": "621084", "bank": "CCB", "type": "DC", "length": "16", "name": "中国建设银行"},
    {"bin": "621086", "bank": "LSCCB", "type": "DC", "length": "19", "name": "乐山市商业银行"},
    {"bin": "621087", "bank": "CHB", "type": "DC", "length": "19", "name": "创兴银行有限公司"},
    {
        "bin": "621088",
        "bank": "MTBANK",
        "type": "DC",
        "length": "19",
        "name": "浙江民泰商业银行",
    },
    {
        "bin": "621089",
        "bank": "PZBANK",
        "type": "DC",
        "length": "19",
        "name": "盘锦市商业银行",
    },
    {"bin": "621090", "bank": "SNCCB", "type": "DC", "length": "19", "name": "遂宁市商业银行"},
    {"bin": "621091", "bank": "BDCBANK", "type": "DC", "length": "19", "name": "保定银行"},
    {"bin": "621092001", "bank": "URB", "type": "DC", "length": "19", "name": "联合村镇银行"},
    {"bin": "621092002", "bank": "URB", "type": "DC", "length": "19", "name": "联合村镇银行"},
    {"bin": "621092003", "bank": "URB", "type": "DC", "length": "19", "name": "联合村镇银行"},
    {"bin": "621092004", "bank": "URB", "type": "DC", "length": "19", "name": "联合村镇银行"},
    {"bin": "621092005", "bank": "URB", "type": "DC", "length": "19", "name": "联合村镇银行"},
    {"bin": "621092006", "bank": "URB", "type": "DC", "length": "19", "name": "联合村镇银行"},
    {"bin": "621092007", "bank": "URB", "type": "DC", "length": "19", "name": "联合村镇银行"},
    {"bin": "621092008", "bank": "URB", "type": "DC", "length": "19", "name": "联合村镇银行"},
    {"bin": "621092009", "bank": "URB", "type": "DC", "length": "19", "name": "联合村镇银行"},
    {"bin": "621092010", "bank": "URB", "type": "DC", "length": "19", "name": "联合村镇银行"},
    {"bin": "621092011", "bank": "URB", "type": "DC", "length": "19", "name": "联合村镇银行"},
    {"bin": "621092012", "bank": "URB", "type": "DC", "length": "19", "name": "联合村镇银行"},
    {"bin": "62109202", "bank": "URB", "type": "DC", "length": "19", "name": "联合村镇银行"},
    {"bin": "62109203", "bank": "URB", "type": "DC", "length": "19", "name": "联合村镇银行"},
    {"bin": "62109205", "bank": "URB", "type": "DC", "length": "19", "name": "联合村镇银行"},
    {"bin": "62109206", "bank": "URB", "type": "DC", "length": "19", "name": "联合村镇银行"},
    {"bin": "62109207", "bank": "URB", "type": "DC", "length": "19", "name": "联合村镇银行"},
    {"bin": "62109208", "bank": "URB", "type": "DC", "length": "19", "name": "联合村镇银行"},
    {"bin": "62109209", "bank": "URB", "type": "DC", "length": "19", "name": "联合村镇银行"},
    {"bin": "62109210", "bank": "URB", "type": "DC", "length": "19", "name": "联合村镇银行"},
    {"bin": "62109211", "bank": "URB", "type": "DC", "length": "19", "name": "联合村镇银行"},
    {"bin": "62109212", "bank": "URB", "type": "DC", "length": "19", "name": "联合村镇银行"},
    {"bin": "62109213", "bank": "URB", "type": "DC", "length": "19", "name": "联合村镇银行"},
    {"bin": "62109214", "bank": "URB", "type": "DC", "length": "19", "name": "联合村镇银行"},
    {"bin": "62109215", "bank": "URB", "type": "DC", "length": "19", "name": "联合村镇银行"},
    {"bin": "621095", "bank": "PSBC", "type": "DC", "length": "19", "name": "中国邮政储蓄银行"},
    {"bin": "621096", "bank": "PSBC", "type": "DC", "length": "19", "name": "中国邮政储蓄银行"},
    {"bin": "621097", "bank": "DAQINGB", "type": "DC", "length": "19", "name": "龙江银行"},
    {"bin": "621098", "bank": "PSBC", "type": "DC", "length": "19", "name": "中国邮政储蓄银行"},
    {
        "bin": "621099",
        "bank": "SCRCU",
        "type": "DC",
        "length": "19",
        "name": "四川省农村信用社",
    },
    {"bin": "621200", "bank": "JNBANK", "type": "DC", "length": "19", "name": "济宁银行"},
    {"bin": "621201", "bank": "HANABANK", "type": "DC", "length": "16", "name": "韩亚银行"},
    {"bin": "621205", "bank": "ICBC", "type": "DC", "length": "18", "name": "中国工商银行"},
    {"bin": "621206", "bank": "ICBC", "type": "DC", "length": "18", "name": "中国工商银行"},
    {"bin": "621207", "bank": "ICBC", "type": "DC", "length": "18", "name": "中国工商银行"},
    {"bin": "621208", "bank": "ICBC", "type": "DC", "length": "18", "name": "中国工商银行"},
    {"bin": "621209", "bank": "ICBC", "type": "DC", "length": "18", "name": "中国工商银行"},
    {"bin": "621210", "bank": "ICBC", "type": "DC", "length": "18", "name": "中国工商银行"},
    {"bin": "621211", "bank": "ICBC", "type": "DC", "length": "18", "name": "中国工商银行"},
    {"bin": "621213", "bank": "NCBANK", "type": "DC", "length": "19", "name": "宁波通商银行"},
    {"bin": "621216", "bank": "JSB", "type": "DC", "length": "19", "name": "晋商银行"},
    {"bin": "621217", "bank": "HBC", "type": "DC", "length": "18", "name": "湖北银行"},
    {"bin": "621221", "bank": "ZYB", "type": "DC", "length": "19", "name": "中原银行"},
    {"bin": "621222", "bank": "HXBANK", "type": "DC", "length": "16", "name": "华夏银行"},
    {
        "bin": "621223",
        "bank": "JZBANK",
        "type": "DC",
        "length": "19",
        "name": "晋中市商业银行",
    },
    {"bin": "621225", "bank": "ICBC", "type": "DC", "length": "19", "name": "中国工商银行"},
    {"bin": "621226", "bank": "ICBC", "type": "DC", "length": "19", "name": "中国工商银行"},
    {"bin": "621227", "bank": "ICBC", "type": "DC", "length": "19", "name": "中国工商银行"},
    {
        "bin": "621228",
        "bank": "HLJRCU",
        "type": "DC",
        "length": "19",
        "name": "黑龙江省农村信用社",
    },
    {"bin": "621229", "bank": "ICBC", "type": "DC", "length": "19", "name": "中国工商银行"},
    {"bin": "621230", "bank": "ICBC", "type": "DC", "length": "19", "name": "中国工商银行"},
    {"bin": "621232", "bank": "BNU", "type": "DC", "length": "19", "name": "大西洋银行"},
    {"bin": "621233", "bank": "DZCBANK", "type": "DC", "length": "19", "name": "达州银行"},
    {"bin": "621234", "bank": "CSC", "type": "DC", "length": "16", "name": "CSC借记卡"},
    {"bin": "621235", "bank": "ZYB", "type": "DC", "length": "18", "name": "中原银行"},
    {"bin": "621237", "bank": "QHDBANK", "type": "DC", "length": "19", "name": "秦皇岛银行"},
    {"bin": "621238", "bank": "XTB", "type": "DC", "length": "19", "name": "邢台银行"},
    {"bin": "621239", "bank": "HSBK", "type": "DC", "length": "19", "name": "衡水银行"},
    {"bin": "621240", "bank": "ICBC", "type": "DC", "length": "19", "name": "中国工商银行"},
    {"bin": "621241", "bank": "BOSZ", "type": "DC", "length": "19", "name": "苏州银行"},
    {"bin": "621241001", "bank": "BOSZ", "type": "DC", "length": "19", "name": "苏州银行"},
    {"bin": "621241002", "bank": "BOSZ", "type": "DC", "length": "19", "name": "苏州银行"},
    {"bin": "621241003", "bank": "BOSZ", "type": "DC", "length": "19", "name": "苏州银行"},
    {"bin": "621241004", "bank": "BOSZ", "type": "DC", "length": "19", "name": "苏州银行"},
    {"bin": "621242", "bank": "LZYH", "type": "DC", "length": "19", "name": "兰州银行"},
    {"bin": "621244", "bank": "SJBANK", "type": "DC", "length": "16", "name": "盛京银行"},
    {"bin": "621246", "bank": "NCB", "type": "DC", "length": "19", "name": "南昌银行"},
    {"bin": "621247", "bank": "BNU", "type": "DC", "length": "19", "name": "大西洋银行"},
    {
        "bin": "621250001",
        "bank": "HSBC",
        "type": "DC",
        "length": "16",
        "name": "汇丰银行(中国)",
    },
    {
        "bin": "621251",
        "bank": "FJNX",
        "type": "DC",
        "length": "19",
        "name": "福建省农村信用社联合社",
    },
    {"bin": "621252", "bank": "QDCCB", "type": "DC", "length": "16", "name": "青岛银行"},
    {"bin": "621253", "bank": "BCDMMA", "type": "DC", "length": "19", "name": "澳门商业银行"},
    {"bin": "621254", "bank": "BCDMMA", "type": "DC", "length": "19", "name": "澳门商业银行"},
    {"bin": "621255", "bank": "BCDMMA", "type": "DC", "length": "19", "name": "澳门商业银行"},
    {"bin": "621256", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {
        "bin": "621258",
        "bank": "CRCBANK",
        "type": "DC",
        "length": "16",
        "name": "重庆农村商业银行",
    },
    {"bin": "621259", "bank": "NJCB", "type": "DC", "length": "16", "name": "南京银行"},
    {"bin": "621260", "bank": "SPABANK", "type": "CC", "length": "16", "name": "平安银行"},
    {
        "bin": "621260",
        "bank": "CSRCB",
        "type": "DC",
        "length": "19",
        "name": "常熟农村商业银行",
    },
    {
        "bin": "621260001",
        "bank": "XFRCB",
        "type": "DC",
        "length": "19",
        "name": "咸丰常农商村镇银行",
    },
    {
        "bin": "621260002",
        "bank": "ESRCB",
        "type": "DC",
        "length": "19",
        "name": "恩施农村商业银行",
    },
    {
        "bin": "621260102",
        "bank": "CSRCB",
        "type": "DC",
        "length": "19",
        "name": "常熟农村商业银行",
    },
    {
        "bin": "621260103",
        "bank": "CSRCB",
        "type": "DC",
        "length": "19",
        "name": "常熟农村商业银行",
    },
    {
        "bin": "621260104",
        "bank": "CSRCB",
        "type": "DC",
        "length": "19",
        "name": "常熟农村商业银行",
    },
    {
        "bin": "621260105",
        "bank": "CSRCB",
        "type": "DC",
        "length": "19",
        "name": "常熟农村商业银行",
    },
    {
        "bin": "621260106",
        "bank": "CSRCB",
        "type": "DC",
        "length": "19",
        "name": "常熟农村商业银行",
    },
    {
        "bin": "621260107",
        "bank": "CSRCB",
        "type": "DC",
        "length": "19",
        "name": "常熟农村商业银行",
    },
    {
        "bin": "621260108",
        "bank": "CSRCB",
        "type": "DC",
        "length": "19",
        "name": "常熟农村商业银行",
    },
    {
        "bin": "621260109",
        "bank": "CSRCB",
        "type": "DC",
        "length": "19",
        "name": "常熟农村商业银行",
    },
    {
        "bin": "621260110",
        "bank": "CSRCB",
        "type": "DC",
        "length": "19",
        "name": "常熟农村商业银行",
    },
    {
        "bin": "621260113",
        "bank": "CSRCB",
        "type": "DC",
        "length": "19",
        "name": "常熟农村商业银行",
    },
    {
        "bin": "621260116",
        "bank": "CSRCB",
        "type": "DC",
        "length": "19",
        "name": "常熟农村商业银行",
    },
    {
        "bin": "621260117",
        "bank": "CSRCB",
        "type": "DC",
        "length": "19",
        "name": "常熟农村商业银行",
    },
    {
        "bin": "621260118",
        "bank": "CSRCB",
        "type": "DC",
        "length": "19",
        "name": "常熟农村商业银行",
    },
    {
        "bin": "621260119",
        "bank": "CSRCB",
        "type": "DC",
        "length": "19",
        "name": "常熟农村商业银行",
    },
    {
        "bin": "621260120",
        "bank": "CSRCB",
        "type": "DC",
        "length": "19",
        "name": "常熟农村商业银行",
    },
    {
        "bin": "621260121",
        "bank": "CSRCB",
        "type": "DC",
        "length": "19",
        "name": "常熟农村商业银行",
    },
    {
        "bin": "621260122",
        "bank": "CSRCB",
        "type": "DC",
        "length": "19",
        "name": "常熟农村商业银行",
    },
    {"bin": "621261", "bank": "SPABANK", "type": "CC", "length": "16", "name": "平安银行"},
    {"bin": "621262", "bank": "SPABANK", "type": "CC", "length": "16", "name": "平安银行"},
    {
        "bin": "621263",
        "bank": "KORLABANK",
        "type": "DC",
        "length": "18",
        "name": "库尔勒市商业银行",
    },
    {
        "bin": "621265001",
        "bank": "JSRCU",
        "type": "DC",
        "length": "19",
        "name": "江苏省农村信用联合社",
    },
    {"bin": "621266", "bank": "BOCZ", "type": "DC", "length": "19", "name": "沧州银行"},
    {"bin": "621267", "bank": "FJHXBC", "type": "DC", "length": "18", "name": "福建海峡银行"},
    {"bin": "621268", "bank": "BOHAIB", "type": "DC", "length": "16", "name": "渤海银行"},
    {"bin": "621269", "bank": "NCB", "type": "DC", "length": "16", "name": "南昌银行"},
    {"bin": "621270", "bank": "HBC", "type": "DC", "length": "18", "name": "湖北银行"},
    {"bin": "621271", "bank": "ZYB", "type": "DC", "length": "19", "name": "中原银行"},
    {"bin": "621272", "bank": "YQCCB", "type": "DC", "length": "16", "name": "阳泉银行"},
    {"bin": "621273", "bank": "YBCCB", "type": "DC", "length": "19", "name": "宜宾市商业银行"},
    {"bin": "621275", "bank": "SPDB", "type": "DC", "length": "19", "name": "上海浦东发展银行"},
    {
        "bin": "621275101",
        "bank": "SPDB",
        "type": "DC",
        "length": "19",
        "name": "上海浦东发展银行",
    },
    {
        "bin": "621275111",
        "bank": "SPDB",
        "type": "DC",
        "length": "19",
        "name": "上海浦东发展银行",
    },
    {
        "bin": "621275121",
        "bank": "SPDB",
        "type": "DC",
        "length": "19",
        "name": "上海浦东发展银行",
    },
    {
        "bin": "621275131",
        "bank": "SPDB",
        "type": "DC",
        "length": "19",
        "name": "上海浦东发展银行",
    },
    {
        "bin": "621275141",
        "bank": "SPDB",
        "type": "DC",
        "length": "19",
        "name": "上海浦东发展银行",
    },
    {
        "bin": "621275151",
        "bank": "SPDB",
        "type": "DC",
        "length": "19",
        "name": "上海浦东发展银行",
    },
    {
        "bin": "621275161",
        "bank": "SPDB",
        "type": "DC",
        "length": "19",
        "name": "上海浦东发展银行",
    },
    {
        "bin": "621275171",
        "bank": "SPDB",
        "type": "DC",
        "length": "19",
        "name": "上海浦东发展银行",
    },
    {
        "bin": "621275181",
        "bank": "SPDB",
        "type": "DC",
        "length": "19",
        "name": "上海浦东发展银行",
    },
    {
        "bin": "621275191",
        "bank": "SPDB",
        "type": "DC",
        "length": "19",
        "name": "上海浦东发展银行",
    },
    {
        "bin": "621275201",
        "bank": "SPDB",
        "type": "DC",
        "length": "19",
        "name": "上海浦东发展银行",
    },
    {
        "bin": "621275211",
        "bank": "SPDB",
        "type": "DC",
        "length": "19",
        "name": "上海浦东发展银行",
    },
    {
        "bin": "621275221",
        "bank": "SPDB",
        "type": "DC",
        "length": "19",
        "name": "上海浦东发展银行",
    },
    {
        "bin": "621275231",
        "bank": "SPDB",
        "type": "DC",
        "length": "19",
        "name": "上海浦东发展银行",
    },
    {
        "bin": "621275241",
        "bank": "SPDB",
        "type": "DC",
        "length": "19",
        "name": "上海浦东发展银行",
    },
    {
        "bin": "621275251",
        "bank": "SPDB",
        "type": "DC",
        "length": "19",
        "name": "上海浦东发展银行",
    },
    {
        "bin": "621275261",
        "bank": "SPDB",
        "type": "DC",
        "length": "19",
        "name": "上海浦东发展银行",
    },
    {
        "bin": "621275271",
        "bank": "SPDB",
        "type": "DC",
        "length": "19",
        "name": "上海浦东发展银行",
    },
    {
        "bin": "621275281",
        "bank": "SPDB",
        "type": "DC",
        "length": "19",
        "name": "上海浦东发展银行",
    },
    {
        "bin": "621275291",
        "bank": "SPDB",
        "type": "DC",
        "length": "19",
        "name": "上海浦东发展银行",
    },
    {
        "bin": "621275301",
        "bank": "SPDB",
        "type": "DC",
        "length": "19",
        "name": "上海浦东发展银行",
    },
    {
        "bin": "621275311",
        "bank": "SPDB",
        "type": "DC",
        "length": "19",
        "name": "上海浦东发展银行",
    },
    {
        "bin": "621275321",
        "bank": "SPDB",
        "type": "DC",
        "length": "19",
        "name": "上海浦东发展银行",
    },
    {
        "bin": "621275341",
        "bank": "SPDB",
        "type": "DC",
        "length": "19",
        "name": "上海浦东发展银行",
    },
    {
        "bin": "62127817",
        "bank": "HDHMCB",
        "type": "DC",
        "length": "18",
        "name": "惠东惠民村镇银行",
    },
    {
        "bin": "621278293",
        "bank": "GXHMVB",
        "type": "DC",
        "length": "18",
        "name": "长春高新惠民村镇银行",
    },
    {
        "bin": "62127839",
        "bank": "FMBANK",
        "type": "DC",
        "length": "18",
        "name": "吉林丰满惠民村镇银行",
    },
    {"bin": "621279", "bank": "NBBANK", "type": "DC", "length": "16", "name": "宁波银行"},
    {
        "bin": "621280",
        "bank": "SXRCU",
        "type": "DC",
        "length": "19",
        "name": "山西省农村信用社",
    },
    {"bin": "621281", "bank": "ICBC", "type": "DC", "length": "19", "name": "中国工商银行"},
    {"bin": "621282", "bank": "ABC", "type": "DC", "length": "19", "name": "中国农业银行"},
    {"bin": "621283", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "621284", "bank": "CCB", "type": "DC", "length": "19", "name": "中国建设银行"},
    {"bin": "621285", "bank": "PSBC", "type": "DC", "length": "19", "name": "中国邮政储蓄银行"},
    {"bin": "621286", "bank": "CMB", "type": "DC", "length": "16", "name": "招商银行"},
    {"bin": "621287", "bank": "XJRCU", "type": "DC", "length": "16", "name": "新疆农村信用社"},
    {"bin": "621288", "bank": "ICBC", "type": "DC", "length": "19", "name": "中国工商银行"},
    {"bin": "621289", "bank": "NCB", "type": "DC", "length": "19", "name": "南昌银行"},
    {"bin": "621290", "bank": "NCBANK", "type": "DC", "length": "19", "name": "宁波通商银行"},
    {"bin": "621291", "bank": "NCB", "type": "DC", "length": "19", "name": "南昌银行"},
    {"bin": "621292", "bank": "NCB", "type": "DC", "length": "19", "name": "南昌银行"},
    {"bin": "621296", "bank": "CABANK", "type": "DC", "length": "19", "name": "长安银行"},
    {"bin": "621298", "bank": "WHB", "type": "DC", "length": "18", "name": "永亨银行"},
    {"bin": "621325", "bank": "YACCB", "type": "DC", "length": "19", "name": "雅安市商业银行"},
    {
        "bin": "621326763",
        "bank": "XLBANK",
        "type": "DC",
        "length": "18",
        "name": "中山小榄村镇银行",
    },
    {"bin": "621327", "bank": "ZYB", "type": "DC", "length": "19", "name": "中原银行"},
    {"bin": "621330", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "621331", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "621332", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "621336", "bank": "ABC", "type": "DC", "length": "19", "name": "中国农业银行"},
    {"bin": "621337", "bank": "ZYB", "type": "DC", "length": "19", "name": "中原银行"},
    {
        "bin": "621338",
        "bank": "MTBANK",
        "type": "DC",
        "length": "19",
        "name": "浙江民泰商业银行",
    },
    {"bin": "621340", "bank": "LANGFB", "type": "DC", "length": "16", "name": "廊坊银行"},
    {"bin": "621341", "bank": "LANGFB", "type": "DC", "length": "16", "name": "廊坊银行"},
    {"bin": "621345", "bank": "NDHB", "type": "DC", "length": "18", "name": "宁波东海银行"},
    {
        "bin": "621346001",
        "bank": "ERB",
        "type": "DC",
        "length": "19",
        "name": "龙岗鼎业村镇银行",
    },
    {
        "bin": "621346002",
        "bank": "WHBANK",
        "type": "DC",
        "length": "19",
        "name": "乌海银行",
    },
    {
        "bin": "621347001",
        "bank": "YZBANK",
        "type": "DC",
        "length": "16",
        "name": "银座银行",
    },
    {
        "bin": "621347002",
        "bank": "YZBANK",
        "type": "DC",
        "length": "16",
        "name": "银座银行",
    },
    {
        "bin": "621347003",
        "bank": "YZBANK",
        "type": "DC",
        "length": "16",
        "name": "银座银行",
    },
    {"bin": "621351", "bank": "SPDB", "type": "DC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "621352", "bank": "SPDB", "type": "DC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "621353", "bank": "XHCZYH", "type": "DC", "length": "19", "name": "新华村镇银行"},
    {
        "bin": "621356",
        "bank": "BOCFCB",
        "type": "DC",
        "length": "19",
        "name": "中银富登村镇银行",
    },
    {"bin": "621359", "bank": "NCB", "type": "DC", "length": "18", "name": "南昌银行"},
    {
        "bin": "621361",
        "bank": "WHRCB",
        "type": "DC",
        "length": "19",
        "name": "武汉农村商业银行",
    },
    {
        "bin": "621362",
        "bank": "NMGNXS",
        "type": "DC",
        "length": "19",
        "name": "内蒙古农村信用社",
    },
    {
        "bin": "621363",
        "bank": "CZRCB",
        "type": "DC",
        "length": "19",
        "name": "常州农村信用联社",
    },
    {"bin": "621366", "bank": "HRXJB", "type": "DC", "length": "19", "name": "华融湘江银行"},
    {"bin": "621384", "bank": "QLCZYH", "type": "DC", "length": "19", "name": "齐鲁村镇银行"},
    {"bin": "621388", "bank": "HRXJB", "type": "DC", "length": "19", "name": "华融湘江银行"},
    {"bin": "621390", "bank": "SPDB", "type": "DC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "621392", "bank": "NYCB", "type": "DC", "length": "18", "name": "南阳村镇银行"},
    {"bin": "621412", "bank": "LZCCB", "type": "DC", "length": "18", "name": "柳州银行"},
    {
        "bin": "621413",
        "bank": "ZJKCCB",
        "type": "DC",
        "length": "19",
        "name": "张家口市商业银行",
    },
    {"bin": "621415", "bank": "FDB", "type": "DC", "length": "19", "name": "富滇银行"},
    {"bin": "621416", "bank": "SRBANK", "type": "DC", "length": "16", "name": "上饶银行"},
    {"bin": "621417", "bank": "NXBANK", "type": "DC", "length": "19", "name": "宁夏银行"},
    {"bin": "621418", "bank": "NBBANK", "type": "DC", "length": "19", "name": "宁波银行"},
    {"bin": "621419", "bank": "QDCCB", "type": "DC", "length": "19", "name": "青岛银行"},
    {"bin": "621420", "bank": "BJBANK", "type": "DC", "length": "16", "name": "北京银行"},
    {"bin": "621439", "bank": "BOD", "type": "DC", "length": "19", "name": "东莞银行"},
    {"bin": "621446", "bank": "CSCB", "type": "DC", "length": "19", "name": "长沙银行"},
    {"bin": "621448", "bank": "CABANK", "type": "DC", "length": "19", "name": "长安银行"},
    {
        "bin": "621449",
        "bank": "LNRCC",
        "type": "DC",
        "length": "19",
        "name": "辽宁省农村信用社",
    },
    {"bin": "621452", "bank": "TCCB", "type": "DC", "length": "18", "name": "天津银行"},
    {"bin": "621453", "bank": "BOHAIB", "type": "DC", "length": "16", "name": "渤海银行"},
    {"bin": "621456", "bank": "GLBANK", "type": "DC", "length": "17", "name": "桂林银行"},
    {
        "bin": "621457",
        "bank": "SCRCU",
        "type": "DC",
        "length": "19",
        "name": "四川省农村信用社",
    },
    {"bin": "621458", "bank": "BOHN", "type": "DC", "length": "19", "name": "海南省农村信用社"},
    {
        "bin": "621459",
        "bank": "SCRCU",
        "type": "DC",
        "length": "19",
        "name": "四川省农村信用社",
    },
    {
        "bin": "621460",
        "bank": "ZYCBANK",
        "type": "DC",
        "length": "19",
        "name": "遵义市商业银行",
    },
    {"bin": "621461", "bank": "BOSZ", "type": "DC", "length": "19", "name": "苏州银行"},
    {"bin": "621462", "bank": "GDB", "type": "DC", "length": "19", "name": "广东发展银行"},
    {"bin": "621463", "bank": "GCB", "type": "DC", "length": "19", "name": "广州银行"},
    {
        "bin": "621465",
        "bank": "CRCBANK",
        "type": "DC",
        "length": "16",
        "name": "重庆农村商业银行",
    },
    {"bin": "621466", "bank": "CCB", "type": "DC", "length": "16", "name": "中国建设银行"},
    {"bin": "621467", "bank": "CCB", "type": "DC", "length": "19", "name": "中国建设银行"},
    {"bin": "621468", "bank": "BJBANK", "type": "DC", "length": "16", "name": "北京银行"},
    {"bin": "621469", "bank": "GHB", "type": "DC", "length": "19", "name": "广东华兴银行"},
    {"bin": "621476", "bank": "ICBC", "type": "DC", "length": "19", "name": "中国工商银行"},
    {
        "bin": "621480",
        "bank": "ZJTLCB",
        "type": "DC",
        "length": "19",
        "name": "浙江泰隆商业银行",
    },
    {"bin": "621481", "bank": "RXCB", "type": "DC", "length": "19", "name": "榆次融信村镇银行"},
    {"bin": "621482", "bank": "CDCB", "type": "DC", "length": "19", "name": "成都银行"},
    {"bin": "621483", "bank": "CMB", "type": "DC", "length": "16", "name": "招商银行"},
    {"bin": "621485", "bank": "CMB", "type": "DC", "length": "16", "name": "招商银行"},
    {"bin": "621486", "bank": "CMB", "type": "DC", "length": "16", "name": "招商银行"},
    {"bin": "621488", "bank": "CCB", "type": "DC", "length": "16", "name": "中国建设银行"},
    {"bin": "621489", "bank": "CEB", "type": "DC", "length": "16", "name": "中国光大银行"},
    {"bin": "621490", "bank": "CEB", "type": "DC", "length": "16", "name": "中国光大银行"},
    {"bin": "621491", "bank": "CEB", "type": "DC", "length": "16", "name": "中国光大银行"},
    {"bin": "621492", "bank": "CEB", "type": "DC", "length": "16", "name": "中国光大银行"},
    {"bin": "621496", "bank": "LZYH", "type": "DC", "length": "19", "name": "兰州银行"},
    {"bin": "621497", "bank": "QJCCB", "type": "DC", "length": "16", "name": "曲靖市商业银行"},
    {"bin": "621498", "bank": "LSCCB", "type": "DC", "length": "19", "name": "乐山市商业银行"},
    {"bin": "621499", "bank": "CCB", "type": "DC", "length": "16", "name": "中国建设银行"},
    {"bin": "621516", "bank": "CDRCB", "type": "DC", "length": "19", "name": "成都农商银行"},
    {"bin": "621517", "bank": "QHRC", "type": "DC", "length": "16", "name": "青海农村信用社"},
    {
        "bin": "621518",
        "bank": "GDRCC",
        "type": "DC",
        "length": "19",
        "name": "广东省农村信用社联合社",
    },
    {
        "bin": "621519",
        "bank": "HNRCC",
        "type": "DC",
        "length": "19",
        "name": "湖南省农村信用社",
    },
    {"bin": "621520", "bank": "GSRCU", "type": "DC", "length": "19", "name": "甘肃省农村信用"},
    {
        "bin": "621521",
        "bank": "SDRCU",
        "type": "DC",
        "length": "16",
        "name": "山东省农村信用社",
    },
    {"bin": "621522", "bank": "GRCB", "type": "DC", "length": "18", "name": "广州农商银行"},
    {
        "bin": "621523",
        "bank": "HURCB",
        "type": "DC",
        "length": "16",
        "name": "湖北省农村信用社",
    },
    {"bin": "621525", "bank": "XJRCU", "type": "DC", "length": "16", "name": "新疆农村信用社"},
    {"bin": "621526", "bank": "ARCU", "type": "DC", "length": "19", "name": "安徽省农村信用社"},
    {
        "bin": "621528",
        "bank": "CRCBANK",
        "type": "DC",
        "length": "16",
        "name": "重庆农村商业银行",
    },
    {"bin": "621529", "bank": "NXBANK", "type": "DC", "length": "19", "name": "宁夏银行"},
    {
        "bin": "621530",
        "bank": "SCRCU",
        "type": "DC",
        "length": "19",
        "name": "四川省农村信用社",
    },
    {"bin": "621531", "bank": "JLRCU", "type": "DC", "length": "19", "name": "吉林农信"},
    {"bin": "621532", "bank": "CDCB", "type": "DC", "length": "19", "name": "成都银行"},
    {
        "bin": "621533",
        "bank": "NMGNXS",
        "type": "DC",
        "length": "19",
        "name": "内蒙古农村信用社",
    },
    {"bin": "621536", "bank": "BOHN", "type": "DC", "length": "19", "name": "海南省农村信用社"},
    {"bin": "621538", "bank": "LZYH", "type": "DC", "length": "19", "name": "兰州银行"},
    {
        "bin": "621539",
        "bank": "HNRCC",
        "type": "DC",
        "length": "19",
        "name": "湖南省农村信用社",
    },
    {"bin": "621552", "bank": "GYCB", "type": "DC", "length": "19", "name": "贵阳市商业银行"},
    {
        "bin": "621557",
        "bank": "HLJRCU",
        "type": "DC",
        "length": "19",
        "name": "黑龙江省农村信用社",
    },
    {"bin": "621558", "bank": "ICBC", "type": "DC", "length": "19", "name": "中国工商银行"},
    {"bin": "621559", "bank": "ICBC", "type": "DC", "length": "19", "name": "中国工商银行"},
    {"bin": "621562", "bank": "GLBANK", "type": "DC", "length": "19", "name": "桂林银行"},
    {"bin": "621566", "bank": "SXRCCU", "type": "DC", "length": "19", "name": "陕西信合"},
    {"bin": "621568", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "621569", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "621577", "bank": "HRBANK", "type": "DC", "length": "19", "name": "哈尔滨银行"},
    {
        "bin": "621578",
        "bank": "JSRCU",
        "type": "DC",
        "length": "19",
        "name": "江苏省农村信用联合社",
    },
    {"bin": "621579", "bank": "JSBANK", "type": "DC", "length": "19", "name": "江苏银行"},
    {
        "bin": "621580",
        "bank": "SXRCU",
        "type": "DC",
        "length": "19",
        "name": "山西省农村信用社",
    },
    {"bin": "621585", "bank": "HNRCU", "type": "DC", "length": "18", "name": "河南省农村信用"},
    {"bin": "621588", "bank": "DAQINGB", "type": "DC", "length": "19", "name": "龙江银行"},
    {
        "bin": "621589",
        "bank": "FJNX",
        "type": "DC",
        "length": "19",
        "name": "福建省农村信用社联合社",
    },
    {
        "bin": "621590",
        "bank": "GZRCU",
        "type": "DC",
        "length": "19",
        "name": "贵州省农村信用社",
    },
    {
        "bin": "621591",
        "bank": "ZYCBANK",
        "type": "DC",
        "length": "16",
        "name": "遵义市商业银行",
    },
    {"bin": "621598", "bank": "CCB", "type": "DC", "length": "19", "name": "中国建设银行"},
    {"bin": "621599", "bank": "PSBC", "type": "DC", "length": "19", "name": "中国邮政储蓄银行"},
    {"bin": "621600", "bank": "XMBANK", "type": "DC", "length": "19", "name": "厦门银行"},
    {"bin": "621619", "bank": "ABC", "type": "DC", "length": "19", "name": "中国农业银行"},
    {"bin": "621620", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "621621", "bank": "CCB", "type": "DC", "length": "19", "name": "中国建设银行"},
    {"bin": "621625", "bank": "GHB", "type": "DC", "length": "19", "name": "广东华兴银行"},
    {"bin": "621626", "bank": "SPABANK", "type": "DC", "length": "19", "name": "平安银行"},
    {"bin": "621627", "bank": "CZCB", "type": "DC", "length": "19", "name": "浙江稠州商业银行"},
    {"bin": "621628", "bank": "SDEB", "type": "DC", "length": "19", "name": "顺德农商银行"},
    {"bin": "621633", "bank": "H3CB", "type": "DC", "length": "19", "name": "内蒙古银行"},
    {"bin": "621660", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "621661", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "621662", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "621663", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "621666", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "621667", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "621668", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "621669", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "621670", "bank": "ICBC", "type": "DC", "length": "19", "name": "中国工商银行"},
    {"bin": "621671", "bank": "ABC", "type": "DC", "length": "19", "name": "中国农业银行"},
    {"bin": "621672", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "621673", "bank": "CCB", "type": "DC", "length": "19", "name": "中国建设银行"},
    {"bin": "621674", "bank": "PSBC", "type": "DC", "length": "19", "name": "中国邮政储蓄银行"},
    {
        "bin": "621676",
        "bank": "WHRCB",
        "type": "DC",
        "length": "19",
        "name": "武汉农村商业银行",
    },
    {
        "bin": "621678",
        "bank": "ZJNX",
        "type": "DC",
        "length": "19",
        "name": "浙江省农村信用社联合社",
    },
    {"bin": "621691", "bank": "CMBC", "type": "DC", "length": "16", "name": "中国民生银行"},
    {"bin": "621700", "bank": "CCB", "type": "DC", "length": "19", "name": "中国建设银行"},
    {
        "bin": "621701",
        "bank": "FJNX",
        "type": "DC",
        "length": "19",
        "name": "福建省农村信用社联合社",
    },
    {"bin": "621720", "bank": "ICBC", "type": "DC", "length": "19", "name": "中国工商银行"},
    {"bin": "621721", "bank": "ICBC", "type": "DC", "length": "19", "name": "中国工商银行"},
    {"bin": "621722", "bank": "ICBC", "type": "DC", "length": "19", "name": "中国工商银行"},
    {"bin": "621723", "bank": "ICBC", "type": "DC", "length": "19", "name": "中国工商银行"},
    {"bin": "621724", "bank": "ICBC", "type": "DC", "length": "19", "name": "中国工商银行"},
    {"bin": "621725", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {
        "bin": "621726",
        "bank": "MTBANK",
        "type": "DC",
        "length": "19",
        "name": "浙江民泰商业银行",
    },
    {"bin": "621727", "bank": "NYBANK", "type": "DC", "length": "19", "name": "广东南粤银行"},
    {
        "bin": "621728",
        "bank": "GDRCC",
        "type": "DC",
        "length": "19",
        "name": "广东省农村信用社联合社",
    },
    {"bin": "621735", "bank": "GYCB", "type": "DC", "length": "19", "name": "贵阳市商业银行"},
    {
        "bin": "621736",
        "bank": "ZJNX",
        "type": "DC",
        "length": "19",
        "name": "浙江省农村信用社联合社",
    },
    {
        "bin": "621737",
        "bank": "NMGNXS",
        "type": "DC",
        "length": "19",
        "name": "内蒙古农村信用社",
    },
    {"bin": "621738", "bank": "YQCCB", "type": "DC", "length": "16", "name": "阳泉银行"},
    {"bin": "621740", "bank": "SCB", "type": "DC", "length": "16", "name": "渣打银行"},
    {"bin": "621748", "bank": "ZYB", "type": "DC", "length": "19", "name": "中原银行"},
    {
        "bin": "621751",
        "bank": "URMQCCB",
        "type": "DC",
        "length": "19",
        "name": "乌鲁木齐市商业银行",
    },
    {"bin": "621752", "bank": "HRBANK", "type": "DC", "length": "19", "name": "哈尔滨银行"},
    {"bin": "621753", "bank": "ZYB", "type": "DC", "length": "19", "name": "中原银行"},
    {
        "bin": "621754",
        "bank": "URMQCCB",
        "type": "DC",
        "length": "19",
        "name": "乌鲁木齐市商业银行",
    },
    {"bin": "621755", "bank": "CCQTGB", "type": "DC", "length": "16", "name": "重庆三峡银行"},
    {"bin": "621756", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "621757", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "621758", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "621759", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "621760", "bank": "BSB", "type": "DC", "length": "17", "name": "包商银行"},
    {"bin": "621766", "bank": "KLB", "type": "DC", "length": "19", "name": "昆仑银行"},
    {"bin": "621767", "bank": "CITIC", "type": "DC", "length": "16", "name": "中信银行"},
    {"bin": "621768", "bank": "CITIC", "type": "DC", "length": "16", "name": "中信银行"},
    {"bin": "621769", "bank": "CITIC", "type": "DC", "length": "16", "name": "中信银行"},
    {"bin": "621770", "bank": "CITIC", "type": "DC", "length": "16", "name": "中信银行"},
    {"bin": "621771", "bank": "CITIC", "type": "DC", "length": "16", "name": "中信银行"},
    {"bin": "621772", "bank": "CITIC", "type": "DC", "length": "16", "name": "中信银行"},
    {"bin": "621773", "bank": "CITIC", "type": "DC", "length": "16", "name": "中信银行"},
    {"bin": "621775", "bank": "HSBANK", "type": "DC", "length": "19", "name": "徽商银行"},
    {"bin": "621777", "bank": "NJCB", "type": "DC", "length": "16", "name": "南京银行"},
    {"bin": "621778", "bank": "ARCU", "type": "DC", "length": "19", "name": "安徽省农村信用社"},
    {
        "bin": "621779",
        "bank": "GZRCU",
        "type": "DC",
        "length": "19",
        "name": "贵州省农村信用社",
    },
    {
        "bin": "621780",
        "bank": "JZBANK",
        "type": "DC",
        "length": "19",
        "name": "晋中市商业银行",
    },
    {"bin": "621785", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "621786", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "621787", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "621788", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "621789", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "621790", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "621791", "bank": "SPDB", "type": "DC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "621792", "bank": "SPDB", "type": "DC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "621793", "bank": "SPDB", "type": "DC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "621795", "bank": "SPDB", "type": "DC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "621796", "bank": "SPDB", "type": "DC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "621797", "bank": "PSBC", "type": "DC", "length": "19", "name": "中国邮政储蓄银行"},
    {"bin": "621798", "bank": "PSBC", "type": "DC", "length": "19", "name": "中国邮政储蓄银行"},
    {"bin": "621799", "bank": "PSBC", "type": "DC", "length": "19", "name": "中国邮政储蓄银行"},
    {"bin": "621977", "bank": "WZCB", "type": "DC", "length": "16", "name": "温州银行"},
    {"bin": "622020", "bank": "ICBC", "type": "DC", "length": "18", "name": "中国工商银行"},
    {"bin": "622126", "bank": "FXCB", "type": "DC", "length": "18", "name": "阜新银行"},
    {
        "bin": "622127",
        "bank": "FJNX",
        "type": "DC",
        "length": "19",
        "name": "福建省农村信用社联合社",
    },
    {"bin": "622128", "bank": "SRCB", "type": "DC", "length": "16", "name": "深圳农村商业银行"},
    {"bin": "622129", "bank": "SRCB", "type": "DC", "length": "16", "name": "深圳农村商业银行"},
    {"bin": "622131", "bank": "JSBANK", "type": "DC", "length": "19", "name": "江苏银行"},
    {"bin": "622132", "bank": "JXBANK", "type": "DC", "length": "16", "name": "嘉兴银行"},
    {"bin": "622133", "bank": "GYCB", "type": "DC", "length": "19", "name": "贵阳市商业银行"},
    {"bin": "622134", "bank": "CQBANK", "type": "DC", "length": "16", "name": "重庆银行"},
    {"bin": "622135", "bank": "CDCB", "type": "DC", "length": "19", "name": "成都银行"},
    {"bin": "622136", "bank": "XABANK", "type": "DC", "length": "18", "name": "西安银行"},
    {"bin": "622137", "bank": "HSBANK", "type": "DC", "length": "17", "name": "徽商银行"},
    {
        "bin": "622138",
        "bank": "BJRCB",
        "type": "DC",
        "length": "19",
        "name": "北京农村商业银行",
    },
    {"bin": "622139", "bank": "LZYH", "type": "DC", "length": "16", "name": "兰州银行"},
    {"bin": "622140", "bank": "LANGFB", "type": "DC", "length": "16", "name": "廊坊银行"},
    {
        "bin": "622141",
        "bank": "ZJTLCB",
        "type": "DC",
        "length": "16",
        "name": "浙江泰隆商业银行",
    },
    {
        "bin": "622143",
        "bank": "URMQCCB",
        "type": "DC",
        "length": "19",
        "name": "乌鲁木齐市商业银行",
    },
    {"bin": "622146", "bank": "QDCCB", "type": "DC", "length": "16", "name": "青岛银行"},
    {"bin": "622147", "bank": "H3CB", "type": "DC", "length": "19", "name": "内蒙古银行"},
    {"bin": "622148", "bank": "SHBANK", "type": "CC", "length": "16", "name": "上海银行"},
    {"bin": "622149", "bank": "SHBANK", "type": "CC", "length": "16", "name": "上海银行"},
    {"bin": "622150", "bank": "PSBC", "type": "DC", "length": "19", "name": "中国邮政储蓄银行"},
    {"bin": "622151", "bank": "PSBC", "type": "DC", "length": "19", "name": "中国邮政储蓄银行"},
    {"bin": "622152", "bank": "CDCB", "type": "DC", "length": "19", "name": "成都银行"},
    {"bin": "622153", "bank": "CDCB", "type": "DC", "length": "19", "name": "成都银行"},
    {"bin": "622154", "bank": "CDCB", "type": "DC", "length": "19", "name": "成都银行"},
    {"bin": "622155", "bank": "SPABANK", "type": "CC", "length": "16", "name": "平安银行"},
    {"bin": "622156", "bank": "SPABANK", "type": "CC", "length": "16", "name": "平安银行"},
    {"bin": "622157", "bank": "SPABANK", "type": "CC", "length": "16", "name": "平安银行"},
    {"bin": "622158", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "622159", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "622161", "bank": "CEB", "type": "CC", "length": "16", "name": "中国光大银行"},
    {"bin": "622162", "bank": "CEB", "type": "CC", "length": "16", "name": "中国光大银行"},
    {"bin": "622162", "bank": "JJBANK", "type": "DC", "length": "19", "name": "九江银行"},
    {"bin": "622163", "bank": "BJBANK", "type": "CC", "length": "16", "name": "北京银行"},
    {"bin": "622165", "bank": "BSB", "type": "DC", "length": "16", "name": "包商银行"},
    {"bin": "622166", "bank": "CCB", "type": "CC", "length": "16", "name": "中国建设银行"},
    {"bin": "622167", "bank": "TSBANK", "type": "DC", "length": "19", "name": "唐山银行"},
    {"bin": "622168", "bank": "CCB", "type": "CC", "length": "16", "name": "中国建设银行"},
    {
        "bin": "622169",
        "bank": "HNRCC",
        "type": "DC",
        "length": "19",
        "name": "湖南省农村信用社",
    },
    {"bin": "622172", "bank": "SHBANK", "type": "DC", "length": "18", "name": "上海银行"},
    {"bin": "622173", "bank": "JSBANK", "type": "DC", "length": "19", "name": "江苏银行"},
    {"bin": "622176", "bank": "SPDB", "type": "CC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "622177", "bank": "SPDB", "type": "CC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "622178", "bank": "JLBANK", "type": "CC", "length": "16", "name": "吉林银行"},
    {"bin": "622179", "bank": "JLBANK", "type": "CC", "length": "16", "name": "吉林银行"},
    {"bin": "622181", "bank": "PSBC", "type": "DC", "length": "19", "name": "中国邮政储蓄银行"},
    {"bin": "622182", "bank": "PSBC", "type": "DC", "length": "19", "name": "中国邮政储蓄银行"},
    {
        "bin": "622184",
        "bank": "FJNX",
        "type": "DC",
        "length": "19",
        "name": "福建省农村信用社联合社",
    },
    {"bin": "622187", "bank": "PSBC", "type": "DC", "length": "19", "name": "中国邮政储蓄银行"},
    {"bin": "622188", "bank": "PSBC", "type": "DC", "length": "19", "name": "中国邮政储蓄银行"},
    {"bin": "622189", "bank": "PSBC", "type": "DC", "length": "19", "name": "中国邮政储蓄银行"},
    {"bin": "622200", "bank": "ICBC", "type": "DC", "length": "19", "name": "中国工商银行"},
    {"bin": "622202", "bank": "ICBC", "type": "DC", "length": "19", "name": "中国工商银行"},
    {"bin": "622203", "bank": "ICBC", "type": "DC", "length": "19", "name": "中国工商银行"},
    {"bin": "622208", "bank": "ICBC", "type": "DC", "length": "19", "name": "中国工商银行"},
    {"bin": "622210", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "622211", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "622212", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "622213", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "622214", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "622215", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {
        "bin": "622218",
        "bank": "CRCBANK",
        "type": "CC",
        "length": "16",
        "name": "重庆农村商业银行",
    },
    {"bin": "622228", "bank": "SPDB", "type": "CC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "62223", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "622240", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "622245", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "622246", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "622251", "bank": "COMM", "type": "CC", "length": "16", "name": "交通银行"},
    {"bin": "622252", "bank": "COMM", "type": "CC", "length": "16", "name": "交通银行"},
    {"bin": "622253", "bank": "COMM", "type": "CC", "length": "16", "name": "交通银行"},
    {"bin": "622254", "bank": "COMM", "type": "SCC", "length": "16", "name": "交通银行"},
    {"bin": "622255", "bank": "COMM", "type": "SCC", "length": "16", "name": "交通银行"},
    {"bin": "622256", "bank": "COMM", "type": "SCC", "length": "16", "name": "交通银行"},
    {"bin": "622257", "bank": "COMM", "type": "SCC", "length": "16", "name": "交通银行"},
    {"bin": "622258", "bank": "COMM", "type": "DC", "length": "17", "name": "交通银行"},
    {"bin": "622259", "bank": "COMM", "type": "DC", "length": "17", "name": "交通银行"},
    {"bin": "622260", "bank": "COMM", "type": "DC", "length": "19", "name": "交通银行"},
    {"bin": "622261", "bank": "COMM", "type": "DC", "length": "19", "name": "交通银行"},
    {"bin": "622262", "bank": "COMM", "type": "DC", "length": "19", "name": "交通银行"},
    {"bin": "622265", "bank": "HKBEA", "type": "CC", "length": "16", "name": "东亚银行"},
    {"bin": "622266", "bank": "HKBEA", "type": "CC", "length": "16", "name": "东亚银行"},
    {"bin": "622267", "bank": "SHBANK", "type": "DC", "length": "18", "name": "上海银行"},
    {"bin": "622268", "bank": "SHBANK", "type": "CC", "length": "16", "name": "上海银行"},
    {"bin": "622269", "bank": "SHBANK", "type": "CC", "length": "16", "name": "上海银行"},
    {"bin": "622270", "bank": "DAQINGB", "type": "CC", "length": "16", "name": "龙江银行"},
    {"bin": "622271", "bank": "NHB", "type": "DC", "length": "18", "name": "南海农村信用联社"},
    {"bin": "622272", "bank": "CHB", "type": "DC", "length": "16", "name": "创兴银行有限公司"},
    {"bin": "622275", "bank": "NCB", "type": "DC", "length": "16", "name": "南昌银行"},
    {"bin": "622276", "bank": "SPDB", "type": "CC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "622277", "bank": "SPDB", "type": "CC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "622278", "bank": "SHBANK", "type": "DC", "length": "18", "name": "上海银行"},
    {"bin": "622279", "bank": "SHBANK", "type": "DC", "length": "18", "name": "上海银行"},
    {"bin": "622280", "bank": "CCB", "type": "DC", "length": "19", "name": "中国建设银行"},
    {"bin": "622281", "bank": "NBBANK", "type": "DC", "length": "16", "name": "宁波银行"},
    {"bin": "622282", "bank": "NBBANK", "type": "CC", "length": "16", "name": "宁波银行"},
    {"bin": "622283", "bank": "JSBANK", "type": "CC", "length": "16", "name": "江苏银行"},
    {"bin": "622284", "bank": "COMM", "type": "SCC", "length": "16", "name": "交通银行"},
    {"bin": "622285", "bank": "COMM", "type": "CC", "length": "16", "name": "交通银行"},
    {"bin": "622286", "bank": "HZCB", "type": "CC", "length": "16", "name": "杭州银行"},
    {
        "bin": "622287",
        "bank": "ZJTLCB",
        "type": "CC",
        "length": "16",
        "name": "浙江泰隆商业银行",
    },
    {
        "bin": "622288",
        "bank": "ZJNX",
        "type": "CC",
        "length": "16",
        "name": "浙江省农村信用社联合社",
    },
    {"bin": "622289", "bank": "NBYZ", "type": "CC", "length": "16", "name": "鄞州银行"},
    {
        "bin": "622290",
        "bank": "FJNX",
        "type": "CC",
        "length": "16",
        "name": "福建省农村信用社联合社",
    },
    {"bin": "622291", "bank": "LZCCB", "type": "DC", "length": "18", "name": "柳州银行"},
    {"bin": "622292", "bank": "LZCCB", "type": "DC", "length": "18", "name": "柳州银行"},
    {"bin": "622293", "bank": "DSB", "type": "CC", "length": "16", "name": "大新银行"},
    {"bin": "622294", "bank": "DSB", "type": "CC", "length": "16", "name": "大新银行"},
    {"bin": "622295", "bank": "DSB", "type": "CC", "length": "16", "name": "大新银行"},
    {"bin": "622296", "bank": "DSB", "type": "CC", "length": "16", "name": "大新银行"},
    {"bin": "622297", "bank": "DSB", "type": "DC", "length": "16", "name": "大新银行"},
    {"bin": "622298", "bank": "SPABANK", "type": "DC", "length": "16", "name": "平安银行"},
    {"bin": "622300", "bank": "SHBANK", "type": "CC", "length": "16", "name": "上海银行"},
    {"bin": "622301", "bank": "HZCCB", "type": "DC", "length": "19", "name": "湖州市商业银行"},
    {
        "bin": "622302",
        "bank": "GDRCC",
        "type": "DC",
        "length": "16",
        "name": "广东省农村信用社联合社",
    },
    {"bin": "622302", "bank": "ICBC", "type": "DC", "length": "18", "name": "中国工商银行"},
    {"bin": "622303", "bank": "NJCB", "type": "CC", "length": "16", "name": "南京银行"},
    {"bin": "622303", "bank": "ICBC", "type": "DC", "length": "18", "name": "中国工商银行"},
    {"bin": "622305", "bank": "NJCB", "type": "DC", "length": "16", "name": "南京银行"},
    {"bin": "622305", "bank": "ICBC", "type": "DC", "length": "18", "name": "中国工商银行"},
    {"bin": "622307", "bank": "ICBC", "type": "DC", "length": "18", "name": "中国工商银行"},
    {"bin": "622307", "bank": "JJBANK", "type": "DC", "length": "19", "name": "九江银行"},
    {"bin": "622308", "bank": "FDB", "type": "DC", "length": "17", "name": "富滇银行"},
    {"bin": "622308", "bank": "ICBC", "type": "DC", "length": "18", "name": "中国工商银行"},
    {"bin": "622309", "bank": "ICBC", "type": "DC", "length": "18", "name": "中国工商银行"},
    {"bin": "622309", "bank": "CZBANK", "type": "DC", "length": "19", "name": "浙商银行"},
    {"bin": "622310", "bank": "BOQH", "type": "DC", "length": "17", "name": "青海银行"},
    {
        "bin": "622312",
        "bank": "JSRCU",
        "type": "DC",
        "length": "16",
        "name": "江苏省农村信用联合社",
    },
    {"bin": "622313", "bank": "ICBC", "type": "DC", "length": "18", "name": "中国工商银行"},
    {"bin": "622315", "bank": "BSB", "type": "CC", "length": "16", "name": "包商银行"},
    {"bin": "622316", "bank": "NBBANK", "type": "DC", "length": "16", "name": "宁波银行"},
    {"bin": "622318", "bank": "NBBANK", "type": "CC", "length": "16", "name": "宁波银行"},
    {
        "bin": "622319",
        "bank": "SDRCU",
        "type": "DC",
        "length": "16",
        "name": "山东省农村信用社",
    },
    {
        "bin": "622320",
        "bank": "SDRCU",
        "type": "DC",
        "length": "16",
        "name": "山东省农村信用社",
    },
    {"bin": "622321", "bank": "TZCB", "type": "CC", "length": "16", "name": "台州银行"},
    {"bin": "622322", "bank": "SDEB", "type": "DC", "length": "16", "name": "顺德农商银行"},
    {
        "bin": "622323",
        "bank": "CSRCB",
        "type": "DC",
        "length": "19",
        "name": "常熟农村商业银行",
    },
    {
        "bin": "622324",
        "bank": "JSRCU",
        "type": "DC",
        "length": "19",
        "name": "江苏省农村信用联合社",
    },
    {"bin": "622325", "bank": "HKB", "type": "DC", "length": "16", "name": "汉口银行"},
    {"bin": "622327", "bank": "HSBANK", "type": "DC", "length": "17", "name": "徽商银行"},
    {
        "bin": "622328",
        "bank": "DRCBCL",
        "type": "DC",
        "length": "19",
        "name": "东莞农村商业银行",
    },
    {"bin": "622329", "bank": "TRCB", "type": "DC", "length": "19", "name": "天津农商银行"},
    {"bin": "622331", "bank": "TCCB", "type": "DC", "length": "18", "name": "天津银行"},
    {
        "bin": "622332",
        "bank": "ZRCBANK",
        "type": "DC",
        "length": "17",
        "name": "张家港农村商业银行",
    },
    {"bin": "622333", "bank": "BOD", "type": "DC", "length": "16", "name": "东莞银行"},
    {"bin": "622335", "bank": "BGB", "type": "DC", "length": "16", "name": "广西北部湾银行"},
    {"bin": "622336", "bank": "BSB", "type": "DC", "length": "17", "name": "包商银行"},
    {"bin": "622337", "bank": "JSBANK", "type": "DC", "length": "16", "name": "江苏银行"},
    {
        "bin": "622338",
        "bank": "JZCBANK",
        "type": "DC",
        "length": "19",
        "name": "焦作市商业银行",
    },
    {"bin": "622339", "bank": "NBYZ", "type": "DC", "length": "16", "name": "鄞州银行"},
    {"bin": "622340", "bank": "HSBANK", "type": "DC", "length": "17", "name": "徽商银行"},
    {
        "bin": "622341",
        "bank": "JRCB",
        "type": "DC",
        "length": "16",
        "name": "江苏江阴农村商业银行",
    },
    {
        "bin": "622342",
        "bank": "PZHCCB",
        "type": "DC",
        "length": "19",
        "name": "攀枝花市商业银行",
    },
    {
        "bin": "622343",
        "bank": "GDRCC",
        "type": "DC",
        "length": "19",
        "name": "广东省农村信用社联合社",
    },
    {"bin": "622345", "bank": "CDRCB", "type": "DC", "length": "19", "name": "成都农商银行"},
    {"bin": "622349", "bank": "NCB", "type": "CC", "length": "16", "name": "南昌银行"},
    {"bin": "622350", "bank": "NCB", "type": "CC", "length": "16", "name": "南昌银行"},
    {"bin": "622351", "bank": "NCB", "type": "DC", "length": "16", "name": "南昌银行"},
    {"bin": "622352", "bank": "CYBC", "type": "CC", "length": "16", "name": "集友银行"},
    {"bin": "622353", "bank": "CYBC", "type": "CC", "length": "16", "name": "集友银行"},
    {"bin": "622355", "bank": "CYBC", "type": "DC", "length": "16", "name": "集友银行"},
    {
        "bin": "622358",
        "bank": "HBRCU",
        "type": "DC",
        "length": "19",
        "name": "河北省农村信用社",
    },
    {"bin": "622359", "bank": "LSBC", "type": "DC", "length": "19", "name": "临商银行"},
    {"bin": "622360", "bank": "HSBC", "type": "CC", "length": "16", "name": "汇丰银行(中国)"},
    {"bin": "622361", "bank": "HSBC", "type": "CC", "length": "16", "name": "汇丰银行(中国)"},
    {
        "bin": "622362",
        "bank": "GDRCC",
        "type": "DC",
        "length": "19",
        "name": "广东省农村信用社联合社",
    },
    {"bin": "622363", "bank": "RBOZ", "type": "DC", "length": "19", "name": "珠海华润银行"},
    {"bin": "622365", "bank": "HKBEA", "type": "DC", "length": "17", "name": "东亚银行"},
    {"bin": "622366", "bank": "HSBANK", "type": "DC", "length": "17", "name": "徽商银行"},
    {
        "bin": "622367",
        "bank": "MYBANK",
        "type": "DC",
        "length": "19",
        "name": "绵阳市商业银行",
    },
    {"bin": "622368", "bank": "CSCB", "type": "DC", "length": "19", "name": "长沙银行"},
    {
        "bin": "622369",
        "bank": "YNRCC",
        "type": "DC",
        "length": "16",
        "name": "云南省农村信用社",
    },
    {"bin": "622370", "bank": "BOQZ", "type": "DC", "length": "19", "name": "泉州银行"},
    {"bin": "622371", "bank": "CITI", "type": "CC", "length": "16", "name": "花旗银行(中国)"},
    {
        "bin": "622372",
        "bank": "BEAHK",
        "type": "CC",
        "length": "16",
        "name": "东亚银行有限公司",
    },
    {"bin": "622373", "bank": "DSB", "type": "CC", "length": "16", "name": "大新银行"},
    {"bin": "622375", "bank": "DSB", "type": "DC", "length": "17", "name": "大新银行"},
    {"bin": "622376", "bank": "HSB", "type": "CC", "length": "16", "name": "恒生银行"},
    {"bin": "622377", "bank": "HSB", "type": "CC", "length": "16", "name": "恒生银行"},
    {"bin": "622378", "bank": "HSB", "type": "CC", "length": "16", "name": "恒生银行"},
    {"bin": "622379", "bank": "QLBANK", "type": "DC", "length": "19", "name": "齐鲁银行"},
    {"bin": "622383", "bank": "DLB", "type": "CC", "length": "16", "name": "大连银行"},
    {"bin": "622384", "bank": "EGBANK", "type": "DC", "length": "17", "name": "恒丰银行"},
    {"bin": "622385", "bank": "DLB", "type": "CC", "length": "16", "name": "大连银行"},
    {"bin": "622386", "bank": "SHBANK", "type": "CC", "length": "16", "name": "上海银行"},
    {"bin": "622387", "bank": "WLB", "type": "CC", "length": "16", "name": "永隆银行"},
    {"bin": "622388", "bank": "FJHXBC", "type": "DC", "length": "16", "name": "福建海峡银行"},
    {"bin": "622389", "bank": "NBYZ", "type": "CC", "length": "16", "name": "鄞州银行"},
    {"bin": "622391", "bank": "BANKWF", "type": "DC", "length": "16", "name": "潍坊银行"},
    {
        "bin": "622392",
        "bank": "LUZBANK",
        "type": "DC",
        "length": "19",
        "name": "泸州市商业银行",
    },
    {"bin": "622393", "bank": "XMBANK", "type": "DC", "length": "16", "name": "厦门银行"},
    {"bin": "622394", "bank": "JSBANK", "type": "DC", "length": "16", "name": "江苏银行"},
    {"bin": "622395", "bank": "DTCCB", "type": "DC", "length": "19", "name": "大同银行"},
    {"bin": "622396", "bank": "HBC", "type": "DC", "length": "17", "name": "湖北银行"},
    {"bin": "622397", "bank": "YCCB", "type": "CC", "length": "16", "name": "宜昌市商业银行"},
    {"bin": "622398", "bank": "HLDB", "type": "DC", "length": "16", "name": "葫芦岛市商业银行"},
    {"bin": "622399", "bank": "LYCB", "type": "DC", "length": "17", "name": "辽阳市商业银行"},
    {"bin": "622400", "bank": "BOYK", "type": "DC", "length": "17", "name": "营口银行"},
    {"bin": "622406", "bank": "HSBC", "type": "DC", "length": "17", "name": "汇丰银行(中国)"},
    {"bin": "622407", "bank": "HSBC", "type": "DC", "length": "19", "name": "汇丰银行(中国)"},
    {"bin": "622409", "bank": "HSB", "type": "DC", "length": "19", "name": "恒生银行"},
    {"bin": "622410", "bank": "HSB", "type": "DC", "length": "17", "name": "恒生银行"},
    {"bin": "622411", "bank": "WHCCB", "type": "DC", "length": "16", "name": "威海市商业银行"},
    {
        "bin": "622412",
        "bank": "HURCB",
        "type": "DC",
        "length": "16",
        "name": "湖北省农村信用社",
    },
    {"bin": "622413", "bank": "ASCB", "type": "DC", "length": "16", "name": "鞍山银行"},
    {"bin": "622415", "bank": "BODD", "type": "DC", "length": "16", "name": "丹东银行"},
    {"bin": "622418", "bank": "JSBANK", "type": "DC", "length": "16", "name": "江苏银行"},
    {"bin": "622420", "bank": "BOL", "type": "DC", "length": "17", "name": "洛阳银行"},
    {"bin": "622421", "bank": "ZZBANK", "type": "DC", "length": "19", "name": "郑州银行"},
    {"bin": "6224217", "bank": "ZZBANK", "type": "DC", "length": "19", "name": "郑州银行"},
    {"bin": "622422", "bank": "JSBANK", "type": "DC", "length": "16", "name": "江苏银行"},
    {"bin": "622423", "bank": "WLB", "type": "CC", "length": "16", "name": "永隆银行"},
    {"bin": "622425", "bank": "HRBANK", "type": "DC", "length": "17", "name": "哈尔滨银行"},
    {"bin": "622425", "bank": "HRBANK", "type": "DC", "length": "19", "name": "哈尔滨银行"},
    {"bin": "622426", "bank": "TCCB", "type": "CC", "length": "16", "name": "天津银行"},
    {"bin": "622427", "bank": "TZCB", "type": "DC", "length": "16", "name": "台州银行"},
    {"bin": "622428", "bank": "NXBANK", "type": "CC", "length": "16", "name": "宁夏银行"},
    {"bin": "622429", "bank": "NXBANK", "type": "DC", "length": "19", "name": "宁夏银行"},
    {"bin": "622432", "bank": "BNU", "type": "DC", "length": "19", "name": "大西洋银行"},
    {"bin": "622434", "bank": "LSB", "type": "DC", "length": "19", "name": "临商银行"},
    {"bin": "622435", "bank": "LSB", "type": "DC", "length": "19", "name": "临商银行"},
    {"bin": "622436", "bank": "LSB", "type": "DC", "length": "19", "name": "临商银行"},
    {"bin": "622439", "bank": "GRCB", "type": "DC", "length": "18", "name": "广州农商银行"},
    {"bin": "622440", "bank": "JLBANK", "type": "DC", "length": "16", "name": "吉林银行"},
    {"bin": "622441", "bank": "ZYB", "type": "DC", "length": "16", "name": "中原银行"},
    {"bin": "622442", "bank": "FSCB", "type": "DC", "length": "17", "name": "抚顺银行"},
    {"bin": "622442", "bank": "FSCB", "type": "DC", "length": "19", "name": "抚顺银行"},
    {"bin": "622443", "bank": "KSRB", "type": "DC", "length": "19", "name": "昆山农村商业银行"},
    {"bin": "622447", "bank": "JSBANK", "type": "DC", "length": "16", "name": "江苏银行"},
    {"bin": "622448", "bank": "NYBANK", "type": "DC", "length": "16", "name": "广东南粤银行"},
    {"bin": "622449", "bank": "JHBANK", "type": "DC", "length": "16", "name": "金华银行"},
    {"bin": "622450", "bank": "JHBANK", "type": "CC", "length": "16", "name": "金华银行"},
    {"bin": "622451", "bank": "DSB", "type": "CC", "length": "16", "name": "大新银行"},
    {
        "bin": "622452",
        "bank": "JSRCU",
        "type": "DC",
        "length": "19",
        "name": "江苏省农村信用联合社",
    },
    {"bin": "622453", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "622456", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "622459", "bank": "CITIC", "type": "DC", "length": "17", "name": "中信银行"},
    {
        "bin": "622462",
        "bank": "CSRCB",
        "type": "CC",
        "length": "16",
        "name": "常熟农村商业银行",
    },
    {"bin": "622463", "bank": "CHB", "type": "DC", "length": "19", "name": "创兴银行有限公司"},
    {"bin": "622465", "bank": "JSB", "type": "DC", "length": "17", "name": "晋商银行"},
    {"bin": "622466", "bank": "SJBANK", "type": "CC", "length": "16", "name": "盛京银行"},
    {"bin": "622467", "bank": "GCB", "type": "DC", "length": "19", "name": "广州银行"},
    {"bin": "622468", "bank": "SHBANK", "type": "DC", "length": "18", "name": "上海银行"},
    {
        "bin": "622469",
        "bank": "YNRCC",
        "type": "CC",
        "length": "16",
        "name": "云南省农村信用社",
    },
    {
        "bin": "622470",
        "bank": "GDRCC",
        "type": "DC",
        "length": "19",
        "name": "广东省农村信用社联合社",
    },
    {"bin": "622471", "bank": "HKBEA", "type": "CC", "length": "16", "name": "东亚银行"},
    {"bin": "622472", "bank": "HKBEA", "type": "CC", "length": "16", "name": "东亚银行"},
    {"bin": "622475", "bank": "DAQINGB", "type": "DC", "length": "16", "name": "龙江银行"},
    {
        "bin": "622476",
        "bank": "URMQCCB",
        "type": "CC",
        "length": "16",
        "name": "乌鲁木齐市商业银行",
    },
    {
        "bin": "622477",
        "bank": "GDRCC",
        "type": "DC",
        "length": "19",
        "name": "广东省农村信用社联合社",
    },
    {
        "bin": "622478",
        "bank": "SHRCB",
        "type": "DC",
        "length": "16",
        "name": "上海农村商业银行",
    },
    {
        "bin": "622481",
        "bank": "JRCB",
        "type": "CC",
        "length": "16",
        "name": "江苏江阴农村商业银行",
    },
    {
        "bin": "622482",
        "bank": "SCBHK",
        "type": "CC",
        "length": "16",
        "name": "渣打银行(香港)",
    },
    {
        "bin": "622483",
        "bank": "SCBHK",
        "type": "CC",
        "length": "16",
        "name": "渣打银行(香港)",
    },
    {
        "bin": "622484",
        "bank": "SCBHK",
        "type": "CC",
        "length": "16",
        "name": "渣打银行(香港)",
    },
    {"bin": "622486", "bank": "SXCB", "type": "DC", "length": "16", "name": "绍兴银行"},
    {"bin": "622488", "bank": "WJRCB", "type": "DC", "length": "16", "name": "吴江农商银行"},
    {"bin": "622489", "bank": "DSB", "type": "DC", "length": "17", "name": "大新银行"},
    {"bin": "622493", "bank": "AEON", "type": "CC", "length": "16", "name": "AEON银行"},
    {"bin": "622498", "bank": "BHB", "type": "DC", "length": "19", "name": "河北银行"},
    {
        "bin": "62249802",
        "bank": "QHDCCB",
        "type": "DC",
        "length": "19",
        "name": "秦皇岛市商业银行",
    },
    {"bin": "62249804", "bank": "BOCZ", "type": "DC", "length": "19", "name": "沧州银行"},
    {"bin": "622499", "bank": "BHB", "type": "DC", "length": "19", "name": "河北银行"},
    {"bin": "622500", "bank": "SPDB", "type": "CC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "622506", "bank": "SXRCCU", "type": "DC", "length": "19", "name": "陕西信合"},
    {
        "bin": "622508",
        "bank": "ZYCBANK",
        "type": "DC",
        "length": "16",
        "name": "遵义市商业银行",
    },
    {
        "bin": "622509",
        "bank": "GDRCC",
        "type": "DC",
        "length": "19",
        "name": "广东省农村信用社联合社",
    },
    {"bin": "622510", "bank": "ICBC", "type": "DC", "length": "18", "name": "中国工商银行"},
    {
        "bin": "622510",
        "bank": "GDRCC",
        "type": "DC",
        "length": "19",
        "name": "广东省农村信用社联合社",
    },
    {"bin": "622511", "bank": "HBC", "type": "DC", "length": "17", "name": "湖北银行"},
    {"bin": "622516", "bank": "SPDB", "type": "DC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "622517", "bank": "SPDB", "type": "DC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "622518", "bank": "SPDB", "type": "DC", "length": "16", "name": "上海浦东发展银行"},
    {
        "bin": "622519",
        "bank": "SPDB",
        "type": "SCC",
        "length": "16",
        "name": "上海浦东发展银行",
    },
    {
        "bin": "622520",
        "bank": "SPDB",
        "type": "SCC",
        "length": "16",
        "name": "上海浦东发展银行",
    },
    {"bin": "622521", "bank": "SPDB", "type": "DC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "622522", "bank": "SPDB", "type": "DC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "622523", "bank": "SPDB", "type": "DC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "622525", "bank": "SPABANK", "type": "CC", "length": "16", "name": "平安银行"},
    {"bin": "622526", "bank": "SPABANK", "type": "CC", "length": "16", "name": "平安银行"},
    {"bin": "622531", "bank": "TRCB", "type": "DC", "length": "19", "name": "天津农商银行"},
    {"bin": "622532", "bank": "JINCHB", "type": "DC", "length": "19", "name": "晋城银行"},
    {"bin": "622535", "bank": "SPABANK", "type": "DC", "length": "16", "name": "平安银行"},
    {"bin": "622536", "bank": "SPABANK", "type": "DC", "length": "16", "name": "平安银行"},
    {"bin": "622537", "bank": "GYCB", "type": "CC", "length": "16", "name": "贵阳市商业银行"},
    {"bin": "622538", "bank": "SPABANK", "type": "DC", "length": "16", "name": "平安银行"},
    {"bin": "622539", "bank": "SPABANK", "type": "DC", "length": "16", "name": "平安银行"},
    {"bin": "622546", "bank": "TFB", "type": "DC", "length": "19", "name": "大丰银行有限公司"},
    {"bin": "622547", "bank": "TFB", "type": "DC", "length": "19", "name": "大丰银行有限公司"},
    {"bin": "622548", "bank": "TFB", "type": "DC", "length": "19", "name": "大丰银行有限公司"},
    {"bin": "622555", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "622556", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "622557", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "622558", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "622559", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "622560", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "622561", "bank": "DYCB", "type": "DC", "length": "19", "name": "德阳商业银行"},
    {"bin": "622562", "bank": "DYCB", "type": "DC", "length": "19", "name": "德阳商业银行"},
    {"bin": "622563", "bank": "DYCB", "type": "DC", "length": "19", "name": "德阳商业银行"},
    {"bin": "622566", "bank": "HKB", "type": "CC", "length": "16", "name": "汉口银行"},
    {"bin": "622567", "bank": "HKB", "type": "CC", "length": "16", "name": "汉口银行"},
    {"bin": "622568", "bank": "GDB", "type": "DC", "length": "19", "name": "广东发展银行"},
    {"bin": "622569", "bank": "WRCB", "type": "CC", "length": "16", "name": "无锡农村商业银行"},
    {"bin": "622570", "bank": "CEB", "type": "CC", "length": "16", "name": "中国光大银行"},
    {"bin": "622571", "bank": "CIB", "type": "CC", "length": "16", "name": "兴业银行"},
    {"bin": "622572", "bank": "CIB", "type": "CC", "length": "16", "name": "兴业银行"},
    {"bin": "622573", "bank": "CIB", "type": "CC", "length": "16", "name": "兴业银行"},
    {"bin": "622575", "bank": "CMB", "type": "CC", "length": "16", "name": "招商银行"},
    {"bin": "622576", "bank": "CMB", "type": "CC", "length": "16", "name": "招商银行"},
    {"bin": "622577", "bank": "CMB", "type": "CC", "length": "16", "name": "招商银行"},
    {"bin": "622578", "bank": "CMB", "type": "CC", "length": "16", "name": "招商银行"},
    {"bin": "622579", "bank": "CMB", "type": "CC", "length": "16", "name": "招商银行"},
    {"bin": "622580", "bank": "CMB", "type": "DC", "length": "16", "name": "招商银行"},
    {"bin": "622581", "bank": "CMB", "type": "CC", "length": "16", "name": "招商银行"},
    {"bin": "622582", "bank": "CMB", "type": "CC", "length": "16", "name": "招商银行"},
    {"bin": "622583", "bank": "SCB", "type": "CC", "length": "16", "name": "渣打银行"},
    {"bin": "622584", "bank": "SCB", "type": "CC", "length": "16", "name": "渣打银行"},
    {"bin": "622588", "bank": "CMB", "type": "DC", "length": "16", "name": "招商银行"},
    {"bin": "622595", "bank": "NJCB", "type": "CC", "length": "16", "name": "南京银行"},
    {"bin": "622596", "bank": "NJCB", "type": "CC", "length": "16", "name": "南京银行"},
    {"bin": "622597", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "622598", "bank": "CMB", "type": "DC", "length": "16", "name": "招商银行"},
    {"bin": "622599", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "622600", "bank": "CMBC", "type": "CC", "length": "16", "name": "中国民生银行"},
    {"bin": "622601", "bank": "CMBC", "type": "CC", "length": "16", "name": "中国民生银行"},
    {"bin": "622602", "bank": "CMBC", "type": "CC", "length": "16", "name": "中国民生银行"},
    {"bin": "622603", "bank": "CMBC", "type": "CC", "length": "16", "name": "中国民生银行"},
    {"bin": "622609", "bank": "CMB", "type": "DC", "length": "16", "name": "招商银行"},
    {
        "bin": "622611",
        "bank": "SHRCB",
        "type": "CC",
        "length": "16",
        "name": "上海农村商业银行",
    },
    {"bin": "622613", "bank": "CQBANK", "type": "CC", "length": "16", "name": "重庆银行"},
    {"bin": "622615", "bank": "CMBC", "type": "DC", "length": "16", "name": "中国民生银行"},
    {"bin": "622616", "bank": "CMBC", "type": "DC", "length": "16", "name": "中国民生银行"},
    {"bin": "622617", "bank": "CMBC", "type": "DC", "length": "16", "name": "中国民生银行"},
    {"bin": "622618", "bank": "CMBC", "type": "DC", "length": "16", "name": "中国民生银行"},
    {"bin": "622619", "bank": "CMBC", "type": "DC", "length": "16", "name": "中国民生银行"},
    {"bin": "622620", "bank": "CMBC", "type": "DC", "length": "16", "name": "中国民生银行"},
    {"bin": "622621", "bank": "CMBC", "type": "CC", "length": "16", "name": "中国民生银行"},
    {"bin": "622622", "bank": "CMBC", "type": "DC", "length": "16", "name": "中国民生银行"},
    {"bin": "622623", "bank": "CMBC", "type": "CC", "length": "16", "name": "中国民生银行"},
    {"bin": "622625", "bank": "HKB", "type": "CC", "length": "16", "name": "汉口银行"},
    {"bin": "622626", "bank": "HKB", "type": "CC", "length": "16", "name": "汉口银行"},
    {"bin": "622630", "bank": "HXBANK", "type": "DC", "length": "16", "name": "华夏银行"},
    {"bin": "622631", "bank": "HXBANK", "type": "DC", "length": "16", "name": "华夏银行"},
    {"bin": "622632", "bank": "HXBANK", "type": "DC", "length": "16", "name": "华夏银行"},
    {"bin": "622633", "bank": "HXBANK", "type": "DC", "length": "16", "name": "华夏银行"},
    {"bin": "622636", "bank": "HXBANK", "type": "CC", "length": "16", "name": "华夏银行"},
    {"bin": "622637", "bank": "HXBANK", "type": "CC", "length": "16", "name": "华夏银行"},
    {"bin": "622638", "bank": "HXBANK", "type": "CC", "length": "16", "name": "华夏银行"},
    {"bin": "622644", "bank": "DAQINGB", "type": "DC", "length": "19", "name": "龙江银行"},
    {"bin": "622648", "bank": "WJRCB", "type": "CC", "length": "16", "name": "吴江农商银行"},
    {"bin": "622650", "bank": "CEB", "type": "CC", "length": "16", "name": "中国光大银行"},
    {"bin": "622651", "bank": "HSBANK", "type": "CC", "length": "16", "name": "徽商银行"},
    {"bin": "622655", "bank": "CEB", "type": "CC", "length": "16", "name": "中国光大银行"},
    {"bin": "622656", "bank": "COMM", "type": "CC", "length": "16", "name": "交通银行"},
    {"bin": "622657", "bank": "CEB", "type": "CC", "length": "16", "name": "中国光大银行"},
    {"bin": "622658", "bank": "CEB", "type": "CC", "length": "16", "name": "中国光大银行"},
    {"bin": "622659", "bank": "CEB", "type": "CC", "length": "16", "name": "中国光大银行"},
    {"bin": "622660", "bank": "CEB", "type": "DC", "length": "16", "name": "中国光大银行"},
    {"bin": "622661", "bank": "CEB", "type": "DC", "length": "16", "name": "中国光大银行"},
    {"bin": "622662", "bank": "CEB", "type": "DC", "length": "16", "name": "中国光大银行"},
    {"bin": "622663", "bank": "CEB", "type": "DC", "length": "16", "name": "中国光大银行"},
    {"bin": "622664", "bank": "CEB", "type": "DC", "length": "16", "name": "中国光大银行"},
    {"bin": "622665", "bank": "CEB", "type": "DC", "length": "16", "name": "中国光大银行"},
    {"bin": "622666", "bank": "CEB", "type": "DC", "length": "16", "name": "中国光大银行"},
    {"bin": "622667", "bank": "CEB", "type": "DC", "length": "16", "name": "中国光大银行"},
    {"bin": "622668", "bank": "CEB", "type": "DC", "length": "16", "name": "中国光大银行"},
    {"bin": "622669", "bank": "CEB", "type": "DC", "length": "16", "name": "中国光大银行"},
    {"bin": "622670", "bank": "CEB", "type": "DC", "length": "16", "name": "中国光大银行"},
    {"bin": "622671", "bank": "CEB", "type": "DC", "length": "16", "name": "中国光大银行"},
    {"bin": "622672", "bank": "CEB", "type": "DC", "length": "16", "name": "中国光大银行"},
    {"bin": "622673", "bank": "CEB", "type": "DC", "length": "16", "name": "中国光大银行"},
    {"bin": "622674", "bank": "CEB", "type": "DC", "length": "16", "name": "中国光大银行"},
    {"bin": "622675", "bank": "CCB", "type": "CC", "length": "16", "name": "中国建设银行"},
    {"bin": "622676", "bank": "CCB", "type": "CC", "length": "16", "name": "中国建设银行"},
    {"bin": "622677", "bank": "CCB", "type": "CC", "length": "16", "name": "中国建设银行"},
    {"bin": "622678", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "622679", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "622680", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "622681", "bank": "JXRCU", "type": "DC", "length": "19", "name": "江西省农村信用"},
    {"bin": "622682", "bank": "JXRCU", "type": "DC", "length": "19", "name": "江西省农村信用"},
    {"bin": "622683", "bank": "JXRCU", "type": "DC", "length": "19", "name": "江西省农村信用"},
    {"bin": "622684", "bank": "BOHAIB", "type": "DC", "length": "16", "name": "渤海银行"},
    {"bin": "622685", "bank": "CEB", "type": "CC", "length": "16", "name": "中国光大银行"},
    {
        "bin": "622686",
        "bank": "ZJNX",
        "type": "CC",
        "length": "16",
        "name": "浙江省农村信用社联合社",
    },
    {"bin": "622687", "bank": "CEB", "type": "CC", "length": "16", "name": "中国光大银行"},
    {"bin": "622688", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "622689", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "622690", "bank": "CITIC", "type": "DC", "length": "16", "name": "中信银行"},
    {"bin": "622691", "bank": "CITIC", "type": "DC", "length": "16", "name": "中信银行"},
    {"bin": "622692", "bank": "CITIC", "type": "DC", "length": "16", "name": "中信银行"},
    {"bin": "622693", "bank": "SPDB", "type": "CC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "622696", "bank": "CITIC", "type": "DC", "length": "16", "name": "中信银行"},
    {"bin": "622698", "bank": "CITIC", "type": "DC", "length": "16", "name": "中信银行"},
    {"bin": "622700", "bank": "CCB", "type": "DC", "length": "19", "name": "中国建设银行"},
    {"bin": "622707", "bank": "CCB", "type": "DC", "length": "16", "name": "中国建设银行"},
    {"bin": "622708", "bank": "CCB", "type": "CC", "length": "16", "name": "中国建设银行"},
    {
        "bin": "622717",
        "bank": "ZJTLCB",
        "type": "SCC",
        "length": "16",
        "name": "浙江泰隆商业银行",
    },
    {
        "bin": "622722",
        "bank": "SHRCB",
        "type": "CC",
        "length": "16",
        "name": "上海农村商业银行",
    },
    {
        "bin": "622740",
        "bank": "MTBANK",
        "type": "CC",
        "length": "16",
        "name": "浙江民泰商业银行",
    },
    {"bin": "62275", "bank": "BOC", "type": "CC", "length": "16", "name": "中国银行"},
    {"bin": "622760", "bank": "BOC", "type": "CC", "length": "16", "name": "中国银行"},
    {"bin": "622761", "bank": "BOC", "type": "CC", "length": "16", "name": "中国银行"},
    {"bin": "622762", "bank": "BOC", "type": "CC", "length": "16", "name": "中国银行"},
    {"bin": "622763", "bank": "BOC", "type": "CC", "length": "16", "name": "中国银行"},
    {"bin": "622764", "bank": "BOC", "type": "CC", "length": "16", "name": "中国银行"},
    {"bin": "622765", "bank": "BOC", "type": "CC", "length": "16", "name": "中国银行"},
    {"bin": "622766", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "622767", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "622768", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "622775", "bank": "WHBMA", "type": "CC", "length": "16", "name": "澳门永亨银行"},
    {"bin": "622777", "bank": "QJCCB", "type": "DC", "length": "16", "name": "曲靖市商业银行"},
    {"bin": "622778", "bank": "NBBANK", "type": "CC", "length": "16", "name": "宁波银行"},
    {"bin": "622785", "bank": "WHBMA", "type": "CC", "length": "16", "name": "澳门永亨银行"},
    {
        "bin": "622802",
        "bank": "FJNX",
        "type": "CC",
        "length": "16",
        "name": "福建省农村信用社联合社",
    },
    {"bin": "622806", "bank": "ICBC", "type": "DC", "length": "18", "name": "中国工商银行"},
    {"bin": "622808", "bank": "CDRCB", "type": "CC", "length": "16", "name": "成都农商银行"},
    {"bin": "622809", "bank": "HRBANK", "type": "CC", "length": "16", "name": "哈尔滨银行"},
    {"bin": "622810", "bank": "PSBC", "type": "CC", "length": "16", "name": "中国邮政储蓄银行"},
    {"bin": "622811", "bank": "PSBC", "type": "CC", "length": "16", "name": "中国邮政储蓄银行"},
    {"bin": "622812", "bank": "PSBC", "type": "CC", "length": "16", "name": "中国邮政储蓄银行"},
    {"bin": "622813", "bank": "CDCB", "type": "CC", "length": "16", "name": "成都银行"},
    {
        "bin": "622815",
        "bank": "JSRCU",
        "type": "CC",
        "length": "16",
        "name": "江苏省农村信用联合社",
    },
    {
        "bin": "622816",
        "bank": "JSRCU",
        "type": "CC",
        "length": "16",
        "name": "江苏省农村信用联合社",
    },
    {"bin": "622817", "bank": "BOQH", "type": "CC", "length": "16", "name": "青海银行"},
    {"bin": "622818", "bank": "CDCB", "type": "CC", "length": "16", "name": "成都银行"},
    {"bin": "622820", "bank": "ABC", "type": "SCC", "length": "16", "name": "中国农业银行"},
    {"bin": "622821", "bank": "ABC", "type": "DC", "length": "19", "name": "中国农业银行"},
    {"bin": "622822", "bank": "ABC", "type": "DC", "length": "19", "name": "中国农业银行"},
    {"bin": "622823", "bank": "ABC", "type": "DC", "length": "19", "name": "中国农业银行"},
    {"bin": "622824", "bank": "ABC", "type": "DC", "length": "19", "name": "中国农业银行"},
    {"bin": "622825", "bank": "ABC", "type": "DC", "length": "19", "name": "中国农业银行"},
    {"bin": "622826", "bank": "ABC", "type": "DC", "length": "19", "name": "中国农业银行"},
    {"bin": "622827", "bank": "ABC", "type": "DC", "length": "19", "name": "中国农业银行"},
    {"bin": "622828", "bank": "ABC", "type": "DC", "length": "19", "name": "中国农业银行"},
    {"bin": "622829", "bank": "TRCB", "type": "CC", "length": "16", "name": "天津农商银行"},
    {"bin": "622830", "bank": "ABC", "type": "SCC", "length": "16", "name": "中国农业银行"},
    {"bin": "622836", "bank": "ABC", "type": "CC", "length": "16", "name": "中国农业银行"},
    {"bin": "622837", "bank": "ABC", "type": "CC", "length": "16", "name": "中国农业银行"},
    {"bin": "622838", "bank": "ABC", "type": "CC", "length": "16", "name": "中国农业银行"},
    {"bin": "622839", "bank": "ABC", "type": "CC", "length": "16", "name": "中国农业银行"},
    {"bin": "622841", "bank": "ABC", "type": "DC", "length": "19", "name": "中国农业银行"},
    {"bin": "622843", "bank": "ABC", "type": "DC", "length": "19", "name": "中国农业银行"},
    {"bin": "622844", "bank": "ABC", "type": "DC", "length": "19", "name": "中国农业银行"},
    {"bin": "622845", "bank": "ABC", "type": "DC", "length": "19", "name": "中国农业银行"},
    {"bin": "622846", "bank": "ABC", "type": "DC", "length": "19", "name": "中国农业银行"},
    {"bin": "622847", "bank": "ABC", "type": "DC", "length": "19", "name": "中国农业银行"},
    {"bin": "622848", "bank": "ABC", "type": "DC", "length": "19", "name": "中国农业银行"},
    {"bin": "622849", "bank": "ABC", "type": "DC", "length": "19", "name": "中国农业银行"},
    {"bin": "622851", "bank": "BJBANK", "type": "CC", "length": "16", "name": "北京银行"},
    {"bin": "622852", "bank": "BJBANK", "type": "CC", "length": "16", "name": "北京银行"},
    {"bin": "622853", "bank": "BJBANK", "type": "CC", "length": "16", "name": "北京银行"},
    {"bin": "622855", "bank": "BOSZ", "type": "DC", "length": "19", "name": "苏州银行"},
    {"bin": "622856", "bank": "GLBANK", "type": "DC", "length": "17", "name": "桂林银行"},
    {"bin": "622857", "bank": "RZB", "type": "DC", "length": "19", "name": "日照银行"},
    {
        "bin": "622858",
        "bank": "ZJNX",
        "type": "DC",
        "length": "19",
        "name": "浙江省农村信用社联合社",
    },
    {
        "bin": "622859",
        "bank": "GDRCC",
        "type": "DC",
        "length": "19",
        "name": "广东省农村信用社联合社",
    },
    {"bin": "622860", "bank": "DAQINGB", "type": "DC", "length": "16", "name": "龙江银行"},
    {"bin": "622861", "bank": "WHB", "type": "DC", "length": "16", "name": "永亨银行"},
    {"bin": "622862", "bank": "WHB", "type": "DC", "length": "16", "name": "永亨银行"},
    {"bin": "622864", "bank": "LSBANK", "type": "DC", "length": "16", "name": "莱商银行"},
    {"bin": "622865", "bank": "JLBANK", "type": "DC", "length": "19", "name": "吉林银行"},
    {"bin": "622866", "bank": "JSBANK", "type": "DC", "length": "19", "name": "江苏银行"},
    {
        "bin": "622867",
        "bank": "CRCBANK",
        "type": "DC",
        "length": "16",
        "name": "重庆农村商业银行",
    },
    {"bin": "622868", "bank": "WZCB", "type": "CC", "length": "16", "name": "温州银行"},
    {
        "bin": "622869",
        "bank": "TCRCB",
        "type": "DC",
        "length": "19",
        "name": "江苏太仓农村商业银行",
    },
    {
        "bin": "622870",
        "bank": "CJCCB",
        "type": "DC",
        "length": "16",
        "name": "苏州长江商业银行",
    },
    {"bin": "622871", "bank": "WHB", "type": "DC", "length": "16", "name": "永亨银行"},
    {"bin": "622876", "bank": "JSBANK", "type": "DC", "length": "19", "name": "江苏银行"},
    {"bin": "622877", "bank": "HSBANK", "type": "DC", "length": "19", "name": "徽商银行"},
    {"bin": "622878", "bank": "HZCB", "type": "DC", "length": "18", "name": "杭州银行"},
    {"bin": "622879", "bank": "HSBANK", "type": "DC", "length": "19", "name": "徽商银行"},
    {"bin": "622880", "bank": "LZCCB", "type": "DC", "length": "16", "name": "柳州银行"},
    {"bin": "622881", "bank": "LZCCB", "type": "DC", "length": "16", "name": "柳州银行"},
    {
        "bin": "622882",
        "bank": "SXRCU",
        "type": "DC",
        "length": "19",
        "name": "山西省农村信用社",
    },
    {"bin": "622883", "bank": "HKBEA", "type": "CC", "length": "16", "name": "东亚银行"},
    {"bin": "622884", "bank": "BOHAIB", "type": "DC", "length": "16", "name": "渤海银行"},
    {
        "bin": "622885",
        "bank": "CRCBANK",
        "type": "DC",
        "length": "16",
        "name": "重庆农村商业银行",
    },
    {"bin": "622886", "bank": "YTBANK", "type": "DC", "length": "16", "name": "烟台银行"},
    {
        "bin": "622891",
        "bank": "CZRCB",
        "type": "DC",
        "length": "19",
        "name": "常州农村信用联社",
    },
    {"bin": "622892", "bank": "SHBANK", "type": "DC", "length": "18", "name": "上海银行"},
    {
        "bin": "622893",
        "bank": "GZRCU",
        "type": "DC",
        "length": "19",
        "name": "贵州省农村信用社",
    },
    {"bin": "622895", "bank": "WRCB", "type": "DC", "length": "16", "name": "无锡农村商业银行"},
    {"bin": "622897", "bank": "CGNB", "type": "DC", "length": "19", "name": "南充市商业银行"},
    {"bin": "622898", "bank": "CSCB", "type": "CC", "length": "16", "name": "长沙银行"},
    {"bin": "622899", "bank": "WZCB", "type": "CC", "length": "16", "name": "温州银行"},
    {"bin": "622900", "bank": "CSCB", "type": "CC", "length": "16", "name": "长沙银行"},
    {"bin": "622901", "bank": "CIB", "type": "CC", "length": "16", "name": "兴业银行"},
    {"bin": "622902", "bank": "CIB", "type": "CC", "length": "16", "name": "兴业银行"},
    {
        "bin": "622906",
        "bank": "SLH",
        "type": "CC",
        "length": "16",
        "name": "湖南农村信用社联合社",
    },
    {"bin": "622908", "bank": "CIB", "type": "DC", "length": "18", "name": "兴业银行"},
    {"bin": "622909", "bank": "CIB", "type": "DC", "length": "18", "name": "兴业银行"},
    {"bin": "622910", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "622916", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "622918", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "622919", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "622921", "bank": "BHB", "type": "CC", "length": "16", "name": "河北银行"},
    {"bin": "622922", "bank": "CIB", "type": "CC", "length": "16", "name": "兴业银行"},
    {"bin": "622932", "bank": "WHB", "type": "DC", "length": "16", "name": "永亨银行"},
    {"bin": "622933", "bank": "HKBEA", "type": "DC", "length": "19", "name": "东亚银行"},
    {"bin": "622935", "bank": "JLRCU", "type": "DC", "length": "19", "name": "吉林农信"},
    {"bin": "622936", "bank": "BOCD", "type": "DC", "length": "19", "name": "承德银行"},
    {"bin": "622937", "bank": "DZBANK", "type": "DC", "length": "19", "name": "德州银行"},
    {"bin": "622938", "bank": "HKBEA", "type": "DC", "length": "19", "name": "东亚银行"},
    {
        "bin": "622939",
        "bank": "ZYCBANK",
        "type": "DC",
        "length": "17",
        "name": "遵义市商业银行",
    },
    {"bin": "622940", "bank": "SZSBK", "type": "DC", "length": "19", "name": "石嘴山银行"},
    {"bin": "622941", "bank": "AEON", "type": "DC", "length": "16", "name": "AEON银行"},
    {"bin": "622942", "bank": "SCB", "type": "DC", "length": "16", "name": "渣打银行"},
    {"bin": "622943", "bank": "HKBEA", "type": "DC", "length": "19", "name": "东亚银行"},
    {"bin": "622944", "bank": "ICBC", "type": "DC", "length": "16", "name": "中国工商银行"},
    {"bin": "622945", "bank": "CCQTGB", "type": "DC", "length": "16", "name": "重庆三峡银行"},
    {"bin": "622946", "bank": "HSBC", "type": "DC", "length": "16", "name": "汇丰银行(中国)"},
    {
        "bin": "622947",
        "bank": "NXRCU",
        "type": "DC",
        "length": "19",
        "name": "宁夏黄河农村商业银行",
    },
    {"bin": "622948", "bank": "SCB", "type": "DC", "length": "16", "name": "渣打银行"},
    {"bin": "622950", "bank": "HSB", "type": "DC", "length": "16", "name": "恒生银行"},
    {"bin": "622951", "bank": "HSB", "type": "DC", "length": "16", "name": "恒生银行"},
    {"bin": "622952", "bank": "SHBANK", "type": "DC", "length": "16", "name": "上海银行"},
    {"bin": "622953", "bank": "ARCU", "type": "DC", "length": "19", "name": "安徽省农村信用社"},
    {"bin": "622955", "bank": "SJBANK", "type": "DC", "length": "16", "name": "盛京银行"},
    {"bin": "622957", "bank": "WHB", "type": "DC", "length": "16", "name": "永亨银行"},
    {"bin": "622958", "bank": "WHB", "type": "DC", "length": "16", "name": "永亨银行"},
    {"bin": "622959", "bank": "HBC", "type": "DC", "length": "19", "name": "湖北银行"},
    {"bin": "622960", "bank": "HDBANK", "type": "DC", "length": "18", "name": "邯郸银行"},
    {
        "bin": "622961",
        "bank": "ZYCBANK",
        "type": "DC",
        "length": "16",
        "name": "遵义市商业银行",
    },
    {"bin": "622962", "bank": "CZCCB", "type": "DC", "length": "17", "name": "长治市商业银行"},
    {"bin": "622963", "bank": "WHB", "type": "DC", "length": "16", "name": "永亨银行"},
    {"bin": "622966", "bank": "CCB", "type": "DC", "length": "16", "name": "中国建设银行"},
    {"bin": "622967", "bank": "GZB", "type": "DC", "length": "19", "name": "赣州银行"},
    {
        "bin": "622968",
        "bank": "SXRCU",
        "type": "DC",
        "length": "19",
        "name": "山西省农村信用社",
    },
    {"bin": "622970", "bank": "WLB", "type": "DC", "length": "17", "name": "永隆银行"},
    {"bin": "622971", "bank": "WLB", "type": "DC", "length": "17", "name": "永隆银行"},
    {"bin": "622972", "bank": "TACCB", "type": "DC", "length": "19", "name": "泰安市商业银行"},
    {"bin": "622973", "bank": "WHBANK", "type": "DC", "length": "19", "name": "乌海银行"},
    {"bin": "622974", "bank": "AEON", "type": "DC", "length": "16", "name": "AEON银行"},
    {
        "bin": "6229756114",
        "bank": "QDRCB",
        "type": "DC",
        "length": "19",
        "name": "青岛农村商业银行",
    },
    {
        "bin": "6229756115",
        "bank": "BJRCB",
        "type": "DC",
        "length": "19",
        "name": "北京农村商业银行",
    },
    {
        "bin": "622976",
        "bank": "NMGNXS",
        "type": "DC",
        "length": "19",
        "name": "内蒙古农村信用社",
    },
    {"bin": "622977", "bank": "DAQINGB", "type": "DC", "length": "19", "name": "龙江银行"},
    {"bin": "622978", "bank": "ORBANK", "type": "DC", "length": "19", "name": "鄂尔多斯银行"},
    {"bin": "622979", "bank": "ZYB", "type": "DC", "length": "19", "name": "中原银行"},
    {"bin": "622980", "bank": "YXCCB", "type": "DC", "length": "19", "name": "玉溪市商业银行"},
    {
        "bin": "622982",
        "bank": "ZJKCCB",
        "type": "DC",
        "length": "19",
        "name": "张家口市商业银行",
    },
    {"bin": "622983", "bank": "SPABANK", "type": "DC", "length": "16", "name": "平安银行"},
    {"bin": "622985", "bank": "SHBANK", "type": "DC", "length": "18", "name": "上海银行"},
    {"bin": "622986", "bank": "SPABANK", "type": "DC", "length": "16", "name": "平安银行"},
    {"bin": "622987", "bank": "SHBANK", "type": "DC", "length": "18", "name": "上海银行"},
    {"bin": "622988", "bank": "CCB", "type": "DC", "length": "16", "name": "中国建设银行"},
    {"bin": "622989", "bank": "SPABANK", "type": "DC", "length": "16", "name": "平安银行"},
    {"bin": "622990", "bank": "BOJZ", "type": "DC", "length": "17", "name": "锦州银行"},
    {"bin": "622991", "bank": "HNRCU", "type": "DC", "length": "18", "name": "河南省农村信用"},
    {"bin": "622992", "bank": "GXRCU", "type": "DC", "length": "19", "name": "广西省农村信用"},
    {"bin": "622993", "bank": "DLB", "type": "DC", "length": "19", "name": "大连银行"},
    {"bin": "622994", "bank": "SCB", "type": "DC", "length": "16", "name": "渣打银行"},
    {"bin": "622995", "bank": "WJRCB", "type": "DC", "length": "16", "name": "吴江农商银行"},
    {"bin": "622996", "bank": "CDCB", "type": "DC", "length": "19", "name": "成都银行"},
    {"bin": "622997", "bank": "CDCB", "type": "DC", "length": "19", "name": "成都银行"},
    {"bin": "622998", "bank": "CITIC", "type": "DC", "length": "16", "name": "中信银行"},
    {"bin": "622999", "bank": "CITIC", "type": "DC", "length": "16", "name": "中信银行"},
    {"bin": "623000", "bank": "BHB", "type": "DC", "length": "19", "name": "河北银行"},
    {"bin": "623001", "bank": "BGB", "type": "DC", "length": "16", "name": "广西北部湾银行"},
    {"bin": "623002", "bank": "ICBC", "type": "DC", "length": "18", "name": "中国工商银行"},
    {"bin": "623003", "bank": "QHDBANK", "type": "DC", "length": "19", "name": "秦皇岛银行"},
    {"bin": "623007", "bank": "LSBC", "type": "DC", "length": "19", "name": "临商银行"},
    {"bin": "623010", "bank": "BOD", "type": "DC", "length": "19", "name": "东莞银行"},
    {"bin": "623013", "bank": "HNRCU", "type": "DC", "length": "18", "name": "河南省农村信用"},
    {"bin": "623016", "bank": "CQBANK", "type": "DC", "length": "16", "name": "重庆银行"},
    {"bin": "623017", "bank": "QHRC", "type": "DC", "length": "16", "name": "青海农村信用社"},
    {"bin": "623018", "bank": "ABC", "type": "DC", "length": "19", "name": "中国农业银行"},
    {"bin": "623019", "bank": "XMBANK", "type": "DC", "length": "19", "name": "厦门银行"},
    {"bin": "623020", "bank": "HXBANK", "type": "DC", "length": "16", "name": "华夏银行"},
    {"bin": "623021", "bank": "HXBANK", "type": "DC", "length": "16", "name": "华夏银行"},
    {"bin": "623022", "bank": "HXBANK", "type": "DC", "length": "16", "name": "华夏银行"},
    {"bin": "623023", "bank": "HXBANK", "type": "DC", "length": "16", "name": "华夏银行"},
    {
        "bin": "623025",
        "bank": "HBRCU",
        "type": "DC",
        "length": "19",
        "name": "河北省农村信用社",
    },
    {"bin": "623026", "bank": "SXCB", "type": "DC", "length": "16", "name": "绍兴银行"},
    {"bin": "623027", "bank": "SXRCCU", "type": "DC", "length": "19", "name": "陕西信合"},
    {"bin": "623029", "bank": "HKB", "type": "DC", "length": "16", "name": "汉口银行"},
    {
        "bin": "623033",
        "bank": "WHRCB",
        "type": "DC",
        "length": "19",
        "name": "武汉农村商业银行",
    },
    {"bin": "623035", "bank": "SRCB", "type": "DC", "length": "16", "name": "深圳农村商业银行"},
    {
        "bin": "623036",
        "bank": "FJNX",
        "type": "DC",
        "length": "19",
        "name": "福建省农村信用社联合社",
    },
    {
        "bin": "623038",
        "bank": "DRCBCL",
        "type": "DC",
        "length": "19",
        "name": "东莞农村商业银行",
    },
    {"bin": "623039", "bank": "TZCB", "type": "DC", "length": "19", "name": "台州银行"},
    {
        "bin": "623051",
        "bank": "SXRCU",
        "type": "DC",
        "length": "19",
        "name": "山西省农村信用社",
    },
    {"bin": "623052", "bank": "ABC", "type": "DC", "length": "19", "name": "中国农业银行"},
    {"bin": "623058", "bank": "SPABANK", "type": "DC", "length": "19", "name": "平安银行"},
    {"bin": "623059", "bank": "HNRCU", "type": "DC", "length": "18", "name": "河南省农村信用"},
    {"bin": "623060", "bank": "BOCD", "type": "DC", "length": "19", "name": "承德银行"},
    {"bin": "623061", "bank": "HZCB", "type": "DC", "length": "18", "name": "杭州银行"},
    {"bin": "623062", "bank": "ICBC", "type": "DC", "length": "19", "name": "中国工商银行"},
    {"bin": "623065", "bank": "GSRCU", "type": "DC", "length": "19", "name": "甘肃省农村信用"},
    {
        "bin": "623066",
        "bank": "JSRCU",
        "type": "DC",
        "length": "19",
        "name": "江苏省农村信用联合社",
    },
    {"bin": "623067", "bank": "JHBANK", "type": "DC", "length": "16", "name": "金华银行"},
    {"bin": "623068", "bank": "HSBK", "type": "DC", "length": "19", "name": "衡水银行"},
    {"bin": "623069", "bank": "DLB", "type": "DC", "length": "19", "name": "大连银行"},
    {"bin": "623070", "bank": "DLB", "type": "DC", "length": "19", "name": "大连银行"},
    {
        "bin": "623071",
        "bank": "CSRCB",
        "type": "DC",
        "length": "19",
        "name": "常熟农村商业银行",
    },
    {"bin": "623072", "bank": "CGNB", "type": "DC", "length": "19", "name": "南充市商业银行"},
    {"bin": "623076", "bank": "HBC", "type": "DC", "length": "19", "name": "湖北银行"},
    {"bin": "623077", "bank": "RZB", "type": "DC", "length": "19", "name": "日照银行"},
    {"bin": "623078", "bank": "EGBANK", "type": "DC", "length": "19", "name": "恒丰银行"},
    {"bin": "623081", "bank": "SJBANK", "type": "DC", "length": "16", "name": "盛京银行"},
    {"bin": "623088", "bank": "CDRCB", "type": "DC", "length": "19", "name": "成都农商银行"},
    {"bin": "623089", "bank": "NXBANK", "type": "DC", "length": "19", "name": "宁夏银行"},
    {
        "bin": "623090",
        "bank": "HNRCC",
        "type": "DC",
        "length": "19",
        "name": "湖南省农村信用社",
    },
    {
        "bin": "623091",
        "bank": "ZJNX",
        "type": "DC",
        "length": "19",
        "name": "浙江省农村信用社联合社",
    },
    {"bin": "623093", "bank": "ORBANK", "type": "DC", "length": "19", "name": "鄂尔多斯银行"},
    {"bin": "623094", "bank": "CCB", "type": "DC", "length": "19", "name": "中国建设银行"},
    {
        "bin": "623095",
        "bank": "NXRCU",
        "type": "DC",
        "length": "19",
        "name": "宁夏黄河农村商业银行",
    },
    {"bin": "623096", "bank": "CQBANK", "type": "DC", "length": "19", "name": "重庆银行"},
    {"bin": "623100", "bank": "ICBC", "type": "DC", "length": "18", "name": "中国工商银行"},
    {"bin": "623101", "bank": "DZBANK", "type": "DC", "length": "19", "name": "德州银行"},
    {"bin": "623102", "bank": "WHCCB", "type": "DC", "length": "19", "name": "威海市商业银行"},
    {"bin": "623103", "bank": "TRCB", "type": "DC", "length": "19", "name": "天津农商银行"},
    {"bin": "623105", "bank": "HKB", "type": "DC", "length": "16", "name": "汉口银行"},
    {"bin": "623106", "bank": "HSB", "type": "DC", "length": "17", "name": "恒生银行"},
    {"bin": "623107", "bank": "HSB", "type": "DC", "length": "19", "name": "恒生银行"},
    {"bin": "623108", "bank": "SJBANK", "type": "DC", "length": "16", "name": "盛京银行"},
    {
        "bin": "623109",
        "bank": "TJBHB",
        "type": "DC",
        "length": "19",
        "name": "天津滨海农村商业银行",
    },
    {"bin": "623110", "bank": "WJRCB", "type": "DC", "length": "16", "name": "吴江农商银行"},
    {"bin": "623111", "bank": "BJBANK", "type": "DC", "length": "16", "name": "北京银行"},
    {"bin": "623112", "bank": "WZCB", "type": "DC", "length": "19", "name": "温州银行"},
    {"bin": "623113", "bank": "GHB", "type": "DC", "length": "19", "name": "广东华兴银行"},
    {
        "bin": "623115",
        "bank": "JRCB",
        "type": "DC",
        "length": "16",
        "name": "江苏江阴农村商业银行",
    },
    {"bin": "623116", "bank": "JNBANK", "type": "DC", "length": "19", "name": "济宁银行"},
    {
        "bin": "623123",
        "bank": "ZRCBANK",
        "type": "DC",
        "length": "17",
        "name": "张家港农村商业银行",
    },
    {"bin": "623125", "bank": "WRCB", "type": "DC", "length": "16", "name": "无锡农村商业银行"},
    {"bin": "623126", "bank": "CMB", "type": "DC", "length": "16", "name": "招商银行"},
    {"bin": "623131", "bank": "JLBANK", "type": "DC", "length": "19", "name": "吉林银行"},
    {"bin": "623132", "bank": "KSRB", "type": "DC", "length": "19", "name": "昆山农村商业银行"},
    {"bin": "623133", "bank": "GXRCU", "type": "DC", "length": "19", "name": "广西省农村信用"},
    {"bin": "623135", "bank": "YXCCB", "type": "DC", "length": "19", "name": "玉溪市商业银行"},
    {"bin": "623136", "bank": "CMB", "type": "DC", "length": "16", "name": "招商银行"},
    {"bin": "623146", "bank": "JJBANK", "type": "DC", "length": "19", "name": "九江银行"},
    {
        "bin": "623150",
        "bank": "CJCCB",
        "type": "DC",
        "length": "16",
        "name": "苏州长江商业银行",
    },
    {"bin": "623151", "bank": "LYCB", "type": "DC", "length": "19", "name": "辽阳市商业银行"},
    {"bin": "623152", "bank": "BOP", "type": "DC", "length": "19", "name": "平顶山银行"},
    {"bin": "623153", "bank": "WHBANK", "type": "DC", "length": "19", "name": "乌海银行"},
    {"bin": "623156", "bank": "CEB", "type": "DC", "length": "16", "name": "中国光大银行"},
    {
        "bin": "623162",
        "bank": "SHRCB",
        "type": "DC",
        "length": "19",
        "name": "上海农村商业银行",
    },
    {"bin": "623163", "bank": "ICBC", "type": "DC", "length": "19", "name": "中国工商银行"},
    {"bin": "623170", "bank": "QDCCB", "type": "DC", "length": "19", "name": "青岛银行"},
    {"bin": "623177", "bank": "BOYK", "type": "DC", "length": "19", "name": "营口银行"},
    {"bin": "623178", "bank": "SNCCB", "type": "DC", "length": "19", "name": "遂宁市商业银行"},
    {"bin": "623179", "bank": "JSB", "type": "DC", "length": "19", "name": "晋商银行"},
    {"bin": "623181", "bank": "JLRCU", "type": "DC", "length": "19", "name": "吉林农信"},
    {"bin": "623182", "bank": "GSBANK", "type": "DC", "length": "19", "name": "甘肃银行"},
    {"bin": "623183", "bank": "SHBANK", "type": "DC", "length": "18", "name": "上海银行"},
    {"bin": "623184", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "623185", "bank": "SHBANK", "type": "DC", "length": "18", "name": "上海银行"},
    {"bin": "623188", "bank": "ASCB", "type": "DC", "length": "16", "name": "鞍山银行"},
    {
        "bin": "623189",
        "bank": "CZRCB",
        "type": "DC",
        "length": "19",
        "name": "常州农村信用联社",
    },
    {
        "bin": "623190",
        "bank": "YNRCC",
        "type": "DC",
        "length": "19",
        "name": "云南省农村信用社",
    },
    {"bin": "623197", "bank": "JINCHB", "type": "DC", "length": "19", "name": "晋城银行"},
    {
        "bin": "623205",
        "bank": "JZCBANK",
        "type": "DC",
        "length": "19",
        "name": "焦作市商业银行",
    },
    {"bin": "623206", "bank": "ABC", "type": "DC", "length": "19", "name": "中国农业银行"},
    {
        "bin": "623207",
        "bank": "WHRCB",
        "type": "DC",
        "length": "19",
        "name": "武汉农村商业银行",
    },
    {"bin": "623208", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "623211", "bank": "CCB", "type": "DC", "length": "19", "name": "中国建设银行"},
    {"bin": "623218", "bank": "PSBC", "type": "DC", "length": "19", "name": "中国邮政储蓄银行"},
    {"bin": "623220", "bank": "ARCU", "type": "DC", "length": "19", "name": "安徽省农村信用社"},
    {"bin": "623221", "bank": "GLBANK", "type": "DC", "length": "17", "name": "桂林银行"},
    {
        "bin": "623501",
        "bank": "HBRCU",
        "type": "DC",
        "length": "19",
        "name": "河北省农村信用社",
    },
    {"bin": "623513", "bank": "HANABANK", "type": "DC", "length": "16", "name": "韩亚银行"},
    {"bin": "623521", "bank": "BOSZ", "type": "DC", "length": "19", "name": "苏州银行"},
    {"bin": "623531", "bank": "ZZBANK", "type": "DC", "length": "19", "name": "郑州银行"},
    {
        "bin": "623535",
        "bank": "ZJTLCB",
        "type": "DC",
        "length": "16",
        "name": "浙江泰隆商业银行",
    },
    {"bin": "623568", "bank": "BOJZ", "type": "DC", "length": "19", "name": "锦州银行"},
    {"bin": "623569", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {
        "bin": "623570",
        "bank": "YDNSCZYH",
        "type": "DC",
        "length": "19",
        "name": "尧都农商村镇银行",
    },
    {"bin": "623571", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "623572", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "623573", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "623575", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "623586", "bank": "BOC", "type": "DC", "length": "19", "name": "中国银行"},
    {"bin": "623627", "bank": "GHB", "type": "DC", "length": "19", "name": "广东华兴银行"},
    {"bin": "623644", "bank": "CCB", "type": "DC", "length": "19", "name": "中国建设银行"},
    {"bin": "623660", "bank": "ZYB", "type": "DC", "length": "16", "name": "中原银行"},
    {"bin": "623668", "bank": "CCB", "type": "DC", "length": "19", "name": "中国建设银行"},
    {"bin": "623669", "bank": "CCB", "type": "DC", "length": "19", "name": "中国建设银行"},
    {"bin": "623683", "bank": "CMBC", "type": "DC", "length": "16", "name": "中国民生银行"},
    {"bin": "623698", "bank": "PSBC", "type": "DC", "length": "19", "name": "中国邮政储蓄银行"},
    {"bin": "623699", "bank": "PSBC", "type": "DC", "length": "19", "name": "中国邮政储蓄银行"},
    {"bin": "625001", "bank": "TZCB", "type": "SCC", "length": "16", "name": "台州银行"},
    {"bin": "625008", "bank": "CHB", "type": "CC", "length": "16", "name": "创兴银行有限公司"},
    {"bin": "625009", "bank": "CHB", "type": "CC", "length": "16", "name": "创兴银行有限公司"},
    {"bin": "625014", "bank": "BCDMMA", "type": "CC", "length": "16", "name": "澳门商业银行"},
    {"bin": "625016", "bank": "BCDMMA", "type": "CC", "length": "16", "name": "澳门商业银行"},
    {"bin": "625024", "bank": "HSB", "type": "CC", "length": "16", "name": "恒生银行"},
    {"bin": "625025", "bank": "HANABANK", "type": "CC", "length": "16", "name": "韩亚银行"},
    {"bin": "625026", "bank": "HSB", "type": "CC", "length": "16", "name": "恒生银行"},
    {
        "bin": "625028",
        "bank": "COMMHK",
        "type": "CC",
        "length": "16",
        "name": "交通银行香港分行",
    },
    {"bin": "625034", "bank": "HSBC", "type": "CC", "length": "16", "name": "汇丰银行(中国)"},
    {"bin": "625040", "bank": "BOC", "type": "CC", "length": "16", "name": "中国银行"},
    {"bin": "625044", "bank": "NCB", "type": "CC", "length": "16", "name": "南昌银行"},
    {"bin": "625046", "bank": "NCB", "type": "CC", "length": "16", "name": "南昌银行"},
    {"bin": "625048", "bank": "CYBC", "type": "CC", "length": "16", "name": "集友银行"},
    {"bin": "625050", "bank": "GCB", "type": "CC", "length": "16", "name": "广州银行"},
    {"bin": "625053", "bank": "CYBC", "type": "CC", "length": "16", "name": "集友银行"},
    {"bin": "625055", "bank": "BOC", "type": "CC", "length": "16", "name": "中国银行"},
    {"bin": "625058", "bank": "NCB", "type": "CC", "length": "16", "name": "南昌银行"},
    {"bin": "625060", "bank": "CYBC", "type": "CC", "length": "16", "name": "集友银行"},
    {"bin": "625062", "bank": "WLBHK", "type": "CC", "length": "16", "name": "永隆银行"},
    {"bin": "625063", "bank": "WLBHK", "type": "CC", "length": "16", "name": "永隆银行"},
    {"bin": "625071", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "625072", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "625073", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "625080", "bank": "GRCB", "type": "CC", "length": "16", "name": "广州农商银行"},
    {"bin": "625082", "bank": "CIB", "type": "CC", "length": "16", "name": "兴业银行"},
    {"bin": "625083", "bank": "CIB", "type": "CC", "length": "16", "name": "兴业银行"},
    {"bin": "625084", "bank": "CIB", "type": "CC", "length": "16", "name": "兴业银行"},
    {"bin": "625085", "bank": "CIB", "type": "CC", "length": "16", "name": "兴业银行"},
    {"bin": "625086", "bank": "CIB", "type": "CC", "length": "16", "name": "兴业银行"},
    {"bin": "625087", "bank": "CIB", "type": "CC", "length": "16", "name": "兴业银行"},
    {"bin": "625088", "bank": "SDEB", "type": "CC", "length": "16", "name": "顺德农商银行"},
    {"bin": "625090", "bank": "DAQINGB", "type": "CC", "length": "16", "name": "龙江银行"},
    {"bin": "625099", "bank": "SHBANK", "type": "CC", "length": "16", "name": "上海银行"},
    {"bin": "625141", "bank": "BOC", "type": "CC", "length": "16", "name": "中国银行"},
    {"bin": "625143", "bank": "BOC", "type": "CC", "length": "16", "name": "中国银行"},
    {"bin": "625158", "bank": "YDRCB", "type": "CC", "length": "16", "name": "尧都农商行"},
    {"bin": "625196", "bank": "TFB", "type": "CC", "length": "16", "name": "大丰银行有限公司"},
    {"bin": "625198", "bank": "TFB", "type": "CC", "length": "16", "name": "大丰银行有限公司"},
    {"bin": "625247", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "625249", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {
        "bin": "625288",
        "bank": "DRCBCL",
        "type": "CC",
        "length": "16",
        "name": "东莞农村商业银行",
    },
    {"bin": "625336", "bank": "ABC", "type": "CC", "length": "16", "name": "中国农业银行"},
    {"bin": "625337", "bank": "BOC", "type": "CC", "length": "16", "name": "中国银行"},
    {"bin": "625339", "bank": "CEB", "type": "CC", "length": "16", "name": "中国光大银行"},
    {"bin": "625362", "bank": "CCB", "type": "CC", "length": "16", "name": "中国建设银行"},
    {"bin": "625363", "bank": "CCB", "type": "CC", "length": "16", "name": "中国建设银行"},
    {
        "bin": "625500",
        "bank": "SHRCB",
        "type": "CC",
        "length": "16",
        "name": "上海农村商业银行",
    },
    {"bin": "625516", "bank": "CDRCB", "type": "SCC", "length": "16", "name": "成都农商银行"},
    {
        "bin": "625519",
        "bank": "HNRCC",
        "type": "DC",
        "length": "16",
        "name": "湖南省农村信用社",
    },
    {"bin": "625529", "bank": "NXBANK", "type": "CC", "length": "16", "name": "宁夏银行"},
    {"bin": "625577", "bank": "HRBANK", "type": "CC", "length": "16", "name": "哈尔滨银行"},
    {"bin": "625588", "bank": "DAQINGB", "type": "CC", "length": "16", "name": "龙江银行"},
    {"bin": "625808", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "625809", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "625810", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "625811", "bank": "SJBANK", "type": "CC", "length": "16", "name": "盛京银行"},
    {"bin": "625826", "bank": "ABC", "type": "CC", "length": "16", "name": "中国农业银行"},
    {"bin": "625827", "bank": "ABC", "type": "CC", "length": "16", "name": "中国农业银行"},
    {"bin": "625858", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "625859", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "625901", "bank": "CSCB", "type": "CC", "length": "16", "name": "长沙银行"},
    {"bin": "625902", "bank": "JSBANK", "type": "CC", "length": "16", "name": "江苏银行"},
    {"bin": "625905", "bank": "BOC", "type": "CC", "length": "16", "name": "中国银行"},
    {"bin": "625906", "bank": "BOC", "type": "CC", "length": "16", "name": "中国银行"},
    {"bin": "625907", "bank": "BOC", "type": "CC", "length": "16", "name": "中国银行"},
    {"bin": "625908", "bank": "BOC", "type": "CC", "length": "16", "name": "中国银行"},
    {"bin": "625909", "bank": "BOC", "type": "CC", "length": "16", "name": "中国银行"},
    {"bin": "625910", "bank": "BOC", "type": "CC", "length": "16", "name": "中国银行"},
    {"bin": "625911", "bank": "CMBC", "type": "CC", "length": "16", "name": "中国民生银行"},
    {"bin": "625912", "bank": "CMBC", "type": "CC", "length": "16", "name": "中国民生银行"},
    {"bin": "625913", "bank": "CMBC", "type": "CC", "length": "16", "name": "中国民生银行"},
    {"bin": "625915", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "625916", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "625917", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "625919", "bank": "PSBC", "type": "CC", "length": "16", "name": "中国邮政储蓄银行"},
    {"bin": "625950", "bank": "BSB", "type": "CC", "length": "16", "name": "包商银行"},
    {"bin": "625955", "bank": "CCB", "type": "DC", "length": "16", "name": "中国建设银行"},
    {"bin": "625956", "bank": "CCB", "type": "DC", "length": "16", "name": "中国建设银行"},
    {"bin": "625957", "bank": "SPDB", "type": "CC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "625958", "bank": "SPDB", "type": "CC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "625959", "bank": "BOQH", "type": "CC", "length": "16", "name": "青海银行"},
    {"bin": "625960", "bank": "CIB", "type": "CC", "length": "16", "name": "兴业银行"},
    {"bin": "625961", "bank": "CIB", "type": "CC", "length": "16", "name": "兴业银行"},
    {"bin": "625962", "bank": "CIB", "type": "CC", "length": "16", "name": "兴业银行"},
    {"bin": "625963", "bank": "CIB", "type": "CC", "length": "16", "name": "兴业银行"},
    {"bin": "625964", "bank": "CCB", "type": "CC", "length": "16", "name": "中国建设银行"},
    {"bin": "625965", "bank": "CCB", "type": "CC", "length": "16", "name": "中国建设银行"},
    {"bin": "625966", "bank": "CCB", "type": "CC", "length": "16", "name": "中国建设银行"},
    {"bin": "625967", "bank": "HXBANK", "type": "CC", "length": "16", "name": "华夏银行"},
    {"bin": "625968", "bank": "HXBANK", "type": "CC", "length": "16", "name": "华夏银行"},
    {"bin": "625969", "bank": "HXBANK", "type": "CC", "length": "16", "name": "华夏银行"},
    {"bin": "625970", "bank": "SPDB", "type": "CC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "625971", "bank": "SPDB", "type": "CC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "625975", "bank": "CEB", "type": "CC", "length": "16", "name": "中国光大银行"},
    {"bin": "625976", "bank": "CEB", "type": "CC", "length": "16", "name": "中国光大银行"},
    {"bin": "625977", "bank": "CEB", "type": "CC", "length": "16", "name": "中国光大银行"},
    {"bin": "625978", "bank": "CEB", "type": "CC", "length": "16", "name": "中国光大银行"},
    {"bin": "625979", "bank": "CEB", "type": "CC", "length": "16", "name": "中国光大银行"},
    {"bin": "625980", "bank": "CEB", "type": "CC", "length": "16", "name": "中国光大银行"},
    {"bin": "625981", "bank": "CEB", "type": "CC", "length": "16", "name": "中国光大银行"},
    {"bin": "625993", "bank": "SPDB", "type": "CC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "625996", "bank": "ABC", "type": "CC", "length": "16", "name": "中国农业银行"},
    {"bin": "625997", "bank": "ABC", "type": "CC", "length": "16", "name": "中国农业银行"},
    {"bin": "625998", "bank": "ABC", "type": "CC", "length": "16", "name": "中国农业银行"},
    {"bin": "627066", "bank": "SPABANK", "type": "CC", "length": "16", "name": "平安银行"},
    {"bin": "627067", "bank": "SPABANK", "type": "CC", "length": "16", "name": "平安银行"},
    {"bin": "627068", "bank": "SPABANK", "type": "CC", "length": "16", "name": "平安银行"},
    {"bin": "627069", "bank": "SPABANK", "type": "CC", "length": "16", "name": "平安银行"},
    {"bin": "628200", "bank": "HKB", "type": "CC", "length": "16", "name": "汉口银行"},
    {"bin": "628201", "bank": "CEB", "type": "CC", "length": "16", "name": "中国光大银行"},
    {"bin": "628202", "bank": "CEB", "type": "CC", "length": "16", "name": "中国光大银行"},
    {"bin": "628203", "bank": "BJBANK", "type": "CC", "length": "16", "name": "北京银行"},
    {"bin": "628204", "bank": "JHBANK", "type": "CC", "length": "16", "name": "金华银行"},
    {"bin": "628205", "bank": "TCCB", "type": "CC", "length": "16", "name": "天津银行"},
    {"bin": "628206", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "628207", "bank": "NBBANK", "type": "CC", "length": "16", "name": "宁波银行"},
    {"bin": "628208", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "628209", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "628210", "bank": "JSBANK", "type": "CC", "length": "16", "name": "江苏银行"},
    {
        "bin": "628211",
        "bank": "SHRCB",
        "type": "CC",
        "length": "16",
        "name": "上海农村商业银行",
    },
    {"bin": "628212", "bank": "CIB", "type": "CC", "length": "16", "name": "兴业银行"},
    {"bin": "628213", "bank": "GYCB", "type": "CC", "length": "16", "name": "贵阳市商业银行"},
    {"bin": "628214", "bank": "NXBANK", "type": "CC", "length": "16", "name": "宁夏银行"},
    {"bin": "628217", "bank": "DYCCB", "type": "CC", "length": "16", "name": "东营市商业银行"},
    {"bin": "628219", "bank": "GLBANK", "type": "CC", "length": "16", "name": "桂林银行"},
    {"bin": "628220", "bank": "CQBANK", "type": "CC", "length": "16", "name": "重庆银行"},
    {"bin": "628221", "bank": "SPDB", "type": "CC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "628222", "bank": "SPDB", "type": "CC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "628223", "bank": "SRBANK", "type": "CC", "length": "16", "name": "上饶银行"},
    {"bin": "628224", "bank": "HRBANK", "type": "CC", "length": "16", "name": "哈尔滨银行"},
    {
        "bin": "628226",
        "bank": "JSRCU",
        "type": "CC",
        "length": "16",
        "name": "江苏省农村信用联合社",
    },
    {"bin": "628227", "bank": "BGB", "type": "CC", "length": "16", "name": "广西北部湾银行"},
    {"bin": "628228", "bank": "CDCB", "type": "CC", "length": "16", "name": "成都银行"},
    {"bin": "628229", "bank": "CDB", "type": "CC", "length": "16", "name": "国家开发银行"},
    {"bin": "628230", "bank": "SHBANK", "type": "CC", "length": "16", "name": "上海银行"},
    {"bin": "628231", "bank": "FDB", "type": "CC", "length": "16", "name": "富滇银行"},
    {
        "bin": "628232",
        "bank": "FJNX",
        "type": "CC",
        "length": "16",
        "name": "福建省农村信用社联合社",
    },
    {"bin": "628233", "bank": "GZB", "type": "CC", "length": "16", "name": "赣州银行"},
    {"bin": "628234", "bank": "WHCCB", "type": "CC", "length": "16", "name": "威海市商业银行"},
    {"bin": "628236", "bank": "HZCB", "type": "CC", "length": "16", "name": "杭州银行"},
    {"bin": "628238", "bank": "JJBANK", "type": "CC", "length": "16", "name": "九江银行"},
    {"bin": "628239", "bank": "QDCCB", "type": "CC", "length": "16", "name": "青岛银行"},
    {"bin": "628242", "bank": "NJCB", "type": "CC", "length": "16", "name": "南京银行"},
    {"bin": "628248", "bank": "WJRCB", "type": "CC", "length": "16", "name": "吴江农商银行"},
    {"bin": "628250", "bank": "CZCB", "type": "CC", "length": "16", "name": "浙江稠州商业银行"},
    {"bin": "628251", "bank": "HSBANK", "type": "CC", "length": "16", "name": "徽商银行"},
    {"bin": "628252", "bank": "H3CB", "type": "CC", "length": "16", "name": "内蒙古银行"},
    {"bin": "628253", "bank": "ORBANK", "type": "CC", "length": "16", "name": "鄂尔多斯银行"},
    {"bin": "628255", "bank": "WZCB", "type": "CC", "length": "16", "name": "温州银行"},
    {"bin": "628257", "bank": "RZB", "type": "CC", "length": "16", "name": "日照银行"},
    {"bin": "628258", "bank": "CMBC", "type": "CC", "length": "16", "name": "中国民生银行"},
    {"bin": "628259", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "628260", "bank": "GDB", "type": "CC", "length": "16", "name": "广东发展银行"},
    {"bin": "628261", "bank": "BOJZ", "type": "CC", "length": "16", "name": "锦州银行"},
    {"bin": "628263", "bank": "LZYH", "type": "CC", "length": "16", "name": "兰州银行"},
    {
        "bin": "628267",
        "bank": "CRCBANK",
        "type": "CC",
        "length": "16",
        "name": "重庆农村商业银行",
    },
    {"bin": "628268", "bank": "ABC", "type": "CC", "length": "16", "name": "中国农业银行"},
    {"bin": "628269", "bank": "ABC", "type": "CC", "length": "16", "name": "中国农业银行"},
    {"bin": "628271", "bank": "ZYB", "type": "CC", "length": "16", "name": "中原银行"},
    {
        "bin": "628272",
        "bank": "CSRCB",
        "type": "CC",
        "length": "16",
        "name": "常熟农村商业银行",
    },
    {"bin": "628279", "bank": "LSBANK", "type": "CC", "length": "16", "name": "莱商银行"},
    {
        "bin": "628280",
        "bank": "ZJNX",
        "type": "CC",
        "length": "16",
        "name": "浙江省农村信用社联合社",
    },
    {"bin": "628281", "bank": "CSCB", "type": "CC", "length": "16", "name": "长沙银行"},
    {"bin": "628282", "bank": "CSCB", "type": "CC", "length": "16", "name": "长沙银行"},
    {"bin": "628283", "bank": "CSCB", "type": "CC", "length": "16", "name": "长沙银行"},
    {"bin": "628285", "bank": "SJBANK", "type": "CC", "length": "16", "name": "盛京银行"},
    {"bin": "628286", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "628287", "bank": "BOQH", "type": "CC", "length": "16", "name": "青海银行"},
    {"bin": "628288", "bank": "ICBC", "type": "CC", "length": "16", "name": "中国工商银行"},
    {"bin": "628299", "bank": "DLB", "type": "CC", "length": "16", "name": "大连银行"},
    {"bin": "628300", "bank": "NBYZ", "type": "CC", "length": "16", "name": "鄞州银行"},
    {"bin": "628301", "bank": "TRCB", "type": "CC", "length": "16", "name": "天津农商银行"},
    {"bin": "628305", "bank": "NCB", "type": "CC", "length": "16", "name": "南昌银行"},
    {"bin": "628306", "bank": "HZCCB", "type": "CC", "length": "16", "name": "湖州市商业银行"},
    {
        "bin": "628307",
        "bank": "YNRCC",
        "type": "CC",
        "length": "16",
        "name": "云南省农村信用社",
    },
    {"bin": "628308", "bank": "CDRCB", "type": "CC", "length": "16", "name": "成都农商银行"},
    {"bin": "628310", "bank": "PSBC", "type": "CC", "length": "16", "name": "中国邮政储蓄银行"},
    {"bin": "628311", "bank": "ZBCB", "type": "CC", "length": "16", "name": "齐商银行"},
    {"bin": "628312", "bank": "BOC", "type": "CC", "length": "16", "name": "中国银行"},
    {"bin": "628317", "bank": "CCB", "type": "CC", "length": "16", "name": "中国建设银行"},
    {"bin": "628318", "bank": "HXBANK", "type": "CC", "length": "16", "name": "华夏银行"},
    {"bin": "628321", "bank": "BHB", "type": "CC", "length": "16", "name": "河北银行"},
    {"bin": "628322", "bank": "SDEB", "type": "CC", "length": "16", "name": "顺德农商银行"},
    {"bin": "628333", "bank": "DAQINGB", "type": "CC", "length": "16", "name": "龙江银行"},
    {"bin": "628359", "bank": "LSBC", "type": "CC", "length": "16", "name": "临商银行"},
    {"bin": "628366", "bank": "CCB", "type": "CC", "length": "16", "name": "中国建设银行"},
    {"bin": "628367", "bank": "GCB", "type": "CC", "length": "16", "name": "广州银行"},
    {"bin": "628368", "bank": "DAQINGB", "type": "CC", "length": "16", "name": "龙江银行"},
    {"bin": "628369", "bank": "WRCB", "type": "CC", "length": "16", "name": "无锡农村商业银行"},
    {"bin": "628370", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "628371", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "628372", "bank": "CITIC", "type": "CC", "length": "16", "name": "中信银行"},
    {"bin": "628379", "bank": "QLBANK", "type": "CC", "length": "16", "name": "齐鲁银行"},
    {
        "bin": "628381",
        "bank": "JRCB",
        "type": "CC",
        "length": "16",
        "name": "江苏江阴农村商业银行",
    },
    {"bin": "628382", "bank": "YDRCB", "type": "CC", "length": "16", "name": "尧都农商行"},
    {
        "bin": "628386",
        "bank": "SLH",
        "type": "CC",
        "length": "16",
        "name": "湖南农村信用社联合社",
    },
    {"bin": "628391", "bank": "BANKWF", "type": "CC", "length": "16", "name": "潍坊银行"},
    {"bin": "628397", "bank": "DZBANK", "type": "CC", "length": "16", "name": "德州银行"},
    {"bin": "683970", "bank": "BOQZ", "type": "DC", "length": "18", "name": "泉州银行"},
    {
        "bin": "6886592",
        "bank": "XMCCB",
        "type": "DC",
        "length": "18",
        "name": "厦门市商业银行",
    },
    {"bin": "690755", "bank": "CMB", "type": "DC", "length": "15", "name": "招商银行"},
    {"bin": "690755", "bank": "CMB", "type": "DC", "length": "18", "name": "招商银行"},
    {"bin": "694301", "bank": "CSCB", "type": "DC", "length": "18", "name": "长沙银行"},
    {"bin": "69580", "bank": "JSBANK", "type": "DC", "length": "18", "name": "江苏银行"},
    {"bin": "84301", "bank": "SPDB", "type": "DC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "84336", "bank": "SPDB", "type": "DC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "84342", "bank": "SPDB", "type": "DC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "84361", "bank": "SPDB", "type": "DC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "84373", "bank": "SPDB", "type": "DC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "84380", "bank": "SPDB", "type": "DC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "84385", "bank": "SPDB", "type": "DC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "84390", "bank": "SPDB", "type": "DC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "87000", "bank": "SPDB", "type": "DC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "87010", "bank": "SPDB", "type": "DC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "87030", "bank": "SPDB", "type": "DC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "87040", "bank": "SPDB", "type": "DC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "87050", "bank": "SPDB", "type": "DC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "900000", "bank": "ICBC", "type": "DC", "length": "19", "name": "中国工商银行"},
    {"bin": "900003", "bank": "CMBC", "type": "DC", "length": "16", "name": "中国民生银行"},
    {"bin": "900010", "bank": "ICBC", "type": "DC", "length": "19", "name": "中国工商银行"},
    {
        "bin": "900105",
        "bank": "SDRCU",
        "type": "DC",
        "length": "16",
        "name": "山东省农村信用社",
    },
    {
        "bin": "900205",
        "bank": "SDRCU",
        "type": "DC",
        "length": "16",
        "name": "山东省农村信用社",
    },
    {"bin": "90030", "bank": "CEB", "type": "DC", "length": "16", "name": "中国光大银行"},
    {"bin": "90592", "bank": "CIB", "type": "DC", "length": "16", "name": "兴业银行"},
    {
        "bin": "909810",
        "bank": "GZRCU",
        "type": "DC",
        "length": "18",
        "name": "贵州省农村信用社",
    },
    {"bin": "9111", "bank": "GDB", "type": "DC", "length": "19", "name": "广东发展银行"},
    {
        "bin": "920000",
        "bank": "CEP",
        "type": "DC",
        "length": "16",
        "name": "中银通商务支付有限公司",
    },
    {
        "bin": "921000",
        "bank": "CEP",
        "type": "PC",
        "length": "19",
        "name": "中银通商务支付有限公司",
    },
    {
        "bin": "940001",
        "bank": "URMQCCB",
        "type": "DC",
        "length": "19",
        "name": "乌鲁木齐市商业银行",
    },
    {"bin": "940002", "bank": "ASCB", "type": "DC", "length": "16", "name": "鞍山银行"},
    {"bin": "940003", "bank": "BOJZ", "type": "DC", "length": "17", "name": "锦州银行"},
    {"bin": "940006", "bank": "NCB", "type": "DC", "length": "17", "name": "南昌银行"},
    {"bin": "940008", "bank": "QLBANK", "type": "DC", "length": "19", "name": "齐鲁银行"},
    {"bin": "940012", "bank": "JLBANK", "type": "DC", "length": "16", "name": "吉林银行"},
    {
        "bin": "940013",
        "bank": "SHRCB",
        "type": "DC",
        "length": "16",
        "name": "上海农村商业银行",
    },
    {"bin": "940015", "bank": "TCCB", "type": "DC", "length": "18", "name": "天津银行"},
    {"bin": "940016", "bank": "GCB", "type": "DC", "length": "19", "name": "广州银行"},
    {"bin": "940017", "bank": "NTCCB", "type": "DC", "length": "18", "name": "南通商业银行"},
    {"bin": "940018", "bank": "CQBANK", "type": "DC", "length": "16", "name": "重庆银行"},
    {
        "bin": "940020",
        "bank": "CRCBANK",
        "type": "DC",
        "length": "16",
        "name": "重庆农村商业银行",
    },
    {"bin": "940021", "bank": "SHBANK", "type": "DC", "length": "18", "name": "上海银行"},
    {"bin": "940022", "bank": "NBBANK", "type": "DC", "length": "16", "name": "宁波银行"},
    {"bin": "940023", "bank": "XMBANK", "type": "DC", "length": "16", "name": "厦门银行"},
    {"bin": "940025", "bank": "ZJCCB", "type": "DC", "length": "16", "name": "镇江市商业银行"},
    {"bin": "940027", "bank": "CDCB", "type": "DC", "length": "19", "name": "成都银行"},
    {"bin": "940029", "bank": "KSRCB", "type": "DC", "length": "19", "name": "昆山农信社"},
    {
        "bin": "940030",
        "bank": "CSRCB",
        "type": "DC",
        "length": "19",
        "name": "常熟农村商业银行",
    },
    {
        "bin": "9400301",
        "bank": "CSRCB",
        "type": "DC",
        "length": "19",
        "name": "常熟农村商业银行",
    },
    {"bin": "940031", "bank": "JSB", "type": "DC", "length": "17", "name": "晋商银行"},
    {"bin": "940032", "bank": "HBC", "type": "DC", "length": "16", "name": "湖北银行"},
    {"bin": "940034", "bank": "EGBANK", "type": "DC", "length": "17", "name": "恒丰银行"},
    {
        "bin": "940035",
        "bank": "GZRCU",
        "type": "DC",
        "length": "18",
        "name": "贵州省农村信用社",
    },
    {"bin": "940037", "bank": "NHB", "type": "DC", "length": "18", "name": "南海农村信用联社"},
    {"bin": "940038", "bank": "SDEB", "type": "DC", "length": "16", "name": "顺德农商银行"},
    {"bin": "940039", "bank": "SJBANK", "type": "DC", "length": "16", "name": "盛京银行"},
    {"bin": "940040", "bank": "LZYH", "type": "DC", "length": "16", "name": "兰州银行"},
    {"bin": "940041", "bank": "BOL", "type": "DC", "length": "17", "name": "洛阳银行"},
    {
        "bin": "940042",
        "bank": "KMRCU",
        "type": "DC",
        "length": "18",
        "name": "昆明农村信用联合社",
    },
    {"bin": "940043", "bank": "LYCB", "type": "DC", "length": "17", "name": "辽阳市商业银行"},
    {
        "bin": "940044",
        "bank": "WHRCB",
        "type": "DC",
        "length": "17",
        "name": "武汉农村商业银行",
    },
    {"bin": "940046", "bank": "BHB", "type": "DC", "length": "19", "name": "河北银行"},
    {
        "bin": "94004602",
        "bank": "QHDCCB",
        "type": "DC",
        "length": "19",
        "name": "秦皇岛市商业银行",
    },
    {"bin": "94004604", "bank": "BOCZ", "type": "DC", "length": "19", "name": "沧州银行"},
    {"bin": "940047", "bank": "JLBANK", "type": "DC", "length": "16", "name": "吉林银行"},
    {
        "bin": "940048",
        "bank": "ZHCCB",
        "type": "DC",
        "length": "19",
        "name": "珠海华润银行股份有限公司",
    },
    {"bin": "940049", "bank": "HRBANK", "type": "DC", "length": "18", "name": "哈尔滨银行"},
    {"bin": "940050", "bank": "BOD", "type": "DC", "length": "16", "name": "东莞银行"},
    {"bin": "940051", "bank": "JHBANK", "type": "DC", "length": "16", "name": "金华银行"},
    {
        "bin": "940053",
        "bank": "FSCCB",
        "type": "DC",
        "length": "18",
        "name": "抚顺银行股份有限公司",
    },
    {
        "bin": "940054",
        "bank": "HLDCCB",
        "type": "DC",
        "length": "16",
        "name": "葫芦岛市商业银行",
    },
    {"bin": "940055", "bank": "HBC", "type": "DC", "length": "17", "name": "湖北银行"},
    {"bin": "940056", "bank": "ZZCCB", "type": "DC", "length": "17", "name": "郑州商业银行"},
    {"bin": "940057", "bank": "ZBCB", "type": "DC", "length": "17", "name": "齐商银行"},
    {
        "bin": "940058",
        "bank": "JRCB",
        "type": "DC",
        "length": "16",
        "name": "江苏江阴农村商业银行",
    },
    {"bin": "940060", "bank": "BODD", "type": "DC", "length": "16", "name": "丹东银行"},
    {"bin": "940061", "bank": "QDCCB", "type": "DC", "length": "16", "name": "青岛银行"},
    {
        "bin": "940062",
        "bank": "DRCBCL",
        "type": "DC",
        "length": "19",
        "name": "东莞农村商业银行",
    },
    {
        "bin": "940063",
        "bank": "ZRCBANK",
        "type": "DC",
        "length": "17",
        "name": "张家港农村商业银行",
    },
    {"bin": "940065", "bank": "RZCCB", "type": "DC", "length": "19", "name": "日照银行"},
    {"bin": "940066", "bank": "LSB", "type": "DC", "length": "19", "name": "临商银行"},
    {"bin": "940068", "bank": "BOQH", "type": "DC", "length": "17", "name": "青海银行"},
    {"bin": "940069", "bank": "TZCB", "type": "DC", "length": "17", "name": "台州银行"},
    {"bin": "940070", "bank": "YCCCB", "type": "DC", "length": "16", "name": "盐城商行"},
    {"bin": "940071", "bank": "CSCB", "type": "DC", "length": "19", "name": "长沙银行"},
    {"bin": "940072", "bank": "BANKWF", "type": "DC", "length": "16", "name": "潍坊银行"},
    {"bin": "940073", "bank": "GZB", "type": "DC", "length": "19", "name": "赣州银行"},
    {"bin": "940074", "bank": "BOQZ", "type": "DC", "length": "18", "name": "泉州银行"},
    {"bin": "940076", "bank": "JSBANK", "type": "DC", "length": "16", "name": "江苏银行"},
    {"bin": "955100", "bank": "PSBC", "type": "DC", "length": "19", "name": "中国邮政储蓄银行"},
    {"bin": "95555", "bank": "CMB", "type": "DC", "length": "16", "name": "招商银行"},
    {"bin": "955590", "bank": "COMM", "type": "CC", "length": "16", "name": "交通银行"},
    {"bin": "955591", "bank": "COMM", "type": "CC", "length": "16", "name": "交通银行"},
    {"bin": "955592", "bank": "COMM", "type": "CC", "length": "16", "name": "交通银行"},
    {"bin": "955593", "bank": "COMM", "type": "CC", "length": "16", "name": "交通银行"},
    {"bin": "9558", "bank": "ICBC", "type": "DC", "length": "19", "name": "中国工商银行"},
    {"bin": "95588", "bank": "ICBC", "type": "DC", "length": "19", "name": "中国工商银行"},
    {"bin": "95595", "bank": "ABC", "type": "DC", "length": "19", "name": "中国农业银行"},
    {"bin": "95596", "bank": "ABC", "type": "DC", "length": "19", "name": "中国农业银行"},
    {"bin": "95597", "bank": "ABC", "type": "DC", "length": "19", "name": "中国农业银行"},
    {"bin": "95598", "bank": "ABC", "type": "DC", "length": "19", "name": "中国农业银行"},
    {"bin": "95599", "bank": "ABC", "type": "DC", "length": "19", "name": "中国农业银行"},
    {"bin": "966666", "bank": "CIB", "type": "DC", "length": "18", "name": "兴业银行"},
    {"bin": "96828", "bank": "ZZCCB", "type": "DC", "length": "16", "name": "郑州商业银行"},
    {"bin": "968807", "bank": "CITIC", "type": "DC", "length": "16", "name": "中信银行"},
    {"bin": "968808", "bank": "CITIC", "type": "DC", "length": "16", "name": "中信银行"},
    {"bin": "968809", "bank": "CITIC", "type": "DC", "length": "16", "name": "中信银行"},
    {"bin": "984301", "bank": "SPDB", "type": "DC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "984303", "bank": "SPDB", "type": "DC", "length": "16", "name": "上海浦东发展银行"},
    {"bin": "985262", "bank": "SDEB", "type": "DC", "length": "16", "name": "顺德农商银行"},
    {"bin": "9896", "bank": "CQBANK", "type": "DC", "length": "16", "name": "重庆银行"},
    {"bin": "990871", "bank": "FDB", "type": "DC", "length": "18", "name": "富滇银行"},
    {"bin": "998800", "bank": "SPABANK", "type": "DC", "length": "16", "name": "平安银行"},
    {"bin": "998801", "bank": "SPABANK", "type": "CC", "length": "16", "name": "平安银行"},
    {"bin": "998802", "bank": "SPABANK", "type": "CC", "length": "16", "name": "平安银行"},
    {"bin": "999999", "bank": "HXBANK", "type": "DC", "length": "16", "name": "华夏银行"},
]
