# -*- coding: utf-8 -*-

import keystone.utils
from keystone.api import keystone_class, api_method
from keystone.order import KSOrderType
from keystone.broker import KSBacktestingBroker
from keystone.portfolio import KSPortfolio
from keystone.universe import KSUniverse
from keystone.history import KSHistory
from keystone.performance.analyzer import KSAnalyzer


class KSContext(object):
    def __init__(self, portfolio, history = None, analyzers = None, universe = None):
        assert isinstance(portfolio, KSPortfolio)
        self.portfolio = portfolio
        if history is not None:
            assert isinstance(history, KSHistory)
            self.history = history
        if analyzers is not None:
            for analyzer in analyzers:
                assert isinstance(analyzer, KSAnalyzer)
            self.analyzers = analyzers
        if universe is not None:
            assert isinstance(universe, KSUniverse)
            self.universe = universe
        
    
class KSAction(object):
    def __init__(self, broker, logger = None):
        assert isinstance(broker, KSBacktestingBroker)
        self.__broker = broker
        self.__logger = logger
    
    
    def order(self, sid, amount, type = KSOrderType.MARKET_ORDER):
        if not isinstance(sid, str):
            raise TypeError(u"sid格式错误，sid必须为字符串。".encode('utf8'))
        
        if not keystone.utils.isint(amount):
            raise TypeError(u"amount格式错误，amount必须为整数。".encode('utf8'))
        
        return self.__broker.order(sid, amount, type)
        
    
    def orderValue(self, sid, value, type = KSOrderType.MARKET_ORDER):
        if not isinstance(sid, str):
            raise TypeError(u"sid格式错误，sid必须为字符串。".encode('utf8'))
        
        if not keystone.utils.isnumber(value):
            raise TypeError(u"value格式错误，value必须为数字。".encode('utf8'))
        
        return self.__broker.orderValue(sid, value, type)
        
    
    def orderPercentage(self, sid, percentage, type = KSOrderType.MARKET_ORDER):
        if not isinstance(sid, str):
            raise TypeError(u"sid格式错误，sid必须为字符串。".encode('utf8'))
        
        if not keystone.utils.isnumber(percentage) or abs(percentage) > 1.0:
            raise TypeError(u"percentage格式错误，percentage必须为数字。".encode('utf8'))
        
        return self.__broker.orderPercentage(sid, percentage, type)
        
    
    def orderTarget(self, sid, amount, type = KSOrderType.MARKET_ORDER):
        if not isinstance(sid, str):
            raise TypeError(u"sid格式错误，sid必须为字符串。".encode('utf8'))
        
        if not keystone.utils.isint(amount):
            raise TypeError(u"amount格式错误，amount必须为整数。".encode('utf8'))
        
        return self.__broker.orderTarget(sid, amount, type)
        
    
    def orderTargetValue(self, sid, value, type = KSOrderType.MARKET_ORDER):
        if not isinstance(sid, str):
            raise TypeError(u"sid格式错误，sid必须为字符串。".encode('utf8'))
        
        if not keystone.utils.isnumber(value):
            raise TypeError(u"value格式错误，value必须为数字。".encode('utf8'))
        
        return self.__broker.orderTargetValue(sid, value, type)
        
    
    def orderTargetPercentage(self, sid, percentage, type = KSOrderType.MARKET_ORDER):
        if not isinstance(sid, str):
            raise TypeError(u"sid格式错误，sid必须为字符串。".encode('utf8'))
        
        if not keystone.utils.isnumber(percentage) or abs(percentage) > 1.0:
            raise TypeError(u"percentage格式错误，percentage必须为数字。".encode('utf8'))
        
        return self.__broker.orderTargetPercentage(sid, percentage, type)
    
    
    def getOrder(self, orderid):
        return self.__broker.getOrder(orderid)