import { Construct } from 'constructs';
import { AttiniTask } from './attini-task';
export interface Project {
    readonly path: string;
    readonly template?: string;
    readonly buildDir?: string;
}
export interface AttiniSamProps {
    readonly project: Project;
    readonly stackName: string;
    readonly configFile?: string;
    readonly parameters?: {
        [key: string]: string;
    };
    readonly tags?: {
        [key: string]: string;
    };
    readonly stackRoleArn?: string;
    readonly executionRoleArn?: string;
    readonly variables?: {
        [key: string]: string;
    };
    readonly action?: string;
    readonly enableTerminationProtection?: boolean;
}
export declare class AttiniSam extends AttiniTask {
    private props;
    type: string;
    constructor(scope: Construct, id: string, props: AttiniSamProps);
    protected renderProps(): object;
}
