#
# Copyright (c) 2025 Huawei Technologies Co., Ltd. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# This file is a part of the vllm-ascend project.
#

import torch


def torchair_silu_and_mul_forward_oot(self, x: torch.Tensor) -> torch.Tensor:
    """AscendSiluAndMul forward in torchair mode.

    The key difference from the original implementation is the removal of operators
    from the torch.ops.vllm class, as these operators only function in non-torchair
    modes. Adding them back would cause the graph compilation to fail.
    """

    import torch_npu

    from vllm_ascend.utils import is_310p

    if is_310p():
        out = torch_npu.npu_swiglu(x.to(torch.float32)).to(torch.float16)
    else:
        out = torch_npu.npu_swiglu(x)
    return out
