<!-- ASCII Logo -->
```ascii
    _       _   _ _     
   (_)_   _| |_(_) |___ 
   | | | | | __| | / __|
   | | |_| | |_| | \__ \
  _/ |\__,_|\__|_|_|___/
 |__/                                                     
```

------------------------------------------------------

<div align="center">

[![GitHub tag (latest by date)](https://img.shields.io/github/v/tag/JordanWelsman/jutils?style=for-the-badge)](https://github.com/JordanWelsman/jutils/tags)
[![GitHub release (latest by date)](https://img.shields.io/github/v/release/JordanWelsman/jutils?style=for-the-badge)](https://github.com/JordanWelsman/jutils/releases)
[![GitHub Release Date](https://img.shields.io/github/release-date/JordanWelsman/jutils?style=for-the-badge)](https://github.com/JordanWelsman/jutils/wiki/Version-History)
[![GitHub](https://img.shields.io/github/license/JordanWelsman/jutils?style=for-the-badge)](https://github.com/JordanWelsman/jutils/blob/main/LICENSE.md)
[![GitHub commit activity](https://img.shields.io/github/commit-activity/m/JordanWelsman/jutils?style=for-the-badge)](https://github.com/JordanWelsman/jutils/commits/main)
[![GitHub wiki](https://img.shields.io/badge/wiki-jutils-blueviolet?style=for-the-badge)](https://github.com/JordanWelsman/jutils/wiki)

</div>
<div align="center">

[![PyPI](https://img.shields.io/pypi/v/jutl?style=for-the-badge)](https://pypi.org/project/jutl)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/jutl?style=for-the-badge)](https://docs.python.org/3/whatsnew/3.11.html)
[![PyPI - Wheel](https://img.shields.io/pypi/wheel/jutl?style=for-the-badge)](https://pypi.org/project/jutl/#files)
[![PyPI - Status](https://img.shields.io/pypi/status/jutl?style=for-the-badge)](https://pypi.org/project/jutl/#data)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/jutl?style=for-the-badge)](https://pypi.org/project/jutl/#history)

</div>
<div align="center">

[![GitHub Repo stars](https://img.shields.io/github/stars/JordanWelsman/jutils?style=for-the-badge)](https://github.com/JordanWelsman/jutils/stargazers)
[![GitHub watchers](https://img.shields.io/github/watchers/JordanWelsman/jutils?style=for-the-badge)](https://github.com/JordanWelsman/jutils/watchers)
[![GitHub forks](https://img.shields.io/github/forks/JordanWelsman/jutils?style=for-the-badge)](https://github.com/JordanWelsman/jutils/network/members)
![Lines of code](https://img.shields.io/tokei/lines/github/JordanWelsman/jutils?style=for-the-badge)
![GitHub repo file count](https://img.shields.io/github/directory-file-count/JordanWelsman/jutils?style=for-the-badge)
![GitHub repo size](https://img.shields.io/github/repo-size/JordanWelsman/jutils?style=for-the-badge)

</div>

# Overview

jutils is a simple `Python 3.10+` package which gives the user various tools. These tools are broken down into sub-modules in which the user can import individually.

# Table of contents

- [Overview](#overview)
- [Table of contents](#table-of-contents)
- [Install \& use](#install--use)
  - [Test](#test)
- [Objectives](#objectives)
- [Credits](#credits)
- [Licence](#licence)
- [Links](#links)

# Install & use

1. From terminal: `pip install jutl`
2. From python environment: `from jutl import <submodule>` where `<submodule>` is one from the following:

- `averages`
- `calculators`
- `converters`
- `cryptography`
- `datastructures`
- `ecxeptions`
- `formatting`
- `language`
- `logic`
- `pipelining`
- `sorters`
- `timers`
- `utilities`

## Test

1. Clone repository: `git clone https://github.com/JordanWelsman/jutils.git`
2. Build module for testing: `python3 setup.py bdist_wheel`
3. Install module locally: `pip install jutl -e .`
4. Run tests with PyTest: `pytest test/<submodule>` where `<submodule>` is one [from the above list](#install--use).

# Objectives

- Publish a package of tools I have developed that I use in production applications.
- Help other users improve their workflows and contribute to more performant applications.

# Credits

jutils was created, developed, and is currently maintained by **Jordan Welsman**.

# Licence

jutils is developed and distributed under the `MIT` license.
> **Note**
> See `LICENSE` for more details.

# Links

:file_folder: [See this project on GitHub](https://github.com/JordanWelsman/jutils/)

:gift: [See this project on PyPI](https://pypi.org/project/jutl/)

:cat: [Follow me on GitHub](https://github.com/JordanWelsman/)

:briefcase: [Connect with me on Linkedin](https://linkedin.com/in/JordanWelsman/)

:email: [Send me an email](mailto:jordan.welsman@outlook.com)
